/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.scroll;

import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import androidx.core.view.AccessibilityDelegateCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import com.facebook.react.R;
import com.facebook.react.bridge.AssertionException;
import com.facebook.react.bridge.ReactSoftExceptionLogger;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.uimanager.ReactAccessibilityDelegate;
import com.facebook.react.views.scroll.ReactAccessibleScrollView;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/facebook/react/views/scroll/ReactScrollViewAccessibilityDelegate;", "Landroidx/core/view/AccessibilityDelegateCompat;", "<init>", "()V", "TAG", "", "onInitializeAccessibilityEvent", "", "host", "Landroid/view/View;", "event", "Landroid/view/accessibility/AccessibilityEvent;", "onInitializeAccessibilityNodeInfo", "info", "Landroidx/core/view/accessibility/AccessibilityNodeInfoCompat;", "onInitializeAccessibilityEventInternal", "view", "onInitializeAccessibilityNodeInfoInternal", "ReactAndroid_debug"})
public final class ReactScrollViewAccessibilityDelegate
extends AccessibilityDelegateCompat {
    @NotNull
    private final String TAG;

    public ReactScrollViewAccessibilityDelegate() {
        String string2 = ReactScrollViewAccessibilityDelegate.class.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getSimpleName(...)");
        this.TAG = string2;
    }

    public void onInitializeAccessibilityEvent(@NotNull View host, @NotNull AccessibilityEvent event) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        super.onInitializeAccessibilityEvent(host, event);
        if (host instanceof ReactAccessibleScrollView) {
            this.onInitializeAccessibilityEventInternal(host, event);
        } else {
            ReactSoftExceptionLogger.logSoftException(this.TAG, new AssertionException("ReactScrollViewAccessibilityDelegate should only be used with ReactAccessibleScrollView, not with class: " + host.getClass().getSimpleName()));
        }
    }

    public void onInitializeAccessibilityNodeInfo(@NotNull View host, @NotNull AccessibilityNodeInfoCompat info) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        super.onInitializeAccessibilityNodeInfo(host, info);
        if (host instanceof ReactAccessibleScrollView) {
            this.onInitializeAccessibilityNodeInfoInternal(host, info);
        } else {
            ReactSoftExceptionLogger.logSoftException(this.TAG, new AssertionException("ReactScrollViewAccessibilityDelegate should only be used with ReactAccessibleScrollView, not with class: " + host.getClass().getSimpleName()));
        }
    }

    private final void onInitializeAccessibilityEventInternal(View view, AccessibilityEvent event) {
        Object object = view.getTag(R.id.accessibility_collection);
        ReadableMap readableMap = object instanceof ReadableMap ? (ReadableMap)object : null;
        if (readableMap == null) {
            return;
        }
        ReadableMap accessibilityCollection = readableMap;
        event.setItemCount(accessibilityCollection.getInt("itemCount"));
        ViewGroup viewGroup = view instanceof ViewGroup ? (ViewGroup)view : null;
        View view2 = viewGroup != null ? viewGroup.getChildAt(0) : null;
        ViewGroup viewGroup2 = view2 instanceof ViewGroup ? (ViewGroup)view2 : null;
        if (viewGroup2 == null) {
            return;
        }
        ViewGroup contentView = viewGroup2;
        Integer firstVisibleIndex = null;
        Integer lastVisibleIndex = null;
        int n = contentView.getChildCount();
        for (int index = 0; index < n; ++index) {
            View nextChild = contentView.getChildAt(index);
            if (!(view instanceof ReactAccessibleScrollView)) {
                return;
            }
            ReactAccessibleScrollView reactAccessibleScrollView = (ReactAccessibleScrollView)view;
            Intrinsics.checkNotNull((Object)nextChild);
            boolean isVisible = reactAccessibleScrollView.isPartiallyScrolledInView(nextChild);
            Object object2 = nextChild.getTag(R.id.accessibility_collection_item);
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type com.facebook.react.bridge.ReadableMap");
            ReadableMap accessibilityCollectionItem = (ReadableMap)object2;
            if (!(nextChild instanceof ViewGroup)) {
                return;
            }
            if (((ViewGroup)nextChild).getChildCount() > 0) {
                // empty if block
            }
            if (isVisible) {
                if (firstVisibleIndex == null) {
                    firstVisibleIndex = accessibilityCollectionItem.getInt("itemIndex");
                }
                lastVisibleIndex = accessibilityCollectionItem.getInt("itemIndex");
            }
            if (firstVisibleIndex == null || lastVisibleIndex == null) continue;
            event.setFromIndex(firstVisibleIndex.intValue());
            event.setToIndex(lastVisibleIndex.intValue());
        }
    }

    private final void onInitializeAccessibilityNodeInfoInternal(View view, AccessibilityNodeInfoCompat info) {
        Object object;
        ReadableMap accessibilityCollection;
        ReactAccessibilityDelegate.AccessibilityRole accessibilityRole = ReactAccessibilityDelegate.AccessibilityRole.fromViewTag(view);
        if (accessibilityRole != null) {
            ReactAccessibilityDelegate.setRole(info, accessibilityRole, view.getContext());
        }
        ReadableMap readableMap = accessibilityCollection = (object = view.getTag(R.id.accessibility_collection)) instanceof ReadableMap ? (ReadableMap)object : null;
        if (accessibilityCollection != null) {
            int rowCount = accessibilityCollection.getInt("rowCount");
            int columnCount = accessibilityCollection.getInt("columnCount");
            boolean hierarchical = accessibilityCollection.getBoolean("hierarchical");
            AccessibilityNodeInfoCompat.CollectionInfoCompat collectionInfoCompat = AccessibilityNodeInfoCompat.CollectionInfoCompat.obtain((int)rowCount, (int)columnCount, (boolean)hierarchical);
            info.setCollectionInfo((Object)collectionInfoCompat);
        }
        if (view instanceof ReactAccessibleScrollView) {
            info.setScrollable(((ReactAccessibleScrollView)view).getScrollEnabled());
        }
    }
}

