/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager.layoutanimation;

import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.Animation;
import android.view.animation.BaseInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.common.annotations.VisibleForTesting;
import com.facebook.react.common.annotations.internal.LegacyArchitectureLogLevel;
import com.facebook.react.common.annotations.internal.LegacyArchitectureLogger;
import com.facebook.react.uimanager.IllegalViewOperationException;
import com.facebook.react.uimanager.layoutanimation.AnimatedPropertyType;
import com.facebook.react.uimanager.layoutanimation.InterpolatorType;
import com.facebook.react.uimanager.layoutanimation.SimpleSpringInterpolator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b \u0018\u0000 ,2\u00020\u0001:\u0001,B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0019\u001a\u00020\u001aH \u00a2\u0006\u0002\b\u001bJ7\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\u000bH \u00a2\u0006\u0002\b$J\u0006\u0010%\u001a\u00020&J\u0016\u0010'\u001a\u00020&2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u000bJ0\u0010+\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\u000bR\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\r\"\u0004\b\u0018\u0010\u000f\u00a8\u0006-"}, d2={"Lcom/facebook/react/uimanager/layoutanimation/AbstractLayoutAnimation;", "", "<init>", "()V", "interpolator", "Landroid/view/animation/Interpolator;", "getInterpolator", "()Landroid/view/animation/Interpolator;", "setInterpolator", "(Landroid/view/animation/Interpolator;)V", "delayMs", "", "getDelayMs", "()I", "setDelayMs", "(I)V", "animatedProperty", "Lcom/facebook/react/uimanager/layoutanimation/AnimatedPropertyType;", "getAnimatedProperty", "()Lcom/facebook/react/uimanager/layoutanimation/AnimatedPropertyType;", "setAnimatedProperty", "(Lcom/facebook/react/uimanager/layoutanimation/AnimatedPropertyType;)V", "durationMs", "getDurationMs", "setDurationMs", "isValid", "", "isValid$ReactAndroid_debug", "createAnimationImpl", "Landroid/view/animation/Animation;", "view", "Landroid/view/View;", "x", "y", "width", "height", "createAnimationImpl$ReactAndroid_debug", "reset", "", "initializeFromConfig", "data", "Lcom/facebook/react/bridge/ReadableMap;", "globalDuration", "createAnimation", "Companion", "ReactAndroid_debug"})
@SourceDebugExtension(value={"SMAP\nAbstractLayoutAnimation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractLayoutAnimation.kt\ncom/facebook/react/uimanager/layoutanimation/AbstractLayoutAnimation\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,129:1\n1#2:130\n*E\n"})
public abstract class AbstractLayoutAnimation {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Interpolator interpolator;
    private int delayMs;
    @Nullable
    private AnimatedPropertyType animatedProperty;
    private int durationMs;
    private static final boolean SLOWDOWN_ANIMATION_MODE = false;
    @NotNull
    private static final Map<InterpolatorType, BaseInterpolator> INTERPOLATOR;

    @Nullable
    public final Interpolator getInterpolator() {
        return this.interpolator;
    }

    public final void setInterpolator(@Nullable Interpolator interpolator) {
        this.interpolator = interpolator;
    }

    public final int getDelayMs() {
        return this.delayMs;
    }

    public final void setDelayMs(int n) {
        this.delayMs = n;
    }

    @Nullable
    public final AnimatedPropertyType getAnimatedProperty() {
        return this.animatedProperty;
    }

    public final void setAnimatedProperty(@Nullable AnimatedPropertyType animatedPropertyType) {
        this.animatedProperty = animatedPropertyType;
    }

    public final int getDurationMs() {
        return this.durationMs;
    }

    public final void setDurationMs(int n) {
        this.durationMs = n;
    }

    public abstract boolean isValid$ReactAndroid_debug();

    @Nullable
    public abstract Animation createAnimationImpl$ReactAndroid_debug(@NotNull View var1, int var2, int var3, int var4, int var5);

    public final void reset() {
        this.animatedProperty = null;
        this.durationMs = 0;
        this.delayMs = 0;
        this.interpolator = null;
    }

    public final void initializeFromConfig(@NotNull ReadableMap data, int globalDuration) {
        AnimatedPropertyType animatedPropertyType;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (data.hasKey("property")) {
            String string2 = data.getString("property");
            if (string2 == null) {
                string2 = "";
            }
            animatedPropertyType = AnimatedPropertyType.Companion.fromString(string2);
        } else {
            animatedPropertyType = null;
        }
        this.animatedProperty = animatedPropertyType;
        this.durationMs = data.hasKey("duration") ? data.getInt("duration") : globalDuration;
        int n = this.delayMs = data.hasKey("delay") ? data.getInt("delay") : 0;
        if (!data.hasKey("type")) {
            boolean bl = false;
            String string3 = "Missing interpolation type.";
            throw new IllegalArgumentException(string3.toString());
        }
        String string4 = data.getString("type");
        if (string4 == null) {
            string4 = "";
        }
        this.interpolator = Companion.getInterpolator(InterpolatorType.Companion.fromString(string4), data);
        if (!this.isValid$ReactAndroid_debug()) {
            throw new IllegalViewOperationException("Invalid layout animation : " + data);
        }
    }

    @Nullable
    public final Animation createAnimation(@NotNull View view, int x, int y, int width, int height) {
        Animation animation;
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        if (!this.isValid$ReactAndroid_debug()) {
            return null;
        }
        Animation animation2 = this.createAnimationImpl$ReactAndroid_debug(view, x, y, width, height);
        if (animation2 != null) {
            Animation animation3;
            Animation $this$createAnimation_u24lambda_u241 = animation3 = animation2;
            boolean bl = false;
            int slowdownFactor = 1;
            $this$createAnimation_u24lambda_u241.setDuration((long)(this.durationMs * slowdownFactor));
            $this$createAnimation_u24lambda_u241.setStartOffset((long)(this.delayMs * slowdownFactor));
            $this$createAnimation_u24lambda_u241.setInterpolator(this.interpolator);
            animation = animation3;
        } else {
            animation = null;
        }
        return animation;
    }

    static {
        LegacyArchitectureLogger.assertLegacyArchitecture("AbstractLayoutAnimation", LegacyArchitectureLogLevel.ERROR);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)((Object)InterpolatorType.LINEAR), (Object)new LinearInterpolator()), TuplesKt.to((Object)((Object)InterpolatorType.EASE_IN), (Object)new AccelerateInterpolator()), TuplesKt.to((Object)((Object)InterpolatorType.EASE_OUT), (Object)new DecelerateInterpolator()), TuplesKt.to((Object)((Object)InterpolatorType.EASE_IN_EASE_OUT), (Object)new AccelerateDecelerateInterpolator())};
        INTERPOLATOR = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/facebook/react/uimanager/layoutanimation/AbstractLayoutAnimation$Companion;", "", "<init>", "()V", "SLOWDOWN_ANIMATION_MODE", "", "INTERPOLATOR", "", "Lcom/facebook/react/uimanager/layoutanimation/InterpolatorType;", "Landroid/view/animation/BaseInterpolator;", "getInterpolator", "Landroid/view/animation/Interpolator;", "type", "params", "Lcom/facebook/react/bridge/ReadableMap;", "ReactAndroid_debug"})
    @SourceDebugExtension(value={"SMAP\nAbstractLayoutAnimation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractLayoutAnimation.kt\ncom/facebook/react/uimanager/layoutanimation/AbstractLayoutAnimation$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,129:1\n1#2:130\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        @NotNull
        public final Interpolator getInterpolator(@NotNull InterpolatorType type, @NotNull ReadableMap params) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            Interpolator interpolator = type == InterpolatorType.SPRING ? (Interpolator)new SimpleSpringInterpolator(SimpleSpringInterpolator.Companion.getSpringDamping(params)) : (Interpolator)INTERPOLATOR.get((Object)type);
            if (interpolator == null) {
                boolean bl = false;
                String string2 = "Missing interpolator for type : " + type;
                throw new IllegalArgumentException(string2.toString());
            }
            return interpolator;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

