/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import androidx.annotation.VisibleForTesting;
import com.facebook.common.logging.FLog;
import com.facebook.react.common.build.ReactBuildConfig;
import com.facebook.react.internal.featureflags.ReactNativeNewArchitectureFeatureFlags;
import com.facebook.react.uimanager.UIManagerModuleConstants;
import com.facebook.react.uimanager.ViewManager;
import com.facebook.react.uimanager.ViewManagerResolver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0002\b\u0010\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J!\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0001\u00a2\u0006\u0002\b\fJ&\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00052\u0014\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0015H\u0002Jc\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u00152\u001c\u0010\u0016\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0006\b\u0000\u0012\u00020\u0019\u0012\u0006\b\u0000\u0012\u00020\u00190\u00180\u00172\u0014\u0010\u001a\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u00152\u0014\u0010\u001b\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0015H\u0001\u00a2\u0006\u0002\b\fJ\u0089\u0001\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u00152\u0016\u0010\u001d\u001a\u0012\u0012\u0006\b\u0000\u0012\u00020\u0019\u0012\u0006\b\u0000\u0012\u00020\u00190\u00182\u0014\u0010\u001e\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u00152\u0014\u0010\u001f\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u00152\u0014\u0010 \u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u00152\u0014\u0010!\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0015H\u0001\u00a2\u0006\u0002\b\"J-\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u00152\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0015H\u0001\u00a2\u0006\u0002\b%J4\u0010&\u001a\u00020\u00122\u0014\u0010'\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u00152\u0014\u0010(\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0015H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R&\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\t8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u000e\u0010\u0003\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006)"}, d2={"Lcom/facebook/react/uimanager/UIManagerModuleConstantsHelper;", "", "<init>", "()V", "TAG", "", "BUBBLING_EVENTS_KEY", "DIRECT_EVENTS_KEY", "createConstants", "", "resolver", "Lcom/facebook/react/uimanager/ViewManagerResolver;", "internal_createConstants", "defaultExportableEventTypes", "getDefaultExportableEventTypes$annotations", "getDefaultExportableEventTypes", "()Ljava/util/Map;", "validateDirectEventNames", "", "viewManagerName", "directEvents", "", "viewManagers", "", "Lcom/facebook/react/uimanager/ViewManager;", "", "allBubblingEventTypes", "allDirectEventTypes", "createConstantsForViewManager", "viewManager", "defaultBubblingEvents", "defaultDirectEvents", "cumulativeBubblingEventTypes", "cumulativeDirectEventTypes", "internal_createConstantsForViewManager", "normalizeEventTypes", "eventsToNormalize", "normalizeEventTypes$ReactAndroid_debug", "recursiveMerge", "dest", "source", "ReactAndroid_debug"})
public final class UIManagerModuleConstantsHelper {
    @NotNull
    public static final UIManagerModuleConstantsHelper INSTANCE = new UIManagerModuleConstantsHelper();
    @NotNull
    private static final String TAG = "UIManagerModuleConstantsHelper";
    @NotNull
    private static final String BUBBLING_EVENTS_KEY = "bubblingEventTypes";
    @NotNull
    private static final String DIRECT_EVENTS_KEY = "directEventTypes";

    private UIManagerModuleConstantsHelper() {
    }

    @JvmStatic
    @JvmName(name="internal_createConstants")
    @NotNull
    public static final Map<String, Object> internal_createConstants(@NotNull ViewManagerResolver resolver2) {
        Intrinsics.checkNotNullParameter((Object)resolver2, (String)"resolver");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"ViewManagerNames", new ArrayList<String>(resolver2.getViewManagerNames())), TuplesKt.to((Object)"LazyViewManagersEnabled", (Object)true)};
        return MapsKt.plus(UIManagerModuleConstants.constants, (Map)MapsKt.mapOf((Pair[])pairArray));
    }

    @NotNull
    public static final Map<String, Object> getDefaultExportableEventTypes() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)BUBBLING_EVENTS_KEY, UIManagerModuleConstants.bubblingEventTypeConstants), TuplesKt.to((Object)DIRECT_EVENTS_KEY, UIManagerModuleConstants.directEventTypeConstants)};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    @JvmStatic
    public static /* synthetic */ void getDefaultExportableEventTypes$annotations() {
    }

    private final void validateDirectEventNames(String viewManagerName, Map<String, Object> directEvents) {
        if (!ReactBuildConfig.DEBUG || directEvents == null) {
            return;
        }
        for (Map.Entry<String, Object> entry : directEvents.entrySet()) {
            String regName;
            String key = entry.getKey();
            Object value = entry.getValue();
            if (!TypeIntrinsics.isMutableMap((Object)value) || (regName = (String)((Map)value).get("registrationName")) == null || !StringsKt.startsWith$default((String)key, (String)"top", (boolean)false, (int)2, null) || !StringsKt.startsWith$default((String)regName, (String)"on", (boolean)false, (int)2, null)) continue;
            String string2 = key.substring(3);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            String string3 = regName.substring(2);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            if (Intrinsics.areEqual((Object)string2, (Object)string3)) continue;
            FLog.e((String)TAG, (String)("Direct event name for '" + viewManagerName + "' doesn't correspond to the naming convention, expected 'topEventName'->'onEventName', got '" + key + "'->'" + regName + "'"));
        }
    }

    @JvmStatic
    @JvmName(name="internal_createConstants")
    @NotNull
    public static final Map<String, Object> internal_createConstants(@NotNull List<? extends ViewManager> viewManagers, @Nullable Map<String, Object> allBubblingEventTypes, @Nullable Map<String, Object> allDirectEventTypes) {
        Intrinsics.checkNotNullParameter(viewManagers, (String)"viewManagers");
        Map constants = MapsKt.toMutableMap(UIManagerModuleConstants.constants);
        Map<String, Object> genericBubblingEventTypes = UIManagerModuleConstants.bubblingEventTypeConstants;
        Map<String, Object> genericDirectEventTypes = UIManagerModuleConstants.directEventTypeConstants;
        Map<String, Object> map = allBubblingEventTypes;
        if (map != null) {
            map.putAll(genericBubblingEventTypes);
        }
        Map<String, Object> map2 = allDirectEventTypes;
        if (map2 != null) {
            map2.putAll(genericDirectEventTypes);
        }
        for (ViewManager viewManager : viewManagers) {
            String viewManagerName;
            Intrinsics.checkNotNullExpressionValue((Object)viewManager.getName(), (String)"getName(...)");
            Map<String, Object> viewManagerConstants = UIManagerModuleConstantsHelper.internal_createConstantsForViewManager(viewManager, null, null, allBubblingEventTypes, allDirectEventTypes);
            if (viewManagerConstants.isEmpty()) continue;
            constants.put(viewManagerName, viewManagerConstants);
        }
        constants.put("genericBubblingEventTypes", genericBubblingEventTypes);
        constants.put("genericDirectEventTypes", genericDirectEventTypes);
        return constants;
    }

    @JvmStatic
    @JvmName(name="internal_createConstantsForViewManager")
    @NotNull
    public static final Map<String, Object> internal_createConstantsForViewManager(@NotNull ViewManager viewManager, @Nullable Map<String, Object> defaultBubblingEvents, @Nullable Map<String, Object> defaultDirectEvents, @Nullable Map<String, Object> cumulativeBubblingEventTypes, @Nullable Map<String, Object> cumulativeDirectEventTypes) {
        Map<String, String> viewManagerNativeProps;
        Map<String, Integer> viewManagerCommands;
        Intrinsics.checkNotNullParameter((Object)viewManager, (String)"viewManager");
        Map viewManagerConstants = new LinkedHashMap();
        Map<String, Object> viewManagerBubblingEvents = viewManager.getExportedCustomBubblingEventTypeConstants();
        if (viewManagerBubblingEvents != null) {
            if (ReactNativeNewArchitectureFeatureFlags.enableFabricRenderer() && ReactNativeNewArchitectureFeatureFlags.useFabricInterop()) {
                viewManagerBubblingEvents = INSTANCE.normalizeEventTypes$ReactAndroid_debug(viewManagerBubblingEvents);
            }
            INSTANCE.recursiveMerge(cumulativeBubblingEventTypes, viewManagerBubblingEvents);
            INSTANCE.recursiveMerge(viewManagerBubblingEvents, defaultBubblingEvents);
            viewManagerConstants.put(BUBBLING_EVENTS_KEY, viewManagerBubblingEvents);
        } else if (defaultBubblingEvents != null) {
            viewManagerConstants.put(BUBBLING_EVENTS_KEY, defaultBubblingEvents);
        }
        Map<String, Object> viewManagerDirectEvents = viewManager.getExportedCustomDirectEventTypeConstants();
        String string2 = viewManager.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        INSTANCE.validateDirectEventNames(string2, viewManagerDirectEvents);
        if (viewManagerDirectEvents != null) {
            if (ReactNativeNewArchitectureFeatureFlags.enableFabricRenderer() && ReactNativeNewArchitectureFeatureFlags.useFabricInterop()) {
                viewManagerDirectEvents = INSTANCE.normalizeEventTypes$ReactAndroid_debug(viewManagerDirectEvents);
            }
            INSTANCE.recursiveMerge(cumulativeDirectEventTypes, viewManagerDirectEvents);
            INSTANCE.recursiveMerge(viewManagerDirectEvents, defaultDirectEvents);
            viewManagerConstants.put(DIRECT_EVENTS_KEY, viewManagerDirectEvents);
        } else if (defaultDirectEvents != null) {
            viewManagerConstants.put(DIRECT_EVENTS_KEY, defaultDirectEvents);
        }
        Map<String, Object> customViewConstants = viewManager.getExportedViewConstants();
        if (customViewConstants != null) {
            viewManagerConstants.put("Constants", customViewConstants);
        }
        if ((viewManagerCommands = viewManager.getCommandsMap()) != null) {
            viewManagerConstants.put("Commands", viewManagerCommands);
        }
        if (!(viewManagerNativeProps = viewManager.getNativeProps()).isEmpty()) {
            Intrinsics.checkNotNull(viewManagerNativeProps);
            viewManagerConstants.put("NativeProps", viewManagerNativeProps);
        }
        return viewManagerConstants;
    }

    @VisibleForTesting
    @NotNull
    public final Map<String, Object> normalizeEventTypes$ReactAndroid_debug(@NotNull Map<String, Object> eventsToNormalize) {
        Intrinsics.checkNotNullParameter(eventsToNormalize, (String)"eventsToNormalize");
        Map events = eventsToNormalize;
        Set keysToNormalize = new HashSet();
        for (String key : events.keySet()) {
            String keyString = key;
            if (StringsKt.startsWith$default((String)keyString, (String)"top", (boolean)false, (int)2, null)) continue;
            keysToNormalize.add(keyString);
        }
        if (!(events instanceof HashMap)) {
            events = new HashMap<String, Object>(events);
        }
        for (String oldKey : keysToNormalize) {
            Object value;
            Object object;
            String string2;
            if (events.get(oldKey) == null) {
                string2 = "Required value was null.";
                throw new IllegalStateException(string2.toString());
            }
            if (StringsKt.startsWith$default((String)oldKey, (String)"on", (boolean)false, (int)2, null)) {
                String string3 = oldKey.substring(2);
                object = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            } else {
                Intrinsics.checkNotNullExpressionValue((Object)oldKey.substring(0, 1), (String)"substring(...)");
                Locale locale = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
                String string4 = string2.toUpperCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toUpperCase(...)");
                String string5 = oldKey.substring(1);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
                object = string4 + string5;
            }
            String baseKey = object;
            String newKey = "top" + baseKey;
            events.put(newKey, value);
        }
        return events;
    }

    private final void recursiveMerge(Map<String, Object> dest, Map<String, Object> source2) {
        if (dest == null || source2 == null || source2.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Object> entry : source2.entrySet()) {
            String key = entry.getKey();
            Object sourceValue = entry.getValue();
            HashMap destValue = dest.get(key);
            if (destValue != null && TypeIntrinsics.isMutableMap((Object)sourceValue) && TypeIntrinsics.isMutableMap((Object)destValue)) {
                if (!(destValue instanceof HashMap)) {
                    destValue = new HashMap(destValue);
                    dest.replace(key, TypeIntrinsics.asMutableMap(destValue));
                }
                Map map = TypeIntrinsics.asMutableMap((Object)destValue);
                Object object = sourceValue;
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.MutableMap<kotlin.String, kotlin.Any>");
                this.recursiveMerge(map, TypeIntrinsics.asMutableMap((Object)object));
                continue;
            }
            dest.put(key, sourceValue);
        }
    }
}

