/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.runtime;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import com.facebook.common.logging.FLog;
import com.facebook.infer.annotation.Assertions;
import com.facebook.infer.annotation.ThreadConfined;
import com.facebook.infer.annotation.ThreadSafe;
import com.facebook.proguard.annotations.DoNotStrip;
import com.facebook.react.MemoryPressureRouter;
import com.facebook.react.ReactHost;
import com.facebook.react.ReactInstanceEventListener;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.JSBundleLoader;
import com.facebook.react.bridge.JavaScriptContextHolder;
import com.facebook.react.bridge.MemoryPressureListener;
import com.facebook.react.bridge.NativeArray;
import com.facebook.react.bridge.NativeModule;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReactMarker;
import com.facebook.react.bridge.ReactMarkerConstants;
import com.facebook.react.bridge.ReactNoCrashBridgeNotAllowedSoftException;
import com.facebook.react.bridge.ReactNoCrashSoftException;
import com.facebook.react.bridge.ReactSoftExceptionLogger;
import com.facebook.react.bridge.RuntimeExecutor;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.bridge.queue.ReactQueueConfiguration;
import com.facebook.react.common.LifecycleState;
import com.facebook.react.common.build.ReactBuildConfig;
import com.facebook.react.devsupport.DefaultDevSupportManagerFactory;
import com.facebook.react.devsupport.DevSupportManagerBase;
import com.facebook.react.devsupport.DevSupportManagerFactory;
import com.facebook.react.devsupport.InspectorFlags;
import com.facebook.react.devsupport.inspector.InspectorNetworkHelper;
import com.facebook.react.devsupport.inspector.InspectorNetworkRequestListener;
import com.facebook.react.devsupport.interfaces.BundleLoadCallback;
import com.facebook.react.devsupport.interfaces.DevSupportManager;
import com.facebook.react.fabric.ComponentFactory;
import com.facebook.react.fabric.FabricUIManager;
import com.facebook.react.interfaces.TaskInterface;
import com.facebook.react.interfaces.fabric.ReactSurface;
import com.facebook.react.internal.featureflags.ReactNativeFeatureFlags;
import com.facebook.react.internal.featureflags.ReactNativeNewArchitectureFeatureFlags;
import com.facebook.react.modules.appearance.AppearanceModule;
import com.facebook.react.modules.core.DefaultHardwareBackBtnHandler;
import com.facebook.react.modules.core.DeviceEventManagerModule;
import com.facebook.react.modules.systeminfo.AndroidInfoHelpers;
import com.facebook.react.runtime.BridgelessAtomicRef;
import com.facebook.react.runtime.BridgelessReactContext;
import com.facebook.react.runtime.BridgelessReactStateTracker;
import com.facebook.react.runtime.ReactHostDelegate;
import com.facebook.react.runtime.ReactHostImplDevHelper;
import com.facebook.react.runtime.ReactHostInspectorTarget;
import com.facebook.react.runtime.ReactInstance;
import com.facebook.react.runtime.ReactLifecycleStateManager;
import com.facebook.react.runtime.ReactSurfaceImpl;
import com.facebook.react.runtime.ReactSurfaceView;
import com.facebook.react.runtime.internal.bolts.Continuation;
import com.facebook.react.runtime.internal.bolts.Task;
import com.facebook.react.runtime.internal.bolts.TaskCompletionSource;
import com.facebook.react.turbomodule.core.interfaces.CallInvokerHolder;
import com.facebook.react.uimanager.DisplayMetricsHolder;
import com.facebook.react.uimanager.UIManagerModule;
import com.facebook.react.uimanager.events.BlackHoleEventDispatcher;
import com.facebook.react.uimanager.events.EventDispatcher;
import com.facebook.react.views.imagehelper.ResourceDrawableIdHelper;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00fc\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u0003\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0007\u0018\u0000 \u00fc\u00012\u00020\u0001:\u0004\u00fb\u0001\u00fc\u0001BO\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\f\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011B1\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0012\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u0010\u0010\u0013J\u000e\u0010C\u001a\b\u0012\u0004\u0012\u00020E0DH\u0016J\u001b\u0010F\u001a\b\u0012\u0004\u0012\u00020E0D2\u0006\u0010G\u001a\u00020\u001eH\u0000\u00a2\u0006\u0002\bHJ\u001b\u0010I\u001a\b\u0012\u0004\u0012\u00020E0D2\u0006\u0010G\u001a\u00020\u001eH\u0000\u00a2\u0006\u0002\bJJ\u001b\u0010K\u001a\b\u0012\u0004\u0012\u00020E0D2\u0006\u0010G\u001a\u00020\u001eH\u0000\u00a2\u0006\u0002\bLJ\u001c\u0010M\u001a\u00020;2\b\u0010&\u001a\u0004\u0018\u00010(2\b\u0010N\u001a\u0004\u0018\u000105H\u0017J\u0012\u0010M\u001a\u00020;2\b\u0010&\u001a\u0004\u0018\u00010(H\u0017J\u0012\u0010O\u001a\u00020;2\b\u0010&\u001a\u0004\u0018\u00010(H\u0017J\u0012\u0010P\u001a\u00020;2\b\u0010&\u001a\u0004\u0018\u00010(H\u0017J\b\u0010P\u001a\u00020;H\u0017J\b\u0010Q\u001a\u00020;H\u0017J\u0012\u0010Q\u001a\u00020;2\b\u0010&\u001a\u0004\u0018\u00010(H\u0017J\u0010\u0010R\u001a\u00020;2\u0006\u0010S\u001a\u00020\fH\u0002J\"\u0010X\u001a\u00020Y2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010Z\u001a\u00020[2\b\u0010\\\u001a\u0004\u0018\u00010]H\u0016J\b\u0010a\u001a\u00020\fH\u0017J\u0010\u0010f\u001a\u00020;2\u0006\u0010g\u001a\u000208H\u0016J\u0010\u0010h\u001a\u00020;2\u0006\u0010g\u001a\u000208H\u0016J\u0016\u0010i\u001a\b\u0012\u0004\u0012\u00020E0D2\u0006\u0010j\u001a\u00020[H\u0016J\u0012\u0010k\u001a\u00020;2\b\u0010l\u001a\u0004\u0018\u00010[H\u0003J\u0018\u0010q\u001a\u00020;2\u0006\u0010r\u001a\u00020[2\u0006\u0010g\u001a\u00020sH\u0003JI\u0010t\u001a\b\u0012\u0004\u0012\u00020E0D2\u0006\u0010j\u001a\u00020[2\u000e\u0010u\u001a\n\u0018\u00010vj\u0004\u0018\u0001`w2!\u0010x\u001a\u001d\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\bz\u0012\b\b{\u0012\u0004\b\b(|\u0012\u0004\u0012\u00020;0yH\u0016J&\u0010t\u001a\b\u0012\u0004\u0012\u00020E0D2\u0006\u0010j\u001a\u00020[2\u000e\u0010u\u001a\n\u0018\u00010vj\u0004\u0018\u0001`wH\u0016J\u0010\u0010}\u001a\u0002032\u0006\u0010#\u001a\u00020\"H\u0002J,\u0010\u008d\u0001\u001a\u00020\f\"\n\b\u0000\u0010\u008e\u0001*\u00030\u008f\u00012\u000f\u0010\u0090\u0001\u001a\n\u0012\u0005\u0012\u0003H\u008e\u00010\u0091\u0001H\u0000\u00a2\u0006\u0003\b\u0092\u0001J2\u0010\u0097\u0001\u001a\u0005\u0018\u0001H\u008e\u0001\"\n\b\u0000\u0010\u008e\u0001*\u00030\u008f\u00012\u000f\u0010\u0090\u0001\u001a\n\u0012\u0005\u0012\u0003H\u008e\u00010\u0091\u0001H\u0000\u00a2\u0006\u0006\b\u0098\u0001\u0010\u0099\u0001J\u001b\u0010\u0097\u0001\u001a\u0005\u0018\u00010\u008f\u00012\u0007\u0010\u009a\u0001\u001a\u00020[H\u0000\u00a2\u0006\u0003\b\u0098\u0001J/\u0010\u00a3\u0001\u001a\u00020;2\u0006\u0010&\u001a\u00020(2\u0007\u0010\u00a4\u0001\u001a\u0002012\u0007\u0010\u00a5\u0001\u001a\u0002012\n\u0010\u00a6\u0001\u001a\u0005\u0018\u00010\u00a7\u0001H\u0017J\u0012\u0010\u00a8\u0001\u001a\u00020;2\u0007\u0010\u00a9\u0001\u001a\u00020\fH\u0017J\u0013\u0010\u00aa\u0001\u001a\u00020;2\b\u0010\u00ab\u0001\u001a\u00030\u00a7\u0001H\u0017J\u0011\u0010\u00ac\u0001\u001a\u00020;2\u0006\u0010\u0002\u001a\u00020\u0003H\u0017J\u001f\u0010\u00b4\u0001\u001a\b\u0012\u0004\u0012\u00020\f0!2\b\u0010\u00b5\u0001\u001a\u00030\u00b6\u0001H\u0000\u00a2\u0006\u0003\b\u00b7\u0001J3\u0010\u00b8\u0001\u001a\b\u0012\u0004\u0012\u00020\f0!2\u0007\u0010\u00b9\u0001\u001a\u0002012\u0007\u0010\u00ba\u0001\u001a\u00020[2\n\u0010\u00bb\u0001\u001a\u0005\u0018\u00010\u00bc\u0001H\u0000\u00a2\u0006\u0003\b\u00bd\u0001J\u001c\u0010\u00be\u0001\u001a\u00020;2\u000b\u0010\u00bf\u0001\u001a\u00060vj\u0002`wH\u0000\u00a2\u0006\u0003\b\u00c0\u0001J0\u0010\u00c1\u0001\u001a\b\u0012\u0004\u0012\u00020\f0!2\u0006\u0010Z\u001a\u00020[2\u0007\u0010\u00c2\u0001\u001a\u00020[2\b\u0010\u00c3\u0001\u001a\u00030\u00c4\u0001H\u0000\u00a2\u0006\u0003\b\u00c5\u0001J\u0017\u0010\u00c6\u0001\u001a\u00020;2\u0006\u0010G\u001a\u00020\u001eH\u0000\u00a2\u0006\u0003\b\u00c7\u0001J\u0017\u0010\u00c8\u0001\u001a\u00020;2\u0006\u0010G\u001a\u00020\u001eH\u0000\u00a2\u0006\u0003\b\u00c9\u0001J\u0017\u0010\u00ca\u0001\u001a\u00020\f2\u0006\u0010G\u001a\u00020\u001eH\u0000\u00a2\u0006\u0003\b\u00cb\u0001J\u0017\u0010\u00cc\u0001\u001a\u00020\f2\u0006\u0010Z\u001a\u00020[H\u0000\u00a2\u0006\u0003\b\u00cd\u0001J\u0018\u0010\u00ce\u0001\u001a\u00020;2\r\u0010\u00cf\u0001\u001a\b\u0012\u0004\u0012\u00020;0:H\u0016J\u0018\u0010\u00d0\u0001\u001a\u00020;2\r\u0010\u00cf\u0001\u001a\b\u0012\u0004\u0012\u00020;0:H\u0016J\u000f\u0010\u00d2\u0001\u001a\b\u0012\u0004\u0012\u00020E0!H\u0003J\u0014\u0010\u00d3\u0001\u001a\u00020;2\t\u0010\u00d4\u0001\u001a\u0004\u0018\u00010UH\u0003J(\u0010\u00d5\u0001\u001a\u00020;2\u0007\u0010\u00d6\u0001\u001a\u00020[2\u0006\u0010l\u001a\u00020[2\f\b\u0002\u0010\u00d7\u0001\u001a\u0005\u0018\u00010\u00d8\u0001H\u0002JG\u0010\u00d9\u0001\u001a\b\u0012\u0004\u0012\u00020\f0!2\u0007\u0010\u00d6\u0001\u001a\u00020[2\t\b\u0002\u0010\u00da\u0001\u001a\u00020\t2\"\u0010\u00db\u0001\u001a\u001d\u0012\u0013\u0012\u00110\"\u00a2\u0006\f\bz\u0012\b\b{\u0012\u0004\b\b(#\u0012\u0004\u0012\u00020;0yH\u0002JG\u0010\u00dc\u0001\u001a\b\u0012\u0004\u0012\u00020E0!2\u0007\u0010\u00d6\u0001\u001a\u00020[2\t\b\u0002\u0010\u00da\u0001\u001a\u00020\t2\"\u0010\u00db\u0001\u001a\u001d\u0012\u0013\u0012\u00110\"\u00a2\u0006\f\bz\u0012\b\b{\u0012\u0004\b\b(#\u0012\u0004\u0012\u00020;0yH\u0002J\t\u0010\u00dd\u0001\u001a\u00020%H\u0002J\u000f\u0010\u00de\u0001\u001a\b\u0012\u0004\u0012\u00020\"0!H\u0002J\u000f\u0010\u00df\u0001\u001a\b\u0012\u0004\u0012\u00020\"0!H\u0003J!\u0010\u00e0\u0001\u001a\b\u0012\u0004\u0012\u00020\"0!2\u0007\u0010\u00e1\u0001\u001a\u0002012\u0007\u0010\u00e2\u0001\u001a\u000201H\u0003J\u000f\u0010\u00e3\u0001\u001a\b\u0012\u0004\u0012\u00020\"0!H\u0003J\u0010\u0010\u00e8\u0001\u001a\t\u0012\u0005\u0012\u00030\u00b6\u00010!H\u0002J\u001a\u0010\u00e9\u0001\u001a\u00020;2\u0007\u0010\u00ea\u0001\u001a\u00020[2\u0006\u0010l\u001a\u00020[H\u0002J\u0012\u0010\u00e9\u0001\u001a\u00020;2\u0007\u0010\u00ea\u0001\u001a\u00020[H\u0002J\u001a\u0010\u00eb\u0001\u001a\u00020;2\u0007\u0010\u00ea\u0001\u001a\u00020[2\u0006\u0010#\u001a\u00020\"H\u0002J\u001a\u0010\u00ec\u0001\u001a\u00020;2\u0007\u0010\u00ea\u0001\u001a\u00020[2\u0006\u0010#\u001a\u00020\"H\u0002J^\u0010\u00ee\u0001\u001a=\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\"0!\u00a2\u0006\r\bz\u0012\t\b{\u0012\u0005\b\b(\u00f0\u0001\u0012\u0014\u0012\u00120[\u00a2\u0006\r\bz\u0012\t\b{\u0012\u0005\b\b(\u00f1\u0001\u0012\u0006\u0012\u0004\u0018\u00010\"0\u00ef\u00012\u0007\u0010\u00f2\u0001\u001a\u00020[2\u0007\u0010\u00ea\u0001\u001a\u00020[2\u0006\u0010j\u001a\u00020[H\u0002J\u0017\u0010\u00f3\u0001\u001a\b\u0012\u0004\u0012\u00020\"0!2\u0006\u0010j\u001a\u00020[H\u0003J'\u0010\u00f5\u0001\u001a\b\u0012\u0004\u0012\u00020E0!2\u0006\u0010j\u001a\u00020[2\u000e\u0010u\u001a\n\u0018\u00010vj\u0004\u0018\u0001`wH\u0003J\u0011\u0010\u00f6\u0001\u001a\u0004\u0018\u00010=H\u0000\u00a2\u0006\u0003\b\u00f7\u0001J\u0019\u0010\u00f8\u0001\u001a\u00020;2\b\u0010#\u001a\u0004\u0018\u00010\"H\u0001\u00a2\u0006\u0003\b\u00f9\u0001J\t\u0010\u00fa\u0001\u001a\u00020;H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\"0!0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010#\u001a\u0004\u0018\u00010\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020%0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010&\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010(0'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010)\u001a \u0012\u001c\u0012\u001a\u0012\u0006\u0012\u0004\u0018\u00010( +*\f\u0012\u0006\u0012\u0004\u0018\u00010(\u0018\u00010*0*0'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020/X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u000201X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00102\u001a\u0004\u0018\u000103X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00104\u001a\u0004\u0018\u000105X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u00106\u001a\b\u0012\u0004\u0012\u00020807X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00109\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020;0:07X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010<\u001a\u0004\u0018\u00010=X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010>\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010?\u001a\u00020@8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bA\u0010BR\u0016\u0010T\u001a\u0004\u0018\u00010U8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bV\u0010WR\u0014\u0010^\u001a\u00020\f8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b_\u0010`R\u0016\u0010b\u001a\u0004\u0018\u00010c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bd\u0010eR\"\u0010m\u001a\u0010\u0012\u0004\u0012\u00020[\u0012\u0006\u0012\u0004\u0018\u00010[0n8CX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bo\u0010pR+\u0010~\u001a\u0004\u0018\u00010(2\b\u0010&\u001a\u0004\u0018\u00010(8@@BX\u0080\u000e\u00a2\u0006\u000f\u001a\u0005\b\u007f\u0010\u0080\u0001\"\u0006\b\u0081\u0001\u0010\u0082\u0001R\u0019\u0010\u0083\u0001\u001a\u0004\u0018\u00010(8@X\u0080\u0004\u00a2\u0006\b\u001a\u0006\b\u0084\u0001\u0010\u0080\u0001R\u0018\u0010\u0085\u0001\u001a\u00030\u0086\u00018@X\u0080\u0004\u00a2\u0006\b\u001a\u0006\b\u0087\u0001\u0010\u0088\u0001R\u001a\u0010\u0089\u0001\u001a\u0005\u0018\u00010\u008a\u00018@X\u0080\u0004\u00a2\u0006\b\u001a\u0006\b\u008b\u0001\u0010\u008c\u0001R\u001f\u0010\u0093\u0001\u001a\n\u0012\u0005\u0012\u00030\u008f\u00010\u0094\u00018@X\u0080\u0004\u00a2\u0006\b\u001a\u0006\b\u0095\u0001\u0010\u0096\u0001R\u001a\u0010\u009b\u0001\u001a\u0005\u0018\u00010\u009c\u00018@X\u0080\u0004\u00a2\u0006\b\u001a\u0006\b\u009d\u0001\u0010\u009e\u0001R\u001a\u0010\u009f\u0001\u001a\u0005\u0018\u00010\u00a0\u00018@X\u0080\u0004\u00a2\u0006\b\u001a\u0006\b\u00a1\u0001\u0010\u00a2\u0001R\u001a\u0010\u00ad\u0001\u001a\u0005\u0018\u00010\u00ae\u00018@X\u0080\u0004\u00a2\u0006\b\u001a\u0006\b\u00af\u0001\u0010\u00b0\u0001R\u0017\u0010\u00b1\u0001\u001a\u0002058@X\u0080\u0004\u00a2\u0006\b\u001a\u0006\b\u00b2\u0001\u0010\u00b3\u0001R\u001b\u0010\u00d1\u0001\u001a\n\u0012\u0004\u0012\u00020E\u0018\u00010!8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u00e4\u0001\u001a\t\u0012\u0005\u0012\u00030\u00b6\u00010!8BX\u0082\u0004\u00a2\u0006\b\u001a\u0006\b\u00e5\u0001\u0010\u00e6\u0001R\u001d\u0010\u00e7\u0001\u001a\b\u0012\u0004\u0012\u00020\f0!8BX\u0082\u0004\u00a2\u0006\b\u001a\u0006\b\u00e7\u0001\u0010\u00e6\u0001R\u001b\u0010\u00ed\u0001\u001a\n\u0012\u0004\u0012\u00020\"\u0018\u00010!8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u00f4\u0001\u001a\n\u0012\u0004\u0012\u00020E\u0018\u00010!8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u00fd\u0001"}, d2={"Lcom/facebook/react/runtime/ReactHostImpl;", "Lcom/facebook/react/ReactHost;", "context", "Landroid/content/Context;", "reactHostDelegate", "Lcom/facebook/react/runtime/ReactHostDelegate;", "componentFactory", "Lcom/facebook/react/fabric/ComponentFactory;", "bgExecutor", "Ljava/util/concurrent/Executor;", "uiExecutor", "allowPackagerServerAccess", "", "useDevSupport", "devSupportManagerFactory", "Lcom/facebook/react/devsupport/DevSupportManagerFactory;", "<init>", "(Landroid/content/Context;Lcom/facebook/react/runtime/ReactHostDelegate;Lcom/facebook/react/fabric/ComponentFactory;Ljava/util/concurrent/Executor;Ljava/util/concurrent/Executor;ZZLcom/facebook/react/devsupport/DevSupportManagerFactory;)V", "delegate", "(Landroid/content/Context;Lcom/facebook/react/runtime/ReactHostDelegate;Lcom/facebook/react/fabric/ComponentFactory;ZZ)V", "devSupportManager", "Lcom/facebook/react/devsupport/interfaces/DevSupportManager;", "getDevSupportManager", "()Lcom/facebook/react/devsupport/interfaces/DevSupportManager;", "memoryPressureRouter", "Lcom/facebook/react/MemoryPressureRouter;", "getMemoryPressureRouter", "()Lcom/facebook/react/MemoryPressureRouter;", "attachedSurfaces", "", "Lcom/facebook/react/runtime/ReactSurfaceImpl;", "createReactInstanceTaskRef", "Lcom/facebook/react/runtime/BridgelessAtomicRef;", "Lcom/facebook/react/runtime/internal/bolts/Task;", "Lcom/facebook/react/runtime/ReactInstance;", "reactInstance", "bridgelessReactContextRef", "Lcom/facebook/react/runtime/BridgelessReactContext;", "activity", "Ljava/util/concurrent/atomic/AtomicReference;", "Landroid/app/Activity;", "lastUsedActivityRef", "Ljava/lang/ref/WeakReference;", "kotlin.jvm.PlatformType", "bridgelessReactStateTracker", "Lcom/facebook/react/runtime/BridgelessReactStateTracker;", "reactLifecycleStateManager", "Lcom/facebook/react/runtime/ReactLifecycleStateManager;", "id", "", "memoryPressureListener", "Lcom/facebook/react/bridge/MemoryPressureListener;", "defaultHardwareBackBtnHandler", "Lcom/facebook/react/modules/core/DefaultHardwareBackBtnHandler;", "reactInstanceEventListeners", "", "Lcom/facebook/react/ReactInstanceEventListener;", "beforeDestroyListeners", "Lkotlin/Function0;", "", "reactHostInspectorTarget", "Lcom/facebook/react/runtime/ReactHostInspectorTarget;", "hostInvalidated", "lifecycleState", "Lcom/facebook/react/common/LifecycleState;", "getLifecycleState", "()Lcom/facebook/react/common/LifecycleState;", "start", "Lcom/facebook/react/interfaces/TaskInterface;", "Ljava/lang/Void;", "prerenderSurface", "surface", "prerenderSurface$ReactAndroid_debug", "startSurface", "startSurface$ReactAndroid_debug", "stopSurface", "stopSurface$ReactAndroid_debug", "onHostResume", "defaultBackButtonImpl", "onHostLeaveHint", "onHostPause", "onHostDestroy", "maybeEnableDevSupport", "enabled", "currentReactContext", "Lcom/facebook/react/bridge/ReactContext;", "getCurrentReactContext", "()Lcom/facebook/react/bridge/ReactContext;", "createSurface", "Lcom/facebook/react/interfaces/fabric/ReactSurface;", "moduleName", "", "initialProps", "Landroid/os/Bundle;", "isInstanceInitialized", "isInstanceInitialized$ReactAndroid_debug", "()Z", "onBackPressed", "reactQueueConfiguration", "Lcom/facebook/react/bridge/queue/ReactQueueConfiguration;", "getReactQueueConfiguration", "()Lcom/facebook/react/bridge/queue/ReactQueueConfiguration;", "addReactInstanceEventListener", "listener", "removeReactInstanceEventListener", "reload", "reason", "setPausedInDebuggerMessage", "message", "hostMetadata", "", "getHostMetadata", "()Ljava/util/Map;", "loadNetworkResource", "url", "Lcom/facebook/react/devsupport/inspector/InspectorNetworkRequestListener;", "destroy", "ex", "Ljava/lang/Exception;", "Lkotlin/Exception;", "onDestroyFinished", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "instanceDestroyedSuccessfully", "createMemoryPressureListener", "currentActivity", "getCurrentActivity$ReactAndroid_debug", "()Landroid/app/Activity;", "setCurrentActivity", "(Landroid/app/Activity;)V", "lastUsedActivity", "getLastUsedActivity$ReactAndroid_debug", "eventDispatcher", "Lcom/facebook/react/uimanager/events/EventDispatcher;", "getEventDispatcher$ReactAndroid_debug", "()Lcom/facebook/react/uimanager/events/EventDispatcher;", "uiManager", "Lcom/facebook/react/fabric/FabricUIManager;", "getUiManager$ReactAndroid_debug", "()Lcom/facebook/react/fabric/FabricUIManager;", "hasNativeModule", "T", "Lcom/facebook/react/bridge/NativeModule;", "nativeModuleInterface", "Ljava/lang/Class;", "hasNativeModule$ReactAndroid_debug", "nativeModules", "", "getNativeModules$ReactAndroid_debug", "()Ljava/util/Collection;", "getNativeModule", "getNativeModule$ReactAndroid_debug", "(Ljava/lang/Class;)Lcom/facebook/react/bridge/NativeModule;", "nativeModuleName", "runtimeExecutor", "Lcom/facebook/react/bridge/RuntimeExecutor;", "getRuntimeExecutor$ReactAndroid_debug", "()Lcom/facebook/react/bridge/RuntimeExecutor;", "jsCallInvokerHolder", "Lcom/facebook/react/turbomodule/core/interfaces/CallInvokerHolder;", "getJsCallInvokerHolder$ReactAndroid_debug", "()Lcom/facebook/react/turbomodule/core/interfaces/CallInvokerHolder;", "onActivityResult", "requestCode", "resultCode", "data", "Landroid/content/Intent;", "onWindowFocusChange", "hasFocus", "onNewIntent", "intent", "onConfigurationChanged", "javaScriptContextHolder", "Lcom/facebook/react/bridge/JavaScriptContextHolder;", "getJavaScriptContextHolder$ReactAndroid_debug", "()Lcom/facebook/react/bridge/JavaScriptContextHolder;", "defaultBackButtonHandler", "getDefaultBackButtonHandler$ReactAndroid_debug", "()Lcom/facebook/react/modules/core/DefaultHardwareBackBtnHandler;", "loadBundle", "bundleLoader", "Lcom/facebook/react/bridge/JSBundleLoader;", "loadBundle$ReactAndroid_debug", "registerSegment", "segmentId", "path", "callback", "Lcom/facebook/react/bridge/Callback;", "registerSegment$ReactAndroid_debug", "handleHostException", "e", "handleHostException$ReactAndroid_debug", "callFunctionOnModule", "methodName", "args", "Lcom/facebook/react/bridge/NativeArray;", "callFunctionOnModule$ReactAndroid_debug", "attachSurface", "attachSurface$ReactAndroid_debug", "detachSurface", "detachSurface$ReactAndroid_debug", "isSurfaceAttached", "isSurfaceAttached$ReactAndroid_debug", "isSurfaceWithModuleNameAttached", "isSurfaceWithModuleNameAttached$ReactAndroid_debug", "addBeforeDestroyListener", "onBeforeDestroy", "removeBeforeDestroyListener", "startTask", "getOrCreateStartTask", "moveToHostDestroy", "currentContext", "raiseSoftException", "callingMethod", "throwable", "", "callWithExistingReactInstance", "executor", "runnable", "callAfterGetOrCreateReactInstance", "getOrCreateReactContext", "getOrCreateReactInstance", "waitThenCallGetOrCreateReactInstanceTask", "waitThenCallGetOrCreateReactInstanceTaskWithRetries", "tryNum", "maxTries", "getOrCreateReactInstanceTask", "jsBundleLoader", "getJsBundleLoader", "()Lcom/facebook/react/runtime/internal/bolts/Task;", "isMetroRunning", "loadJSBundleFromMetro", "log", "method", "stopAttachedSurfaces", "startAttachedSurfaces", "reloadTask", "createReactInstanceUnwrapper", "Lkotlin/Function2;", "task", "stage", "tag", "getOrCreateReloadTask", "destroyTask", "getOrCreateDestroyTask", "getOrCreateReactHostInspectorTarget", "getOrCreateReactHostInspectorTarget$ReactAndroid_debug", "unregisterInstanceFromInspector", "unregisterInstanceFromInspector$ReactAndroid_debug", "invalidate", "CreationResult", "Companion", "ReactAndroid_debug"})
@DoNotStrip
@ThreadSafe
@SourceDebugExtension(value={"SMAP\nReactHostImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReactHostImpl.kt\ncom/facebook/react/runtime/ReactHostImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1473:1\n1#2:1474\n1761#3,3:1475\n*S KotlinDebug\n*F\n+ 1 ReactHostImpl.kt\ncom/facebook/react/runtime/ReactHostImpl\n*L\n709#1:1475,3\n*E\n"})
public final class ReactHostImpl
implements ReactHost {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final ReactHostDelegate reactHostDelegate;
    @NotNull
    private final ComponentFactory componentFactory;
    @NotNull
    private final Executor bgExecutor;
    @NotNull
    private final Executor uiExecutor;
    private final boolean allowPackagerServerAccess;
    private final boolean useDevSupport;
    @NotNull
    private final DevSupportManager devSupportManager;
    @NotNull
    private final MemoryPressureRouter memoryPressureRouter;
    @NotNull
    private final Set<ReactSurfaceImpl> attachedSurfaces;
    @NotNull
    private final BridgelessAtomicRef<Task<ReactInstance>> createReactInstanceTaskRef;
    @Nullable
    private ReactInstance reactInstance;
    @NotNull
    private final BridgelessAtomicRef<BridgelessReactContext> bridgelessReactContextRef;
    @NotNull
    private final AtomicReference<Activity> activity;
    @NotNull
    private final AtomicReference<WeakReference<Activity>> lastUsedActivityRef;
    @NotNull
    private final BridgelessReactStateTracker bridgelessReactStateTracker;
    @NotNull
    private final ReactLifecycleStateManager reactLifecycleStateManager;
    private final int id;
    @Nullable
    private MemoryPressureListener memoryPressureListener;
    @Nullable
    private DefaultHardwareBackBtnHandler defaultHardwareBackBtnHandler;
    @NotNull
    private final List<ReactInstanceEventListener> reactInstanceEventListeners;
    @NotNull
    private final List<Function0<Unit>> beforeDestroyListeners;
    @Nullable
    private ReactHostInspectorTarget reactHostInspectorTarget;
    private volatile boolean hostInvalidated;
    @ThreadConfined(value="ReactHost")
    @Nullable
    private Task<Void> startTask;
    @ThreadConfined(value="ReactHost")
    @Nullable
    private Task<ReactInstance> reloadTask;
    @ThreadConfined(value="ReactHost")
    @Nullable
    private Task<Void> destroyTask;
    @NotNull
    private static final String TAG = "ReactHost";
    private static final int BRIDGELESS_MARKER_INSTANCE_KEY = 1;
    @NotNull
    private static final AtomicInteger counter = new AtomicInteger(0);

    public ReactHostImpl(@NotNull Context context, @NotNull ReactHostDelegate reactHostDelegate, @NotNull ComponentFactory componentFactory, @NotNull Executor bgExecutor, @NotNull Executor uiExecutor, boolean allowPackagerServerAccess, boolean useDevSupport, @Nullable DevSupportManagerFactory devSupportManagerFactory) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reactHostDelegate, (String)"reactHostDelegate");
        Intrinsics.checkNotNullParameter((Object)componentFactory, (String)"componentFactory");
        Intrinsics.checkNotNullParameter((Object)bgExecutor, (String)"bgExecutor");
        Intrinsics.checkNotNullParameter((Object)uiExecutor, (String)"uiExecutor");
        this.context = context;
        this.reactHostDelegate = reactHostDelegate;
        this.componentFactory = componentFactory;
        this.bgExecutor = bgExecutor;
        this.uiExecutor = uiExecutor;
        this.allowPackagerServerAccess = allowPackagerServerAccess;
        this.useDevSupport = useDevSupport;
        DevSupportManagerFactory devSupportManagerFactory2 = devSupportManagerFactory;
        if (devSupportManagerFactory2 == null) {
            devSupportManagerFactory2 = new DefaultDevSupportManagerFactory();
        }
        Context context2 = this.context.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"getApplicationContext(...)");
        this.devSupportManager = devSupportManagerFactory2.create(context2, new ReactHostImplDevHelper(this), this.reactHostDelegate.getJsMainModulePath(), true, null, null, 2, null, null, null, null, this.useDevSupport);
        this.memoryPressureRouter = new MemoryPressureRouter(this.context);
        this.attachedSurfaces = new HashSet();
        this.createReactInstanceTaskRef = new BridgelessAtomicRef<Task<Object>>(Task.Companion.forResult(null));
        this.bridgelessReactContextRef = new BridgelessAtomicRef(null, 1, null);
        this.activity = new AtomicReference();
        this.lastUsedActivityRef = new AtomicReference<WeakReference<Object>>(new WeakReference<Object>(null));
        this.bridgelessReactStateTracker = new BridgelessReactStateTracker(ReactBuildConfig.DEBUG);
        this.reactLifecycleStateManager = new ReactLifecycleStateManager(this.bridgelessReactStateTracker);
        this.id = counter.getAndIncrement();
        this.reactInstanceEventListeners = new CopyOnWriteArrayList();
        this.beforeDestroyListeners = new CopyOnWriteArrayList();
    }

    public /* synthetic */ ReactHostImpl(Context context, ReactHostDelegate reactHostDelegate, ComponentFactory componentFactory, Executor executor, Executor executor2, boolean bl, boolean bl2, DevSupportManagerFactory devSupportManagerFactory, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            executor = Executors.newSingleThreadExecutor();
        }
        if ((n & 0x10) != 0) {
            executor2 = Task.UI_THREAD_EXECUTOR;
        }
        if ((n & 0x80) != 0) {
            devSupportManagerFactory = null;
        }
        this(context, reactHostDelegate, componentFactory, executor, executor2, bl, bl2, devSupportManagerFactory);
    }

    @Override
    @NotNull
    public DevSupportManager getDevSupportManager() {
        return this.devSupportManager;
    }

    @Override
    @NotNull
    public MemoryPressureRouter getMemoryPressureRouter() {
        return this.memoryPressureRouter;
    }

    public ReactHostImpl(@NotNull Context context, @NotNull ReactHostDelegate delegate, @NotNull ComponentFactory componentFactory, boolean allowPackagerServerAccess, boolean useDevSupport) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter((Object)componentFactory, (String)"componentFactory");
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"newSingleThreadExecutor(...)");
        this(context, delegate, componentFactory, executorService, Task.UI_THREAD_EXECUTOR, allowPackagerServerAccess, useDevSupport, null, 128, null);
    }

    @Override
    @NotNull
    public LifecycleState getLifecycleState() {
        return this.reactLifecycleStateManager.getLifecycleState();
    }

    @Override
    @NotNull
    public TaskInterface<Void> start() {
        return Task.Companion.call(() -> ReactHostImpl.start$lambda$0(this), this.bgExecutor);
    }

    @NotNull
    public final TaskInterface<Void> prerenderSurface$ReactAndroid_debug(@NotNull ReactSurfaceImpl surface) {
        Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
        String method = "prerenderSurface(surfaceId = " + surface.getSurfaceID() + ")";
        this.log(method, "Schedule");
        this.attachSurface$ReactAndroid_debug(surface);
        return this.callAfterGetOrCreateReactInstance(method, this.bgExecutor, (Function1<? super ReactInstance, Unit>)((Function1)arg_0 -> ReactHostImpl.prerenderSurface$lambda$1(this, method, surface, arg_0)));
    }

    @NotNull
    public final TaskInterface<Void> startSurface$ReactAndroid_debug(@NotNull ReactSurfaceImpl surface) {
        Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
        String method = "startSurface(surfaceId = " + surface.getSurfaceID() + ")";
        this.log(method, "Schedule");
        this.attachSurface$ReactAndroid_debug(surface);
        return this.callAfterGetOrCreateReactInstance(method, this.bgExecutor, (Function1<? super ReactInstance, Unit>)((Function1)arg_0 -> ReactHostImpl.startSurface$lambda$2(this, method, surface, arg_0)));
    }

    @NotNull
    public final TaskInterface<Void> stopSurface$ReactAndroid_debug(@NotNull ReactSurfaceImpl surface) {
        Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
        String method = "stopSurface(surfaceId = " + surface.getSurfaceID() + ")";
        this.log(method, "Schedule");
        this.detachSurface$ReactAndroid_debug(surface);
        return this.callWithExistingReactInstance(method, this.bgExecutor, (Function1<? super ReactInstance, Unit>)((Function1)arg_0 -> ReactHostImpl.stopSurface$lambda$3(this, method, surface, arg_0))).makeVoid();
    }

    @Override
    @ThreadConfined(value="UI")
    public void onHostResume(@Nullable Activity activity, @Nullable DefaultHardwareBackBtnHandler defaultBackButtonImpl) {
        this.defaultHardwareBackBtnHandler = defaultBackButtonImpl;
        this.onHostResume(activity);
    }

    @Override
    @ThreadConfined(value="UI")
    public void onHostResume(@Nullable Activity activity) {
        String method = "onHostResume(activity)";
        this.log(method);
        this.setCurrentActivity(activity);
        this.maybeEnableDevSupport(true);
        this.reactLifecycleStateManager.moveToOnHostResume(this.getCurrentReactContext(), activity);
    }

    @Override
    @ThreadConfined(value="UI")
    public void onHostLeaveHint(@Nullable Activity activity) {
        block0: {
            String method = "onUserLeaveHint(activity)";
            this.log(method);
            ReactContext reactContext = this.getCurrentReactContext();
            if (reactContext == null) break block0;
            reactContext.onUserLeaveHint(activity);
        }
    }

    @Override
    @ThreadConfined(value="UI")
    public void onHostPause(@Nullable Activity activity) {
        String method = "onHostPause(activity)";
        this.log(method);
        Activity currentActivity = this.getCurrentActivity$ReactAndroid_debug();
        if (currentActivity != null) {
            String currentActivityClass = currentActivity.getClass().getSimpleName();
            Activity activity2 = activity;
            String activityClass = activity2 == null ? "null" : activity2.getClass().getSimpleName();
            Assertions.assertCondition((activity == currentActivity ? 1 : 0) != 0, (String)("Pausing an activity that is not the current activity, this is incorrect! Current activity: " + currentActivityClass + " Paused activity: " + activityClass));
        }
        this.maybeEnableDevSupport(false);
        this.defaultHardwareBackBtnHandler = null;
        this.reactLifecycleStateManager.moveToOnHostPause(this.getCurrentReactContext(), currentActivity);
    }

    @Override
    @ThreadConfined(value="UI")
    public void onHostPause() {
        String method = "onHostPause()";
        this.log(method);
        this.maybeEnableDevSupport(false);
        this.defaultHardwareBackBtnHandler = null;
        this.reactLifecycleStateManager.moveToOnHostPause(this.getCurrentReactContext(), this.getCurrentActivity$ReactAndroid_debug());
    }

    @Override
    @ThreadConfined(value="UI")
    public void onHostDestroy() {
        String method = "onHostDestroy()";
        this.log(method);
        this.maybeEnableDevSupport(false);
        this.moveToHostDestroy(this.getCurrentReactContext());
    }

    @Override
    @ThreadConfined(value="UI")
    public void onHostDestroy(@Nullable Activity activity) {
        String method = "onHostDestroy(activity)";
        this.log(method);
        Activity currentActivity = this.getCurrentActivity$ReactAndroid_debug();
        if (currentActivity == activity) {
            this.maybeEnableDevSupport(false);
            this.moveToHostDestroy(this.getCurrentReactContext());
        }
    }

    private final void maybeEnableDevSupport(boolean enabled) {
        if (this.useDevSupport) {
            this.getDevSupportManager().setDevSupportEnabled(enabled);
        }
    }

    @Override
    @Nullable
    public ReactContext getCurrentReactContext() {
        return this.bridgelessReactContextRef.getNullable();
    }

    @Override
    @NotNull
    public ReactSurface createSurface(@NotNull Context context, @NotNull String moduleName, @Nullable Bundle initialProps) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        ReactSurfaceImpl surface = new ReactSurfaceImpl(context, moduleName, initialProps);
        ReactSurfaceView surfaceView = new ReactSurfaceView(context, surface);
        surfaceView.setShouldLogContentAppeared(true);
        surface.attachView(surfaceView);
        surface.attach(this);
        return surface;
    }

    public final boolean isInstanceInitialized$ReactAndroid_debug() {
        return this.reactInstance != null;
    }

    @Override
    @ThreadConfined(value="UI")
    public boolean onBackPressed() {
        UiThreadUtil.assertOnUiThread();
        ReactInstance reactInstance = this.reactInstance;
        if (reactInstance == null) {
            return false;
        }
        ReactInstance reactInstance2 = reactInstance;
        DeviceEventManagerModule deviceEventManagerModule = reactInstance2.getNativeModule(DeviceEventManagerModule.class);
        if (deviceEventManagerModule == null) {
            return false;
        }
        DeviceEventManagerModule deviceEventManagerModule2 = deviceEventManagerModule;
        deviceEventManagerModule2.emitHardwareBackPressed();
        return true;
    }

    @Override
    @Nullable
    public ReactQueueConfiguration getReactQueueConfiguration() {
        ReactInstance reactInstance = this.reactInstance;
        return reactInstance != null ? reactInstance.getReactQueueConfiguration() : null;
    }

    @Override
    public void addReactInstanceEventListener(@NotNull ReactInstanceEventListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.reactInstanceEventListeners.add(listener);
    }

    @Override
    public void removeReactInstanceEventListener(@NotNull ReactInstanceEventListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.reactInstanceEventListeners.remove(listener);
    }

    @Override
    @NotNull
    public TaskInterface<Void> reload(@NotNull String reason) {
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        return Task.Companion.call(() -> ReactHostImpl.reload$lambda$7(this, reason), this.bgExecutor);
    }

    @DoNotStrip
    private final void setPausedInDebuggerMessage(String message) {
        if (message == null) {
            this.getDevSupportManager().hidePausedInDebuggerOverlay();
        } else {
            this.getDevSupportManager().showPausedInDebuggerOverlay(message, new DevSupportManager.PausedInDebuggerOverlayCommandListener(this){
                final /* synthetic */ ReactHostImpl this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onResume() {
                    block0: {
                        UiThreadUtil.assertOnUiThread();
                        ReactHostInspectorTarget reactHostInspectorTarget = ReactHostImpl.access$getReactHostInspectorTarget$p(this.this$0);
                        if (reactHostInspectorTarget == null) break block0;
                        reactHostInspectorTarget.sendDebuggerResumeCommand();
                    }
                }
            });
        }
    }

    @DoNotStrip
    private final Map<String, String> getHostMetadata() {
        return AndroidInfoHelpers.getInspectorHostMetadata(this.context);
    }

    @DoNotStrip
    private final void loadNetworkResource(String url, InspectorNetworkRequestListener listener) {
        InspectorNetworkHelper.loadNetworkResource(url, listener);
    }

    @Override
    @NotNull
    public TaskInterface<Void> destroy(@NotNull String reason, @Nullable Exception ex, @NotNull Function1<? super Boolean, Unit> onDestroyFinished) {
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        Intrinsics.checkNotNullParameter(onDestroyFinished, (String)"onDestroyFinished");
        TaskInterface<Void> taskInterface = this.destroy(reason, ex);
        Intrinsics.checkNotNull(taskInterface, (String)"null cannot be cast to non-null type com.facebook.react.runtime.internal.bolts.Task<java.lang.Void>");
        Task destroyTask = (Task)taskInterface;
        return Task.continueWith$default(destroyTask, arg_0 -> ReactHostImpl.destroy$lambda$8(onDestroyFinished, arg_0), null, 2, null);
    }

    @Override
    @NotNull
    public TaskInterface<Void> destroy(@NotNull String reason, @Nullable Exception ex) {
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        return Task.Companion.call(() -> ReactHostImpl.destroy$lambda$10(this, reason, ex), this.bgExecutor);
    }

    private final MemoryPressureListener createMemoryPressureListener(ReactInstance reactInstance) {
        WeakReference<ReactInstance> weakReactInstance = new WeakReference<ReactInstance>(reactInstance);
        return arg_0 -> ReactHostImpl.createMemoryPressureListener$lambda$12(this, weakReactInstance, arg_0);
    }

    @Nullable
    public final Activity getCurrentActivity$ReactAndroid_debug() {
        return this.activity.get();
    }

    private final void setCurrentActivity(Activity activity) {
        this.activity.set(activity);
        if (activity != null) {
            this.lastUsedActivityRef.set(new WeakReference<Activity>(activity));
        }
    }

    @Nullable
    public final Activity getLastUsedActivity$ReactAndroid_debug() {
        WeakReference<Activity> weakReference = this.lastUsedActivityRef.get();
        return weakReference != null ? (Activity)weakReference.get() : null;
    }

    @NotNull
    public final EventDispatcher getEventDispatcher$ReactAndroid_debug() {
        Object object = this.reactInstance;
        if (object == null || (object = ((ReactInstance)object).getEventDispatcher()) == null) {
            object = BlackHoleEventDispatcher.INSTANCE;
        }
        return object;
    }

    @Nullable
    public final FabricUIManager getUiManager$ReactAndroid_debug() {
        ReactInstance reactInstance = this.reactInstance;
        return reactInstance != null ? reactInstance.getFabricUIManager() : null;
    }

    public final <T extends NativeModule> boolean hasNativeModule$ReactAndroid_debug(@NotNull Class<T> nativeModuleInterface) {
        Intrinsics.checkNotNullParameter(nativeModuleInterface, (String)"nativeModuleInterface");
        ReactInstance reactInstance = this.reactInstance;
        return reactInstance != null ? reactInstance.hasNativeModule(nativeModuleInterface) : false;
    }

    @NotNull
    public final Collection<NativeModule> getNativeModules$ReactAndroid_debug() {
        Object object = this.reactInstance;
        if (object == null || (object = ((ReactInstance)object).getNativeModules()) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    @Nullable
    public final <T extends NativeModule> T getNativeModule$ReactAndroid_debug(@NotNull Class<T> nativeModuleInterface) {
        Intrinsics.checkNotNullParameter(nativeModuleInterface, (String)"nativeModuleInterface");
        if (!ReactBuildConfig.UNSTABLE_ENABLE_MINIFY_LEGACY_ARCHITECTURE && Intrinsics.areEqual(nativeModuleInterface, UIManagerModule.class)) {
            ReactSoftExceptionLogger.logSoftExceptionVerbose(TAG, new ReactNoCrashBridgeNotAllowedSoftException("getNativeModule(UIManagerModule.class) cannot be called when the bridge is disabled"));
        }
        ReactInstance reactInstance = this.reactInstance;
        return (T)(reactInstance != null ? reactInstance.getNativeModule(nativeModuleInterface) : null);
    }

    @Nullable
    public final NativeModule getNativeModule$ReactAndroid_debug(@NotNull String nativeModuleName) {
        Intrinsics.checkNotNullParameter((Object)nativeModuleName, (String)"nativeModuleName");
        ReactInstance reactInstance = this.reactInstance;
        return reactInstance != null ? reactInstance.getNativeModule(nativeModuleName) : null;
    }

    @Nullable
    public final RuntimeExecutor getRuntimeExecutor$ReactAndroid_debug() {
        ReactInstance reactInstance = this.reactInstance;
        if (reactInstance != null) {
            ReactInstance $this$_get_runtimeExecutor__u24lambda_u2413 = reactInstance;
            boolean bl = false;
            return $this$_get_runtimeExecutor__u24lambda_u2413.getBufferedRuntimeExecutor();
        }
        ReactHostImpl.raiseSoftException$default(this, "getRuntimeExecutor()", "Tried to get runtime executor while instance is not ready", null, 4, null);
        return null;
    }

    @Nullable
    public final CallInvokerHolder getJsCallInvokerHolder$ReactAndroid_debug() {
        ReactInstance reactInstance = this.reactInstance;
        if (reactInstance != null) {
            ReactInstance $this$_get_jsCallInvokerHolder__u24lambda_u2414 = reactInstance;
            boolean bl = false;
            return $this$_get_jsCallInvokerHolder__u24lambda_u2414.getJSCallInvokerHolder();
        }
        ReactHostImpl.raiseSoftException$default(this, "getJSCallInvokerHolder()", "Tried to get JSCallInvokerHolder while instance is not ready", null, 4, null);
        return null;
    }

    @Override
    @ThreadConfined(value="UI")
    public void onActivityResult(@NotNull Activity activity, int requestCode, int resultCode, @Nullable Intent data) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        String method = "onActivityResult(activity = \"" + activity + "\", requestCode = \"" + requestCode + "\", resultCode = \"" + resultCode + "\", data = \"" + data + "\")";
        ReactContext currentContext = this.getCurrentReactContext();
        if (currentContext != null) {
            currentContext.onActivityResult(activity, requestCode, resultCode, data);
        } else {
            ReactHostImpl.raiseSoftException$default(this, method, "Tried to access onActivityResult while context is not ready", null, 4, null);
        }
    }

    @Override
    @ThreadConfined(value="UI")
    public void onWindowFocusChange(boolean hasFocus) {
        ReactContext currentContext = this.getCurrentReactContext();
        if (currentContext != null) {
            currentContext.onWindowFocusChange(hasFocus);
        } else {
            String method = "onWindowFocusChange(hasFocus = \"" + hasFocus + "\")";
            ReactHostImpl.raiseSoftException$default(this, method, "Tried to access onWindowFocusChange while context is not ready", null, 4, null);
        }
    }

    @Override
    @ThreadConfined(value="UI")
    public void onNewIntent(@NotNull Intent intent) {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        ReactContext currentContext = this.getCurrentReactContext();
        if (currentContext != null) {
            String action = intent.getAction();
            Uri uri = intent.getData();
            if (uri != null && (Intrinsics.areEqual((Object)"android.intent.action.VIEW", (Object)action) || Intrinsics.areEqual((Object)"android.nfc.action.NDEF_DISCOVERED", (Object)action))) {
                DeviceEventManagerModule deviceEventManagerModule;
                DeviceEventManagerModule deviceEventManagerModule2 = deviceEventManagerModule = currentContext.getNativeModule(DeviceEventManagerModule.class);
                if (deviceEventManagerModule2 != null) {
                    deviceEventManagerModule2.emitNewIntentReceived(uri);
                }
            }
            currentContext.onNewIntent(this.getCurrentActivity$ReactAndroid_debug(), intent);
        } else {
            String method = "onNewIntent(intent = \"" + intent + "\")";
            ReactHostImpl.raiseSoftException$default(this, method, "Tried to access onNewIntent while context is not ready", null, 4, null);
        }
    }

    @Override
    @ThreadConfined(value="UI")
    public void onConfigurationChanged(@NotNull Context context) {
        block2: {
            AppearanceModule appearanceModule;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            ReactContext currentReactContext = this.getCurrentReactContext();
            if (currentReactContext == null) break block2;
            if (ReactNativeFeatureFlags.enableFontScaleChangesUpdatingLayout()) {
                DisplayMetricsHolder.initDisplayMetrics((Context)currentReactContext);
            }
            AppearanceModule appearanceModule2 = appearanceModule = currentReactContext.getNativeModule(AppearanceModule.class);
            if (appearanceModule2 != null) {
                appearanceModule2.onConfigurationChanged(context);
            }
        }
    }

    @Nullable
    public final JavaScriptContextHolder getJavaScriptContextHolder$ReactAndroid_debug() {
        ReactInstance reactInstance = this.reactInstance;
        return reactInstance != null ? reactInstance.getJavaScriptContextHolder() : null;
    }

    @NotNull
    public final DefaultHardwareBackBtnHandler getDefaultBackButtonHandler$ReactAndroid_debug() {
        return () -> ReactHostImpl._get_defaultBackButtonHandler_$lambda$15(this);
    }

    @NotNull
    public final Task<Boolean> loadBundle$ReactAndroid_debug(@NotNull JSBundleLoader bundleLoader) {
        Intrinsics.checkNotNullParameter((Object)bundleLoader, (String)"bundleLoader");
        String method = "loadBundle()";
        this.log(method, "Schedule");
        return ReactHostImpl.callWithExistingReactInstance$default(this, method, null, arg_0 -> ReactHostImpl.loadBundle$lambda$16(this, method, bundleLoader, arg_0), 2, null);
    }

    @NotNull
    public final Task<Boolean> registerSegment$ReactAndroid_debug(int segmentId, @NotNull String path, @Nullable Callback callback) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String method = "registerSegment(segmentId = \"" + segmentId + "\", path = \"" + path + "\")";
        this.log(method, "Schedule");
        return ReactHostImpl.callWithExistingReactInstance$default(this, method, null, arg_0 -> ReactHostImpl.registerSegment$lambda$17(this, method, segmentId, path, callback, arg_0), 2, null);
    }

    public final void handleHostException$ReactAndroid_debug(@NotNull Exception e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        String method = "handleHostException(message = \"" + e.getMessage() + "\")";
        this.log(method);
        if (this.useDevSupport) {
            this.getDevSupportManager().handleException(e);
        } else {
            this.reactHostDelegate.handleInstanceException(e);
        }
        this.destroy(method, e);
    }

    @NotNull
    public final Task<Boolean> callFunctionOnModule$ReactAndroid_debug(@NotNull String moduleName, @NotNull String methodName, @NotNull NativeArray args) {
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        String method = "callFunctionOnModule(\"" + moduleName + "\", \"" + methodName + "\")";
        return ReactHostImpl.callWithExistingReactInstance$default(this, method, null, arg_0 -> ReactHostImpl.callFunctionOnModule$lambda$18(moduleName, methodName, args, arg_0), 2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void attachSurface$ReactAndroid_debug(@NotNull ReactSurfaceImpl surface) {
        Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
        this.log("attachSurface(surfaceId = " + surface.getSurfaceID() + ")");
        Set<ReactSurfaceImpl> set = this.attachedSurfaces;
        synchronized (set) {
            boolean bl = false;
            boolean bl2 = this.attachedSurfaces.add(surface);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void detachSurface$ReactAndroid_debug(@NotNull ReactSurfaceImpl surface) {
        Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
        this.log("detachSurface(surfaceId = " + surface.getSurfaceID() + ")");
        Set<ReactSurfaceImpl> set = this.attachedSurfaces;
        synchronized (set) {
            boolean bl = false;
            boolean bl2 = this.attachedSurfaces.remove(surface);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isSurfaceAttached$ReactAndroid_debug(@NotNull ReactSurfaceImpl surface) {
        Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
        Set<ReactSurfaceImpl> set = this.attachedSurfaces;
        synchronized (set) {
            boolean bl = false;
            boolean bl2 = this.attachedSurfaces.contains(surface);
            return bl2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isSurfaceWithModuleNameAttached$ReactAndroid_debug(@NotNull String moduleName) {
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        Set<ReactSurfaceImpl> set = this.attachedSurfaces;
        synchronized (set) {
            boolean bl;
            block6: {
                boolean bl2 = false;
                Iterable $this$any$iv = this.attachedSurfaces;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ReactSurfaceImpl surface = (ReactSurfaceImpl)element$iv;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)surface.getModuleName(), (Object)moduleName)) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
            }
            boolean bl4 = bl;
            return bl4;
        }
    }

    @Override
    public void addBeforeDestroyListener(@NotNull Function0<Unit> onBeforeDestroy) {
        Intrinsics.checkNotNullParameter(onBeforeDestroy, (String)"onBeforeDestroy");
        this.beforeDestroyListeners.add(onBeforeDestroy);
    }

    @Override
    public void removeBeforeDestroyListener(@NotNull Function0<Unit> onBeforeDestroy) {
        Intrinsics.checkNotNullParameter(onBeforeDestroy, (String)"onBeforeDestroy");
        this.beforeDestroyListeners.remove(onBeforeDestroy);
    }

    @ThreadConfined(value="ReactHost")
    private final Task<Void> getOrCreateStartTask() {
        Task<Void> task;
        Task<Void> task2 = this.startTask;
        if (task2 != null) {
            Task<Void> it = task2;
            boolean bl = false;
            return it;
        }
        String method = "getOrCreateStartTask()";
        this.log(method, "Schedule");
        if (ReactBuildConfig.DEBUG) {
            Assertions.assertCondition((boolean)ReactNativeNewArchitectureFeatureFlags.enableBridgelessArchitecture(), (String)"enableBridgelessArchitecture FeatureFlag must be set to start ReactNative.");
            Assertions.assertCondition((boolean)ReactNativeNewArchitectureFeatureFlags.enableFabricRenderer(), (String)"enableFabricRenderer FeatureFlag must be set to start ReactNative.");
            Assertions.assertCondition((boolean)ReactNativeNewArchitectureFeatureFlags.useTurboModules(), (String)"useTurboModules FeatureFlag must be set to start ReactNative.");
        }
        if (ReactBuildConfig.UNSTABLE_ENABLE_MINIFY_LEGACY_ARCHITECTURE) {
            Assertions.assertCondition((!ReactNativeNewArchitectureFeatureFlags.useFabricInterop() ? 1 : 0) != 0, (String)"useFabricInterop FeatureFlag must be false when UNSTABLE_ENABLE_MINIFY_LEGACY_ARCHITECTURE == true.");
            Assertions.assertCondition((!ReactNativeNewArchitectureFeatureFlags.useTurboModuleInterop() ? 1 : 0) != 0, (String)"useTurboModuleInterop FeatureFlag must be false when UNSTABLE_ENABLE_MINIFY_LEGACY_ARCHITECTURE == true.");
        }
        Task<Void> it = task = this.waitThenCallGetOrCreateReactInstanceTask().continueWithTask(arg_0 -> ReactHostImpl.getOrCreateStartTask$lambda$26(this, arg_0), this.bgExecutor);
        boolean bl = false;
        this.startTask = it;
        return task;
    }

    @ThreadConfined(value="UI")
    private final void moveToHostDestroy(ReactContext currentContext) {
        this.reactLifecycleStateManager.moveToOnHostDestroy(currentContext);
        this.setCurrentActivity(null);
    }

    private final void raiseSoftException(String callingMethod, String message, Throwable throwable) {
        String method = "raiseSoftException(" + callingMethod + ")";
        this.log(method, message);
        ReactSoftExceptionLogger.logSoftException(TAG, new ReactNoCrashSoftException(method + ": " + message, throwable));
    }

    static /* synthetic */ void raiseSoftException$default(ReactHostImpl reactHostImpl, String string2, String string3, Throwable throwable, int n, Object object) {
        if ((n & 4) != 0) {
            throwable = null;
        }
        reactHostImpl.raiseSoftException(string2, string3, throwable);
    }

    private final Task<Boolean> callWithExistingReactInstance(String callingMethod, Executor executor, Function1<? super ReactInstance, Unit> runnable) {
        return this.createReactInstanceTaskRef.get().onSuccess(arg_0 -> ReactHostImpl.callWithExistingReactInstance$lambda$28(this, callingMethod, runnable, arg_0), executor);
    }

    static /* synthetic */ Task callWithExistingReactInstance$default(ReactHostImpl reactHostImpl, String string2, Executor executor, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            executor = Task.IMMEDIATE_EXECUTOR;
        }
        return reactHostImpl.callWithExistingReactInstance(string2, executor, (Function1<? super ReactInstance, Unit>)function1);
    }

    private final Task<Void> callAfterGetOrCreateReactInstance(String callingMethod, Executor executor, Function1<? super ReactInstance, Unit> runnable) {
        return Task.continueWith$default(this.getOrCreateReactInstance().onSuccess(arg_0 -> ReactHostImpl.callAfterGetOrCreateReactInstance$lambda$29(this, callingMethod, runnable, arg_0), executor), arg_0 -> ReactHostImpl.callAfterGetOrCreateReactInstance$lambda$30(this, arg_0), null, 2, null);
    }

    static /* synthetic */ Task callAfterGetOrCreateReactInstance$default(ReactHostImpl reactHostImpl, String string2, Executor executor, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            executor = Task.IMMEDIATE_EXECUTOR;
        }
        return reactHostImpl.callAfterGetOrCreateReactInstance(string2, executor, (Function1<? super ReactInstance, Unit>)function1);
    }

    private final BridgelessReactContext getOrCreateReactContext() {
        String method = "getOrCreateReactContext()";
        return this.bridgelessReactContextRef.getOrCreate(() -> ReactHostImpl.getOrCreateReactContext$lambda$31(this, method));
    }

    private final Task<ReactInstance> getOrCreateReactInstance() {
        return Task.Companion.call(() -> ReactHostImpl.getOrCreateReactInstance$lambda$32(this), this.bgExecutor);
    }

    @ThreadConfined(value="ReactHost")
    private final Task<ReactInstance> waitThenCallGetOrCreateReactInstanceTask() {
        return this.waitThenCallGetOrCreateReactInstanceTaskWithRetries(0, 4);
    }

    @ThreadConfined(value="ReactHost")
    private final Task<ReactInstance> waitThenCallGetOrCreateReactInstanceTaskWithRetries(int tryNum, int maxTries) {
        block2: {
            boolean shouldTryAgain;
            String method = "waitThenCallGetOrCreateReactInstanceTaskWithRetries";
            Task<ReactInstance> task = this.reloadTask;
            if (task != null) {
                Task<ReactInstance> task2 = task;
                boolean bl = false;
                this.log(method, "React Native is reloading. Return reload task.");
                return task2;
            }
            Task<Void> task3 = this.destroyTask;
            if (task3 == null) break block2;
            Task<Void> task4 = task3;
            boolean bl = false;
            boolean bl2 = shouldTryAgain = tryNum < maxTries;
            if (shouldTryAgain) {
                this.log(method, "React Native is tearing down.Wait for teardown to finish, before trying again (try count = " + tryNum + ").");
                return task4.onSuccessTask(arg_0 -> ReactHostImpl.waitThenCallGetOrCreateReactInstanceTaskWithRetries$lambda$35$lambda$34(this, tryNum, maxTries, arg_0), this.bgExecutor);
            }
            ReactHostImpl.raiseSoftException$default(this, method, "React Native is tearing down. Not wait for teardown to finish: reached max retries.", null, 4, null);
        }
        return this.getOrCreateReactInstanceTask();
    }

    @ThreadConfined(value="ReactHost")
    private final Task<ReactInstance> getOrCreateReactInstanceTask() {
        String method = "getOrCreateReactInstanceTask()";
        this.log(method);
        return this.createReactInstanceTaskRef.getOrCreate(() -> ReactHostImpl.getOrCreateReactInstanceTask$lambda$41(this, method));
    }

    private final Task<JSBundleLoader> getJsBundleLoader() {
        Task<JSBundleLoader> task;
        String method = "getJSBundleLoader()";
        this.log(method);
        if (this.useDevSupport && this.allowPackagerServerAccess) {
            return this.isMetroRunning().onSuccessTask(arg_0 -> ReactHostImpl._get_jsBundleLoader_$lambda$42(this, arg_0), this.bgExecutor);
        }
        if (ReactBuildConfig.DEBUG) {
            FLog.d((String)TAG, (String)"Packager server access is disabled in this environment");
        }
        try {
            task = Task.Companion.forResult(this.reactHostDelegate.getJsBundleLoader());
        }
        catch (Exception e) {
            task = Task.Companion.forError(e);
        }
        return task;
    }

    private final Task<Boolean> isMetroRunning() {
        String method = "isMetroRunning()";
        this.log(method);
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        DevSupportManager asyncDevSupportManager = this.getDevSupportManager();
        asyncDevSupportManager.isPackagerRunning(arg_0 -> ReactHostImpl._get_isMetroRunning_$lambda$43(this, method, taskCompletionSource, arg_0));
        return taskCompletionSource.getTask();
    }

    private final Task<JSBundleLoader> loadJSBundleFromMetro() {
        String method = "loadJSBundleFromMetro()";
        this.log(method);
        TaskCompletionSource<JSBundleLoader> taskCompletionSource = new TaskCompletionSource<JSBundleLoader>();
        DevSupportManager devSupportManager = this.getDevSupportManager();
        Intrinsics.checkNotNull((Object)devSupportManager, (String)"null cannot be cast to non-null type com.facebook.react.devsupport.DevSupportManagerBase");
        DevSupportManagerBase asyncDevSupportManager = (DevSupportManagerBase)devSupportManager;
        String string2 = asyncDevSupportManager.getJSAppBundleName();
        if (string2 == null) {
            String string3 = "Required value was null.";
            throw new IllegalStateException(string3.toString());
        }
        String bundleURL = asyncDevSupportManager.getDevServerHelper().getDevServerBundleURL(string2);
        asyncDevSupportManager.reloadJSFromServer(bundleURL, new BundleLoadCallback(this, method, bundleURL, asyncDevSupportManager, taskCompletionSource){
            final /* synthetic */ ReactHostImpl this$0;
            final /* synthetic */ String $method;
            final /* synthetic */ String $bundleURL;
            final /* synthetic */ DevSupportManagerBase $asyncDevSupportManager;
            final /* synthetic */ TaskCompletionSource<JSBundleLoader> $taskCompletionSource;
            {
                this.this$0 = $receiver;
                this.$method = $method;
                this.$bundleURL = $bundleURL;
                this.$asyncDevSupportManager = $asyncDevSupportManager;
                this.$taskCompletionSource = $taskCompletionSource;
            }

            public void onSuccess() {
                ReactHostImpl.access$log(this.this$0, this.$method, "Creating BundleLoader");
                JSBundleLoader bundleLoader = JSBundleLoader.Companion.createCachedBundleFromNetworkLoader(this.$bundleURL, this.$asyncDevSupportManager.getDownloadedJSBundleFile());
                this.$taskCompletionSource.setResult(bundleLoader);
            }

            public void onError(Exception cause) {
                Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
                this.$taskCompletionSource.setError(cause);
            }
        });
        return taskCompletionSource.getTask();
    }

    private final void log(String method, String message) {
        this.bridgelessReactStateTracker.enterState("ReactHost{" + this.id + "}." + method + ": " + message);
    }

    private final void log(String method) {
        this.bridgelessReactStateTracker.enterState("ReactHost{" + this.id + "}." + method);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void stopAttachedSurfaces(String method, ReactInstance reactInstance) {
        this.log(method, "Stopping all React Native surfaces");
        Set<ReactSurfaceImpl> set = this.attachedSurfaces;
        synchronized (set) {
            boolean bl = false;
            for (ReactSurfaceImpl surface : this.attachedSurfaces) {
                reactInstance.stopSurface(surface);
                surface.clear();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void startAttachedSurfaces(String method, ReactInstance reactInstance) {
        this.log(method, "Restarting previously running React Native Surfaces");
        Set<ReactSurfaceImpl> set = this.attachedSurfaces;
        synchronized (set) {
            boolean bl = false;
            for (ReactSurfaceImpl surface : this.attachedSurfaces) {
                reactInstance.startSurface(surface);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final Function2<Task<ReactInstance>, String, ReactInstance> createReactInstanceUnwrapper(String tag, String method, String reason) {
        return (arg_0, arg_1) -> ReactHostImpl.createReactInstanceUnwrapper$lambda$46(this, tag, reason, method, arg_0, arg_1);
    }

    @ThreadConfined(value="ReactHost")
    private final Task<ReactInstance> getOrCreateReloadTask(String reason) {
        Task<ReactInstance> task;
        String method = "getOrCreateReloadTask()";
        this.log(method);
        ReactHostImpl.raiseSoftException$default(this, method, reason, null, 4, null);
        Task<ReactInstance> task2 = this.reloadTask;
        if (task2 != null) {
            Task<ReactInstance> it = task2;
            boolean bl = false;
            return it;
        }
        Function2<Task<ReactInstance>, String, ReactInstance> taskUnwrapper = this.createReactInstanceUnwrapper("Reload", method, reason);
        this.log(method, "Resetting createReactInstance task ref");
        Task<ReactInstance> it = task = this.createReactInstanceTaskRef.getAndReset().continueWithTask(arg_0 -> ReactHostImpl.getOrCreateReloadTask$lambda$48(this, method, taskUnwrapper, reason, arg_0), this.uiExecutor).continueWithTask(arg_0 -> ReactHostImpl.getOrCreateReloadTask$lambda$49(taskUnwrapper, this, method, arg_0), this.bgExecutor).continueWithTask(arg_0 -> ReactHostImpl.getOrCreateReloadTask$lambda$51(taskUnwrapper, this, method, arg_0), this.uiExecutor).continueWithTask(arg_0 -> ReactHostImpl.getOrCreateReloadTask$lambda$52(taskUnwrapper, this, method, arg_0), this.bgExecutor).continueWithTask(arg_0 -> ReactHostImpl.getOrCreateReloadTask$lambda$53(taskUnwrapper, this, method, arg_0), this.bgExecutor).continueWithTask(arg_0 -> ReactHostImpl.getOrCreateReloadTask$lambda$54(this, method, reason, arg_0), this.bgExecutor);
        boolean bl = false;
        this.reloadTask = it;
        return task;
    }

    @ThreadConfined(value="ReactHost")
    private final Task<Void> getOrCreateDestroyTask(String reason, Exception ex) {
        Task task;
        String method = "getOrCreateDestroyTask()";
        this.log(method);
        this.raiseSoftException(method, reason, ex);
        Task<Void> task2 = this.destroyTask;
        if (task2 != null) {
            Task<Void> it = task2;
            boolean bl = false;
            return it;
        }
        Function2<Task<ReactInstance>, String, ReactInstance> taskUnwrapper = this.createReactInstanceUnwrapper("Destroy", method, reason);
        this.log(method, "Resetting createReactInstance task ref");
        Task it = task = Task.continueWith$default(this.createReactInstanceTaskRef.getAndReset().continueWithTask(arg_0 -> ReactHostImpl.getOrCreateDestroyTask$lambda$57(this, method, taskUnwrapper, reason, arg_0), this.uiExecutor).continueWithTask(arg_0 -> ReactHostImpl.getOrCreateDestroyTask$lambda$59(taskUnwrapper, this, method, arg_0), this.bgExecutor).continueWithTask(arg_0 -> ReactHostImpl.getOrCreateDestroyTask$lambda$60(taskUnwrapper, this, method, reason, arg_0), this.uiExecutor).continueWithTask(arg_0 -> ReactHostImpl.getOrCreateDestroyTask$lambda$61(taskUnwrapper, this, method, arg_0), this.bgExecutor), arg_0 -> ReactHostImpl.getOrCreateDestroyTask$lambda$62(this, method, reason, arg_0), null, 2, null);
        boolean bl = false;
        this.destroyTask = it;
        return task;
    }

    @Nullable
    public final ReactHostInspectorTarget getOrCreateReactHostInspectorTarget$ReactAndroid_debug() {
        if (this.reactHostInspectorTarget == null && InspectorFlags.getFuseboxEnabled()) {
            this.reactHostInspectorTarget = new ReactHostInspectorTarget(this);
        }
        return this.reactHostInspectorTarget;
    }

    @ThreadConfined(value="UI")
    public final void unregisterInstanceFromInspector$ReactAndroid_debug(@Nullable ReactInstance reactInstance) {
        if (reactInstance != null) {
            if (InspectorFlags.getFuseboxEnabled()) {
                ReactHostInspectorTarget reactHostInspectorTarget = this.reactHostInspectorTarget;
                Assertions.assertCondition((boolean)(reactHostInspectorTarget != null ? reactHostInspectorTarget.isValid() : false), (String)"Host inspector target destroyed before instance was unregistered");
            }
            reactInstance.unregisterFromInspector();
        }
    }

    @Override
    public void invalidate() {
        FLog.d((String)TAG, (String)"ReactHostImpl.invalidate()");
        this.hostInvalidated = true;
        this.destroy("ReactHostImpl.invalidate()", null);
    }

    private static final Task start$lambda$0(ReactHostImpl this$0) {
        return this$0.getOrCreateStartTask();
    }

    private static final Unit prerenderSurface$lambda$1(ReactHostImpl this$0, String $method, ReactSurfaceImpl $surface, ReactInstance reactInstance) {
        Intrinsics.checkNotNullParameter((Object)reactInstance, (String)"reactInstance");
        this$0.log($method, "Execute");
        reactInstance.prerenderSurface($surface);
        return Unit.INSTANCE;
    }

    private static final Unit startSurface$lambda$2(ReactHostImpl this$0, String $method, ReactSurfaceImpl $surface, ReactInstance reactInstance) {
        Intrinsics.checkNotNullParameter((Object)reactInstance, (String)"reactInstance");
        this$0.log($method, "Execute");
        reactInstance.startSurface($surface);
        return Unit.INSTANCE;
    }

    private static final Unit stopSurface$lambda$3(ReactHostImpl this$0, String $method, ReactSurfaceImpl $surface, ReactInstance reactInstance) {
        Intrinsics.checkNotNullParameter((Object)reactInstance, (String)"reactInstance");
        this$0.log($method, "Execute");
        reactInstance.stopSurface($surface);
        return Unit.INSTANCE;
    }

    private static final Task reload$lambda$7$lambda$5$lambda$4(ReactHostImpl this$0, String $reason, Task it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.getOrCreateReloadTask($reason);
    }

    private static final Task reload$lambda$7$lambda$6(ReactHostImpl this$0, Task task) {
        Task<Void> task2;
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        if (task.isFaulted()) {
            Exception exception = task.getError();
            if (exception == null) {
                String string2 = "Required value was null.";
                throw new IllegalStateException(string2.toString());
            }
            Exception ex = exception;
            if (this$0.useDevSupport) {
                this$0.getDevSupportManager().handleException(ex);
            } else {
                this$0.reactHostDelegate.handleInstanceException(ex);
            }
            task2 = this$0.getOrCreateDestroyTask("Reload failed", ex);
        } else {
            task2 = task;
        }
        return task2;
    }

    private static final Task reload$lambda$7(ReactHostImpl this$0, String $reason) {
        Task<Object> task;
        block3: {
            block2: {
                task = this$0.destroyTask;
                if (task == null) break block2;
                Task<Void> destroyTask = task;
                boolean bl = false;
                this$0.log("reload()", "Waiting for destroy to finish, before reloading React Native.");
                Task task2 = destroyTask.continueWithTask(arg_0 -> ReactHostImpl.reload$lambda$7$lambda$5$lambda$4(this$0, $reason, arg_0), this$0.bgExecutor);
                task = task2;
                if (task2 != null) break block3;
            }
            task = this$0.getOrCreateReloadTask($reason);
        }
        Task<Void> reloadTask = task.makeVoid();
        return reloadTask.continueWithTask(arg_0 -> ReactHostImpl.reload$lambda$7$lambda$6(this$0, arg_0), this$0.bgExecutor);
    }

    private static final Void destroy$lambda$8(Function1 $onDestroyFinished, Task task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        boolean instanceDestroyedSuccessfully = task.isCompleted() && !task.isFaulted();
        $onDestroyFinished.invoke((Object)instanceDestroyedSuccessfully);
        return null;
    }

    private static final Task destroy$lambda$10$lambda$9(ReactHostImpl this$0, String $reason, Exception $ex, Task it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.getOrCreateDestroyTask($reason, $ex);
    }

    private static final Task destroy$lambda$10(ReactHostImpl this$0, String $reason, Exception $ex) {
        Task<Void> task;
        Task<ReactInstance> reloadTask = this$0.reloadTask;
        if (reloadTask != null) {
            this$0.log("destroy()", "Reloading React Native. Waiting for reload to finish before destroying React Native.");
            task = reloadTask.continueWithTask(arg_0 -> ReactHostImpl.destroy$lambda$10$lambda$9(this$0, $reason, $ex, arg_0), this$0.bgExecutor);
        } else {
            task = this$0.getOrCreateDestroyTask($reason, $ex);
        }
        return task;
    }

    private static final void createMemoryPressureListener$lambda$12$lambda$11(WeakReference $weakReactInstance, int $level) {
        block0: {
            ReactInstance strongReactInstance;
            ReactInstance reactInstance = strongReactInstance = (ReactInstance)$weakReactInstance.get();
            if (reactInstance == null) break block0;
            reactInstance.handleMemoryPressure($level);
        }
    }

    private static final void createMemoryPressureListener$lambda$12(ReactHostImpl this$0, WeakReference $weakReactInstance, int level) {
        this$0.bgExecutor.execute(() -> ReactHostImpl.createMemoryPressureListener$lambda$12$lambda$11($weakReactInstance, level));
    }

    private static final void _get_defaultBackButtonHandler_$lambda$15(ReactHostImpl this$0) {
        block0: {
            UiThreadUtil.assertOnUiThread();
            DefaultHardwareBackBtnHandler defaultHardwareBackBtnHandler = this$0.defaultHardwareBackBtnHandler;
            if (defaultHardwareBackBtnHandler == null) break block0;
            defaultHardwareBackBtnHandler.invokeDefaultOnBackPressed();
        }
    }

    private static final Unit loadBundle$lambda$16(ReactHostImpl this$0, String $method, JSBundleLoader $bundleLoader, ReactInstance reactInstance) {
        Intrinsics.checkNotNullParameter((Object)reactInstance, (String)"reactInstance");
        this$0.log($method, "Execute");
        reactInstance.loadJSBundle($bundleLoader);
        return Unit.INSTANCE;
    }

    private static final Unit registerSegment$lambda$17(ReactHostImpl this$0, String $method, int $segmentId, String $path, Callback $callback, ReactInstance reactInstance) {
        Intrinsics.checkNotNullParameter((Object)reactInstance, (String)"reactInstance");
        this$0.log($method, "Execute");
        reactInstance.registerSegment($segmentId, $path);
        Callback callback = $callback;
        if (callback == null) {
            String string2 = "Required value was null.";
            throw new IllegalStateException(string2.toString());
        }
        callback.invoke(new Object[0]);
        return Unit.INSTANCE;
    }

    private static final Unit callFunctionOnModule$lambda$18(String $moduleName, String $methodName, NativeArray $args, ReactInstance reactInstance) {
        Intrinsics.checkNotNullParameter((Object)reactInstance, (String)"reactInstance");
        reactInstance.callFunctionOnModule($moduleName, $methodName, $args);
        return Unit.INSTANCE;
    }

    private static final Task getOrCreateStartTask$lambda$26$lambda$25(Exception $ex, Task it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Task.Companion.forError($ex);
    }

    private static final Task getOrCreateStartTask$lambda$26(ReactHostImpl this$0, Task task) {
        Task task2;
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        if (task.isFaulted()) {
            Exception exception = task.getError();
            if (exception == null) {
                String string2 = "Required value was null.";
                throw new IllegalStateException(string2.toString());
            }
            Exception ex = exception;
            if (this$0.useDevSupport) {
                this$0.getDevSupportManager().handleException(ex);
            } else {
                this$0.reactHostDelegate.handleInstanceException(ex);
            }
            task2 = Task.continueWithTask$default(this$0.getOrCreateDestroyTask("getOrCreateStartTask() failure: " + ex.getMessage(), ex), arg_0 -> ReactHostImpl.getOrCreateStartTask$lambda$26$lambda$25(ex, arg_0), null, 2, null);
        } else {
            task2 = task.makeVoid();
        }
        return task2;
    }

    private static final Boolean callWithExistingReactInstance$lambda$28(ReactHostImpl this$0, String $callingMethod, Function1 $runnable, Task task) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        ReactInstance reactInstance = (ReactInstance)task.getResult();
        if (reactInstance == null) {
            ReactHostImpl.raiseSoftException$default(this$0, "callWithExistingReactInstance(" + $callingMethod + ")", "Execute: reactInstance is null. Dropping work.", null, 4, null);
            bl = false;
        } else {
            $runnable.invoke((Object)reactInstance);
            bl = true;
        }
        return bl;
    }

    private static final Void callAfterGetOrCreateReactInstance$lambda$29(ReactHostImpl this$0, String $callingMethod, Function1 $runnable, Task task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        ReactInstance reactInstance = (ReactInstance)task.getResult();
        if (reactInstance == null) {
            ReactHostImpl.raiseSoftException$default(this$0, "callAfterGetOrCreateReactInstance(" + $callingMethod + ")", "Execute: reactInstance is null. Dropping work.", null, 4, null);
        } else {
            $runnable.invoke((Object)reactInstance);
        }
        return null;
    }

    private static final Void callAfterGetOrCreateReactInstance$lambda$30(ReactHostImpl this$0, Task task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        if (task.isFaulted()) {
            Exception exception = task.getError();
            if (exception == null) {
                String string2 = "Required value was null.";
                throw new IllegalStateException(string2.toString());
            }
            this$0.handleHostException$ReactAndroid_debug(exception);
        }
        return null;
    }

    private static final BridgelessReactContext getOrCreateReactContext$lambda$31(ReactHostImpl this$0, String $method) {
        this$0.log($method, "Creating BridgelessReactContext");
        return new BridgelessReactContext(this$0.context, this$0);
    }

    private static final Task getOrCreateReactInstance$lambda$32(ReactHostImpl this$0) {
        return this$0.waitThenCallGetOrCreateReactInstanceTask();
    }

    private static final Task waitThenCallGetOrCreateReactInstanceTaskWithRetries$lambda$35$lambda$34(ReactHostImpl this$0, int $tryNum, int $maxTries, Task it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.waitThenCallGetOrCreateReactInstanceTaskWithRetries($tryNum + 1, $maxTries);
    }

    private static final void getOrCreateReactInstanceTask$lambda$41$lambda$38$lambda$36(ReactHostImpl this$0, Exception e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this$0.handleHostException$ReactAndroid_debug(e);
    }

    private static final void getOrCreateReactInstanceTask$lambda$41$lambda$38$lambda$37() {
        ReactMarker.logMarker(ReactMarkerConstants.REACT_BRIDGELESS_LOADING_END, 1);
    }

    private static final CreationResult getOrCreateReactInstanceTask$lambda$41$lambda$38(ReactHostImpl this$0, String $method, Task task) {
        MemoryPressureListener memoryPressureListener;
        ReactInstance instance;
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Object TResult = task.getResult();
        if (TResult == null) {
            String string2 = "Required value was null.";
            throw new IllegalStateException(string2.toString());
        }
        JSBundleLoader bundleLoader = (JSBundleLoader)TResult;
        BridgelessReactContext reactContext = this$0.getOrCreateReactContext();
        reactContext.setJSExceptionHandler(this$0.getDevSupportManager());
        this$0.log($method, "Creating ReactInstance");
        this$0.reactInstance = instance = new ReactInstance(reactContext, this$0.reactHostDelegate, this$0.componentFactory, this$0.getDevSupportManager(), arg_0 -> ReactHostImpl.getOrCreateReactInstanceTask$lambda$41$lambda$38$lambda$36(this$0, arg_0), this$0.useDevSupport, this$0.getOrCreateReactHostInspectorTarget$ReactAndroid_debug());
        this$0.memoryPressureListener = memoryPressureListener = this$0.createMemoryPressureListener(instance);
        this$0.getMemoryPressureRouter().addMemoryPressureListener(memoryPressureListener);
        instance.initializeEagerTurboModules();
        this$0.log($method, "Loading JS Bundle");
        instance.loadJSBundle(bundleLoader);
        this$0.log($method, "Calling DevSupportManagerBase.onNewReactContextCreated(reactContext)");
        this$0.getDevSupportManager().onNewReactContextCreated(reactContext);
        reactContext.runOnJSQueueThread(ReactHostImpl::getOrCreateReactInstanceTask$lambda$41$lambda$38$lambda$37);
        return new CreationResult(instance, reactContext, this$0.reloadTask != null);
    }

    private static final ReactInstance getOrCreateReactInstanceTask$lambda$41$lambda$39(ReactHostImpl this$0, String $method, Task task) {
        boolean isManagerResumed;
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Object TResult = task.getResult();
        if (TResult == null) {
            String string2 = "Required value was null.";
            throw new IllegalStateException(string2.toString());
        }
        CreationResult result = (CreationResult)TResult;
        ReactInstance reactInstance = result.getInstance();
        ReactContext reactContext = result.getContext();
        boolean isReloading = result.isReloading();
        boolean bl = isManagerResumed = this$0.reactLifecycleStateManager.getLifecycleState() == LifecycleState.RESUMED;
        if (isReloading && !isManagerResumed) {
            this$0.reactLifecycleStateManager.moveToOnHostResume(reactContext, this$0.getCurrentActivity$ReactAndroid_debug());
        } else {
            this$0.reactLifecycleStateManager.resumeReactContextIfHostResumed(reactContext, this$0.getCurrentActivity$ReactAndroid_debug());
        }
        this$0.log($method, "Executing ReactInstanceEventListeners");
        for (ReactInstanceEventListener listener : this$0.reactInstanceEventListeners) {
            listener.onReactContextInitialized(reactContext);
        }
        return reactInstance;
    }

    private static final ReactInstance getOrCreateReactInstanceTask$lambda$41$lambda$40(Task task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Object TResult = task.getResult();
        if (TResult == null) {
            String string2 = "Required value was null.";
            throw new IllegalStateException(string2.toString());
        }
        return ((CreationResult)TResult).getInstance();
    }

    private static final Task getOrCreateReactInstanceTask$lambda$41(ReactHostImpl this$0, String $method) {
        this$0.log($method, "Start");
        Assertions.assertCondition((!this$0.hostInvalidated ? 1 : 0) != 0, (String)"Cannot start a new ReactInstance on an invalidated ReactHost");
        ReactMarker.logMarker(ReactMarkerConstants.REACT_BRIDGELESS_LOADING_START, 1);
        Task<CreationResult> creationTask = this$0.getJsBundleLoader().onSuccess(arg_0 -> ReactHostImpl.getOrCreateReactInstanceTask$lambda$41$lambda$38(this$0, $method, arg_0), this$0.bgExecutor);
        Function1 lifecycleUpdateTask = arg_0 -> ReactHostImpl.getOrCreateReactInstanceTask$lambda$41$lambda$39(this$0, $method, arg_0);
        creationTask.onSuccess(new Continuation(lifecycleUpdateTask){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ Object then(Task task) {
                return this.function.invoke((Object)task);
            }

            @NotNull
            public final Function<?> getFunctionDelegate() {
                return (Function)this.function;
            }

            public final boolean equals(@Nullable Object other) {
                return other instanceof Continuation ? (other instanceof FunctionAdapter ? Intrinsics.areEqual((Object)((FunctionAdapter)this).getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return ((FunctionAdapter)this).getFunctionDelegate().hashCode();
            }
        }, this$0.uiExecutor);
        return Task.onSuccess$default(creationTask, ReactHostImpl::getOrCreateReactInstanceTask$lambda$41$lambda$40, null, 2, null);
    }

    private static final Task _get_jsBundleLoader_$lambda$42(ReactHostImpl this$0, Task task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Object TResult = task.getResult();
        if (TResult == null) {
            String string2 = "Required value was null.";
            throw new IllegalStateException(string2.toString());
        }
        boolean isMetroRunning = (Boolean)TResult;
        return isMetroRunning ? this$0.loadJSBundleFromMetro() : Task.Companion.forResult(this$0.reactHostDelegate.getJsBundleLoader());
    }

    private static final void _get_isMetroRunning_$lambda$43(ReactHostImpl this$0, String $method, TaskCompletionSource $taskCompletionSource, boolean packagerIsRunning) {
        this$0.log($method, "Async result = " + packagerIsRunning);
        $taskCompletionSource.setResult(packagerIsRunning);
    }

    private static final ReactInstance createReactInstanceUnwrapper$lambda$46(ReactHostImpl this$0, String $tag, String $reason, String $method, Task task, String stage) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)stage, (String)"stage");
        ReactInstance reactInstance = (ReactInstance)task.getResult();
        ReactInstance currentReactInstance = this$0.reactInstance;
        String stageLabel = "Stage: " + stage;
        String reasonLabel = $tag + " reason: " + $reason;
        if (task.isFaulted()) {
            Exception exception = task.getError();
            if (exception == null) {
                String string2 = "Required value was null.";
                throw new IllegalStateException(string2.toString());
            }
            Exception ex = exception;
            String faultLabel = "Fault reason: " + ex.getMessage();
            ReactHostImpl.raiseSoftException$default(this$0, $method, $tag + ": ReactInstance task faulted. " + stageLabel + ". " + faultLabel + ". " + reasonLabel, null, 4, null);
            return currentReactInstance;
        }
        if (task.isCancelled()) {
            ReactHostImpl.raiseSoftException$default(this$0, $method, $tag + ": ReactInstance task cancelled. " + stageLabel + ". " + reasonLabel, null, 4, null);
            return currentReactInstance;
        }
        if (reactInstance == null) {
            ReactHostImpl.raiseSoftException$default(this$0, $method, $tag + ": ReactInstance task returned null. " + stageLabel + ". " + reasonLabel, null, 4, null);
            return currentReactInstance;
        }
        if (currentReactInstance != null && !Intrinsics.areEqual((Object)reactInstance, (Object)currentReactInstance)) {
            ReactHostImpl.raiseSoftException$default(this$0, $method, $tag + ": Detected two different ReactInstances. Returning old. " + stageLabel + ". " + reasonLabel, null, 4, null);
        }
        return reactInstance;
    }

    private static final Task getOrCreateReloadTask$lambda$48(ReactHostImpl this$0, String $method, Function2 $taskUnwrapper, String $reason, Task task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        this$0.log($method, "Starting React Native reload");
        ReactInstance reactInstance = (ReactInstance)$taskUnwrapper.invoke((Object)task, (Object)"1: Starting reload");
        this$0.unregisterInstanceFromInspector$ReactAndroid_debug(reactInstance);
        BridgelessReactContext reactContext = this$0.bridgelessReactContextRef.getNullable();
        if (reactContext == null) {
            ReactHostImpl.raiseSoftException$default(this$0, $method, "ReactContext is null. Reload reason: " + $reason, null, 4, null);
        }
        if (reactContext != null && this$0.reactLifecycleStateManager.getLifecycleState() == LifecycleState.RESUMED) {
            this$0.log($method, "Calling ReactContext.onHostPause()");
            reactContext.onHostPause();
        }
        return Task.Companion.forResult(reactInstance);
    }

    private static final Task getOrCreateReloadTask$lambda$49(Function2 $taskUnwrapper, ReactHostImpl this$0, String $method, Task task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        ReactInstance reactInstance = (ReactInstance)$taskUnwrapper.invoke((Object)task, (Object)"2: Surface shutdown");
        if (reactInstance == null) {
            ReactHostImpl.raiseSoftException$default(this$0, $method, "Skipping surface shutdown: ReactInstance null", null, 4, null);
        } else {
            this$0.stopAttachedSurfaces($method, reactInstance);
        }
        return task;
    }

    private static final Task getOrCreateReloadTask$lambda$51(Function2 $taskUnwrapper, ReactHostImpl this$0, String $method, Task task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        $taskUnwrapper.invoke((Object)task, (Object)"3: Destroying ReactContext");
        for (Function0<Unit> destroyListener : this$0.beforeDestroyListeners) {
            destroyListener.invoke();
        }
        MemoryPressureListener memoryPressureListener = this$0.memoryPressureListener;
        if (memoryPressureListener != null) {
            MemoryPressureListener listener = memoryPressureListener;
            boolean bl = false;
            this$0.log($method, "Removing memory pressure listener");
            this$0.getMemoryPressureRouter().removeMemoryPressureListener(listener);
        }
        BridgelessReactContext reactContext = this$0.bridgelessReactContextRef.getNullable();
        if (reactContext != null) {
            this$0.log($method, "Resetting ReactContext ref");
            this$0.bridgelessReactContextRef.reset();
            this$0.log($method, "Destroying ReactContext");
            reactContext.destroy();
        }
        if (this$0.useDevSupport && reactContext != null) {
            this$0.log($method, "Calling DevSupportManager.onReactInstanceDestroyed(reactContext)");
            this$0.getDevSupportManager().onReactInstanceDestroyed(reactContext);
        }
        return task;
    }

    private static final Task getOrCreateReloadTask$lambda$52(Function2 $taskUnwrapper, ReactHostImpl this$0, String $method, Task task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        ReactInstance reactInstance = (ReactInstance)$taskUnwrapper.invoke((Object)task, (Object)"4: Destroying ReactInstance");
        if (reactInstance == null) {
            ReactHostImpl.raiseSoftException$default(this$0, $method, "Skipping ReactInstance.destroy(): ReactInstance null", null, 4, null);
        } else {
            this$0.log($method, "Resetting ReactInstance ptr");
            this$0.reactInstance = null;
            this$0.log($method, "Destroying ReactInstance");
            reactInstance.destroy();
        }
        this$0.log($method, "Resetting start task ref");
        this$0.startTask = null;
        return this$0.getOrCreateReactInstanceTask();
    }

    private static final Task getOrCreateReloadTask$lambda$53(Function2 $taskUnwrapper, ReactHostImpl this$0, String $method, Task task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        ReactInstance reactInstance = (ReactInstance)$taskUnwrapper.invoke((Object)task, (Object)"5: Restarting surfaces");
        if (reactInstance == null) {
            ReactHostImpl.raiseSoftException$default(this$0, $method, "Skipping surface restart: ReactInstance null", null, 4, null);
        } else {
            this$0.startAttachedSurfaces($method, reactInstance);
        }
        return task;
    }

    private static final Task getOrCreateReloadTask$lambda$54(ReactHostImpl this$0, String $method, String $reason, Task task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        if (task.isFaulted()) {
            Exception exception = task.getError();
            if (exception == null) {
                String string2 = "Required value was null.";
                throw new IllegalStateException(string2.toString());
            }
            Exception fault = exception;
            this$0.raiseSoftException($method, "Error during reload. ReactInstance task faulted. Fault reason: " + fault.getMessage() + ". Reload reason: " + $reason, task.getError());
        }
        if (task.isCancelled()) {
            ReactHostImpl.raiseSoftException$default(this$0, $method, "Error during reload. ReactInstance task cancelled. Reload reason: " + $reason, null, 4, null);
        }
        this$0.log($method, "Resetting reload task ref");
        this$0.reloadTask = null;
        return task;
    }

    private static final Task getOrCreateDestroyTask$lambda$57(ReactHostImpl this$0, String $method, Function2 $taskUnwrapper, String $reason, Task task) {
        BridgelessReactContext reactContext;
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        this$0.log($method, "Starting React Native destruction");
        ReactInstance reactInstance = (ReactInstance)$taskUnwrapper.invoke((Object)task, (Object)"1: Starting destroy");
        this$0.unregisterInstanceFromInspector$ReactAndroid_debug(reactInstance);
        if (this$0.hostInvalidated) {
            ReactHostInspectorTarget reactHostInspectorTarget = this$0.reactHostInspectorTarget;
            if (reactHostInspectorTarget != null) {
                reactHostInspectorTarget.close();
            }
            this$0.reactHostInspectorTarget = null;
        }
        if (this$0.useDevSupport) {
            this$0.log($method, "DevSupportManager cleanup");
            this$0.getDevSupportManager().stopInspector();
        }
        if ((reactContext = this$0.bridgelessReactContextRef.getNullable()) == null) {
            ReactHostImpl.raiseSoftException$default(this$0, $method, "ReactContext is null. Destroy reason: " + $reason, null, 4, null);
        }
        this$0.log($method, "Move ReactHost to onHostDestroy()");
        this$0.reactLifecycleStateManager.moveToOnHostDestroy(reactContext);
        return Task.Companion.forResult(reactInstance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Task getOrCreateDestroyTask$lambda$59(Function2 $taskUnwrapper, ReactHostImpl this$0, String $method, Task task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        ReactInstance reactInstance = (ReactInstance)$taskUnwrapper.invoke((Object)task, (Object)"2: Stopping surfaces");
        if (reactInstance == null) {
            ReactHostImpl.raiseSoftException$default(this$0, $method, "Skipping surface shutdown: ReactInstance null", null, 4, null);
        } else {
            this$0.stopAttachedSurfaces($method, reactInstance);
            Set<ReactSurfaceImpl> set = this$0.attachedSurfaces;
            synchronized (set) {
                boolean bl = false;
                this$0.attachedSurfaces.clear();
                Unit unit = Unit.INSTANCE;
            }
        }
        return task;
    }

    private static final Task getOrCreateDestroyTask$lambda$60(Function2 $taskUnwrapper, ReactHostImpl this$0, String $method, String $reason, Task task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        $taskUnwrapper.invoke((Object)task, (Object)"3: Destroying ReactContext");
        for (Function0<Unit> destroyListener : this$0.beforeDestroyListeners) {
            destroyListener.invoke();
        }
        BridgelessReactContext reactContext = this$0.bridgelessReactContextRef.getNullable();
        if (reactContext == null) {
            ReactHostImpl.raiseSoftException$default(this$0, $method, "ReactContext is null. Destroy reason: " + $reason, null, 4, null);
        }
        this$0.log($method, "Destroying MemoryPressureRouter");
        this$0.getMemoryPressureRouter().destroy(this$0.context);
        if (reactContext != null) {
            this$0.log($method, "Resetting ReactContext ref");
            this$0.bridgelessReactContextRef.reset();
            this$0.log($method, "Destroying ReactContext");
            reactContext.destroy();
        }
        this$0.setCurrentActivity(null);
        ResourceDrawableIdHelper.clear();
        return task;
    }

    private static final Task getOrCreateDestroyTask$lambda$61(Function2 $taskUnwrapper, ReactHostImpl this$0, String $method, Task task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        ReactInstance reactInstance = (ReactInstance)$taskUnwrapper.invoke((Object)task, (Object)"4: Destroying ReactInstance");
        if (reactInstance == null) {
            ReactHostImpl.raiseSoftException$default(this$0, $method, "Skipping ReactInstance.destroy(): ReactInstance null", null, 4, null);
        } else {
            this$0.log($method, "Resetting ReactInstance ptr");
            this$0.reactInstance = null;
            this$0.log($method, "Destroying ReactInstance");
            reactInstance.destroy();
        }
        this$0.log($method, "Resetting start task ref");
        this$0.startTask = null;
        this$0.log($method, "Resetting destroy task ref");
        this$0.destroyTask = null;
        return task;
    }

    private static final Void getOrCreateDestroyTask$lambda$62(ReactHostImpl this$0, String $method, String $reason, Task task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        if (task.isFaulted()) {
            Exception exception = task.getError();
            if (exception == null) {
                String string2 = "Required value was null.";
                throw new IllegalStateException(string2.toString());
            }
            Exception fault = exception;
            this$0.raiseSoftException($method, "React destruction failed. ReactInstance task faulted. Fault reason: " + fault.getMessage() + ". Destroy reason: " + $reason, task.getError());
        }
        if (task.isCancelled()) {
            ReactHostImpl.raiseSoftException$default(this$0, $method, "React destruction failed. ReactInstance task cancelled. Destroy reason: " + $reason, null, 4, null);
        }
        return null;
    }

    public static final /* synthetic */ ReactHostInspectorTarget access$getReactHostInspectorTarget$p(ReactHostImpl $this) {
        return $this.reactHostInspectorTarget;
    }

    public static final /* synthetic */ void access$log(ReactHostImpl $this, String method, String message) {
        $this.log(method, message);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/facebook/react/runtime/ReactHostImpl$Companion;", "", "<init>", "()V", "TAG", "", "BRIDGELESS_MARKER_INSTANCE_KEY", "", "counter", "Ljava/util/concurrent/atomic/AtomicInteger;", "ReactAndroid_debug"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/facebook/react/runtime/ReactHostImpl$CreationResult;", "", "instance", "Lcom/facebook/react/runtime/ReactInstance;", "context", "Lcom/facebook/react/bridge/ReactContext;", "isReloading", "", "<init>", "(Lcom/facebook/react/runtime/ReactInstance;Lcom/facebook/react/bridge/ReactContext;Z)V", "getInstance", "()Lcom/facebook/react/runtime/ReactInstance;", "getContext", "()Lcom/facebook/react/bridge/ReactContext;", "()Z", "ReactAndroid_debug"})
    private static final class CreationResult {
        @NotNull
        private final ReactInstance instance;
        @NotNull
        private final ReactContext context;
        private final boolean isReloading;

        public CreationResult(@NotNull ReactInstance instance, @NotNull ReactContext context, boolean isReloading) {
            Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
            Intrinsics.checkNotNullParameter((Object)((Object)context), (String)"context");
            this.instance = instance;
            this.context = context;
            this.isReloading = isReloading;
        }

        @NotNull
        public final ReactInstance getInstance() {
            return this.instance;
        }

        @NotNull
        public final ReactContext getContext() {
            return this.context;
        }

        public final boolean isReloading() {
            return this.isReloading;
        }
    }
}

