/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.fabric.mounting;

import android.content.Context;
import android.view.View;
import androidx.annotation.AnyThread;
import androidx.annotation.UiThread;
import com.facebook.common.logging.FLog;
import com.facebook.infer.annotation.ThreadConfined;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReactSoftExceptionLogger;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.RetryableMountingLayerException;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.common.annotations.UnstableReactNativeAPI;
import com.facebook.react.common.mapbuffer.MapBuffer;
import com.facebook.react.fabric.events.EventEmitterWrapper;
import com.facebook.react.fabric.mounting.SurfaceMountingManager;
import com.facebook.react.fabric.mounting.mountitems.MountItem;
import com.facebook.react.touch.JSResponderHandler;
import com.facebook.react.uimanager.RootViewManager;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.ViewManagerRegistry;
import com.facebook.yoga.YogaMeasureMode;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 M2\u00020\u0001:\u0002LMB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J$\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\n2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0007J$\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\n2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001c\u001a\u0004\u0018\u00010\u0017H\u0007J\u0010\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\nH\u0007J\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0015\u001a\u00020\nJ\u0016\u0010\u001f\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010 \u001a\u00020!J\u000e\u0010\"\u001a\u00020#2\u0006\u0010\u0015\u001a\u00020\nJ\u000e\u0010$\u001a\u00020#2\u0006\u0010\u0015\u001a\u00020\nJ\u0010\u0010%\u001a\u0004\u0018\u00010\u000b2\u0006\u0010&\u001a\u00020\nJ\u0010\u0010'\u001a\u00020\u000b2\u0006\u0010&\u001a\u00020\nH\u0007J\u000e\u0010(\u001a\u00020#2\u0006\u0010&\u001a\u00020\nJ(\u0010)\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010&\u001a\u00020\n2\u0006\u0010*\u001a\u00020\n2\u0006\u0010+\u001a\u00020,H\u0007J(\u0010)\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010&\u001a\u00020\n2\b\u0010*\u001a\u0004\u0018\u00010!2\u0006\u0010+\u001a\u00020,J\u001e\u0010-\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010&\u001a\u00020\n2\u0006\u0010.\u001a\u00020\nJ\u001a\u0010/\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\n2\b\u00100\u001a\u0004\u0018\u000101H\u0007J\b\u00102\u001a\u00020\u001bH\u0007J\u001a\u00103\u001a\u0004\u0018\u0001042\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010&\u001a\u00020\nH\u0007Jh\u00105\u001a\u0002062\b\u0010 \u001a\u0004\u0018\u0001072\b\u00108\u001a\u0004\u0018\u00010!2\b\u00109\u001a\u0004\u0018\u0001012\b\u00100\u001a\u0004\u0018\u0001012\b\u0010:\u001a\u0004\u0018\u0001012\u0006\u0010;\u001a\u00020<2\b\u0010=\u001a\u0004\u0018\u00010>2\u0006\u0010?\u001a\u00020<2\b\u0010@\u001a\u0004\u0018\u00010>2\b\u0010A\u001a\u0004\u0018\u00010BH\u0007J6\u0010C\u001a\u00020\u001b2\b\u0010\u0016\u001a\u0004\u0018\u0001072\b\u00108\u001a\u0004\u0018\u00010!2\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010&\u001a\u00020\n2\b\u0010D\u001a\u0004\u0018\u00010EH\u0007J:\u0010F\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010&\u001a\u00020\n2\b\u0010G\u001a\u0004\u0018\u00010!2\u0006\u0010H\u001a\u00020#2\b\u0010D\u001a\u0004\u0018\u00010I2\u0006\u0010J\u001a\u00020\nJ\u001a\u0010K\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010&\u001a\u00020\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006N"}, d2={"Lcom/facebook/react/fabric/mounting/MountingManager;", "", "viewManagerRegistry", "Lcom/facebook/react/uimanager/ViewManagerRegistry;", "mountItemExecutor", "Lcom/facebook/react/fabric/mounting/MountingManager$MountItemExecutor;", "<init>", "(Lcom/facebook/react/uimanager/ViewManagerRegistry;Lcom/facebook/react/fabric/mounting/MountingManager$MountItemExecutor;)V", "surfaceIdToManager", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/facebook/react/fabric/mounting/SurfaceMountingManager;", "stoppedSurfaceIds", "Ljava/util/concurrent/CopyOnWriteArrayList;", "mostRecentSurfaceMountingManager", "lastQueriedSurfaceMountingManager", "jsResponderHandler", "Lcom/facebook/react/touch/JSResponderHandler;", "rootViewManager", "Lcom/facebook/react/uimanager/RootViewManager;", "startSurface", "surfaceId", "reactContext", "Lcom/facebook/react/uimanager/ThemedReactContext;", "rootView", "Landroid/view/View;", "attachRootView", "", "themedReactContext", "stopSurface", "getSurfaceManager", "getSurfaceManagerEnforced", "context", "", "surfaceIsStopped", "", "isWaitingForViewAttach", "getSurfaceManagerForView", "reactTag", "getSurfaceManagerForViewEnforced", "getViewExists", "receiveCommand", "commandId", "commandArgs", "Lcom/facebook/react/bridge/ReadableArray;", "sendAccessibilityEvent", "eventType", "updateProps", "props", "Lcom/facebook/react/bridge/ReadableMap;", "clearJSResponder", "getEventEmitter", "Lcom/facebook/react/fabric/events/EventEmitterWrapper;", "measure", "", "Lcom/facebook/react/bridge/ReactContext;", "componentName", "localData", "state", "width", "", "widthMode", "Lcom/facebook/yoga/YogaMeasureMode;", "height", "heightMode", "attachmentsPositions", "", "experimental_prefetchResource", "params", "Lcom/facebook/react/common/mapbuffer/MapBuffer;", "enqueuePendingEvent", "eventName", "canCoalesceEvent", "Lcom/facebook/react/bridge/WritableMap;", "eventCategory", "getSurfaceMountingManager", "MountItemExecutor", "Companion", "ReactAndroid_debug"})
public final class MountingManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ViewManagerRegistry viewManagerRegistry;
    @NotNull
    private final MountItemExecutor mountItemExecutor;
    @NotNull
    private final ConcurrentHashMap<Integer, SurfaceMountingManager> surfaceIdToManager;
    @NotNull
    private final CopyOnWriteArrayList<Integer> stoppedSurfaceIds;
    @Nullable
    private SurfaceMountingManager mostRecentSurfaceMountingManager;
    @Nullable
    private SurfaceMountingManager lastQueriedSurfaceMountingManager;
    @NotNull
    private final JSResponderHandler jsResponderHandler;
    @NotNull
    private final RootViewManager rootViewManager;
    @NotNull
    private static final String TAG;
    private static final int MAX_STOPPED_SURFACE_IDS_LENGTH = 15;

    public MountingManager(@NotNull ViewManagerRegistry viewManagerRegistry2, @NotNull MountItemExecutor mountItemExecutor) {
        Intrinsics.checkNotNullParameter((Object)viewManagerRegistry2, (String)"viewManagerRegistry");
        Intrinsics.checkNotNullParameter((Object)mountItemExecutor, (String)"mountItemExecutor");
        this.viewManagerRegistry = viewManagerRegistry2;
        this.mountItemExecutor = mountItemExecutor;
        this.surfaceIdToManager = new ConcurrentHashMap();
        this.stoppedSurfaceIds = new CopyOnWriteArrayList();
        this.jsResponderHandler = new JSResponderHandler();
        this.rootViewManager = new RootViewManager();
    }

    @AnyThread
    @NotNull
    public final SurfaceMountingManager startSurface(int surfaceId, @Nullable ThemedReactContext reactContext, @Nullable View rootView) {
        ThemedReactContext themedReactContext = reactContext;
        if (themedReactContext == null) {
            String string2 = "Required value was null.";
            throw new IllegalStateException(string2.toString());
        }
        SurfaceMountingManager surfaceMountingManager = new SurfaceMountingManager(surfaceId, this.jsResponderHandler, this.viewManagerRegistry, this.rootViewManager, this.mountItemExecutor, themedReactContext);
        this.surfaceIdToManager.putIfAbsent(surfaceId, surfaceMountingManager);
        if (this.surfaceIdToManager.get(surfaceId) != surfaceMountingManager) {
            ReactSoftExceptionLogger.logSoftException(TAG, new IllegalStateException("Called startSurface more than once for the SurfaceId [" + surfaceId + "]"));
        }
        this.mostRecentSurfaceMountingManager = this.surfaceIdToManager.get(surfaceId);
        if (rootView != null) {
            surfaceMountingManager.attachRootView(rootView, reactContext);
        }
        return surfaceMountingManager;
    }

    @AnyThread
    public final void attachRootView(int surfaceId, @Nullable View rootView, @Nullable ThemedReactContext themedReactContext) {
        SurfaceMountingManager surfaceMountingManager = this.getSurfaceManagerEnforced(surfaceId, "attachView");
        if (surfaceMountingManager.isStopped()) {
            ReactSoftExceptionLogger.logSoftException(TAG, new IllegalStateException("Trying to attach a view to a stopped surface"));
            return;
        }
        surfaceMountingManager.attachRootView(rootView, themedReactContext);
    }

    @AnyThread
    public final void stopSurface(int surfaceId) {
        SurfaceMountingManager surfaceMountingManager = this.surfaceIdToManager.get(surfaceId);
        if (surfaceMountingManager != null) {
            while (this.stoppedSurfaceIds.size() >= 15) {
                Integer staleStoppedId = this.stoppedSurfaceIds.get(0);
                if (staleStoppedId == null) {
                    String string2 = "Required value was null.";
                    throw new IllegalStateException(string2.toString());
                }
                this.surfaceIdToManager.remove(staleStoppedId);
                this.stoppedSurfaceIds.remove(staleStoppedId);
                FLog.d((String)TAG, (String)"Removing stale SurfaceMountingManager: [%d]", (Object)staleStoppedId);
            }
            this.stoppedSurfaceIds.add(surfaceId);
            surfaceMountingManager.stopSurface();
            if (this.mostRecentSurfaceMountingManager == surfaceMountingManager) {
                this.mostRecentSurfaceMountingManager = null;
            }
            if (this.lastQueriedSurfaceMountingManager == surfaceMountingManager) {
                this.lastQueriedSurfaceMountingManager = null;
            }
        } else {
            ReactSoftExceptionLogger.logSoftException(TAG, new IllegalStateException("Cannot call stopSurface on non-existent surface: [" + surfaceId + "]"));
        }
    }

    @Nullable
    public final SurfaceMountingManager getSurfaceManager(int surfaceId) {
        SurfaceMountingManager surfaceMountingManager;
        SurfaceMountingManager surfaceMountingManager2 = this.lastQueriedSurfaceMountingManager;
        boolean bl = surfaceMountingManager2 != null ? surfaceMountingManager2.getSurfaceId() == surfaceId : false;
        if (bl) {
            return this.lastQueriedSurfaceMountingManager;
        }
        SurfaceMountingManager surfaceMountingManager3 = this.mostRecentSurfaceMountingManager;
        boolean bl2 = surfaceMountingManager3 != null ? surfaceMountingManager3.getSurfaceId() == surfaceId : false;
        if (bl2) {
            return this.mostRecentSurfaceMountingManager;
        }
        this.lastQueriedSurfaceMountingManager = surfaceMountingManager = this.surfaceIdToManager.get(surfaceId);
        return surfaceMountingManager;
    }

    @NotNull
    public final SurfaceMountingManager getSurfaceManagerEnforced(int surfaceId, @NotNull String context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        SurfaceMountingManager surfaceMountingManager = this.getSurfaceManager(surfaceId);
        if (surfaceMountingManager == null) {
            throw new RetryableMountingLayerException("Unable to find SurfaceMountingManager for surfaceId: [" + surfaceId + "]. Context: " + context);
        }
        return surfaceMountingManager;
    }

    public final boolean surfaceIsStopped(int surfaceId) {
        if (this.stoppedSurfaceIds.contains(surfaceId)) {
            return true;
        }
        SurfaceMountingManager surfaceMountingManager = this.getSurfaceManager(surfaceId);
        return surfaceMountingManager != null && surfaceMountingManager.isStopped();
    }

    public final boolean isWaitingForViewAttach(int surfaceId) {
        SurfaceMountingManager surfaceMountingManager = this.getSurfaceManager(surfaceId);
        if (surfaceMountingManager == null) {
            return false;
        }
        SurfaceMountingManager mountingManager = surfaceMountingManager;
        if (mountingManager.isStopped()) {
            return false;
        }
        return !mountingManager.isRootViewAttached();
    }

    @Nullable
    public final SurfaceMountingManager getSurfaceManagerForView(int reactTag) {
        SurfaceMountingManager surfaceMountingManager = this.mostRecentSurfaceMountingManager;
        boolean bl = surfaceMountingManager != null ? surfaceMountingManager.getViewExists(reactTag) : false;
        if (bl) {
            return this.mostRecentSurfaceMountingManager;
        }
        Iterator iterator2 = ((Map)this.surfaceIdToManager).entrySet().iterator();
        while (iterator2.hasNext()) {
            SurfaceMountingManager smm = (SurfaceMountingManager)iterator2.next().getValue();
            if (smm == this.mostRecentSurfaceMountingManager || !smm.getViewExists(reactTag)) continue;
            if (this.mostRecentSurfaceMountingManager == null) {
                this.mostRecentSurfaceMountingManager = smm;
            }
            return smm;
        }
        return null;
    }

    @AnyThread
    @NotNull
    public final SurfaceMountingManager getSurfaceManagerForViewEnforced(int reactTag) {
        SurfaceMountingManager surfaceMountingManager = this.getSurfaceManagerForView(reactTag);
        if (surfaceMountingManager == null) {
            throw new RetryableMountingLayerException("Unable to find SurfaceMountingManager for tag: [" + reactTag + "]");
        }
        return surfaceMountingManager;
    }

    public final boolean getViewExists(int reactTag) {
        return this.getSurfaceManagerForView(reactTag) != null;
    }

    @Deprecated(message="receiveCommand with Int is deprecated, you should use receiveCommand with commandId:String", replaceWith=@ReplaceWith(expression="receiveCommand(Int,Int,String,ReadableArray)", imports={}))
    public final void receiveCommand(int surfaceId, int reactTag, int commandId, @NotNull ReadableArray commandArgs) {
        Intrinsics.checkNotNullParameter((Object)commandArgs, (String)"commandArgs");
        UiThreadUtil.assertOnUiThread();
        this.getSurfaceManagerEnforced(surfaceId, "receiveCommand:int").receiveCommand(reactTag, commandId, commandArgs);
    }

    public final void receiveCommand(int surfaceId, int reactTag, @Nullable String commandId, @NotNull ReadableArray commandArgs) {
        Intrinsics.checkNotNullParameter((Object)commandArgs, (String)"commandArgs");
        UiThreadUtil.assertOnUiThread();
        String string2 = commandId;
        if (string2 == null) {
            String string3 = "Required value was null.";
            throw new IllegalStateException(string3.toString());
        }
        this.getSurfaceManagerEnforced(surfaceId, "receiveCommand:string").receiveCommand(reactTag, string2, commandArgs);
    }

    public final void sendAccessibilityEvent(int surfaceId, int reactTag, int eventType) {
        UiThreadUtil.assertOnUiThread();
        if (surfaceId == -1) {
            this.getSurfaceManagerForViewEnforced(reactTag).sendAccessibilityEvent(reactTag, eventType);
        } else {
            this.getSurfaceManagerEnforced(surfaceId, "sendAccessibilityEvent").sendAccessibilityEvent(reactTag, eventType);
        }
    }

    @UiThread
    public final void updateProps(int reactTag, @Nullable ReadableMap props) {
        UiThreadUtil.assertOnUiThread();
        if (props == null) {
            return;
        }
        this.getSurfaceManagerForViewEnforced(reactTag).updateProps(reactTag, props);
    }

    @UiThread
    public final void clearJSResponder() {
        this.jsResponderHandler.clearJSResponder();
    }

    @AnyThread
    @ThreadConfined(value="ANY")
    @Nullable
    public final EventEmitterWrapper getEventEmitter(int surfaceId, int reactTag) {
        SurfaceMountingManager surfaceMountingManager = this.getSurfaceMountingManager(surfaceId, reactTag);
        return surfaceMountingManager != null ? surfaceMountingManager.getEventEmitter(reactTag) : null;
    }

    @AnyThread
    public final long measure(@Nullable ReactContext context, @Nullable String componentName, @Nullable ReadableMap localData, @Nullable ReadableMap props, @Nullable ReadableMap state, float width, @Nullable YogaMeasureMode widthMode, float height, @Nullable YogaMeasureMode heightMode, @Nullable float[] attachmentsPositions) {
        String string2 = componentName;
        if (string2 == null) {
            String string3 = "Required value was null.";
            throw new IllegalStateException(string3.toString());
        }
        return this.viewManagerRegistry.get(string2).measure((Context)context, localData, props, state, width, widthMode, height, heightMode, attachmentsPositions);
    }

    @UnstableReactNativeAPI
    @AnyThread
    public final void experimental_prefetchResource(@Nullable ReactContext reactContext, @Nullable String componentName, int surfaceId, int reactTag, @Nullable MapBuffer params) {
        String string2 = componentName;
        if (string2 == null) {
            String string3 = "Required value was null.";
            throw new IllegalStateException(string3.toString());
        }
        this.viewManagerRegistry.get(string2).experimental_prefetchResource(reactContext, surfaceId, reactTag, params);
    }

    public final void enqueuePendingEvent(int surfaceId, int reactTag, @Nullable String eventName, boolean canCoalesceEvent, @Nullable WritableMap params, int eventCategory) {
        SurfaceMountingManager smm = this.getSurfaceMountingManager(surfaceId, reactTag);
        if (smm == null) {
            FLog.d((String)TAG, (String)"Cannot queue event without valid surface mounting manager for tag: %d, surfaceId: %d", (Object)reactTag, (Object)surfaceId);
            return;
        }
        smm.enqueuePendingEvent(reactTag, eventName, canCoalesceEvent, params, eventCategory);
    }

    private final SurfaceMountingManager getSurfaceMountingManager(int surfaceId, int reactTag) {
        return surfaceId == -1 ? this.getSurfaceManagerForView(reactTag) : this.getSurfaceManager(surfaceId);
    }

    static {
        String string2 = MountingManager.class.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getSimpleName(...)");
        TAG = string2;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/facebook/react/fabric/mounting/MountingManager$Companion;", "", "<init>", "()V", "TAG", "", "getTAG", "()Ljava/lang/String;", "MAX_STOPPED_SURFACE_IDS_LENGTH", "", "ReactAndroid_debug"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getTAG() {
            return TAG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00e0\u0080\u0001\u0018\u00002\u00020\u0001J\u001a\u0010\u0002\u001a\u00020\u00032\u0010\u0010\u0004\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0018\u00010\u0005H'\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0007\u00c0\u0006\u0001"}, d2={"Lcom/facebook/react/fabric/mounting/MountingManager$MountItemExecutor;", "", "executeItems", "", "items", "Ljava/util/Queue;", "Lcom/facebook/react/fabric/mounting/mountitems/MountItem;", "ReactAndroid_debug"})
    public static interface MountItemExecutor {
        @UiThread
        @ThreadConfined(value="UI")
        public void executeItems(@Nullable Queue<MountItem> var1);
    }
}

