/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge;

import com.facebook.react.bridge.JSInstance;
import com.facebook.react.bridge.JavaModuleWrapper;
import com.facebook.react.bridge.ModuleHolder;
import com.facebook.react.bridge.NativeModule;
import com.facebook.react.bridge.OnBatchCompleteListener;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactMarker;
import com.facebook.react.bridge.ReactMarkerConstants;
import com.facebook.react.common.annotations.internal.LegacyArchitectureLogLevel;
import com.facebook.react.common.annotations.internal.LegacyArchitectureLogger;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.systrace.Systrace;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 '2\u00020\u0001:\u0001'B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0001J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0000H\u0001J\b\u0010\u0019\u001a\u00020\u0017H\u0001J\b\u0010\u001a\u001a\u00020\u0017H\u0001J\u0006\u0010\u001b\u001a\u00020\u0017J\u001e\u0010\u001c\u001a\u00020\u001d\"\b\b\u0000\u0010\u001e*\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u0002H\u001e0!J#\u0010\"\u001a\u0002H\u001e\"\b\b\u0000\u0010\u001e*\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u0002H\u001e0!\u00a2\u0006\u0002\u0010#J\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020\u0006J\u000e\u0010\"\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020\u0006R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\u000f8AX\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001f0\u000f8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u0015\u00a8\u0006("}, d2={"Lcom/facebook/react/bridge/NativeModuleRegistry;", "", "reactApplicationContext", "Lcom/facebook/react/bridge/ReactApplicationContext;", "modules", "", "", "Lcom/facebook/react/bridge/ModuleHolder;", "<init>", "(Lcom/facebook/react/bridge/ReactApplicationContext;Ljava/util/Map;)V", "moduleMap", "", "getModuleMap", "()Ljava/util/Map;", "getJavaModules", "", "Lcom/facebook/react/bridge/JavaModuleWrapper;", "jsInstance", "Lcom/facebook/react/bridge/JSInstance;", "cxxModules", "getCxxModules", "()Ljava/util/List;", "registerModules", "", "newRegister", "notifyJSInstanceDestroy", "notifyJSInstanceInitialized", "onBatchComplete", "hasModule", "", "T", "Lcom/facebook/react/bridge/NativeModule;", "moduleInterface", "Ljava/lang/Class;", "getModule", "(Ljava/lang/Class;)Lcom/facebook/react/bridge/NativeModule;", "name", "allModules", "getAllModules", "Companion", "ReactAndroid_debug"})
@SourceDebugExtension(value={"SMAP\nNativeModuleRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NativeModuleRegistry.kt\ncom/facebook/react/bridge/NativeModuleRegistry\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,157:1\n1#2:158\n*E\n"})
public final class NativeModuleRegistry {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final ReactApplicationContext reactApplicationContext;
    @NotNull
    private final Map<String, ModuleHolder> modules;

    public NativeModuleRegistry(@NotNull ReactApplicationContext reactApplicationContext, @NotNull Map<String, ModuleHolder> modules) {
        Intrinsics.checkNotNullParameter((Object)((Object)reactApplicationContext), (String)"reactApplicationContext");
        Intrinsics.checkNotNullParameter(modules, (String)"modules");
        this.reactApplicationContext = reactApplicationContext;
        this.modules = modules;
    }

    private final Map<String, ModuleHolder> getModuleMap() {
        return this.modules;
    }

    @JvmName(name="getJavaModules")
    @NotNull
    public final List<JavaModuleWrapper> getJavaModules(@NotNull JSInstance jsInstance) {
        List list;
        Intrinsics.checkNotNullParameter((Object)jsInstance, (String)"jsInstance");
        List $this$getJavaModules_u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        Iterator<Map.Entry<String, ModuleHolder>> iterator2 = this.modules.entrySet().iterator();
        while (iterator2.hasNext()) {
            ModuleHolder value = iterator2.next().getValue();
            if (value.isCxxModule()) continue;
            $this$getJavaModules_u24lambda_u240.add(new JavaModuleWrapper(jsInstance, value));
        }
        return CollectionsKt.build((List)list);
    }

    @JvmName(name="getCxxModules")
    @NotNull
    public final List<ModuleHolder> getCxxModules() {
        List list;
        List $this$_get_cxxModules__u24lambda_u241 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        Iterator<Map.Entry<String, ModuleHolder>> iterator2 = this.modules.entrySet().iterator();
        while (iterator2.hasNext()) {
            ModuleHolder value = iterator2.next().getValue();
            if (!value.isCxxModule()) continue;
            $this$_get_cxxModules__u24lambda_u241.add(value);
        }
        return CollectionsKt.build((List)list);
    }

    @JvmName(name="registerModules")
    public final void registerModules(@NotNull NativeModuleRegistry newRegister) {
        Intrinsics.checkNotNullParameter((Object)newRegister, (String)"newRegister");
        if (!Intrinsics.areEqual((Object)((Object)this.reactApplicationContext), (Object)((Object)newRegister.reactApplicationContext))) {
            boolean bl = false;
            String string2 = "Extending native modules with non-matching application contexts.";
            throw new IllegalStateException(string2.toString());
        }
        Map<String, ModuleHolder> newModules = newRegister.getModuleMap();
        for (Map.Entry<String, ModuleHolder> entry : newModules.entrySet()) {
            String key = entry.getKey();
            ModuleHolder value = entry.getValue();
            if (this.modules.containsKey(key)) continue;
            this.modules.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmName(name="notifyJSInstanceDestroy")
    public final void notifyJSInstanceDestroy() {
        this.reactApplicationContext.assertOnNativeModulesQueueThread();
        Systrace.beginSection(0L, "NativeModuleRegistry_notifyJSInstanceDestroy");
        try {
            for (ModuleHolder module : this.modules.values()) {
                module.destroy();
            }
        }
        finally {
            Systrace.endSection(0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmName(name="notifyJSInstanceInitialized")
    public final void notifyJSInstanceInitialized() {
        this.reactApplicationContext.assertOnNativeModulesQueueThread("From version React Native v0.44, native modules are explicitly not initialized on the UI thread.");
        ReactMarker.logMarker(ReactMarkerConstants.NATIVE_MODULE_INITIALIZE_START);
        Systrace.beginSection(0L, "NativeModuleRegistry_notifyJSInstanceInitialized");
        try {
            for (ModuleHolder module : this.modules.values()) {
                module.markInitializable$ReactAndroid_debug();
            }
        }
        finally {
            Systrace.endSection(0L);
            ReactMarker.logMarker(ReactMarkerConstants.NATIVE_MODULE_INITIALIZE_END);
        }
    }

    public final void onBatchComplete() {
        block1: {
            LegacyArchitectureLogger.assertLegacyArchitecture("NativeModuleRegistry.onBatchComplete()", LegacyArchitectureLogLevel.WARNING);
            ModuleHolder moduleHolder = this.modules.get("UIManager");
            if (moduleHolder == null) break block1;
            ModuleHolder it = moduleHolder;
            boolean bl = false;
            if (it.hasInstance$ReactAndroid_debug()) {
                NativeModule nativeModule = it.getModule();
                Intrinsics.checkNotNull((Object)nativeModule, (String)"null cannot be cast to non-null type com.facebook.react.bridge.OnBatchCompleteListener");
                ((OnBatchCompleteListener)((Object)nativeModule)).onBatchComplete();
            }
        }
    }

    public final <T extends NativeModule> boolean hasModule(@NotNull Class<T> moduleInterface) {
        Intrinsics.checkNotNullParameter(moduleInterface, (String)"moduleInterface");
        ReactModule annotation = moduleInterface.getAnnotation(ReactModule.class);
        if (annotation == null) {
            boolean $i$a$-requireNotNull-NativeModuleRegistry$hasModule$22 = false;
            String $i$a$-requireNotNull-NativeModuleRegistry$hasModule$22 = "Could not find @ReactModule annotation in class " + moduleInterface.getName();
            throw new IllegalArgumentException($i$a$-requireNotNull-NativeModuleRegistry$hasModule$22.toString());
        }
        String name = annotation.name();
        return this.modules.containsKey(name);
    }

    @NotNull
    public final <T extends NativeModule> T getModule(@NotNull Class<T> moduleInterface) {
        Intrinsics.checkNotNullParameter(moduleInterface, (String)"moduleInterface");
        ReactModule annotation = moduleInterface.getAnnotation(ReactModule.class);
        if (annotation == null) {
            boolean bl = false;
            String string2 = "Could not find @ReactModule annotation in class " + moduleInterface.getName();
            throw new IllegalArgumentException(string2.toString());
        }
        ModuleHolder moduleHolder = this.modules.get(annotation.name());
        if (moduleHolder == null) {
            boolean bl = false;
            String string3 = annotation + ".name could not be found. Is it defined in " + moduleInterface.getName();
            throw new IllegalStateException(string3.toString());
        }
        NativeModule nativeModule = moduleHolder.getModule();
        Intrinsics.checkNotNull((Object)nativeModule, (String)"null cannot be cast to non-null type T of com.facebook.react.bridge.NativeModuleRegistry.getModule");
        return (T)nativeModule;
    }

    public final boolean hasModule(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.modules.containsKey(name);
    }

    @NotNull
    public final NativeModule getModule(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ModuleHolder moduleHolder = this.modules.get(name);
        if (moduleHolder == null) {
            boolean bl = false;
            String string2 = "Could not find module with name " + name;
            throw new IllegalStateException(string2.toString());
        }
        return moduleHolder.getModule();
    }

    @NotNull
    public final List<NativeModule> getAllModules() {
        List list;
        List $this$_get_allModules__u24lambda_u248 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        for (ModuleHolder module : this.modules.values()) {
            $this$_get_allModules__u24lambda_u248.add(module.getModule());
        }
        return CollectionsKt.build((List)list);
    }

    static {
        LegacyArchitectureLogger.assertLegacyArchitecture("NativeModuleRegistry", LegacyArchitectureLogLevel.ERROR);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/facebook/react/bridge/NativeModuleRegistry$Companion;", "", "<init>", "()V", "ReactAndroid_debug"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

