/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.scroll;

import android.content.Context;
import android.view.View;
import androidx.core.view.ViewCompat;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.RetryableMountingLayerException;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.uimanager.BackgroundStyleApplicator;
import com.facebook.react.uimanager.LengthPercentage;
import com.facebook.react.uimanager.LengthPercentageType;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.PointerEvents;
import com.facebook.react.uimanager.ReactStylesDiffMap;
import com.facebook.react.uimanager.StateWrapper;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.ViewGroupManager;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.facebook.react.uimanager.annotations.ReactPropGroup;
import com.facebook.react.uimanager.style.BorderRadiusProp;
import com.facebook.react.uimanager.style.BorderStyle;
import com.facebook.react.uimanager.style.LogicalEdge;
import com.facebook.react.views.scroll.FpsListener;
import com.facebook.react.views.scroll.MaintainVisibleScrollPositionHelper;
import com.facebook.react.views.scroll.ReactScrollView;
import com.facebook.react.views.scroll.ReactScrollViewCommandHelper;
import com.facebook.react.views.scroll.ReactScrollViewHelper;
import com.facebook.react.views.scroll.ScrollEventType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ReactModule(name="RCTScrollView")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0017\u0018\u0000 [2\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003:\u0001[B\u0015\b\u0007\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0018\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0018\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u0018\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0011H\u0007J\u0018\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u0015H\u0007J\u001a\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0007J\u001a\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\b\u0010\u001e\u001a\u0004\u0018\u00010\tH\u0007J\u0018\u0010\u001f\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010 \u001a\u00020\u0011H\u0007J\u0018\u0010!\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020\u0011H\u0007J\u0018\u0010#\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010$\u001a\u00020\u0011H\u0007J\u0018\u0010%\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010&\u001a\u00020\u0011H\u0007J\u001a\u0010'\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\b\u0010(\u001a\u0004\u0018\u00010\tH\u0007J\u0018\u0010)\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010*\u001a\u00020\u0011H\u0007J\u0018\u0010+\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010,\u001a\u00020-H\u0007J\u001a\u0010.\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\b\u0010\u0010\u001a\u0004\u0018\u00010\tH\u0017J\u001a\u0010/\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0016\u00100\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020-\u0018\u000101H\u0016J\"\u00102\u001a\u00020\u000e2\u0006\u00103\u001a\u00020\u00022\u0006\u00104\u001a\u00020-2\b\u00105\u001a\u0004\u0018\u00010\u001cH\u0017J\"\u00102\u001a\u00020\u000e2\u0006\u00103\u001a\u00020\u00022\u0006\u00104\u001a\u00020\t2\b\u00105\u001a\u0004\u0018\u00010\u001cH\u0016J\u0010\u00106\u001a\u00020\u000e2\u0006\u00103\u001a\u00020\u0002H\u0016J\u0018\u00107\u001a\u00020\u000e2\u0006\u00103\u001a\u00020\u00022\u0006\u00108\u001a\u000209H\u0016J\"\u0010:\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00022\u0006\u0010;\u001a\u00020-2\u0006\u0010<\u001a\u00020\u0015H\u0007J\u001c\u0010=\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00022\b\u0010>\u001a\u0004\u0018\u00010\tH\u0007J\"\u0010?\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00022\u0006\u0010;\u001a\u00020-2\u0006\u0010@\u001a\u00020\u0015H\u0007J)\u0010A\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00022\u0006\u0010;\u001a\u00020-2\b\u0010,\u001a\u0004\u0018\u00010-H\u0007\u00a2\u0006\u0002\u0010BJ\u001a\u0010C\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\b\u0010D\u001a\u0004\u0018\u00010\tH\u0007J\u0018\u0010E\u001a\u00020\u000e2\u0006\u00103\u001a\u00020\u00022\u0006\u00108\u001a\u00020FH\u0016J\u0018\u0010G\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0018\u0010H\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020-H\u0007J\u001a\u0010I\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\b\u0010\u0010\u001a\u0004\u0018\u00010JH\u0007J\u001a\u0010K\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\b\u0010\u0010\u001a\u0004\u0018\u00010JH\u0007J\"\u0010L\u001a\u0004\u0018\u00010M2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010N\u001a\u00020O2\u0006\u0010P\u001a\u00020QH\u0016J\u0016\u0010R\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020M\u0018\u000101H\u0016J\u001a\u0010S\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\b\u0010T\u001a\u0004\u0018\u00010\tH\u0007J\u0018\u0010U\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010V\u001a\u00020-H\u0007J\u001a\u0010W\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00022\u0006\u0010X\u001a\u00020\u0011H\u0007J\u0018\u0010Y\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010Z\u001a\u00020\u0011H\u0007R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\\"}, d2={"Lcom/facebook/react/views/scroll/ReactScrollViewManager;", "Lcom/facebook/react/uimanager/ViewGroupManager;", "Lcom/facebook/react/views/scroll/ReactScrollView;", "Lcom/facebook/react/views/scroll/ReactScrollViewCommandHelper$ScrollCommandHandler;", "fpsListener", "Lcom/facebook/react/views/scroll/FpsListener;", "<init>", "(Lcom/facebook/react/views/scroll/FpsListener;)V", "getName", "", "createViewInstance", "context", "Lcom/facebook/react/uimanager/ThemedReactContext;", "setScrollEnabled", "", "view", "value", "", "setShowsVerticalScrollIndicator", "setDecelerationRate", "decelerationRate", "", "setDisableIntervalMomentum", "disableIntervalMomentum", "setSnapToInterval", "snapToInterval", "setSnapToOffsets", "snapToOffsets", "Lcom/facebook/react/bridge/ReadableArray;", "setSnapToAlignment", "alignment", "setSnapToStart", "snapToStart", "setSnapToEnd", "snapToEnd", "setRemoveClippedSubviews", "removeClippedSubviews", "setSendMomentumEvents", "sendMomentumEvents", "setScrollPerfTag", "scrollPerfTag", "setPagingEnabled", "pagingEnabled", "setBottomFillColor", "color", "", "setOverScrollMode", "setNestedScrollEnabled", "getCommandsMap", "", "receiveCommand", "scrollView", "commandId", "args", "flashScrollIndicators", "scrollTo", "data", "Lcom/facebook/react/views/scroll/ReactScrollViewCommandHelper$ScrollToCommandData;", "setBorderRadius", "index", "borderRadius", "setBorderStyle", "borderStyle", "setBorderWidth", "width", "setBorderColor", "(Lcom/facebook/react/views/scroll/ReactScrollView;ILjava/lang/Integer;)V", "setOverflow", "overflow", "scrollToEnd", "Lcom/facebook/react/views/scroll/ReactScrollViewCommandHelper$ScrollToEndCommandData;", "setPersistentScrollbar", "setFadingEdgeLength", "setContentOffset", "Lcom/facebook/react/bridge/ReadableMap;", "setMaintainVisibleContentPosition", "updateState", "", "props", "Lcom/facebook/react/uimanager/ReactStylesDiffMap;", "stateWrapper", "Lcom/facebook/react/uimanager/StateWrapper;", "getExportedCustomDirectEventTypeConstants", "setPointerEvents", "pointerEventsStr", "setScrollEventThrottle", "scrollEventThrottle", "setHorizontal", "horizontal", "setIsInvertedVirtualizedList", "applyFix", "Companion", "ReactAndroid_debug"})
public class ReactScrollViewManager
extends ViewGroupManager<ReactScrollView>
implements ReactScrollViewCommandHelper.ScrollCommandHandler<ReactScrollView> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final FpsListener fpsListener;
    @NotNull
    public static final String REACT_CLASS = "RCTScrollView";

    @JvmOverloads
    public ReactScrollViewManager(@Nullable FpsListener fpsListener) {
        super(null, 1, null);
        this.fpsListener = fpsListener;
    }

    public /* synthetic */ ReactScrollViewManager(FpsListener fpsListener, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            fpsListener = null;
        }
        this(fpsListener);
    }

    @Override
    @NotNull
    public String getName() {
        return REACT_CLASS;
    }

    @Override
    @NotNull
    public ReactScrollView createViewInstance(@NotNull ThemedReactContext context) {
        Intrinsics.checkNotNullParameter((Object)((Object)context), (String)"context");
        return new ReactScrollView((Context)context, this.fpsListener);
    }

    @ReactProp(name="scrollEnabled", defaultBoolean=true)
    public final void setScrollEnabled(@NotNull ReactScrollView view, boolean value) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        view.setScrollEnabled(value);
        view.setFocusable(value);
    }

    @ReactProp(name="showsVerticalScrollIndicator", defaultBoolean=true)
    public final void setShowsVerticalScrollIndicator(@NotNull ReactScrollView view, boolean value) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        view.setVerticalScrollBarEnabled(value);
    }

    @ReactProp(name="decelerationRate")
    public final void setDecelerationRate(@NotNull ReactScrollView view, float decelerationRate) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        view.setDecelerationRate(decelerationRate);
    }

    @ReactProp(name="disableIntervalMomentum")
    public final void setDisableIntervalMomentum(@NotNull ReactScrollView view, boolean disableIntervalMomentum) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        view.setDisableIntervalMomentum(disableIntervalMomentum);
    }

    @ReactProp(name="snapToInterval")
    public final void setSnapToInterval(@NotNull ReactScrollView view, float snapToInterval) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        float density = PixelUtil.getDisplayMetricDensity();
        view.setSnapInterval((int)(snapToInterval * density));
    }

    @ReactProp(name="snapToOffsets")
    public final void setSnapToOffsets(@NotNull ReactScrollView view, @Nullable ReadableArray snapToOffsets) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        if (snapToOffsets == null || snapToOffsets.size() == 0) {
            view.setSnapOffsets(null);
            return;
        }
        float density = PixelUtil.getDisplayMetricDensity();
        List offsets = new ArrayList();
        int n = snapToOffsets.size();
        for (int i = 0; i < n; ++i) {
            offsets.add((int)(snapToOffsets.getDouble(i) * (double)density));
        }
        view.setSnapOffsets(offsets);
    }

    @ReactProp(name="snapToAlignment")
    public final void setSnapToAlignment(@NotNull ReactScrollView view, @Nullable String alignment) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        view.setSnapToAlignment(ReactScrollViewHelper.parseSnapToAlignment(alignment));
    }

    @ReactProp(name="snapToStart")
    public final void setSnapToStart(@NotNull ReactScrollView view, boolean snapToStart) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        view.setSnapToStart(snapToStart);
    }

    @ReactProp(name="snapToEnd")
    public final void setSnapToEnd(@NotNull ReactScrollView view, boolean snapToEnd) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        view.setSnapToEnd(snapToEnd);
    }

    @ReactProp(name="removeClippedSubviews")
    public final void setRemoveClippedSubviews(@NotNull ReactScrollView view, boolean removeClippedSubviews) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        view.setRemoveClippedSubviews(removeClippedSubviews);
    }

    @ReactProp(name="sendMomentumEvents")
    public final void setSendMomentumEvents(@NotNull ReactScrollView view, boolean sendMomentumEvents) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        view.setSendMomentumEvents(sendMomentumEvents);
    }

    @ReactProp(name="scrollPerfTag")
    public final void setScrollPerfTag(@NotNull ReactScrollView view, @Nullable String scrollPerfTag) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        view.setScrollPerfTag(scrollPerfTag);
    }

    @ReactProp(name="pagingEnabled")
    public final void setPagingEnabled(@NotNull ReactScrollView view, boolean pagingEnabled) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        view.setPagingEnabled(pagingEnabled);
    }

    @ReactProp(name="endFillColor", customType="Color", defaultInt=0)
    public final void setBottomFillColor(@NotNull ReactScrollView view, int color) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        view.setEndFillColor(color);
    }

    @ReactProp(name="overScrollMode")
    public void setOverScrollMode(@NotNull ReactScrollView view, @Nullable String value) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        view.setOverScrollMode(ReactScrollViewHelper.parseOverScrollMode(value));
    }

    @ReactProp(name="nestedScrollEnabled")
    public final void setNestedScrollEnabled(@Nullable ReactScrollView view, boolean value) {
        if (view != null) {
            ViewCompat.setNestedScrollingEnabled((View)((View)view), (boolean)value);
        }
    }

    @Override
    @Nullable
    public Map<String, Integer> getCommandsMap() {
        return ReactScrollViewCommandHelper.Companion.getCommandsMap();
    }

    @Override
    @Deprecated(message="ReceiveCommand with an int commandId param is deprecated. Use the overload where commandId is a string.", replaceWith=@ReplaceWith(expression="receiveCommand(scrollView, commandId, args)", imports={}))
    public void receiveCommand(@NotNull ReactScrollView scrollView, int commandId, @Nullable ReadableArray args) {
        Intrinsics.checkNotNullParameter((Object)scrollView, (String)"scrollView");
        ReactScrollViewCommandHelper.Companion.receiveCommand((ReactScrollViewCommandHelper.ScrollCommandHandler)this, scrollView, commandId, args);
    }

    @Override
    public void receiveCommand(@NotNull ReactScrollView scrollView, @NotNull String commandId, @Nullable ReadableArray args) {
        Intrinsics.checkNotNullParameter((Object)scrollView, (String)"scrollView");
        Intrinsics.checkNotNullParameter((Object)commandId, (String)"commandId");
        ReactScrollViewCommandHelper.Companion.receiveCommand((ReactScrollViewCommandHelper.ScrollCommandHandler)this, scrollView, commandId, args);
    }

    @Override
    public void flashScrollIndicators(@NotNull ReactScrollView scrollView) {
        Intrinsics.checkNotNullParameter((Object)scrollView, (String)"scrollView");
        scrollView.flashScrollIndicators();
    }

    @Override
    public void scrollTo(@NotNull ReactScrollView scrollView, @NotNull ReactScrollViewCommandHelper.ScrollToCommandData data) {
        Intrinsics.checkNotNullParameter((Object)scrollView, (String)"scrollView");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        scrollView.abortAnimation();
        if (data.mAnimated) {
            scrollView.reactSmoothScrollTo(data.mDestX, data.mDestY);
        } else {
            scrollView.scrollTo(data.mDestX, data.mDestY);
        }
    }

    @ReactPropGroup(names={"borderRadius", "borderTopLeftRadius", "borderTopRightRadius", "borderBottomRightRadius", "borderBottomLeftRadius"}, defaultFloat=NaNf)
    public final void setBorderRadius(@Nullable ReactScrollView view, int index, float borderRadius) {
        if (view != null) {
            LengthPercentage radius = Float.isNaN(borderRadius) ? null : new LengthPercentage(borderRadius, LengthPercentageType.POINT);
            BackgroundStyleApplicator.setBorderRadius((View)view, (BorderRadiusProp)((Object)BorderRadiusProp.getEntries().get(index)), radius);
        }
    }

    @ReactProp(name="borderStyle")
    public final void setBorderStyle(@Nullable ReactScrollView view, @Nullable String borderStyle) {
        if (view != null) {
            String string2 = borderStyle;
            BorderStyle parsedBorderStyle = string2 == null ? null : BorderStyle.Companion.fromString(string2);
            BackgroundStyleApplicator.setBorderStyle((View)view, parsedBorderStyle);
        }
    }

    @ReactPropGroup(names={"borderWidth", "borderLeftWidth", "borderRightWidth", "borderTopWidth", "borderBottomWidth"}, defaultFloat=NaNf)
    public final void setBorderWidth(@Nullable ReactScrollView view, int index, float width) {
        if (view != null) {
            BackgroundStyleApplicator.setBorderWidth((View)view, (LogicalEdge)((Object)LogicalEdge.getEntries().get(index)), Float.valueOf(width));
        }
    }

    @ReactPropGroup(names={"borderColor", "borderLeftColor", "borderRightColor", "borderTopColor", "borderBottomColor"}, customType="Color")
    public final void setBorderColor(@Nullable ReactScrollView view, int index, @Nullable Integer color) {
        if (view != null) {
            BackgroundStyleApplicator.setBorderColor((View)view, LogicalEdge.ALL, color);
        }
    }

    @ReactProp(name="overflow")
    public final void setOverflow(@NotNull ReactScrollView view, @Nullable String overflow) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        view.setOverflow(overflow);
    }

    @Override
    public void scrollToEnd(@NotNull ReactScrollView scrollView, @NotNull ReactScrollViewCommandHelper.ScrollToEndCommandData data) {
        Intrinsics.checkNotNullParameter((Object)scrollView, (String)"scrollView");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        View view = scrollView.getChildAt(0);
        if (view == null) {
            throw new RetryableMountingLayerException("scrollToEnd called on ScrollView without child");
        }
        View child = view;
        int bottom = child.getHeight() + scrollView.getPaddingBottom();
        scrollView.abortAnimation();
        if (data.mAnimated) {
            scrollView.reactSmoothScrollTo(scrollView.getScrollX(), bottom);
        } else {
            scrollView.scrollTo(scrollView.getScrollX(), bottom);
        }
    }

    @ReactProp(name="persistentScrollbar")
    public final void setPersistentScrollbar(@NotNull ReactScrollView view, boolean value) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        view.setScrollbarFadingEnabled(!value);
    }

    @ReactProp(name="fadingEdgeLength")
    public final void setFadingEdgeLength(@NotNull ReactScrollView view, int value) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        if (value > 0) {
            view.setVerticalFadingEdgeEnabled(true);
            view.setFadingEdgeLength(value);
        } else {
            view.setVerticalFadingEdgeEnabled(false);
            view.setFadingEdgeLength(0);
        }
    }

    @ReactProp(name="contentOffset", customType="Point")
    public final void setContentOffset(@NotNull ReactScrollView view, @Nullable ReadableMap value) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        view.setContentOffset(value);
    }

    @ReactProp(name="maintainVisibleContentPosition")
    public final void setMaintainVisibleContentPosition(@NotNull ReactScrollView view, @Nullable ReadableMap value) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        if (value != null) {
            view.setMaintainVisibleContentPosition(MaintainVisibleScrollPositionHelper.Config.Companion.fromReadableMap(value));
        } else {
            view.setMaintainVisibleContentPosition(null);
        }
    }

    @Override
    @Nullable
    public Object updateState(@NotNull ReactScrollView view, @NotNull ReactStylesDiffMap props, @NotNull StateWrapper stateWrapper) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)props, (String)"props");
        Intrinsics.checkNotNullParameter((Object)stateWrapper, (String)"stateWrapper");
        view.setStateWrapper(stateWrapper);
        return null;
    }

    @Override
    @Nullable
    public Map<String, Object> getExportedCustomDirectEventTypeConstants() {
        Map baseEventTypeConstants = super.getExportedCustomDirectEventTypeConstants();
        Map map = baseEventTypeConstants;
        if (map == null) {
            map = new HashMap();
        }
        Map eventTypeConstants = map;
        eventTypeConstants.putAll(Companion.createExportedCustomDirectEventTypeConstants());
        return eventTypeConstants;
    }

    @ReactProp(name="pointerEvents")
    public final void setPointerEvents(@NotNull ReactScrollView view, @Nullable String pointerEventsStr) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        view.setPointerEvents(PointerEvents.Companion.parsePointerEvents(pointerEventsStr));
    }

    @ReactProp(name="scrollEventThrottle")
    public final void setScrollEventThrottle(@NotNull ReactScrollView view, int scrollEventThrottle) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        view.setScrollEventThrottle(scrollEventThrottle);
    }

    @ReactProp(name="horizontal")
    public final void setHorizontal(@Nullable ReactScrollView view, boolean horizontal) {
    }

    @ReactProp(name="isInvertedVirtualizedList")
    public final void setIsInvertedVirtualizedList(@NotNull ReactScrollView view, boolean applyFix) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        if (applyFix) {
            view.setVerticalScrollbarPosition(1);
        } else {
            view.setVerticalScrollbarPosition(0);
        }
    }

    @JvmOverloads
    public ReactScrollViewManager() {
        this((FpsListener)null, 1, (DefaultConstructorMarker)null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/facebook/react/views/scroll/ReactScrollViewManager$Companion;", "", "<init>", "()V", "REACT_CLASS", "", "createExportedCustomDirectEventTypeConstants", "", "ReactAndroid_debug"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Map<String, Object> createExportedCustomDirectEventTypeConstants() {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)ScrollEventType.Companion.getJSEventName(ScrollEventType.SCROLL), (Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"registrationName", (Object)"onScroll"))), TuplesKt.to((Object)ScrollEventType.Companion.getJSEventName(ScrollEventType.BEGIN_DRAG), (Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"registrationName", (Object)"onScrollBeginDrag"))), TuplesKt.to((Object)ScrollEventType.Companion.getJSEventName(ScrollEventType.END_DRAG), (Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"registrationName", (Object)"onScrollEndDrag"))), TuplesKt.to((Object)ScrollEventType.Companion.getJSEventName(ScrollEventType.MOMENTUM_BEGIN), (Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"registrationName", (Object)"onMomentumScrollBegin"))), TuplesKt.to((Object)ScrollEventType.Companion.getJSEventName(ScrollEventType.MOMENTUM_END), (Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"registrationName", (Object)"onMomentumScrollEnd")))};
            return MapsKt.mapOf((Pair[])pairArray);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

