/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager.layoutanimation;

import android.os.Handler;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.common.annotations.internal.LegacyArchitectureLogLevel;
import com.facebook.react.common.annotations.internal.LegacyArchitectureLogger;
import com.facebook.react.uimanager.layoutanimation.AbstractLayoutAnimation;
import com.facebook.react.uimanager.layoutanimation.LayoutAnimationListener;
import com.facebook.react.uimanager.layoutanimation.LayoutAnimationType;
import com.facebook.react.uimanager.layoutanimation.LayoutCreateAnimation;
import com.facebook.react.uimanager.layoutanimation.LayoutDeleteAnimation;
import com.facebook.react.uimanager.layoutanimation.LayoutHandlingAnimation;
import com.facebook.react.uimanager.layoutanimation.LayoutUpdateAnimation;
import javax.annotation.concurrent.NotThreadSafe;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0017\u0018\u0000 '2\u00020\u0001:\u0001'B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016J\b\u0010\u0017\u001a\u00020\u0012H\u0016J\u0012\u0010\u000b\u001a\u00020\f2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J0\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\u001dH\u0016J\u0018\u0010!\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u0019H\u0002J\u0010\u0010%\u001a\u00020\u00122\u0006\u0010&\u001a\u00020\u000eH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/facebook/react/uimanager/layoutanimation/LayoutAnimationController;", "", "<init>", "()V", "layoutCreateAnimation", "Lcom/facebook/react/uimanager/layoutanimation/AbstractLayoutAnimation;", "layoutUpdateAnimation", "layoutDeleteAnimation", "layoutHandlers", "Landroid/util/SparseArray;", "Lcom/facebook/react/uimanager/layoutanimation/LayoutHandlingAnimation;", "shouldAnimateLayout", "", "maxAnimationDuration", "", "completionRunnable", "Ljava/lang/Runnable;", "initializeFromConfig", "", "config", "Lcom/facebook/react/bridge/ReadableMap;", "completionCallback", "Lcom/facebook/react/bridge/Callback;", "reset", "viewToAnimate", "Landroid/view/View;", "applyLayoutUpdate", "view", "x", "", "y", "width", "height", "deleteView", "listener", "Lcom/facebook/react/uimanager/layoutanimation/LayoutAnimationListener;", "disableUserInteractions", "scheduleCompletionCallback", "delayMillis", "Companion", "ReactAndroid_debug"})
@NotThreadSafe
public class LayoutAnimationController {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final AbstractLayoutAnimation layoutCreateAnimation = new LayoutCreateAnimation();
    @NotNull
    private final AbstractLayoutAnimation layoutUpdateAnimation = new LayoutUpdateAnimation();
    @NotNull
    private final AbstractLayoutAnimation layoutDeleteAnimation = new LayoutDeleteAnimation();
    @NotNull
    private final SparseArray<LayoutHandlingAnimation> layoutHandlers = new SparseArray(0);
    private boolean shouldAnimateLayout;
    private long maxAnimationDuration = -1L;
    @Nullable
    private Runnable completionRunnable;

    public final void initializeFromConfig(@Nullable ReadableMap config, @Nullable Callback completionCallback) {
        int globalDuration;
        if (config == null) {
            this.reset();
            return;
        }
        this.shouldAnimateLayout = false;
        int n = globalDuration = config.hasKey("duration") ? config.getInt("duration") : 0;
        if (config.hasKey(LayoutAnimationType.Companion.toString(LayoutAnimationType.CREATE))) {
            ReadableMap readableMap = config.getMap(LayoutAnimationType.Companion.toString(LayoutAnimationType.CREATE));
            Intrinsics.checkNotNull((Object)readableMap);
            this.layoutCreateAnimation.initializeFromConfig(readableMap, globalDuration);
            this.shouldAnimateLayout = true;
        }
        if (config.hasKey(LayoutAnimationType.Companion.toString(LayoutAnimationType.UPDATE))) {
            ReadableMap readableMap = config.getMap(LayoutAnimationType.Companion.toString(LayoutAnimationType.UPDATE));
            Intrinsics.checkNotNull((Object)readableMap);
            this.layoutUpdateAnimation.initializeFromConfig(readableMap, globalDuration);
            this.shouldAnimateLayout = true;
        }
        if (config.hasKey(LayoutAnimationType.Companion.toString(LayoutAnimationType.DELETE))) {
            ReadableMap readableMap = config.getMap(LayoutAnimationType.Companion.toString(LayoutAnimationType.DELETE));
            Intrinsics.checkNotNull((Object)readableMap);
            this.layoutDeleteAnimation.initializeFromConfig(readableMap, globalDuration);
            this.shouldAnimateLayout = true;
        }
        if (this.shouldAnimateLayout && completionCallback != null) {
            this.completionRunnable = () -> LayoutAnimationController.initializeFromConfig$lambda$0(completionCallback);
        }
    }

    public void reset() {
        this.layoutCreateAnimation.reset();
        this.layoutUpdateAnimation.reset();
        this.layoutDeleteAnimation.reset();
        this.completionRunnable = null;
        this.shouldAnimateLayout = false;
        this.maxAnimationDuration = -1L;
        for (int i = this.layoutHandlers.size() - 1; -1 < i; --i) {
            LayoutHandlingAnimation animation;
            LayoutHandlingAnimation layoutHandlingAnimation = animation = (LayoutHandlingAnimation)this.layoutHandlers.valueAt(i);
            Intrinsics.checkNotNull((Object)layoutHandlingAnimation);
            if (layoutHandlingAnimation.isValid()) continue;
            this.layoutHandlers.removeAt(i);
        }
    }

    public boolean shouldAnimateLayout(@Nullable View viewToAnimate) {
        if (viewToAnimate == null) {
            return false;
        }
        return this.shouldAnimateLayout && viewToAnimate.getParent() != null || this.layoutHandlers.get(viewToAnimate.getId()) != null;
    }

    public void applyLayoutUpdate(@NotNull View view, int x, int y, int width, int height) {
        AbstractLayoutAnimation layoutAnimation;
        Animation animation;
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        UiThreadUtil.assertOnUiThread();
        int reactTag = view.getId();
        LayoutHandlingAnimation existingAnimation = (LayoutHandlingAnimation)this.layoutHandlers.get(reactTag);
        if (existingAnimation != null) {
            if (!existingAnimation.isValid()) {
                this.layoutHandlers.remove(reactTag);
            } else {
                existingAnimation.onLayoutUpdate(x, y, width, height);
                return;
            }
        }
        if ((animation = (layoutAnimation = view.getWidth() == 0 || view.getHeight() == 0 ? this.layoutCreateAnimation : this.layoutUpdateAnimation).createAnimation(view, x, y, width, height)) instanceof LayoutHandlingAnimation) {
            animation.setAnimationListener(new Animation.AnimationListener(this, reactTag){
                final /* synthetic */ LayoutAnimationController this$0;
                final /* synthetic */ int $reactTag;
                {
                    this.this$0 = $receiver;
                    this.$reactTag = $reactTag;
                }

                public void onAnimationStart(Animation animation) {
                    Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
                    LayoutAnimationController.access$getLayoutHandlers$p(this.this$0).put(this.$reactTag, (Object)((LayoutHandlingAnimation)animation));
                }

                public void onAnimationEnd(Animation animation) {
                    Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
                    LayoutAnimationController.access$getLayoutHandlers$p(this.this$0).remove(this.$reactTag);
                }

                public void onAnimationRepeat(Animation animation) {
                    Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
                }
            });
        } else {
            view.layout(x, y, x + width, y + height);
        }
        if (animation != null) {
            long animationDuration = animation.getDuration();
            if (animationDuration > this.maxAnimationDuration) {
                this.maxAnimationDuration = animationDuration;
                this.scheduleCompletionCallback(animationDuration);
            }
            view.startAnimation(animation);
        }
    }

    public void deleteView(@NotNull View view, @NotNull LayoutAnimationListener listener) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        UiThreadUtil.assertOnUiThread();
        Animation animation = this.layoutDeleteAnimation.createAnimation(view, view.getLeft(), view.getTop(), view.getWidth(), view.getHeight());
        if (animation != null) {
            this.disableUserInteractions(view);
            animation.setAnimationListener(new Animation.AnimationListener(listener){
                final /* synthetic */ LayoutAnimationListener $listener;
                {
                    this.$listener = $listener;
                }

                public void onAnimationStart(Animation anim) {
                    Intrinsics.checkNotNullParameter((Object)anim, (String)"anim");
                }

                public void onAnimationRepeat(Animation anim) {
                    Intrinsics.checkNotNullParameter((Object)anim, (String)"anim");
                }

                public void onAnimationEnd(Animation anim) {
                    Intrinsics.checkNotNullParameter((Object)anim, (String)"anim");
                    this.$listener.onAnimationEnd();
                }
            });
            long animationDuration = animation.getDuration();
            if (animationDuration > this.maxAnimationDuration) {
                this.scheduleCompletionCallback(animationDuration);
                this.maxAnimationDuration = animationDuration;
            }
            view.startAnimation(animation);
        } else {
            listener.onAnimationEnd();
        }
    }

    private final void disableUserInteractions(View view) {
        view.setClickable(false);
        if (view instanceof ViewGroup) {
            int n = ((ViewGroup)view).getChildCount();
            for (int i = 0; i < n; ++i) {
                View view2 = ((ViewGroup)view).getChildAt(i);
                Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"getChildAt(...)");
                this.disableUserInteractions(view2);
            }
        }
    }

    private final void scheduleCompletionCallback(long delayMillis) {
        if (this.completionRunnable != null) {
            Handler completionHandler = UiThreadUtil.getUiThreadHandler();
            Runnable runnable = this.completionRunnable;
            Intrinsics.checkNotNull((Object)runnable);
            completionHandler.removeCallbacks(runnable);
            Runnable runnable2 = this.completionRunnable;
            Intrinsics.checkNotNull((Object)runnable2);
            completionHandler.postDelayed(runnable2, delayMillis);
        }
    }

    private static final void initializeFromConfig$lambda$0(Callback $completionCallback) {
        Object[] objectArray = new Object[]{true};
        $completionCallback.invoke(objectArray);
    }

    public static final /* synthetic */ SparseArray access$getLayoutHandlers$p(LayoutAnimationController $this) {
        return $this.layoutHandlers;
    }

    static {
        LegacyArchitectureLogger.assertLegacyArchitecture("LayoutAnimationController", LegacyArchitectureLogLevel.WARNING);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/facebook/react/uimanager/layoutanimation/LayoutAnimationController$Companion;", "", "<init>", "()V", "ReactAndroid_debug"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

