/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.deviceinfo;

import android.content.Context;
import android.content.res.Resources;
import com.facebook.fbreact.specs.NativeDeviceInfoSpec;
import com.facebook.react.bridge.LifecycleEventListener;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactNoCrashSoftException;
import com.facebook.react.bridge.ReactSoftExceptionLogger;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.uimanager.DisplayMetricsHolder;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ReactModule(name="DeviceInfo")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0001\u0018\u0000 \u00152\u00020\u00012\u00020\u0002:\u0001\u0015B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0014\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0010H\u0016J\b\u0010\u0012\u001a\u00020\u0010H\u0016J\u0006\u0010\u0013\u001a\u00020\u0010J\b\u0010\u0014\u001a\u00020\u0010H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/facebook/react/modules/deviceinfo/DeviceInfoModule;", "Lcom/facebook/fbreact/specs/NativeDeviceInfoSpec;", "Lcom/facebook/react/bridge/LifecycleEventListener;", "reactContext", "Lcom/facebook/react/bridge/ReactApplicationContext;", "<init>", "(Lcom/facebook/react/bridge/ReactApplicationContext;)V", "fontScale", "", "previousDisplayMetrics", "Lcom/facebook/react/bridge/ReadableMap;", "getTypedExportedConstants", "", "", "", "onHostResume", "", "onHostPause", "onHostDestroy", "emitUpdateDimensionsEvent", "invalidate", "Companion", "ReactAndroid_debug"})
public final class DeviceInfoModule
extends NativeDeviceInfoSpec
implements LifecycleEventListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private float fontScale;
    @Nullable
    private ReadableMap previousDisplayMetrics;
    @NotNull
    public static final String NAME = "DeviceInfo";

    public DeviceInfoModule(@NotNull ReactApplicationContext reactContext) {
        Intrinsics.checkNotNullParameter((Object)((Object)reactContext), (String)"reactContext");
        super(reactContext);
        this.fontScale = reactContext.getResources().getConfiguration().fontScale;
        DisplayMetricsHolder.initDisplayMetricsIfNotInitialized((Context)reactContext);
        reactContext.addLifecycleEventListener(this);
    }

    @Override
    @NotNull
    public Map<String, Object> getTypedExportedConstants() {
        WritableMap displayMetrics = DisplayMetricsHolder.getDisplayMetricsWritableMap(this.fontScale);
        this.previousDisplayMetrics = displayMetrics.copy();
        return MapsKt.mapOf((Pair)TuplesKt.to((Object)"Dimensions", displayMetrics.toHashMap()));
    }

    @Override
    public void onHostResume() {
        Float newFontScale;
        Resources resources = this.getReactApplicationContext().getResources();
        Float f = resources != null && (resources = resources.getConfiguration()) != null ? Float.valueOf(resources.fontScale) : (newFontScale = null);
        if (newFontScale != null && !Intrinsics.areEqual((Float)newFontScale, (float)this.fontScale)) {
            this.fontScale = newFontScale.floatValue();
            this.emitUpdateDimensionsEvent();
        }
    }

    @Override
    public void onHostPause() {
    }

    @Override
    public void onHostDestroy() {
    }

    public final void emitUpdateDimensionsEvent() {
        ReactApplicationContext context = this.getReactApplicationContext();
        boolean bl = false;
        if (context.hasActiveReactInstance()) {
            WritableMap displayMetrics = DisplayMetricsHolder.getDisplayMetricsWritableMap(this.fontScale);
            if (this.previousDisplayMetrics == null) {
                this.previousDisplayMetrics = displayMetrics.copy();
            } else if (!Intrinsics.areEqual((Object)displayMetrics, (Object)this.previousDisplayMetrics)) {
                this.previousDisplayMetrics = displayMetrics.copy();
                context.emitDeviceEvent("didUpdateDimensions", displayMetrics);
            }
        } else {
            ReactSoftExceptionLogger.logSoftException(NAME, new ReactNoCrashSoftException("No active CatalystInstance, cannot emitUpdateDimensionsEvent"));
        }
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.getReactApplicationContext().removeLifecycleEventListener(this);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/facebook/react/modules/deviceinfo/DeviceInfoModule$Companion;", "", "<init>", "()V", "NAME", "", "ReactAndroid_debug"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

