/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge;

import com.facebook.infer.annotation.Nullsafe;
import com.facebook.jni.HybridData;
import com.facebook.proguard.annotations.DoNotStripAny;
import com.facebook.react.bridge.BridgeSoLoader;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.common.annotations.internal.LegacyArchitectureLogLevel;
import com.facebook.react.common.annotations.internal.LegacyArchitectureLogger;
import com.facebook.react.devsupport.inspector.InspectorNetworkRequestListener;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;

@DoNotStripAny
@Nullsafe(value=Nullsafe.Mode.LOCAL)
public class ReactInstanceManagerInspectorTarget
implements AutoCloseable {
    private final HybridData mHybridData;

    public ReactInstanceManagerInspectorTarget(TargetDelegate delegate) {
        this.mHybridData = this.initHybrid(new Executor(){

            @Override
            public void execute(Runnable command) {
                if (UiThreadUtil.isOnUiThread()) {
                    command.run();
                } else {
                    UiThreadUtil.runOnUiThread(command);
                }
            }
        }, delegate);
    }

    private native HybridData initHybrid(Executor var1, TargetDelegate var2);

    public native void sendDebuggerResumeCommand();

    @Override
    public void close() {
        this.mHybridData.resetNative();
    }

    boolean isValid() {
        return this.mHybridData.isValid();
    }

    static {
        LegacyArchitectureLogger.assertLegacyArchitecture("ReactInstanceManagerInspectorTarget", LegacyArchitectureLogLevel.WARNING);
        BridgeSoLoader.staticInit();
    }

    @DoNotStripAny
    public static interface TargetDelegate {
        public Map<String, String> getMetadata();

        public void onReload();

        public void onSetPausedInDebuggerMessage(@Nullable String var1);

        public void loadNetworkResource(String var1, InspectorNetworkRequestListener var2);
    }
}

