/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge;

import androidx.core.util.Pools;
import com.facebook.react.bridge.Dynamic;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableType;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\u0011\u001a\u00020\u0005H\u0016J\b\u0010\u0012\u001a\u00020\u000fH\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0007H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0010\u00a8\u0006\u001b"}, d2={"Lcom/facebook/react/bridge/DynamicFromArray;", "Lcom/facebook/react/bridge/Dynamic;", "<init>", "()V", "array", "Lcom/facebook/react/bridge/ReadableArray;", "index", "", "recycle", "", "type", "Lcom/facebook/react/bridge/ReadableType;", "getType", "()Lcom/facebook/react/bridge/ReadableType;", "isNull", "", "()Z", "asArray", "asBoolean", "asDouble", "", "asInt", "asMap", "Lcom/facebook/react/bridge/ReadableMap;", "asString", "", "Companion", "ReactAndroid_debug"})
public final class DynamicFromArray
implements Dynamic {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private ReadableArray array;
    private int index = -1;
    @NotNull
    private static final Pools.SimplePool<DynamicFromArray> pool = new Pools.SimplePool(10);

    private DynamicFromArray() {
    }

    @Override
    public void recycle() {
        this.array = null;
        this.index = -1;
        pool.release((Object)this);
    }

    @Override
    @NotNull
    public ReadableType getType() {
        Object object = this.array;
        if (object == null || (object = object.getType(this.index)) == null) {
            throw new IllegalStateException("This dynamic value has been recycled");
        }
        return object;
    }

    @Override
    public boolean isNull() {
        ReadableArray readableArray = this.array;
        if (readableArray == null) {
            throw new IllegalStateException("This dynamic value has been recycled");
        }
        return readableArray.isNull(this.index);
    }

    @Override
    @NotNull
    public ReadableArray asArray() {
        ReadableArray readableArray = this.array;
        if (readableArray == null || (readableArray = readableArray.getArray(this.index)) == null) {
            throw new IllegalStateException("This dynamic value has been recycled");
        }
        return readableArray;
    }

    @Override
    public boolean asBoolean() {
        ReadableArray readableArray = this.array;
        if (readableArray == null) {
            throw new IllegalStateException("This dynamic value has been recycled");
        }
        return readableArray.getBoolean(this.index);
    }

    @Override
    public double asDouble() {
        ReadableArray readableArray = this.array;
        if (readableArray == null) {
            throw new IllegalStateException("This dynamic value has been recycled");
        }
        return readableArray.getDouble(this.index);
    }

    @Override
    public int asInt() {
        ReadableArray readableArray = this.array;
        if (readableArray == null) {
            throw new IllegalStateException("This dynamic value has been recycled");
        }
        return readableArray.getInt(this.index);
    }

    @Override
    @NotNull
    public ReadableMap asMap() {
        Object object = this.array;
        if (object == null || (object = object.getMap(this.index)) == null) {
            throw new IllegalStateException("This dynamic value has been recycled");
        }
        return object;
    }

    @Override
    @NotNull
    public String asString() {
        Object object = this.array;
        if (object == null || (object = object.getString(this.index)) == null) {
            throw new IllegalStateException("This dynamic value has been recycled");
        }
        return object;
    }

    @JvmStatic
    @NotNull
    public static final DynamicFromArray create(@NotNull ReadableArray array, int index) {
        return Companion.create(array, index);
    }

    public /* synthetic */ DynamicFromArray(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/facebook/react/bridge/DynamicFromArray$Companion;", "", "<init>", "()V", "pool", "Landroidx/core/util/Pools$SimplePool;", "Lcom/facebook/react/bridge/DynamicFromArray;", "create", "array", "Lcom/facebook/react/bridge/ReadableArray;", "index", "", "ReactAndroid_debug"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final DynamicFromArray create(@NotNull ReadableArray array, int index) {
            Intrinsics.checkNotNullParameter((Object)array, (String)"array");
            DynamicFromArray dynamicFromArray = (DynamicFromArray)pool.acquire();
            if (dynamicFromArray == null) {
                dynamicFromArray = new DynamicFromArray(null);
            }
            DynamicFromArray dynamic = dynamicFromArray;
            dynamic.array = array;
            dynamic.index = index;
            return dynamic;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

