/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react;

import android.annotation.SuppressLint;
import android.app.Application;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.IBinder;
import android.os.PowerManager;
import com.facebook.react.ReactApplication;
import com.facebook.react.ReactHost;
import com.facebook.react.ReactInstanceEventListener;
import com.facebook.react.ReactInstanceManager;
import com.facebook.react.ReactNativeHost;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.internal.featureflags.ReactNativeNewArchitectureFeatureFlags;
import com.facebook.react.jstasks.HeadlessJsTaskConfig;
import com.facebook.react.jstasks.HeadlessJsTaskContext;
import com.facebook.react.jstasks.HeadlessJsTaskEventListener;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u0000 &2\u00020\u00012\u00020\u0002:\u0001&B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\"\u0010\b\u001a\u00020\u00072\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0007H\u0016J\u0014\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0014J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000eH\u0004J\u0018\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u000eH\u0002J\b\u0010\u0017\u001a\u00020\u0012H\u0016J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u0007H\u0016J\u0010\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u0007H\u0016J\u0010\u0010%\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000eH\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\u00020\u001c8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0016\u0010\u001f\u001a\u0004\u0018\u00010 8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0016\u0010\u0015\u001a\u0004\u0018\u00010\u00168DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$\u00a8\u0006'"}, d2={"Lcom/facebook/react/HeadlessJsTaskService;", "Landroid/app/Service;", "Lcom/facebook/react/jstasks/HeadlessJsTaskEventListener;", "<init>", "()V", "activeTasks", "", "", "onStartCommand", "intent", "Landroid/content/Intent;", "flags", "startId", "getTaskConfig", "Lcom/facebook/react/jstasks/HeadlessJsTaskConfig;", "onBind", "Landroid/os/IBinder;", "startTask", "", "taskConfig", "invokeStartTask", "reactContext", "Lcom/facebook/react/bridge/ReactContext;", "onDestroy", "onHeadlessJsTaskStart", "taskId", "onHeadlessJsTaskFinish", "reactNativeHost", "Lcom/facebook/react/ReactNativeHost;", "getReactNativeHost", "()Lcom/facebook/react/ReactNativeHost;", "reactHost", "Lcom/facebook/react/ReactHost;", "getReactHost", "()Lcom/facebook/react/ReactHost;", "getReactContext", "()Lcom/facebook/react/bridge/ReactContext;", "createReactContextAndScheduleTask", "Companion", "ReactAndroid_debug"})
@SourceDebugExtension(value={"SMAP\nHeadlessJsTaskService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HeadlessJsTaskService.kt\ncom/facebook/react/HeadlessJsTaskService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,186:1\n1#2:187\n*E\n"})
public abstract class HeadlessJsTaskService
extends Service
implements HeadlessJsTaskEventListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<Integer> activeTasks = new CopyOnWriteArraySet();
    @Nullable
    private static PowerManager.WakeLock wakeLock;

    public int onStartCommand(@Nullable Intent intent, int flags, int startId) {
        int n;
        HeadlessJsTaskConfig taskConfig = this.getTaskConfig(intent);
        if (taskConfig != null) {
            this.startTask(taskConfig);
            n = 3;
        } else {
            n = 2;
        }
        return n;
    }

    @Nullable
    protected HeadlessJsTaskConfig getTaskConfig(@Nullable Intent intent) {
        return null;
    }

    @Nullable
    public IBinder onBind(@NotNull Intent intent) {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        return null;
    }

    protected final void startTask(@NotNull HeadlessJsTaskConfig taskConfig) {
        Intrinsics.checkNotNullParameter((Object)taskConfig, (String)"taskConfig");
        UiThreadUtil.assertOnUiThread();
        Companion.acquireWakeLockNow((Context)this);
        ReactContext context = this.getReactContext();
        if (context == null) {
            this.createReactContextAndScheduleTask(taskConfig);
        } else {
            this.invokeStartTask(context, taskConfig);
        }
    }

    private final void invokeStartTask(ReactContext reactContext, HeadlessJsTaskConfig taskConfig) {
        HeadlessJsTaskContext headlessJsTaskContext = HeadlessJsTaskContext.Companion.getInstance(reactContext);
        headlessJsTaskContext.addTaskEventListener(this);
        UiThreadUtil.runOnUiThread(() -> HeadlessJsTaskService.invokeStartTask$lambda$0(headlessJsTaskContext, taskConfig, this));
    }

    public void onDestroy() {
        block1: {
            super.onDestroy();
            ReactContext reactContext = this.getReactContext();
            if (reactContext != null) {
                ReactContext context = reactContext;
                boolean bl = false;
                HeadlessJsTaskContext headlessJsTaskContext = HeadlessJsTaskContext.Companion.getInstance(context);
                headlessJsTaskContext.removeTaskEventListener(this);
            }
            PowerManager.WakeLock wakeLock = HeadlessJsTaskService.wakeLock;
            if (wakeLock == null) break block1;
            wakeLock.release();
        }
    }

    @Override
    public void onHeadlessJsTaskStart(int taskId) {
    }

    @Override
    public void onHeadlessJsTaskFinish(int taskId) {
        this.activeTasks.remove(taskId);
        if (this.activeTasks.isEmpty()) {
            this.stopSelf();
        }
    }

    @NotNull
    protected final ReactNativeHost getReactNativeHost() {
        Application application = this.getApplication();
        Intrinsics.checkNotNull((Object)application, (String)"null cannot be cast to non-null type com.facebook.react.ReactApplication");
        return ((ReactApplication)application).getReactNativeHost();
    }

    @Nullable
    protected final ReactHost getReactHost() {
        Application application = this.getApplication();
        Intrinsics.checkNotNull((Object)application, (String)"null cannot be cast to non-null type com.facebook.react.ReactApplication");
        return ((ReactApplication)application).getReactHost();
    }

    @Nullable
    protected final ReactContext getReactContext() {
        if (ReactNativeNewArchitectureFeatureFlags.enableBridgelessArchitecture()) {
            ReactHost reactHost = this.getReactHost();
            if (reactHost == null) {
                boolean bl = false;
                String string2 = "ReactHost is not initialized in New Architecture";
                throw new IllegalStateException(string2.toString());
            }
            ReactHost reactHost2 = reactHost;
            return reactHost2.getCurrentReactContext();
        }
        ReactInstanceManager reactInstanceManager = this.getReactNativeHost().getReactInstanceManager();
        return reactInstanceManager.getCurrentReactContext();
    }

    private final void createReactContextAndScheduleTask(HeadlessJsTaskConfig taskConfig) {
        if (ReactNativeNewArchitectureFeatureFlags.enableBridgelessArchitecture()) {
            ReactHost reactHost = this.getReactHost();
            if (reactHost == null) {
                String string2 = "Required value was null.";
                throw new IllegalStateException(string2.toString());
            }
            ReactHost reactHost2 = reactHost;
            reactHost2.addReactInstanceEventListener(new ReactInstanceEventListener(this, taskConfig, reactHost2){
                final /* synthetic */ HeadlessJsTaskService this$0;
                final /* synthetic */ HeadlessJsTaskConfig $taskConfig;
                final /* synthetic */ ReactHost $reactHost;
                {
                    this.this$0 = $receiver;
                    this.$taskConfig = $taskConfig;
                    this.$reactHost = $reactHost;
                }

                public void onReactContextInitialized(ReactContext context) {
                    Intrinsics.checkNotNullParameter((Object)((Object)context), (String)"context");
                    HeadlessJsTaskService.access$invokeStartTask(this.this$0, context, this.$taskConfig);
                    this.$reactHost.removeReactInstanceEventListener(this);
                }
            });
            reactHost2.start();
        } else {
            ReactInstanceManager reactInstanceManager = this.getReactNativeHost().getReactInstanceManager();
            reactInstanceManager.addReactInstanceEventListener(new ReactInstanceEventListener(this, taskConfig, reactInstanceManager){
                final /* synthetic */ HeadlessJsTaskService this$0;
                final /* synthetic */ HeadlessJsTaskConfig $taskConfig;
                final /* synthetic */ ReactInstanceManager $reactInstanceManager;
                {
                    this.this$0 = $receiver;
                    this.$taskConfig = $taskConfig;
                    this.$reactInstanceManager = $reactInstanceManager;
                }

                public void onReactContextInitialized(ReactContext context) {
                    Intrinsics.checkNotNullParameter((Object)((Object)context), (String)"context");
                    HeadlessJsTaskService.access$invokeStartTask(this.this$0, context, this.$taskConfig);
                    this.$reactInstanceManager.removeReactInstanceEventListener(this);
                }
            });
            reactInstanceManager.createReactContextInBackground();
        }
    }

    private static final void invokeStartTask$lambda$0(HeadlessJsTaskContext $headlessJsTaskContext, HeadlessJsTaskConfig $taskConfig, HeadlessJsTaskService this$0) {
        int taskId = $headlessJsTaskContext.startTask($taskConfig);
        this$0.activeTasks.add(taskId);
    }

    @JvmStatic
    @SuppressLint(value={"WakelockTimeout"})
    public static final void acquireWakeLockNow(@NotNull Context context) {
        Companion.acquireWakeLockNow(context);
    }

    public static final /* synthetic */ void access$invokeStartTask(HeadlessJsTaskService $this, ReactContext reactContext, HeadlessJsTaskConfig taskConfig) {
        $this.invokeStartTask(reactContext, taskConfig);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007R\u0014\u0010\u0004\u001a\b\u0018\u00010\u0005R\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/facebook/react/HeadlessJsTaskService$Companion;", "", "<init>", "()V", "wakeLock", "Landroid/os/PowerManager$WakeLock;", "Landroid/os/PowerManager;", "acquireWakeLockNow", "", "context", "Landroid/content/Context;", "ReactAndroid_debug"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @SuppressLint(value={"WakelockTimeout"})
        public final void acquireWakeLockNow(@NotNull Context context) {
            block4: {
                PowerManager.WakeLock wakeLock;
                block3: {
                    Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                    if (wakeLock == null) break block3;
                    PowerManager.WakeLock wakeLock2 = wakeLock;
                    boolean bl = wakeLock2 != null ? !wakeLock2.isHeld() : false;
                    if (!bl) break block4;
                }
                Object object = context.getSystemService("power");
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.os.PowerManager");
                PowerManager powerManager = (PowerManager)object;
                PowerManager.WakeLock lock = wakeLock = powerManager.newWakeLock(1, HeadlessJsTaskService.class.getCanonicalName());
                boolean bl = false;
                lock.setReferenceCounted(false);
                lock.acquire();
                HeadlessJsTaskService.wakeLock = wakeLock;
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

