/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.devsupport;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.AlertDialog;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.hardware.SensorManager;
import android.os.Build;
import android.util.Pair;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.Nullable;
import androidx.annotation.UiThread;
import androidx.core.util.Supplier;
import com.facebook.common.logging.FLog;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.R;
import com.facebook.react.bridge.DefaultJSExceptionHandler;
import com.facebook.react.bridge.JSBundleLoader;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReactMarker;
import com.facebook.react.bridge.ReactMarkerConstants;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.common.DebugServerException;
import com.facebook.react.common.JavascriptException;
import com.facebook.react.common.ShakeDetector;
import com.facebook.react.common.SurfaceDelegate;
import com.facebook.react.common.SurfaceDelegateFactory;
import com.facebook.react.devsupport.BundleDownloader;
import com.facebook.react.devsupport.DebugOverlayController;
import com.facebook.react.devsupport.DefaultDevLoadingViewImplementation;
import com.facebook.react.devsupport.DevInternalSettings;
import com.facebook.react.devsupport.DevServerHelper;
import com.facebook.react.devsupport.DevSettingsActivity;
import com.facebook.react.devsupport.HMRClient;
import com.facebook.react.devsupport.InspectorFlags;
import com.facebook.react.devsupport.PausedInDebuggerOverlayDialogManager;
import com.facebook.react.devsupport.ReactInstanceDevHelper;
import com.facebook.react.devsupport.RedBoxDialogSurfaceDelegate;
import com.facebook.react.devsupport.StackTraceHelper;
import com.facebook.react.devsupport.interfaces.BundleLoadCallback;
import com.facebook.react.devsupport.interfaces.DevBundleDownloadListener;
import com.facebook.react.devsupport.interfaces.DevLoadingViewManager;
import com.facebook.react.devsupport.interfaces.DevOptionHandler;
import com.facebook.react.devsupport.interfaces.DevSupportManager;
import com.facebook.react.devsupport.interfaces.ErrorCustomizer;
import com.facebook.react.devsupport.interfaces.ErrorType;
import com.facebook.react.devsupport.interfaces.PackagerStatusCallback;
import com.facebook.react.devsupport.interfaces.PausedInDebuggerOverlayManager;
import com.facebook.react.devsupport.interfaces.RedBoxHandler;
import com.facebook.react.devsupport.interfaces.StackFrame;
import com.facebook.react.modules.core.RCTNativeAppEventEmitter;
import com.facebook.react.modules.debug.interfaces.DeveloperSettings;
import com.facebook.react.packagerconnection.RequestHandler;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public abstract class DevSupportManagerBase
implements DevSupportManager {
    private static final int JAVA_ERROR_COOKIE = -1;
    private static final int JSEXCEPTION_ERROR_COOKIE = -1;
    private static final String RELOAD_APP_ACTION_SUFFIX = ".RELOAD_APP_ACTION";
    private static final String EXOPACKAGE_LOCATION_FORMAT = "/data/local/tmp/exopackage/%s//secondary-dex";
    private final Context mApplicationContext;
    private final ShakeDetector mShakeDetector;
    private final BroadcastReceiver mReloadAppBroadcastReceiver;
    private final DevServerHelper mDevServerHelper;
    private final LinkedHashMap<String, DevOptionHandler> mCustomDevOptions = new LinkedHashMap();
    protected final ReactInstanceDevHelper mReactInstanceDevHelper;
    @Nullable
    private final String mJSAppBundleName;
    private final File mJSBundleDownloadedFile;
    private final File mJSSplitBundlesDir;
    private final DefaultJSExceptionHandler mDefaultJSExceptionHandler;
    private final DevLoadingViewManager mDevLoadingViewManager;
    private final PausedInDebuggerOverlayManager mPausedInDebuggerOverlayManager;
    @Nullable
    private SurfaceDelegate mRedBoxSurfaceDelegate;
    @Nullable
    private AlertDialog mDevOptionsDialog;
    @Nullable
    private DebugOverlayController mDebugOverlayController;
    private boolean mDevLoadingViewVisible = false;
    private int mPendingJSSplitBundleRequests = 0;
    @Nullable
    private ReactContext mCurrentReactContext;
    private final DeveloperSettings mDevSettings;
    private boolean mIsReceiverRegistered = false;
    private boolean mIsShakeDetectorStarted = false;
    private boolean mIsDevSupportEnabled = false;
    private boolean mIsPackagerConnected;
    @Nullable
    private final RedBoxHandler mRedBoxHandler;
    @Nullable
    private String mLastErrorTitle;
    @Nullable
    private StackFrame[] mLastErrorStack;
    @Nullable
    private ErrorType mLastErrorType;
    private int mLastErrorCookie = 0;
    @Nullable
    private final DevBundleDownloadListener mBundleDownloadListener;
    @Nullable
    private List<ErrorCustomizer> mErrorCustomizers;
    @Nullable
    private DevSupportManager.PackagerLocationCustomizer mPackagerLocationCustomizer;
    @Nullable
    private final Map<String, RequestHandler> mCustomPackagerCommandHandlers;
    @Nullable
    private final SurfaceDelegateFactory mSurfaceDelegateFactory;

    public DevSupportManagerBase(Context applicationContext, ReactInstanceDevHelper reactInstanceDevHelper, @Nullable String packagerPathForJSBundleName, boolean enableOnCreate, @Nullable RedBoxHandler redBoxHandler, @Nullable DevBundleDownloadListener devBundleDownloadListener, int minNumShakes, @Nullable Map<String, RequestHandler> customPackagerCommandHandlers, @Nullable SurfaceDelegateFactory surfaceDelegateFactory, @Nullable DevLoadingViewManager devLoadingViewManager, @Nullable PausedInDebuggerOverlayManager pausedInDebuggerOverlayManager) {
        this.mReactInstanceDevHelper = reactInstanceDevHelper;
        this.mApplicationContext = applicationContext;
        this.mJSAppBundleName = packagerPathForJSBundleName;
        this.mDevSettings = new DevInternalSettings(applicationContext, this::reloadSettings);
        this.mDevServerHelper = new DevServerHelper(this.mDevSettings, this.mApplicationContext, this.mDevSettings.getPackagerConnectionSettings());
        this.mBundleDownloadListener = devBundleDownloadListener;
        this.mShakeDetector = new ShakeDetector(this::showDevOptionsDialog, minNumShakes);
        this.mCustomPackagerCommandHandlers = customPackagerCommandHandlers;
        this.mReloadAppBroadcastReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                String action = intent.getAction();
                if (DevSupportManagerBase.getReloadAppAction(context).equals(action)) {
                    DevSupportManagerBase.this.handleReloadJS();
                }
            }
        };
        String subclassTag = this.getUniqueTag();
        String bundleFile = subclassTag + "ReactNativeDevBundle.js";
        this.mJSBundleDownloadedFile = new File(applicationContext.getFilesDir(), bundleFile);
        String splitBundlesDir = subclassTag.toLowerCase(Locale.ROOT) + "_dev_js_split_bundles";
        this.mJSSplitBundlesDir = this.mApplicationContext.getDir(splitBundlesDir, 0);
        this.mDefaultJSExceptionHandler = new DefaultJSExceptionHandler();
        this.setDevSupportEnabled(enableOnCreate);
        this.mRedBoxHandler = redBoxHandler;
        this.mDevLoadingViewManager = devLoadingViewManager != null ? devLoadingViewManager : new DefaultDevLoadingViewImplementation(reactInstanceDevHelper);
        this.mSurfaceDelegateFactory = surfaceDelegateFactory;
        this.mPausedInDebuggerOverlayManager = pausedInDebuggerOverlayManager != null ? pausedInDebuggerOverlayManager : new PausedInDebuggerOverlayDialogManager((Supplier<Context>)((Supplier)() -> {
            Activity context = this.mReactInstanceDevHelper.getCurrentActivity();
            if (context == null || context.isFinishing()) {
                return null;
            }
            return context;
        }));
    }

    protected abstract String getUniqueTag();

    @Override
    public void handleException(Exception e) {
        if (this.mIsDevSupportEnabled) {
            this.logJSException(e);
        } else {
            this.mDefaultJSExceptionHandler.handleException(e);
        }
    }

    private void logJSException(Exception e) {
        StringBuilder message = new StringBuilder(e.getMessage() == null ? "Exception in native call from JS" : e.getMessage());
        for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
            message.append("\n\n").append(cause.getMessage());
        }
        if (e instanceof JavascriptException) {
            FLog.e((String)"ReactNative", (String)"Exception in native call from JS", (Throwable)e);
            this.showNewError(e.getMessage().toString(), new StackFrame[0], -1, ErrorType.JS);
        } else {
            this.showNewJavaError(message.toString(), e);
        }
    }

    @Override
    public void showNewJavaError(@Nullable String message, Throwable e) {
        FLog.e((String)"ReactNative", (String)"Exception in native call", (Throwable)e);
        this.showNewError(message, StackTraceHelper.convertJavaStackTrace(e), -1, ErrorType.NATIVE);
    }

    @Override
    public void addCustomDevOption(String optionName, DevOptionHandler optionHandler) {
        this.mCustomDevOptions.put(optionName, optionHandler);
    }

    @Override
    public void showNewJSError(String message, ReadableArray details, int errorCookie) {
        this.showNewError(message, StackTraceHelper.convertJsStackTrace(details), errorCookie, ErrorType.JS);
    }

    @Override
    public void registerErrorCustomizer(ErrorCustomizer errorCustomizer) {
        if (this.mErrorCustomizers == null) {
            this.mErrorCustomizers = new ArrayList<ErrorCustomizer>();
        }
        this.mErrorCustomizers.add(errorCustomizer);
    }

    @Override
    public Pair<String, StackFrame[]> processErrorCustomizers(Pair<String, StackFrame[]> errorInfo) {
        if (this.mErrorCustomizers != null) {
            for (ErrorCustomizer errorCustomizer : this.mErrorCustomizers) {
                Pair<String, StackFrame[]> result = errorCustomizer.customizeErrorInfo(errorInfo);
                if (result == null) continue;
                errorInfo = result;
            }
        }
        return errorInfo;
    }

    @Override
    public void hideRedboxDialog() {
        if (this.mRedBoxSurfaceDelegate == null) {
            return;
        }
        this.mRedBoxSurfaceDelegate.hide();
    }

    @Override
    @Nullable
    public View createRootView(String appKey) {
        return this.mReactInstanceDevHelper.createRootView(appKey);
    }

    @Override
    public void destroyRootView(View rootView) {
        this.mReactInstanceDevHelper.destroyRootView(rootView);
    }

    private void hideDevOptionsDialog() {
        if (this.mDevOptionsDialog != null) {
            this.mDevOptionsDialog.dismiss();
            this.mDevOptionsDialog = null;
        }
    }

    private void showNewError(@Nullable String message, StackFrame[] stack, int errorCookie, ErrorType errorType) {
        UiThreadUtil.runOnUiThread(() -> {
            this.updateLastErrorInfo(message, stack, errorCookie, errorType);
            if (this.mRedBoxSurfaceDelegate == null) {
                SurfaceDelegate redBoxSurfaceDelegate = this.createSurfaceDelegate("RedBox");
                this.mRedBoxSurfaceDelegate = redBoxSurfaceDelegate != null ? redBoxSurfaceDelegate : new RedBoxDialogSurfaceDelegate(this);
                this.mRedBoxSurfaceDelegate.createContentView("RedBox");
            }
            if (this.mRedBoxSurfaceDelegate.isShowing()) {
                return;
            }
            this.mRedBoxSurfaceDelegate.show();
        });
    }

    @Override
    public void showDevOptionsDialog() {
        if (this.mDevOptionsDialog != null || !this.mIsDevSupportEnabled || ActivityManager.isUserAMonkey()) {
            return;
        }
        LinkedHashMap<String, DevOptionHandler> options = new LinkedHashMap<String, DevOptionHandler>();
        final HashSet<String> disabledItemKeys = new HashSet<String>();
        options.put(this.mApplicationContext.getString(R.string.catalyst_reload), new DevOptionHandler(){

            @Override
            public void onOptionSelected() {
                if (!DevSupportManagerBase.this.mDevSettings.isJSDevModeEnabled() && DevSupportManagerBase.this.mDevSettings.isHotModuleReplacementEnabled()) {
                    Toast.makeText((Context)DevSupportManagerBase.this.mApplicationContext, (CharSequence)DevSupportManagerBase.this.mApplicationContext.getString(R.string.catalyst_hot_reloading_auto_disable), (int)1).show();
                    DevSupportManagerBase.this.mDevSettings.setHotModuleReplacementEnabled(false);
                }
                DevSupportManagerBase.this.handleReloadJS();
            }
        });
        if (this.mDevSettings.isDeviceDebugEnabled()) {
            boolean isConnected = this.mIsPackagerConnected;
            String debuggerItemString = this.mApplicationContext.getString(isConnected ? R.string.catalyst_debug_open : R.string.catalyst_debug_open_disabled);
            if (!isConnected) {
                disabledItemKeys.add(debuggerItemString);
            }
            options.put(debuggerItemString, () -> this.openDebugger());
        }
        options.put(this.mApplicationContext.getString(R.string.catalyst_change_bundle_location), () -> {
            Activity context = this.mReactInstanceDevHelper.getCurrentActivity();
            if (context == null || context.isFinishing()) {
                FLog.e((String)"ReactNative", (String)"Unable to launch change bundle location because react activity is not available");
                return;
            }
            final EditText input = new EditText((Context)context);
            input.setHint((CharSequence)"localhost:8081");
            AlertDialog bundleLocationDialog = new AlertDialog.Builder((Context)context).setTitle((CharSequence)this.mApplicationContext.getString(R.string.catalyst_change_bundle_location)).setView((View)input).setPositiveButton(17039370, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    String host = input.getText().toString();
                    DevSupportManagerBase.this.mDevSettings.getPackagerConnectionSettings().setDebugServerHost(host);
                    DevSupportManagerBase.this.handleReloadJS();
                }
            }).create();
            bundleLocationDialog.show();
        });
        options.put(this.mApplicationContext.getString(R.string.catalyst_inspector_toggle), new DevOptionHandler(){

            @Override
            public void onOptionSelected() {
                DevSupportManagerBase.this.mDevSettings.setElementInspectorEnabled(!DevSupportManagerBase.this.mDevSettings.isElementInspectorEnabled());
                DevSupportManagerBase.this.mReactInstanceDevHelper.toggleElementInspector();
            }
        });
        options.put(this.mDevSettings.isHotModuleReplacementEnabled() ? this.mApplicationContext.getString(R.string.catalyst_hot_reloading_stop) : this.mApplicationContext.getString(R.string.catalyst_hot_reloading), () -> {
            boolean nextEnabled = !this.mDevSettings.isHotModuleReplacementEnabled();
            this.mDevSettings.setHotModuleReplacementEnabled(nextEnabled);
            if (this.mCurrentReactContext != null) {
                if (nextEnabled) {
                    this.mCurrentReactContext.getJSModule(HMRClient.class).enable();
                } else {
                    this.mCurrentReactContext.getJSModule(HMRClient.class).disable();
                }
            }
            if (nextEnabled && !this.mDevSettings.isJSDevModeEnabled()) {
                Toast.makeText((Context)this.mApplicationContext, (CharSequence)this.mApplicationContext.getString(R.string.catalyst_hot_reloading_auto_enable), (int)1).show();
                this.mDevSettings.setJSDevModeEnabled(true);
                this.handleReloadJS();
            }
        });
        options.put(this.mDevSettings.isFpsDebugEnabled() ? this.mApplicationContext.getString(R.string.catalyst_perf_monitor_stop) : this.mApplicationContext.getString(R.string.catalyst_perf_monitor), () -> {
            if (!this.mDevSettings.isFpsDebugEnabled()) {
                Activity context = this.mReactInstanceDevHelper.getCurrentActivity();
                if (context == null) {
                    FLog.e((String)"ReactNative", (String)"Unable to get reference to react activity");
                } else {
                    DebugOverlayController.requestPermission((Context)context);
                }
            }
            this.mDevSettings.setFpsDebugEnabled(!this.mDevSettings.isFpsDebugEnabled());
        });
        options.put(this.mApplicationContext.getString(R.string.catalyst_settings), () -> {
            Intent intent = new Intent(this.mApplicationContext, DevSettingsActivity.class);
            intent.setFlags(0x10000000);
            this.mApplicationContext.startActivity(intent);
        });
        if (this.mCustomDevOptions.size() > 0) {
            options.putAll(this.mCustomDevOptions);
        }
        DevOptionHandler[] optionHandlers = options.values().toArray(new DevOptionHandler[0]);
        Activity context = this.mReactInstanceDevHelper.getCurrentActivity();
        if (context == null || context.isFinishing()) {
            FLog.e((String)"ReactNative", (String)"Unable to launch dev options menu because react activity isn't available");
            return;
        }
        LinearLayout header = new LinearLayout((Context)context);
        header.setOrientation(1);
        TextView title = new TextView((Context)context);
        title.setText((CharSequence)context.getString(R.string.catalyst_dev_menu_header, new Object[]{this.getUniqueTag()}));
        title.setPadding(0, 50, 0, 0);
        title.setGravity(17);
        title.setTextSize(16.0f);
        title.setTypeface(title.getTypeface(), 1);
        header.addView((View)title);
        String jsExecutorDescription = this.getJSExecutorDescription();
        if (jsExecutorDescription != null) {
            TextView jsExecutorLabel = new TextView((Context)context);
            jsExecutorLabel.setText((CharSequence)context.getString(R.string.catalyst_dev_menu_sub_header, new Object[]{jsExecutorDescription}));
            jsExecutorLabel.setPadding(0, 20, 0, 0);
            jsExecutorLabel.setGravity(17);
            jsExecutorLabel.setTextSize(14.0f);
            header.addView((View)jsExecutorLabel);
        }
        ArrayAdapter<String> adapter = new ArrayAdapter<String>((Context)context, 17367043, options.keySet().toArray(new String[0])){

            public boolean areAllItemsEnabled() {
                return false;
            }

            public boolean isEnabled(int position) {
                return !disabledItemKeys.contains(this.getItem(position));
            }

            public View getView(int position, @Nullable View convertView, ViewGroup parent) {
                View view = super.getView(position, convertView, parent);
                view.setEnabled(this.isEnabled(position));
                return view;
            }
        };
        this.mDevOptionsDialog = new AlertDialog.Builder((Context)context).setCustomTitle((View)header).setAdapter((ListAdapter)adapter, (dialog, which) -> {
            optionHandlers[which].onOptionSelected();
            this.mDevOptionsDialog = null;
        }).setOnCancelListener(dialog -> {
            this.mDevOptionsDialog = null;
        }).create();
        this.mDevOptionsDialog.show();
        if (this.mCurrentReactContext != null) {
            this.mCurrentReactContext.getJSModule(RCTNativeAppEventEmitter.class).emit("RCTDevMenuShown", null);
        }
    }

    private String getJSExecutorDescription() {
        try {
            return this.getReactInstanceDevHelper().getJavaScriptExecutorFactory().toString();
        }
        catch (IllegalStateException e) {
            return null;
        }
    }

    @Override
    public void setDevSupportEnabled(boolean isDevSupportEnabled) {
        this.mIsDevSupportEnabled = isDevSupportEnabled;
        this.reloadSettings();
    }

    @Override
    public boolean getDevSupportEnabled() {
        return this.mIsDevSupportEnabled;
    }

    @Override
    public DeveloperSettings getDevSettings() {
        return this.mDevSettings;
    }

    @Override
    @Nullable
    public RedBoxHandler getRedBoxHandler() {
        return this.mRedBoxHandler;
    }

    @Override
    public void onNewReactContextCreated(ReactContext reactContext) {
        this.resetCurrentContext(reactContext);
    }

    @Override
    public void onReactInstanceDestroyed(ReactContext reactContext) {
        if (reactContext == this.mCurrentReactContext) {
            this.resetCurrentContext(null);
        }
        System.gc();
    }

    @Override
    public String getSourceMapUrl() {
        if (this.mJSAppBundleName == null) {
            return "";
        }
        return this.mDevServerHelper.getSourceMapUrl((String)Assertions.assertNotNull((Object)this.mJSAppBundleName));
    }

    @Override
    public String getSourceUrl() {
        if (this.mJSAppBundleName == null) {
            return "";
        }
        return this.mDevServerHelper.getSourceUrl((String)Assertions.assertNotNull((Object)this.mJSAppBundleName));
    }

    @Override
    public String getDownloadedJSBundleFile() {
        return this.mJSBundleDownloadedFile.getAbsolutePath();
    }

    @Override
    public boolean hasUpToDateJSBundleInCache() {
        if (this.mIsDevSupportEnabled && this.mJSBundleDownloadedFile.exists()) {
            try {
                String packageName = this.mApplicationContext.getPackageName();
                PackageInfo thisPackage = this.mApplicationContext.getPackageManager().getPackageInfo(packageName, 0);
                if (this.mJSBundleDownloadedFile.lastModified() > thisPackage.lastUpdateTime) {
                    File exopackageDir = new File(String.format(Locale.US, EXOPACKAGE_LOCATION_FORMAT, packageName));
                    if (exopackageDir.exists()) {
                        return this.mJSBundleDownloadedFile.lastModified() > exopackageDir.lastModified();
                    }
                    return true;
                }
            }
            catch (PackageManager.NameNotFoundException e) {
                FLog.e((String)"ReactNative", (String)"DevSupport is unable to get current app info");
            }
        }
        return false;
    }

    private void resetCurrentContext(@Nullable ReactContext reactContext) {
        if (this.mCurrentReactContext == reactContext) {
            return;
        }
        this.mCurrentReactContext = reactContext;
        if (this.mDebugOverlayController != null) {
            this.mDebugOverlayController.setFpsDebugViewVisible(false);
        }
        if (reactContext != null) {
            this.mDebugOverlayController = new DebugOverlayController(reactContext);
        }
        if (this.mCurrentReactContext != null) {
            try {
                URL sourceUrl = new URL(this.getSourceUrl());
                String path = sourceUrl.getPath().substring(1);
                String host = sourceUrl.getHost();
                String scheme = sourceUrl.getProtocol();
                int port = sourceUrl.getPort() != -1 ? sourceUrl.getPort() : sourceUrl.getDefaultPort();
                this.mCurrentReactContext.getJSModule(HMRClient.class).setup("android", path, host, port, this.mDevSettings.isHotModuleReplacementEnabled(), scheme);
            }
            catch (MalformedURLException e) {
                this.showNewJavaError(e.getMessage(), e);
            }
        }
        this.reloadSettings();
    }

    @Override
    public void reloadSettings() {
        if (UiThreadUtil.isOnUiThread()) {
            this.reload();
        } else {
            UiThreadUtil.runOnUiThread(this::reload);
        }
    }

    @Override
    @Nullable
    public ReactContext getCurrentReactContext() {
        return this.mCurrentReactContext;
    }

    @Nullable
    public String getJSAppBundleName() {
        return this.mJSAppBundleName;
    }

    protected Context getApplicationContext() {
        return this.mApplicationContext;
    }

    public DevServerHelper getDevServerHelper() {
        return this.mDevServerHelper;
    }

    public DevLoadingViewManager getDevLoadingViewManager() {
        return this.mDevLoadingViewManager;
    }

    public ReactInstanceDevHelper getReactInstanceDevHelper() {
        return this.mReactInstanceDevHelper;
    }

    @UiThread
    private void showDevLoadingViewForUrl(String bundleUrl) {
        URL parsedURL;
        if (this.mApplicationContext == null) {
            return;
        }
        try {
            parsedURL = new URL(bundleUrl);
        }
        catch (MalformedURLException e) {
            FLog.e((String)"ReactNative", (String)("Bundle url format is invalid. \n\n" + e.toString()));
            return;
        }
        int port = parsedURL.getPort() != -1 ? parsedURL.getPort() : parsedURL.getDefaultPort();
        this.mDevLoadingViewManager.showMessage(this.mApplicationContext.getString(R.string.catalyst_loading_from_url, new Object[]{parsedURL.getHost() + ":" + port}));
        this.mDevLoadingViewVisible = true;
    }

    @UiThread
    protected void showDevLoadingViewForRemoteJSEnabled() {
        if (this.mApplicationContext == null) {
            return;
        }
        this.mDevLoadingViewManager.showMessage(this.mApplicationContext.getString(R.string.catalyst_debug_connecting));
        this.mDevLoadingViewVisible = true;
    }

    @UiThread
    protected void hideDevLoadingView() {
        this.mDevLoadingViewManager.hide();
        this.mDevLoadingViewVisible = false;
    }

    public void fetchSplitBundleAndCreateBundleLoader(String bundlePath, final CallbackWithBundleLoader callback) {
        final String bundleUrl = this.mDevServerHelper.getDevServerSplitBundleURL(bundlePath);
        final File bundleFile = new File(this.mJSSplitBundlesDir, bundlePath.replaceAll("/", "_") + ".jsbundle");
        UiThreadUtil.runOnUiThread(() -> {
            this.showSplitBundleDevLoadingView(bundleUrl);
            this.mDevServerHelper.downloadBundleFromURL(new DevBundleDownloadListener(){

                @Override
                public void onSuccess() {
                    UiThreadUtil.runOnUiThread(() -> DevSupportManagerBase.this.hideSplitBundleDevLoadingView());
                    ReactContext context = DevSupportManagerBase.this.mCurrentReactContext;
                    if (context == null || !context.hasActiveReactInstance()) {
                        return;
                    }
                    JSBundleLoader bundleLoader = JSBundleLoader.createCachedSplitBundleFromNetworkLoader(bundleUrl, bundleFile.getAbsolutePath());
                    callback.onSuccess(bundleLoader);
                }

                @Override
                public void onProgress(@Nullable String status, @Nullable Integer done, @Nullable Integer total) {
                    DevSupportManagerBase.this.mDevLoadingViewManager.updateProgress(status, done, total);
                }

                @Override
                public void onFailure(Exception cause) {
                    UiThreadUtil.runOnUiThread(DevSupportManagerBase.this::hideSplitBundleDevLoadingView);
                    callback.onError(bundleUrl, cause);
                }
            }, bundleFile, bundleUrl, null);
        });
    }

    @UiThread
    private void showSplitBundleDevLoadingView(String bundleUrl) {
        this.showDevLoadingViewForUrl(bundleUrl);
        ++this.mPendingJSSplitBundleRequests;
    }

    @UiThread
    private void hideSplitBundleDevLoadingView() {
        if (--this.mPendingJSSplitBundleRequests == 0) {
            this.hideDevLoadingView();
        }
    }

    @Override
    public void isPackagerRunning(PackagerStatusCallback callback) {
        Runnable checkPackagerRunning = () -> this.mDevServerHelper.isPackagerRunning(callback);
        if (this.mPackagerLocationCustomizer != null) {
            this.mPackagerLocationCustomizer.run(checkPackagerRunning);
        } else {
            checkPackagerRunning.run();
        }
    }

    @Override
    @Nullable
    public File downloadBundleResourceFromUrlSync(String resourceURL, File outputFile) {
        return this.mDevServerHelper.downloadBundleResourceFromUrlSync(resourceURL, outputFile);
    }

    @Override
    @Nullable
    public String getLastErrorTitle() {
        return this.mLastErrorTitle;
    }

    @Override
    @Nullable
    public StackFrame[] getLastErrorStack() {
        return this.mLastErrorStack;
    }

    @Override
    public int getLastErrorCookie() {
        return this.mLastErrorCookie;
    }

    @Override
    @Nullable
    public ErrorType getLastErrorType() {
        return this.mLastErrorType;
    }

    private void updateLastErrorInfo(@Nullable String message, StackFrame[] stack, int errorCookie, ErrorType errorType) {
        this.mLastErrorTitle = message;
        this.mLastErrorStack = stack;
        this.mLastErrorCookie = errorCookie;
        this.mLastErrorType = errorType;
    }

    @Override
    public void reloadJSFromServer(String bundleURL, final BundleLoadCallback callback) {
        ReactMarker.logMarker(ReactMarkerConstants.DOWNLOAD_START);
        this.showDevLoadingViewForUrl(bundleURL);
        final BundleDownloader.BundleInfo bundleInfo = new BundleDownloader.BundleInfo();
        this.mDevServerHelper.downloadBundleFromURL(new DevBundleDownloadListener(){

            @Override
            public void onSuccess() {
                DevSupportManagerBase.this.hideDevLoadingView();
                if (DevSupportManagerBase.this.mBundleDownloadListener != null) {
                    DevSupportManagerBase.this.mBundleDownloadListener.onSuccess();
                }
                ReactMarker.logMarker(ReactMarkerConstants.DOWNLOAD_END, bundleInfo.toJSONString());
                callback.onSuccess();
            }

            @Override
            public void onProgress(@Nullable String status, @Nullable Integer done, @Nullable Integer total) {
                DevSupportManagerBase.this.mDevLoadingViewManager.updateProgress(status, done, total);
                if (DevSupportManagerBase.this.mBundleDownloadListener != null) {
                    DevSupportManagerBase.this.mBundleDownloadListener.onProgress(status, done, total);
                }
            }

            @Override
            public void onFailure(Exception cause) {
                DevSupportManagerBase.this.hideDevLoadingView();
                if (DevSupportManagerBase.this.mBundleDownloadListener != null) {
                    DevSupportManagerBase.this.mBundleDownloadListener.onFailure(cause);
                }
                FLog.e((String)"ReactNative", (String)"Unable to download JS bundle", (Throwable)cause);
                DevSupportManagerBase.this.reportBundleLoadingFailure(cause);
                callback.onError(cause);
            }
        }, this.mJSBundleDownloadedFile, bundleURL, bundleInfo);
    }

    private void reportBundleLoadingFailure(Exception cause) {
        UiThreadUtil.runOnUiThread(() -> {
            if (cause instanceof DebugServerException) {
                DebugServerException debugServerException = (DebugServerException)cause;
                this.showNewJavaError(debugServerException.getMessage(), cause);
            } else {
                this.showNewJavaError(this.mApplicationContext.getString(R.string.catalyst_reload_error), cause);
            }
        });
    }

    @Override
    public void startInspector() {
        if (this.mIsDevSupportEnabled) {
            this.mDevServerHelper.openInspectorConnection();
        }
    }

    @Override
    public void stopInspector() {
        this.mDevServerHelper.closeInspectorConnection();
    }

    @Override
    public void setHotModuleReplacementEnabled(boolean isHotModuleReplacementEnabled) {
        if (!this.mIsDevSupportEnabled) {
            return;
        }
        UiThreadUtil.runOnUiThread(() -> {
            this.mDevSettings.setHotModuleReplacementEnabled(isHotModuleReplacementEnabled);
            this.handleReloadJS();
        });
    }

    @Override
    public void setFpsDebugEnabled(boolean isFpsDebugEnabled) {
        if (!this.mIsDevSupportEnabled) {
            return;
        }
        UiThreadUtil.runOnUiThread(() -> this.mDevSettings.setFpsDebugEnabled(isFpsDebugEnabled));
    }

    @Override
    public void toggleElementInspector() {
        if (!this.mIsDevSupportEnabled) {
            return;
        }
        UiThreadUtil.runOnUiThread(() -> {
            this.mDevSettings.setElementInspectorEnabled(!this.mDevSettings.isElementInspectorEnabled());
            this.mReactInstanceDevHelper.toggleElementInspector();
        });
    }

    private void reload() {
        UiThreadUtil.assertOnUiThread();
        if (this.mIsDevSupportEnabled) {
            if (this.mDebugOverlayController != null) {
                this.mDebugOverlayController.setFpsDebugViewVisible(this.mDevSettings.isFpsDebugEnabled());
            }
            if (!this.mIsShakeDetectorStarted) {
                this.mShakeDetector.start((SensorManager)this.mApplicationContext.getSystemService("sensor"));
                this.mIsShakeDetectorStarted = true;
            }
            if (!this.mIsReceiverRegistered) {
                IntentFilter filter = new IntentFilter();
                filter.addAction(DevSupportManagerBase.getReloadAppAction(this.mApplicationContext));
                this.compatRegisterReceiver(this.mApplicationContext, this.mReloadAppBroadcastReceiver, filter, true);
                this.mIsReceiverRegistered = true;
            }
            if (this.mDevLoadingViewVisible) {
                this.mDevLoadingViewManager.showMessage("Reloading...");
            }
            this.mDevServerHelper.openPackagerConnection(this.getClass().getSimpleName(), new DevServerHelper.PackagerCommandListener(){

                @Override
                public void onPackagerConnected() {
                    DevSupportManagerBase.this.mIsPackagerConnected = true;
                }

                @Override
                public void onPackagerDisconnected() {
                    DevSupportManagerBase.this.mIsPackagerConnected = false;
                }

                @Override
                public void onPackagerReloadCommand() {
                    if (!InspectorFlags.getFuseboxEnabled()) {
                        DevSupportManagerBase.this.mDevServerHelper.disableDebugger();
                    }
                    UiThreadUtil.runOnUiThread(() -> DevSupportManagerBase.this.handleReloadJS());
                }

                @Override
                public void onPackagerDevMenuCommand() {
                    UiThreadUtil.runOnUiThread(() -> DevSupportManagerBase.this.showDevOptionsDialog());
                }

                @Override
                @Nullable
                public Map<String, RequestHandler> customCommandHandlers() {
                    return DevSupportManagerBase.this.mCustomPackagerCommandHandlers;
                }
            });
        } else {
            if (this.mDebugOverlayController != null) {
                this.mDebugOverlayController.setFpsDebugViewVisible(false);
            }
            if (this.mIsShakeDetectorStarted) {
                this.mShakeDetector.stop();
                this.mIsShakeDetectorStarted = false;
            }
            if (this.mIsReceiverRegistered) {
                this.mApplicationContext.unregisterReceiver(this.mReloadAppBroadcastReceiver);
                this.mIsReceiverRegistered = false;
            }
            this.hideRedboxDialog();
            this.hideDevOptionsDialog();
            this.mDevLoadingViewManager.hide();
            this.mDevServerHelper.closePackagerConnection();
        }
    }

    private static String getReloadAppAction(Context context) {
        return context.getPackageName() + RELOAD_APP_ACTION_SUFFIX;
    }

    @Override
    public void setPackagerLocationCustomizer(DevSupportManager.PackagerLocationCustomizer packagerLocationCustomizer) {
        this.mPackagerLocationCustomizer = packagerLocationCustomizer;
    }

    @Override
    @Nullable
    public Activity getCurrentActivity() {
        return this.mReactInstanceDevHelper.getCurrentActivity();
    }

    @Override
    @Nullable
    public SurfaceDelegate createSurfaceDelegate(String moduleName) {
        if (this.mSurfaceDelegateFactory == null) {
            return null;
        }
        return this.mSurfaceDelegateFactory.createSurfaceDelegate(moduleName);
    }

    private void compatRegisterReceiver(Context context, BroadcastReceiver receiver, IntentFilter filter, boolean exported) {
        if (Build.VERSION.SDK_INT >= 34 && context.getApplicationInfo().targetSdkVersion >= 34) {
            context.registerReceiver(receiver, filter, exported ? 2 : 4);
        } else {
            context.registerReceiver(receiver, filter);
        }
    }

    @Override
    public void openDebugger() {
        this.mDevServerHelper.openDebugger(this.mCurrentReactContext, this.mApplicationContext.getString(R.string.catalyst_open_debugger_error));
    }

    @Override
    public void showPausedInDebuggerOverlay(String message, DevSupportManager.PausedInDebuggerOverlayCommandListener listener) {
        this.mPausedInDebuggerOverlayManager.showPausedInDebuggerOverlay(message, listener);
    }

    @Override
    public void hidePausedInDebuggerOverlay() {
        this.mPausedInDebuggerOverlayManager.hidePausedInDebuggerOverlay();
    }

    @Override
    public void setAdditionalOptionForPackager(String name, String value) {
        this.mDevSettings.getPackagerConnectionSettings().setAdditionalOptionForPackager(name, value);
    }

    public static interface CallbackWithBundleLoader {
        public void onSuccess(JSBundleLoader var1);

        public void onError(String var1, Throwable var2);
    }
}

