/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.common.futures;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0015\u0010\f\u001a\u00020\r2\b\u0010\u0007\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\u000eJ\u0012\u0010\u000f\u001a\u00020\r2\n\u0010\t\u001a\u00060\nj\u0002`\u000bJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J\b\u0010\u0013\u001a\u00020\u0011H\u0016J\b\u0010\u0014\u001a\u00020\u0011H\u0016J\u000f\u0010\u0015\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\u0016J \u0010\u0015\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0096\u0002\u00a2\u0006\u0002\u0010\u001bJ\r\u0010\u001c\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\u0016J\u001d\u0010\u001c\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\u0002\u0010\u001bJ\b\u0010\u001d\u001a\u00020\rH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u0004\u0018\u00018\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\bR\u0016\u0010\t\u001a\n\u0018\u00010\nj\u0004\u0018\u0001`\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/facebook/react/common/futures/SimpleSettableFuture;", "T", "Ljava/util/concurrent/Future;", "<init>", "()V", "readyLatch", "Ljava/util/concurrent/CountDownLatch;", "result", "Ljava/lang/Object;", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "set", "", "(Ljava/lang/Object;)V", "setException", "cancel", "", "mayInterruptIfRunning", "isCancelled", "isDone", "get", "()Ljava/lang/Object;", "timeout", "", "unit", "Ljava/util/concurrent/TimeUnit;", "(JLjava/util/concurrent/TimeUnit;)Ljava/lang/Object;", "getOrThrow", "checkNotSet", "ReactAndroid_debug"})
public final class SimpleSettableFuture<T>
implements Future<T> {
    @NotNull
    private final CountDownLatch readyLatch = new CountDownLatch(1);
    @Nullable
    private T result;
    @Nullable
    private Exception exception;

    public final void set(@Nullable T result) {
        this.checkNotSet();
        this.result = result;
        this.readyLatch.countDown();
    }

    public final void setException(@NotNull Exception exception) {
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        this.checkNotSet();
        this.exception = exception;
        this.readyLatch.countDown();
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return this.readyLatch.getCount() == 0L;
    }

    @Override
    @Nullable
    public T get() throws InterruptedException, ExecutionException {
        this.readyLatch.await();
        if (this.exception != null) {
            throw new ExecutionException(this.exception);
        }
        return this.result;
    }

    @Override
    @Nullable
    public T get(long timeout, @NotNull TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        if (!this.readyLatch.await(timeout, unit)) {
            throw new TimeoutException("Timed out waiting for result");
        }
        if (this.exception != null) {
            throw new ExecutionException(this.exception);
        }
        return this.result;
    }

    @Nullable
    public final T getOrThrow() {
        T t;
        try {
            t = this.get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        return t;
    }

    @Nullable
    public final T getOrThrow(long timeout, @NotNull TimeUnit unit) {
        T t;
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        try {
            t = this.get(timeout, unit);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        catch (TimeoutException e) {
            throw new RuntimeException(e);
        }
        return t;
    }

    private final void checkNotSet() {
        if (this.readyLatch.getCount() == 0L) {
            throw new RuntimeException("Result has already been set!");
        }
    }
}

