/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.devsupport;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.FrameLayout;
import androidx.core.graphics.Insets;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;
import com.facebook.common.logging.FLog;
import com.facebook.react.R;
import com.facebook.react.bridge.LifecycleEventListener;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.common.SurfaceDelegate;
import com.facebook.react.devsupport.DoubleTapReloadRecognizer;
import com.facebook.react.devsupport.RedBoxContentView;
import com.facebook.react.devsupport.RedBoxDialogSurfaceDelegate;
import com.facebook.react.devsupport.interfaces.DevSupportManager;
import com.facebook.react.devsupport.interfaces.RedBoxHandler;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0000\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\rH\u0016J\b\u0010\u0013\u001a\u00020\rH\u0016J\b\u0010\u0014\u001a\u00020\rH\u0016J\b\u0010\u0015\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/facebook/react/devsupport/RedBoxDialogSurfaceDelegate;", "Lcom/facebook/react/common/SurfaceDelegate;", "devSupportManager", "Lcom/facebook/react/devsupport/interfaces/DevSupportManager;", "<init>", "(Lcom/facebook/react/devsupport/interfaces/DevSupportManager;)V", "doubleTapReloadRecognizer", "Lcom/facebook/react/devsupport/DoubleTapReloadRecognizer;", "dialog", "Landroid/app/Dialog;", "redBoxContentView", "Lcom/facebook/react/devsupport/RedBoxContentView;", "createContentView", "", "appKey", "", "isContentViewReady", "", "destroyContentView", "show", "hide", "isShowing", "Companion", "ReactAndroid_release"})
@SourceDebugExtension(value={"SMAP\nRedBoxDialogSurfaceDelegate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RedBoxDialogSurfaceDelegate.kt\ncom/facebook/react/devsupport/RedBoxDialogSurfaceDelegate\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,160:1\n1#2:161\n*E\n"})
public final class RedBoxDialogSurfaceDelegate
implements SurfaceDelegate {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DevSupportManager devSupportManager;
    @NotNull
    private final DoubleTapReloadRecognizer doubleTapReloadRecognizer;
    @Nullable
    private Dialog dialog;
    @Nullable
    private RedBoxContentView redBoxContentView;

    public RedBoxDialogSurfaceDelegate(@NotNull DevSupportManager devSupportManager) {
        Intrinsics.checkNotNullParameter((Object)devSupportManager, (String)"devSupportManager");
        this.devSupportManager = devSupportManager;
        this.doubleTapReloadRecognizer = new DoubleTapReloadRecognizer();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void createContentView(@NotNull String appKey) {
        void it;
        RedBoxContentView redBoxContentView;
        Intrinsics.checkNotNullParameter((Object)appKey, (String)"appKey");
        RedBoxHandler redBoxHandler = this.devSupportManager.getRedBoxHandler();
        Activity context = this.devSupportManager.getCurrentActivity();
        if (context == null || context.isFinishing()) {
            String message = this.devSupportManager.getLastErrorTitle();
            String string2 = message;
            if (string2 == null) {
                string2 = "N/A";
            }
            FLog.e((String)"ReactNative", (String)("Unable to launch redbox because react activity is not available, here is the error that redbox would've displayed: " + string2));
            return;
        }
        RedBoxContentView redBoxContentView2 = redBoxContentView = new RedBoxContentView((Context)context, this.devSupportManager, redBoxHandler);
        RedBoxDialogSurfaceDelegate redBoxDialogSurfaceDelegate = this;
        boolean bl = false;
        it.init();
        redBoxDialogSurfaceDelegate.redBoxContentView = redBoxContentView;
    }

    @Override
    public boolean isContentViewReady() {
        return this.redBoxContentView != null;
    }

    @Override
    public void destroyContentView() {
        this.redBoxContentView = null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void show() {
        block7: {
            String message = this.devSupportManager.getLastErrorTitle();
            Activity context = this.devSupportManager.getCurrentActivity();
            if (context == null || context.isFinishing()) {
                ReactContext reactContext = this.devSupportManager.getCurrentReactContext();
                if (reactContext != null) {
                    ReactContext reactContext2 = reactContext;
                    boolean bl = false;
                    RedBoxDialogSurfaceDelegate.Companion.runAfterHostResume(reactContext2, () -> RedBoxDialogSurfaceDelegate.show$lambda$2$lambda$1(this));
                    return;
                }
                String string2 = message;
                if (string2 == null) {
                    string2 = "N/A";
                }
                FLog.e((String)"ReactNative", (String)("Unable to launch redbox because react activity and react context is not available, here is the error that redbox would've displayed: " + string2));
                return;
            }
            RedBoxContentView redBoxContentView = this.redBoxContentView;
            if ((redBoxContentView != null ? redBoxContentView.getContext() : null) != context) {
                this.createContentView("RedBox");
            }
            RedBoxContentView redBoxContentView2 = this.redBoxContentView;
            if (redBoxContentView2 != null) {
                redBoxContentView2.refreshContentView();
            }
            if (this.dialog == null) {
                void $this$show_u24lambda_u243;
                Dialog dialog;
                int n = R.style.Theme_Catalyst_RedBox;
                Dialog dialog2 = dialog = new Dialog(context, this, n){
                    final /* synthetic */ RedBoxDialogSurfaceDelegate this$0;
                    {
                        this.this$0 = $receiver;
                        super((Context)$context, $super_call_param$1);
                    }

                    public boolean onKeyUp(int keyCode, KeyEvent event) {
                        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                        if (keyCode == 82) {
                            RedBoxDialogSurfaceDelegate.access$getDevSupportManager$p(this.this$0).showDevOptionsDialog();
                            return true;
                        }
                        if (RedBoxDialogSurfaceDelegate.access$getDoubleTapReloadRecognizer$p(this.this$0).didDoubleTapR(keyCode, this.getCurrentFocus())) {
                            RedBoxDialogSurfaceDelegate.access$getDevSupportManager$p(this.this$0).handleReloadJS();
                        }
                        return super.onKeyUp(keyCode, event);
                    }

                    protected void onCreate(Bundle savedInstanceState) {
                        Window window = this.getWindow();
                        if (window == null) {
                            String string2 = "Required value was null.";
                            throw new IllegalStateException(string2.toString());
                        }
                        window.setBackgroundDrawable((Drawable)new ColorDrawable(-16777216));
                        int insetsType = WindowInsetsCompat.Type.systemBars() | WindowInsetsCompat.Type.displayCutout();
                        RedBoxContentView redBoxContentView = RedBoxDialogSurfaceDelegate.access$getRedBoxContentView$p(this.this$0);
                        if (redBoxContentView == null) {
                            String string3 = "Required value was null.";
                            throw new IllegalStateException(string3.toString());
                        }
                        ViewCompat.setOnApplyWindowInsetsListener((View)((View)redBoxContentView), (arg_0, arg_1) -> show.2.onCreate$lambda$0(insetsType, arg_0, arg_1));
                    }

                    private static final WindowInsetsCompat onCreate$lambda$0(int $insetsType, View view, WindowInsetsCompat windowInsetsCompat) {
                        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
                        Intrinsics.checkNotNullParameter((Object)windowInsetsCompat, (String)"windowInsetsCompat");
                        Insets insets = windowInsetsCompat.getInsets($insetsType);
                        Intrinsics.checkNotNullExpressionValue((Object)insets, (String)"getInsets(...)");
                        Insets insets2 = insets;
                        ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
                        Intrinsics.checkNotNull((Object)layoutParams, (String)"null cannot be cast to non-null type android.widget.FrameLayout.LayoutParams");
                        FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)layoutParams;
                        lp.setMargins(insets2.left, insets2.top, insets2.right, insets2.bottom);
                        return WindowInsetsCompat.CONSUMED;
                    }
                };
                RedBoxDialogSurfaceDelegate redBoxDialogSurfaceDelegate = this;
                boolean bl = false;
                $this$show_u24lambda_u243.requestWindowFeature(1);
                RedBoxContentView redBoxContentView3 = this.redBoxContentView;
                if (redBoxContentView3 == null) {
                    String string3 = "Required value was null.";
                    throw new IllegalStateException(string3.toString());
                }
                $this$show_u24lambda_u243.setContentView((View)redBoxContentView3);
                redBoxDialogSurfaceDelegate.dialog = dialog;
            }
            Dialog dialog = this.dialog;
            if (dialog == null) break block7;
            dialog.show();
        }
    }

    @Override
    public void hide() {
        try {
            Dialog dialog = this.dialog;
            if (dialog != null) {
                dialog.dismiss();
            }
        }
        catch (IllegalArgumentException e) {
            FLog.e((String)"ReactNative", (String)"RedBoxDialogSurfaceDelegate: error while dismissing dialog: ", (Throwable)e);
        }
        this.destroyContentView();
        this.dialog = null;
    }

    @Override
    public boolean isShowing() {
        Dialog dialog = this.dialog;
        return dialog != null ? dialog.isShowing() : false;
    }

    private static final void show$lambda$2$lambda$1(RedBoxDialogSurfaceDelegate this$0) {
        this$0.show();
    }

    public static final /* synthetic */ DevSupportManager access$getDevSupportManager$p(RedBoxDialogSurfaceDelegate $this) {
        return $this.devSupportManager;
    }

    public static final /* synthetic */ DoubleTapReloadRecognizer access$getDoubleTapReloadRecognizer$p(RedBoxDialogSurfaceDelegate $this) {
        return $this.doubleTapReloadRecognizer;
    }

    public static final /* synthetic */ RedBoxContentView access$getRedBoxContentView$p(RedBoxDialogSurfaceDelegate $this) {
        return $this.redBoxContentView;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\n"}, d2={"Lcom/facebook/react/devsupport/RedBoxDialogSurfaceDelegate$Companion;", "", "<init>", "()V", "runAfterHostResume", "", "reactContext", "Lcom/facebook/react/bridge/ReactContext;", "runnable", "Ljava/lang/Runnable;", "ReactAndroid_release"})
    public static final class Companion {
        private Companion() {
        }

        private final void runAfterHostResume(ReactContext reactContext, Runnable runnable) {
            reactContext.addLifecycleEventListener(new LifecycleEventListener(runnable, reactContext){
                final /* synthetic */ Runnable $runnable;
                final /* synthetic */ ReactContext $reactContext;
                {
                    this.$runnable = $runnable;
                    this.$reactContext = $reactContext;
                }

                public void onHostResume() {
                    this.$runnable.run();
                    this.$reactContext.removeLifecycleEventListener(this);
                }

                public void onHostPause() {
                }

                public void onHostDestroy() {
                }
            });
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

