/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.text.internal.span;

import android.text.SpannableStringBuilder;
import com.facebook.common.logging.FLog;
import com.facebook.react.views.text.internal.span.ReactSpan;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/facebook/react/views/text/internal/span/SetSpanOperation;", "", "start", "", "end", "what", "Lcom/facebook/react/views/text/internal/span/ReactSpan;", "<init>", "(IILcom/facebook/react/views/text/internal/span/ReactSpan;)V", "execute", "", "builder", "Landroid/text/SpannableStringBuilder;", "priorityIndex", "Companion", "ReactAndroid_release"})
public final class SetSpanOperation {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int start;
    private final int end;
    @JvmField
    @NotNull
    public final ReactSpan what;
    @NotNull
    private static final String TAG = "SetSpanOperation";
    public static final int SPAN_MAX_PRIORITY = 255;

    public SetSpanOperation(int start, int end, @NotNull ReactSpan what) {
        Intrinsics.checkNotNullParameter((Object)what, (String)"what");
        this.start = start;
        this.end = end;
        this.what = what;
    }

    public final void execute(@NotNull SpannableStringBuilder builder, int priorityIndex) {
        int priority;
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        if (!(priorityIndex >= 0)) {
            String string2 = "Check failed.";
            throw new IllegalStateException(string2.toString());
        }
        int spanFlags = 34;
        if (this.start == 0) {
            spanFlags = 18;
        }
        if ((priority = 255 - priorityIndex) < 0) {
            FLog.w((String)TAG, (String)"Text tree size exceeded the limit, styling may become unpredictable");
        }
        int effectivePriority = Math.max(priority, 0);
        spanFlags &= 0xFF00FFFF;
        builder.setSpan((Object)this.what, this.start, this.end, spanFlags |= effectivePriority << 16 & 0xFF0000);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/facebook/react/views/text/internal/span/SetSpanOperation$Companion;", "", "<init>", "()V", "TAG", "", "SPAN_MAX_PRIORITY", "", "ReactAndroid_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

