/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.dialog;

import android.annotation.SuppressLint;
import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.TypedArray;
import android.os.Build;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.appcompat.R;
import androidx.appcompat.app.AlertDialog;
import androidx.core.view.AccessibilityDelegateCompat;
import androidx.core.view.ViewCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import androidx.fragment.app.DialogFragment;
import com.facebook.infer.annotation.Assertions;
import com.facebook.infer.annotation.Nullsafe;
import com.facebook.react.R;
import com.facebook.react.modules.dialog.DialogModule;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
public class AlertFragment
extends DialogFragment
implements DialogInterface.OnClickListener {
    static final String ARG_TITLE = "title";
    static final String ARG_MESSAGE = "message";
    static final String ARG_BUTTON_POSITIVE = "button_positive";
    static final String ARG_BUTTON_NEGATIVE = "button_negative";
    static final String ARG_BUTTON_NEUTRAL = "button_neutral";
    static final String ARG_ITEMS = "items";
    @Nullable
    private final DialogModule.AlertFragmentListener mListener;

    public AlertFragment() {
        this.mListener = null;
    }

    @SuppressLint(value={"ValidFragment"})
    public AlertFragment(@Nullable DialogModule.AlertFragmentListener listener, Bundle arguments) {
        this.mListener = listener;
        this.setArguments(arguments);
    }

    public static Dialog createDialog(Context activityContext, Bundle arguments, DialogInterface.OnClickListener fragment) {
        if (AlertFragment.isAppCompatTheme(activityContext)) {
            return AlertFragment.createAppCompatDialog(activityContext, arguments, fragment);
        }
        return AlertFragment.createAppDialog(activityContext, arguments, fragment);
    }

    private static boolean isAppCompatTheme(Context activityContext) {
        TypedArray attributes = activityContext.obtainStyledAttributes(R.styleable.AppCompatTheme);
        boolean isAppCompat = attributes.hasValue(R.styleable.AppCompatTheme_windowActionBar);
        attributes.recycle();
        return isAppCompat;
    }

    private static View getAccessibleTitle(Context activityContext, String titleText) {
        LayoutInflater inflater = LayoutInflater.from((Context)activityContext);
        View titleContainer = inflater.inflate(R.layout.alert_title_layout, null);
        final TextView accessibleTitle = (TextView)Assertions.assertNotNull((Object)((TextView)titleContainer.findViewById(R.id.alert_title)));
        accessibleTitle.setText((CharSequence)titleText);
        accessibleTitle.setFocusable(true);
        if (Build.VERSION.SDK_INT >= 28) {
            accessibleTitle.setAccessibilityHeading(true);
        } else {
            ViewCompat.setAccessibilityDelegate((View)accessibleTitle, (AccessibilityDelegateCompat)new AccessibilityDelegateCompat(){

                public void onInitializeAccessibilityNodeInfo(View view, AccessibilityNodeInfoCompat info) {
                    super.onInitializeAccessibilityNodeInfo((View)accessibleTitle, info);
                    info.setHeading(true);
                }
            });
        }
        return titleContainer;
    }

    private static Dialog createAppCompatDialog(Context activityContext, Bundle arguments, DialogInterface.OnClickListener fragment) {
        AlertDialog.Builder builder = new AlertDialog.Builder(activityContext);
        if (arguments.containsKey(ARG_TITLE)) {
            String title = (String)Assertions.assertNotNull((Object)arguments.getString(ARG_TITLE));
            View accessibleTitle = AlertFragment.getAccessibleTitle(activityContext, title);
            builder.setCustomTitle(accessibleTitle);
        }
        if (arguments.containsKey(ARG_BUTTON_POSITIVE)) {
            builder.setPositiveButton((CharSequence)arguments.getString(ARG_BUTTON_POSITIVE), fragment);
        }
        if (arguments.containsKey(ARG_BUTTON_NEGATIVE)) {
            builder.setNegativeButton((CharSequence)arguments.getString(ARG_BUTTON_NEGATIVE), fragment);
        }
        if (arguments.containsKey(ARG_BUTTON_NEUTRAL)) {
            builder.setNeutralButton((CharSequence)arguments.getString(ARG_BUTTON_NEUTRAL), fragment);
        }
        if (arguments.containsKey(ARG_MESSAGE)) {
            builder.setMessage((CharSequence)arguments.getString(ARG_MESSAGE));
        }
        if (arguments.containsKey(ARG_ITEMS)) {
            builder.setItems(arguments.getCharSequenceArray(ARG_ITEMS), fragment);
        }
        return builder.create();
    }

    @Deprecated(since="0.75.0", forRemoval=true)
    private static Dialog createAppDialog(Context activityContext, Bundle arguments, DialogInterface.OnClickListener fragment) {
        AlertDialog.Builder builder = new AlertDialog.Builder(activityContext);
        if (arguments.containsKey(ARG_TITLE)) {
            String title = (String)Assertions.assertNotNull((Object)arguments.getString(ARG_TITLE));
            View accessibleTitle = AlertFragment.getAccessibleTitle(activityContext, title);
            builder.setCustomTitle(accessibleTitle);
        }
        if (arguments.containsKey(ARG_BUTTON_POSITIVE)) {
            builder.setPositiveButton((CharSequence)arguments.getString(ARG_BUTTON_POSITIVE), fragment);
        }
        if (arguments.containsKey(ARG_BUTTON_NEGATIVE)) {
            builder.setNegativeButton((CharSequence)arguments.getString(ARG_BUTTON_NEGATIVE), fragment);
        }
        if (arguments.containsKey(ARG_BUTTON_NEUTRAL)) {
            builder.setNeutralButton((CharSequence)arguments.getString(ARG_BUTTON_NEUTRAL), fragment);
        }
        if (arguments.containsKey(ARG_MESSAGE)) {
            builder.setMessage((CharSequence)arguments.getString(ARG_MESSAGE));
        }
        if (arguments.containsKey(ARG_ITEMS)) {
            builder.setItems(arguments.getCharSequenceArray(ARG_ITEMS), fragment);
        }
        return builder.create();
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        return AlertFragment.createDialog((Context)this.requireActivity(), this.requireArguments(), this);
    }

    public void onClick(DialogInterface dialog, int which) {
        if (this.mListener != null) {
            this.mListener.onClick(dialog, which);
        }
    }

    public void onDismiss(DialogInterface dialog) {
        super.onDismiss(dialog);
        if (this.mListener != null) {
            this.mListener.onDismiss(dialog);
        }
    }
}

