/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.shell;

import android.annotation.SuppressLint;
import com.facebook.imagepipeline.core.ImagePipelineConfig;
import com.facebook.react.BaseReactPackage;
import com.facebook.react.ViewManagerOnDemandReactPackage;
import com.facebook.react.animated.NativeAnimatedModule;
import com.facebook.react.bridge.ModuleSpec;
import com.facebook.react.bridge.NativeModule;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.common.ClassFinder;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.module.model.ReactModuleInfo;
import com.facebook.react.module.model.ReactModuleInfoProvider;
import com.facebook.react.modules.accessibilityinfo.AccessibilityInfoModule;
import com.facebook.react.modules.appearance.AppearanceModule;
import com.facebook.react.modules.appstate.AppStateModule;
import com.facebook.react.modules.blob.BlobModule;
import com.facebook.react.modules.blob.FileReaderModule;
import com.facebook.react.modules.camera.ImageStoreManager;
import com.facebook.react.modules.clipboard.ClipboardModule;
import com.facebook.react.modules.devloading.DevLoadingModule;
import com.facebook.react.modules.devtoolsruntimesettings.ReactDevToolsRuntimeSettingsModule;
import com.facebook.react.modules.dialog.DialogModule;
import com.facebook.react.modules.fresco.FrescoModule;
import com.facebook.react.modules.i18nmanager.I18nManagerModule;
import com.facebook.react.modules.image.ImageLoaderModule;
import com.facebook.react.modules.intent.IntentModule;
import com.facebook.react.modules.network.NetworkingModule;
import com.facebook.react.modules.permissions.PermissionsModule;
import com.facebook.react.modules.reactdevtoolssettings.ReactDevToolsSettingsManagerModule;
import com.facebook.react.modules.share.ShareModule;
import com.facebook.react.modules.sound.SoundManagerModule;
import com.facebook.react.modules.statusbar.StatusBarModule;
import com.facebook.react.modules.toast.ToastModule;
import com.facebook.react.modules.vibration.VibrationModule;
import com.facebook.react.modules.websocket.WebSocketModule;
import com.facebook.react.shell.MainPackageConfig;
import com.facebook.react.uimanager.ViewManager;
import com.facebook.react.views.drawer.ReactDrawerLayoutManager;
import com.facebook.react.views.image.ReactImageManager;
import com.facebook.react.views.modal.ReactModalHostManager;
import com.facebook.react.views.progressbar.ReactProgressBarViewManager;
import com.facebook.react.views.safeareaview.ReactSafeAreaViewManager;
import com.facebook.react.views.scroll.ReactHorizontalScrollContainerViewManager;
import com.facebook.react.views.scroll.ReactHorizontalScrollViewManager;
import com.facebook.react.views.scroll.ReactScrollViewManager;
import com.facebook.react.views.swiperefresh.SwipeRefreshLayoutManager;
import com.facebook.react.views.switchview.ReactSwitchManager;
import com.facebook.react.views.text.ReactRawTextManager;
import com.facebook.react.views.text.ReactTextViewManager;
import com.facebook.react.views.text.ReactVirtualTextViewManager;
import com.facebook.react.views.text.frescosupport.FrescoBasedReactTextInlineImageViewManager;
import com.facebook.react.views.textinput.ReactTextInputManager;
import com.facebook.react.views.unimplementedview.ReactUnimplementedViewManager;
import com.facebook.react.views.view.ReactViewManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Provider;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\b\u0007\u0012\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001e\u0010\r\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000f0\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\n0\u00172\u0006\u0010\u000b\u001a\u00020\fH\u0016J\"\u0010\u0018\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u000f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\nH\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001bH\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00120\u00118\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001d"}, d2={"Lcom/facebook/react/shell/MainReactPackage;", "Lcom/facebook/react/BaseReactPackage;", "Lcom/facebook/react/ViewManagerOnDemandReactPackage;", "config", "Lcom/facebook/react/shell/MainPackageConfig;", "<init>", "(Lcom/facebook/react/shell/MainPackageConfig;)V", "getModule", "Lcom/facebook/react/bridge/NativeModule;", "name", "", "reactContext", "Lcom/facebook/react/bridge/ReactApplicationContext;", "createViewManagers", "", "Lcom/facebook/react/uimanager/ViewManager;", "viewManagersMap", "", "Lcom/facebook/react/bridge/ModuleSpec;", "getViewManagersMap", "()Ljava/util/Map;", "getViewManagers", "getViewManagerNames", "", "createViewManager", "viewManagerName", "getReactModuleInfoProvider", "Lcom/facebook/react/module/model/ReactModuleInfoProvider;", "fallbackForMissingClass", "ReactAndroid_release"})
@SourceDebugExtension(value={"SMAP\nMainReactPackage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MainReactPackage.kt\ncom/facebook/react/shell/MainReactPackage\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,273:1\n3829#2:274\n4344#2,2:275\n1187#3,2:277\n1261#3,4:279\n*S KotlinDebug\n*F\n+ 1 MainReactPackage.kt\ncom/facebook/react/shell/MainReactPackage\n*L\n258#1:274\n258#1:275,2\n259#1:277,2\n259#1:279,4\n*E\n"})
public final class MainReactPackage
extends BaseReactPackage
implements ViewManagerOnDemandReactPackage {
    @Nullable
    private final MainPackageConfig config;
    @SuppressLint(value={"VisibleForTests"})
    @NotNull
    private final Map<String, ModuleSpec> viewManagersMap;

    @JvmOverloads
    public MainReactPackage(@Nullable MainPackageConfig config) {
        this.config = config;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"AndroidDrawerLayout", (Object)ModuleSpec.viewManagerSpec((Provider<? extends NativeModule>)((Provider)MainReactPackage::viewManagersMap$lambda$0))), TuplesKt.to((Object)"AndroidHorizontalScrollView", (Object)ModuleSpec.viewManagerSpec((Provider<? extends NativeModule>)((Provider)MainReactPackage::viewManagersMap$lambda$1))), TuplesKt.to((Object)"AndroidHorizontalScrollContentView", (Object)ModuleSpec.viewManagerSpec((Provider<? extends NativeModule>)((Provider)MainReactPackage::viewManagersMap$lambda$2))), TuplesKt.to((Object)"AndroidProgressBar", (Object)ModuleSpec.viewManagerSpec((Provider<? extends NativeModule>)((Provider)MainReactPackage::viewManagersMap$lambda$3))), TuplesKt.to((Object)"RCTSafeAreaView", (Object)ModuleSpec.viewManagerSpec((Provider<? extends NativeModule>)((Provider)MainReactPackage::viewManagersMap$lambda$4))), TuplesKt.to((Object)"RCTScrollView", (Object)ModuleSpec.viewManagerSpec((Provider<? extends NativeModule>)((Provider)MainReactPackage::viewManagersMap$lambda$5))), TuplesKt.to((Object)"AndroidSwitch", (Object)ModuleSpec.viewManagerSpec((Provider<? extends NativeModule>)((Provider)MainReactPackage::viewManagersMap$lambda$6))), TuplesKt.to((Object)"AndroidSwipeRefreshLayout", (Object)ModuleSpec.viewManagerSpec((Provider<? extends NativeModule>)((Provider)MainReactPackage::viewManagersMap$lambda$7))), TuplesKt.to((Object)"RCTTextInlineImage", (Object)ModuleSpec.viewManagerSpec((Provider<? extends NativeModule>)((Provider)MainReactPackage::viewManagersMap$lambda$8))), TuplesKt.to((Object)"RCTImageView", (Object)ModuleSpec.viewManagerSpec((Provider<? extends NativeModule>)((Provider)MainReactPackage::viewManagersMap$lambda$9))), TuplesKt.to((Object)"RCTModalHostView", (Object)ModuleSpec.viewManagerSpec((Provider<? extends NativeModule>)((Provider)MainReactPackage::viewManagersMap$lambda$10))), TuplesKt.to((Object)"RCTRawText", (Object)ModuleSpec.viewManagerSpec((Provider<? extends NativeModule>)((Provider)MainReactPackage::viewManagersMap$lambda$11))), TuplesKt.to((Object)"AndroidTextInput", (Object)ModuleSpec.viewManagerSpec((Provider<? extends NativeModule>)((Provider)MainReactPackage::viewManagersMap$lambda$12))), TuplesKt.to((Object)"RCTText", (Object)ModuleSpec.viewManagerSpec((Provider<? extends NativeModule>)((Provider)MainReactPackage::viewManagersMap$lambda$13))), TuplesKt.to((Object)"RCTView", (Object)ModuleSpec.viewManagerSpec((Provider<? extends NativeModule>)((Provider)MainReactPackage::viewManagersMap$lambda$14))), TuplesKt.to((Object)"RCTVirtualText", (Object)ModuleSpec.viewManagerSpec((Provider<? extends NativeModule>)((Provider)MainReactPackage::viewManagersMap$lambda$15))), TuplesKt.to((Object)"UnimplementedNativeView", (Object)ModuleSpec.viewManagerSpec((Provider<? extends NativeModule>)((Provider)MainReactPackage::viewManagersMap$lambda$16)))};
        this.viewManagersMap = MapsKt.mapOf((Pair[])pairArray);
    }

    public /* synthetic */ MainReactPackage(MainPackageConfig mainPackageConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            mainPackageConfig = null;
        }
        this(mainPackageConfig);
    }

    @Override
    @Nullable
    public NativeModule getModule(@NotNull String name, @NotNull ReactApplicationContext reactContext) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)((Object)reactContext), (String)"reactContext");
        return switch (name) {
            case "AccessibilityInfo" -> new AccessibilityInfoModule(reactContext);
            case "Appearance" -> new AppearanceModule(reactContext, null, 2, null);
            case "AppState" -> new AppStateModule(reactContext);
            case "BlobModule" -> new BlobModule(reactContext);
            case "DevLoadingView" -> new DevLoadingModule(reactContext);
            case "FileReaderModule" -> new FileReaderModule(reactContext);
            case "Clipboard" -> new ClipboardModule(reactContext);
            case "DialogManagerAndroid" -> new DialogModule(reactContext);
            case "FrescoModule" -> {
                MainPackageConfig v1 = this.config;
                yield new FrescoModule(reactContext, true, (ImagePipelineConfig)(v1 != null ? v1.getFrescoConfig() : null));
            }
            case "I18nManager" -> new I18nManagerModule(reactContext);
            case "ImageLoader" -> new ImageLoaderModule(reactContext);
            case "ImageStoreManager" -> new ImageStoreManager(reactContext);
            case "IntentAndroid" -> new IntentModule(reactContext);
            case "NativeAnimatedModule" -> new NativeAnimatedModule(reactContext);
            case "Networking" -> new NetworkingModule(reactContext);
            case "PermissionsAndroid" -> new PermissionsModule(reactContext);
            case "ShareModule" -> new ShareModule(reactContext);
            case "StatusBarManager" -> new StatusBarModule(reactContext);
            case "SoundManager" -> new SoundManagerModule(reactContext);
            case "ToastAndroid" -> new ToastModule(reactContext);
            case "Vibration" -> new VibrationModule(reactContext);
            case "WebSocketModule" -> new WebSocketModule(reactContext);
            case "ReactDevToolsSettingsManager" -> new ReactDevToolsSettingsManagerModule(reactContext);
            case "ReactDevToolsRuntimeSettingsModule" -> new ReactDevToolsRuntimeSettingsModule(reactContext);
            default -> null;
        };
    }

    @NotNull
    public List<ViewManager<?, ?>> createViewManagers(@NotNull ReactApplicationContext reactContext) {
        Intrinsics.checkNotNullParameter((Object)((Object)reactContext), (String)"reactContext");
        Object[] objectArray = new ViewManager[]{new ReactDrawerLayoutManager(), new ReactHorizontalScrollViewManager(), new ReactHorizontalScrollContainerViewManager(), new ReactProgressBarViewManager(), new ReactScrollViewManager(), new ReactSwitchManager(), new ReactSafeAreaViewManager(), new SwipeRefreshLayoutManager(), new FrescoBasedReactTextInlineImageViewManager(null, null, 3, null), new ReactImageManager(null, null, null, 7, null), new ReactModalHostManager(), new ReactRawTextManager(), new ReactTextInputManager(), new ReactTextViewManager(), new ReactViewManager(), new ReactVirtualTextViewManager(), new ReactUnimplementedViewManager()};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public final Map<String, ModuleSpec> getViewManagersMap() {
        return this.viewManagersMap;
    }

    @Override
    @NotNull
    public List<ModuleSpec> getViewManagers(@NotNull ReactApplicationContext reactContext) {
        Intrinsics.checkNotNullParameter((Object)((Object)reactContext), (String)"reactContext");
        return CollectionsKt.toList((Iterable)this.viewManagersMap.values());
    }

    @Override
    @NotNull
    public Collection<String> getViewManagerNames(@NotNull ReactApplicationContext reactContext) {
        Intrinsics.checkNotNullParameter((Object)((Object)reactContext), (String)"reactContext");
        return this.viewManagersMap.keySet();
    }

    @Override
    @Nullable
    public ViewManager<?, ?> createViewManager(@NotNull ReactApplicationContext reactContext, @NotNull String viewManagerName) {
        Intrinsics.checkNotNullParameter((Object)((Object)reactContext), (String)"reactContext");
        Intrinsics.checkNotNullParameter((Object)viewManagerName, (String)"viewManagerName");
        Provider<? extends NativeModule> spec = this.viewManagersMap.get(viewManagerName);
        Provider<? extends NativeModule> provider = spec;
        NativeModule nativeModule = provider != null && (provider = provider.getProvider()) != null ? (NativeModule)provider.get() : null;
        return nativeModule instanceof ViewManager ? (ViewManager)nativeModule : null;
    }

    @Override
    @NotNull
    public ReactModuleInfoProvider getReactModuleInfoProvider() {
        if (!ClassFinder.canLoadClassesFromAnnotationProcessors()) {
            return this.fallbackForMissingClass();
        }
        try {
            Class<?> reactModuleInfoProviderClass;
            Class<?> clazz = reactModuleInfoProviderClass = ClassFinder.findClass("com.facebook.react.shell.MainReactPackage$$ReactModuleInfoProvider");
            Object obj = clazz != null ? clazz.newInstance() : null;
            ReactModuleInfoProvider reactModuleInfoProvider = obj instanceof ReactModuleInfoProvider ? (ReactModuleInfoProvider)obj : null;
            if (reactModuleInfoProvider == null) {
                reactModuleInfoProvider = this.fallbackForMissingClass();
            }
            return reactModuleInfoProvider;
        }
        catch (ClassNotFoundException e) {
            return this.fallbackForMissingClass();
        }
        catch (InstantiationException e) {
            throw new RuntimeException("No ReactModuleInfoProvider for MainReactPackage$$ReactModuleInfoProvider", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("No ReactModuleInfoProvider for MainReactPackage$$ReactModuleInfoProvider", e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final ReactModuleInfoProvider fallbackForMissingClass() {
        void $this$associateTo$iv$iv;
        void $this$filterTo$iv$iv;
        Class[] moduleList;
        Class[] classArray = new Class[]{AccessibilityInfoModule.class, AppearanceModule.class, AppStateModule.class, BlobModule.class, DevLoadingModule.class, FileReaderModule.class, ClipboardModule.class, DialogModule.class, FrescoModule.class, I18nManagerModule.class, ImageLoaderModule.class, ImageStoreManager.class, IntentModule.class, NativeAnimatedModule.class, NetworkingModule.class, PermissionsModule.class, ReactDevToolsSettingsManagerModule.class, ReactDevToolsRuntimeSettingsModule.class, ShareModule.class, StatusBarModule.class, SoundManagerModule.class, ToastModule.class, VibrationModule.class, WebSocketModule.class};
        Class[] $this$filter$iv = moduleList = classArray;
        boolean $i$f$filter = false;
        Class[] classArray2 = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            void it = element$iv$iv;
            boolean bl = false;
            if (!it.isAnnotationPresent(ReactModule.class)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$associate$iv = (List)destination$iv$iv;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            ReactModule reactModule;
            Map map = destination$iv$iv2;
            Class moduleClass = (Class)element$iv$iv;
            boolean bl = false;
            if (moduleClass.getAnnotation(ReactModule.class) == null) {
                String string2 = "Required value was null.";
                throw new IllegalStateException(string2.toString());
            }
            String string3 = reactModule.name();
            String string4 = reactModule.name();
            String string5 = moduleClass.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getName(...)");
            Pair pair = TuplesKt.to((Object)string3, (Object)new ReactModuleInfo(string4, string5, reactModule.canOverrideExistingModule(), reactModule.needsEagerInit(), reactModule.isCxxModule(), ReactModuleInfo.Companion.classIsTurboModule(moduleClass)));
            map.put(pair.getFirst(), pair.getSecond());
        }
        Map moduleMap = destination$iv$iv2;
        return () -> MainReactPackage.fallbackForMissingClass$lambda$19(moduleMap);
    }

    @JvmOverloads
    public MainReactPackage() {
        this(null, 1, null);
    }

    private static final NativeModule viewManagersMap$lambda$0() {
        return new ReactDrawerLayoutManager();
    }

    private static final NativeModule viewManagersMap$lambda$1() {
        return new ReactHorizontalScrollViewManager();
    }

    private static final NativeModule viewManagersMap$lambda$2() {
        return new ReactHorizontalScrollContainerViewManager();
    }

    private static final NativeModule viewManagersMap$lambda$3() {
        return new ReactProgressBarViewManager();
    }

    private static final NativeModule viewManagersMap$lambda$4() {
        return new ReactSafeAreaViewManager();
    }

    private static final NativeModule viewManagersMap$lambda$5() {
        return new ReactScrollViewManager();
    }

    private static final NativeModule viewManagersMap$lambda$6() {
        return new ReactSwitchManager();
    }

    private static final NativeModule viewManagersMap$lambda$7() {
        return new SwipeRefreshLayoutManager();
    }

    private static final NativeModule viewManagersMap$lambda$8() {
        return new FrescoBasedReactTextInlineImageViewManager(null, null, 3, null);
    }

    private static final NativeModule viewManagersMap$lambda$9() {
        return new ReactImageManager(null, null, null, 7, null);
    }

    private static final NativeModule viewManagersMap$lambda$10() {
        return new ReactModalHostManager();
    }

    private static final NativeModule viewManagersMap$lambda$11() {
        return new ReactRawTextManager();
    }

    private static final NativeModule viewManagersMap$lambda$12() {
        return new ReactTextInputManager();
    }

    private static final NativeModule viewManagersMap$lambda$13() {
        return new ReactTextViewManager();
    }

    private static final NativeModule viewManagersMap$lambda$14() {
        return new ReactViewManager();
    }

    private static final NativeModule viewManagersMap$lambda$15() {
        return new ReactVirtualTextViewManager();
    }

    private static final NativeModule viewManagersMap$lambda$16() {
        return new ReactUnimplementedViewManager();
    }

    private static final Map fallbackForMissingClass$lambda$19(Map $moduleMap) {
        return $moduleMap;
    }
}

