/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.i18nmanager;

import android.content.Context;
import com.facebook.fbreact.specs.NativeI18nManagerSpec;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.modules.i18nmanager.I18nUtil;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ReactModule(name="I18nManager")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007H\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u0011"}, d2={"Lcom/facebook/react/modules/i18nmanager/I18nManagerModule;", "Lcom/facebook/fbreact/specs/NativeI18nManagerSpec;", "context", "Lcom/facebook/react/bridge/ReactApplicationContext;", "<init>", "(Lcom/facebook/react/bridge/ReactApplicationContext;)V", "getTypedExportedConstants", "", "", "", "allowRTL", "", "value", "", "forceRTL", "swapLeftAndRightInRTL", "Companion", "ReactAndroid_release"})
public final class I18nManagerModule
extends NativeI18nManagerSpec {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NAME = "I18nManager";

    public I18nManagerModule(@Nullable ReactApplicationContext context) {
        super(context);
    }

    @Override
    @NotNull
    public Map<String, Object> getTypedExportedConstants() {
        ReactApplicationContext context = this.getReactApplicationContext();
        Locale locale = context.getResources().getConfiguration().getLocales().get(0);
        Pair[] pairArray = new Pair[3];
        I18nUtil i18nUtil = I18nUtil.Companion.getInstance();
        Intrinsics.checkNotNull((Object)((Object)context));
        pairArray[0] = TuplesKt.to((Object)"isRTL", (Object)i18nUtil.isRTL((Context)context));
        pairArray[1] = TuplesKt.to((Object)"doLeftAndRightSwapInRTL", (Object)I18nUtil.Companion.getInstance().doLeftAndRightSwapInRTL((Context)context));
        pairArray[2] = TuplesKt.to((Object)"localeIdentifier", (Object)locale.toString());
        return MapsKt.mapOf((Pair[])pairArray);
    }

    @Override
    public void allowRTL(boolean value) {
        I18nUtil i18nUtil = I18nUtil.Companion.getInstance();
        ReactApplicationContext reactApplicationContext = this.getReactApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)reactApplicationContext), (String)"getReactApplicationContext(...)");
        i18nUtil.allowRTL((Context)reactApplicationContext, value);
    }

    @Override
    public void forceRTL(boolean value) {
        I18nUtil i18nUtil = I18nUtil.Companion.getInstance();
        ReactApplicationContext reactApplicationContext = this.getReactApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)reactApplicationContext), (String)"getReactApplicationContext(...)");
        i18nUtil.forceRTL((Context)reactApplicationContext, value);
    }

    @Override
    public void swapLeftAndRightInRTL(boolean value) {
        I18nUtil i18nUtil = I18nUtil.Companion.getInstance();
        ReactApplicationContext reactApplicationContext = this.getReactApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)reactApplicationContext), (String)"getReactApplicationContext(...)");
        i18nUtil.swapLeftAndRightInRTL((Context)reactApplicationContext, value);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/facebook/react/modules/i18nmanager/I18nManagerModule$Companion;", "", "<init>", "()V", "NAME", "", "ReactAndroid_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

