/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.devsupport;

import com.facebook.common.logging.FLog;
import com.facebook.react.devsupport.interfaces.PackagerStatusCallback;
import java.io.IOException;
import java.util.Arrays;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \r2\u00020\u0001:\u0001\rB\t\b\u0016\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0002\u0010\u0006J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/facebook/react/devsupport/PackagerStatusCheck;", "", "<init>", "()V", "client", "Lokhttp3/OkHttpClient;", "(Lokhttp3/OkHttpClient;)V", "run", "", "host", "", "callback", "Lcom/facebook/react/devsupport/interfaces/PackagerStatusCallback;", "Companion", "ReactAndroid_release"})
public final class PackagerStatusCheck {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final OkHttpClient client;
    @NotNull
    private static final String PACKAGER_OK_STATUS = "packager-status:running";
    private static final int HTTP_CONNECT_TIMEOUT_MS = 5000;
    @NotNull
    private static final String PACKAGER_STATUS_URL_TEMPLATE = "http://%s/status";

    public PackagerStatusCheck() {
        this.client = new OkHttpClient.Builder().connectTimeout(5000L, TimeUnit.MILLISECONDS).readTimeout(0L, TimeUnit.MILLISECONDS).writeTimeout(0L, TimeUnit.MILLISECONDS).build();
    }

    public PackagerStatusCheck(@NotNull OkHttpClient client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        this.client = client;
    }

    public final void run(@NotNull String host, @NotNull PackagerStatusCallback callback) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        String statusURL = PackagerStatusCheck.Companion.createPackagerStatusURL(host);
        Request request = new Request.Builder().url(statusURL).build();
        this.client.newCall(request).enqueue(new Callback(callback){
            final /* synthetic */ PackagerStatusCallback $callback;
            {
                this.$callback = $callback;
            }

            public void onFailure(Call call, IOException e) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                FLog.w((String)"ReactNative", (String)("The packager does not seem to be running as we got an IOException requesting its status: " + e.getMessage()));
                this.$callback.onPackagerStatusFetched(false);
            }

            public void onResponse(Call call, Response response) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                if (!response.isSuccessful()) {
                    FLog.e((String)"ReactNative", (String)("Got non-success http code from packager when requesting status: " + response.-deprecated_code()));
                    this.$callback.onPackagerStatusFetched(false);
                    return;
                }
                ResponseBody body = response.-deprecated_body();
                if (body == null) {
                    FLog.e((String)"ReactNative", (String)"Got null body response from packager when requesting status");
                    this.$callback.onPackagerStatusFetched(false);
                    return;
                }
                String bodyString = body.string();
                if (!Intrinsics.areEqual((Object)"packager-status:running", (Object)bodyString)) {
                    FLog.e((String)"ReactNative", (String)("Got unexpected response from packager when requesting status: " + bodyString));
                    this.$callback.onPackagerStatusFetched(false);
                    return;
                }
                this.$callback.onPackagerStatusFetched(true);
            }
        });
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/facebook/react/devsupport/PackagerStatusCheck$Companion;", "", "<init>", "()V", "PACKAGER_OK_STATUS", "", "HTTP_CONNECT_TIMEOUT_MS", "", "PACKAGER_STATUS_URL_TEMPLATE", "createPackagerStatusURL", "host", "ReactAndroid_release"})
    private static final class Companion {
        private Companion() {
        }

        private final String createPackagerStatusURL(String host) {
            Locale locale = Locale.US;
            String string2 = PackagerStatusCheck.PACKAGER_STATUS_URL_TEMPLATE;
            Object[] objectArray = new Object[]{host};
            String string3 = String.format(locale, string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
            return string3;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

