/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.packagerconnection;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import com.facebook.common.logging.FLog;
import com.facebook.react.modules.systeminfo.AndroidInfoHelpers;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0004\b\u0016\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u000f\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\t8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0010\u0010\u000b\"\u0004\b\u0011\u0010\u0012R\u001d\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001c"}, d2={"Lcom/facebook/react/packagerconnection/PackagerConnectionSettings;", "", "appContext", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "preferences", "Landroid/content/SharedPreferences;", "packageName", "", "getPackageName", "()Ljava/lang/String;", "_additionalOptionsForPackager", "", "host", "debugServerHost", "getDebugServerHost", "setDebugServerHost", "(Ljava/lang/String;)V", "setAdditionalOptionForPackager", "", "key", "value", "additionalOptionsForPackager", "", "getAdditionalOptionsForPackager", "()Ljava/util/Map;", "Companion", "ReactAndroid_debug"})
public class PackagerConnectionSettings {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Context appContext;
    @NotNull
    private final SharedPreferences preferences;
    @NotNull
    private final String packageName;
    @NotNull
    private final Map<String, String> _additionalOptionsForPackager;
    private static final String TAG = PackagerConnectionSettings.class.getSimpleName();
    @NotNull
    private static final String PREFS_DEBUG_SERVER_HOST_KEY = "debug_http_host";

    public PackagerConnectionSettings(@NotNull Context appContext) {
        Intrinsics.checkNotNullParameter((Object)appContext, (String)"appContext");
        this.appContext = appContext;
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)this.appContext);
        Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"getDefaultSharedPreferences(...)");
        this.preferences = sharedPreferences;
        String string2 = this.appContext.getPackageName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPackageName(...)");
        this.packageName = string2;
        this._additionalOptionsForPackager = new LinkedHashMap();
    }

    @NotNull
    public final String getPackageName() {
        return this.packageName;
    }

    @NotNull
    public String getDebugServerHost() {
        String hostFromSettings;
        String string2 = hostFromSettings = this.preferences.getString(PREFS_DEBUG_SERVER_HOST_KEY, null);
        boolean bl = string2 != null ? ((CharSequence)string2).length() > 0 : false;
        if (bl) {
            return hostFromSettings;
        }
        String host = AndroidInfoHelpers.getServerHost(this.appContext);
        if (Intrinsics.areEqual((Object)host, (Object)"localhost")) {
            FLog.w((String)TAG, (String)("You seem to be running on device. Run '" + AndroidInfoHelpers.getAdbReverseTcpCommand(this.appContext) + "' to forward the debug server's port to the device."));
        }
        return host;
    }

    public void setDebugServerHost(@NotNull String host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        this.preferences.edit().putString(PREFS_DEBUG_SERVER_HOST_KEY, host).apply();
    }

    public final void setAdditionalOptionForPackager(@NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this._additionalOptionsForPackager.put(key, value);
    }

    @NotNull
    public final Map<String, String> getAdditionalOptionsForPackager() {
        return this._additionalOptionsForPackager;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/facebook/react/packagerconnection/PackagerConnectionSettings$Companion;", "", "<init>", "()V", "TAG", "", "kotlin.jvm.PlatformType", "Ljava/lang/String;", "PREFS_DEBUG_SERVER_HOST_KEY", "ReactAndroid_debug"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

