/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.switchview;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.RippleDrawable;
import androidx.appcompat.widget.SwitchCompat;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007H\u0016J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\tH\u0016J\u001d\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0010\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\u0014J\u0015\u0010\u0015\u001a\u00020\r2\b\u0010\u0010\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\u0016J\u0015\u0010\u0017\u001a\u00020\r2\b\u0010\u0010\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\u0016J\u000e\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u0007J\u0015\u0010\u001a\u001a\u00020\r2\b\u0010\u0010\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\u0016J\u0015\u0010\u001b\u001a\u00020\r2\b\u0010\u0010\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\u0016J\u0010\u0010\u0015\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007H\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0010\u001a\u00020\tH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\nR\u0012\u0010\u000b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\n\u00a8\u0006\u001e"}, d2={"Lcom/facebook/react/views/switchview/ReactSwitch;", "Landroidx/appcompat/widget/SwitchCompat;", "context", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "allowChange", "", "trackColorForFalse", "", "Ljava/lang/Integer;", "trackColorForTrue", "setChecked", "", "checked", "setBackgroundColor", "color", "setColor", "drawable", "Landroid/graphics/drawable/Drawable;", "(Landroid/graphics/drawable/Drawable;Ljava/lang/Integer;)V", "setTrackColor", "(Ljava/lang/Integer;)V", "setThumbColor", "setOn", "on", "setTrackColorForTrue", "setTrackColorForFalse", "createRippleDrawableColorStateList", "Landroid/content/res/ColorStateList;", "ReactAndroid_release"})
public final class ReactSwitch
extends SwitchCompat {
    private boolean allowChange;
    @Nullable
    private Integer trackColorForFalse;
    @Nullable
    private Integer trackColorForTrue;

    public ReactSwitch(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.allowChange = true;
    }

    public void setChecked(boolean checked) {
        if (this.allowChange && this.isChecked() != checked) {
            this.allowChange = false;
            super.setChecked(checked);
            this.setTrackColor(checked);
        } else {
            super.setChecked(this.isChecked());
        }
    }

    public void setBackgroundColor(int color) {
        this.setBackground((Drawable)new RippleDrawable(this.createRippleDrawableColorStateList(color), (Drawable)new ColorDrawable(color), null));
    }

    public final void setColor(@NotNull Drawable drawable, @Nullable Integer color) {
        Intrinsics.checkNotNullParameter((Object)drawable, (String)"drawable");
        if (color == null) {
            drawable.clearColorFilter();
        } else {
            drawable.setColorFilter((ColorFilter)new PorterDuffColorFilter(color.intValue(), PorterDuff.Mode.MULTIPLY));
        }
    }

    public final void setTrackColor(@Nullable Integer color) {
        Drawable drawable = super.getTrackDrawable();
        Intrinsics.checkNotNullExpressionValue((Object)drawable, (String)"getTrackDrawable(...)");
        this.setColor(drawable, color);
    }

    public final void setThumbColor(@Nullable Integer color) {
        Drawable drawable = super.getThumbDrawable();
        Intrinsics.checkNotNullExpressionValue((Object)drawable, (String)"getThumbDrawable(...)");
        this.setColor(drawable, color);
        if (color != null && super.getBackground() instanceof RippleDrawable) {
            ColorStateList customColorState = this.createRippleDrawableColorStateList(color);
            Drawable drawable2 = super.getBackground();
            Intrinsics.checkNotNull((Object)drawable2, (String)"null cannot be cast to non-null type android.graphics.drawable.RippleDrawable");
            ((RippleDrawable)drawable2).setColor(customColorState);
        }
    }

    public final void setOn(boolean on) {
        if (this.isChecked() != on) {
            super.setChecked(on);
            this.setTrackColor(on);
        }
        this.allowChange = true;
    }

    public final void setTrackColorForTrue(@Nullable Integer color) {
        if (Intrinsics.areEqual((Object)color, (Object)this.trackColorForTrue)) {
            return;
        }
        this.trackColorForTrue = color;
        if (this.isChecked()) {
            this.setTrackColor(this.trackColorForTrue);
        }
    }

    public final void setTrackColorForFalse(@Nullable Integer color) {
        if (Intrinsics.areEqual((Object)color, (Object)this.trackColorForFalse)) {
            return;
        }
        this.trackColorForFalse = color;
        if (!this.isChecked()) {
            this.setTrackColor(this.trackColorForFalse);
        }
    }

    private final void setTrackColor(boolean checked) {
        if (this.trackColorForTrue != null || this.trackColorForFalse != null) {
            Integer currentTrackColor = checked ? this.trackColorForTrue : this.trackColorForFalse;
            this.setTrackColor(currentTrackColor);
        }
    }

    private final ColorStateList createRippleDrawableColorStateList(int color) {
        Object object = new int[1][];
        int[] nArray = new int[]{16842919};
        object[0] = nArray;
        int[][] nArrayArray = object;
        object = new int[1];
        object[0] = (int[])color;
        return new ColorStateList((int[][])nArrayArray, (int[])object);
    }
}

