/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.drawer;

import android.annotation.SuppressLint;
import android.content.Context;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import androidx.core.view.AccessibilityDelegateCompat;
import androidx.core.view.ViewCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import androidx.drawerlayout.widget.DrawerLayout;
import com.facebook.common.logging.FLog;
import com.facebook.react.R;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.uimanager.ReactAccessibilityDelegate;
import com.facebook.react.uimanager.events.NativeGestureUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\r\u0010\n\u001a\u00020\u000bH\u0001\u00a2\u0006\u0002\b\fJ\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\r\u0010\u0011\u001a\u00020\u000bH\u0001\u00a2\u0006\u0002\b\u0012J\u0015\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\u0015J\r\u0010\u0016\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\u0017J\u0015\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\u001aR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/facebook/react/views/drawer/ReactDrawerLayout;", "Landroidx/drawerlayout/widget/DrawerLayout;", "reactContext", "Lcom/facebook/react/bridge/ReactContext;", "(Lcom/facebook/react/bridge/ReactContext;)V", "dragging", "", "drawerPosition", "", "drawerWidth", "closeDrawer", "", "closeDrawer$ReactAndroid_debug", "onInterceptTouchEvent", "ev", "Landroid/view/MotionEvent;", "onTouchEvent", "openDrawer", "openDrawer$ReactAndroid_debug", "setDrawerPosition", "newDrawerPosition", "setDrawerPosition$ReactAndroid_debug", "setDrawerProperties", "setDrawerProperties$ReactAndroid_debug", "setDrawerWidth", "drawerWidthInPx", "setDrawerWidth$ReactAndroid_debug", "Companion", "ReactAndroid_debug"})
public final class ReactDrawerLayout
extends DrawerLayout {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int drawerPosition;
    private int drawerWidth;
    private boolean dragging;
    public static final int DEFAULT_DRAWER_WIDTH = -1;

    public ReactDrawerLayout(@NotNull ReactContext reactContext) {
        Intrinsics.checkNotNullParameter((Object)((Object)reactContext), (String)"reactContext");
        super((Context)reactContext);
        this.drawerPosition = 0x800003;
        this.drawerWidth = -1;
        ViewCompat.setAccessibilityDelegate((View)((View)this), (AccessibilityDelegateCompat)new AccessibilityDelegateCompat(){

            public void onInitializeAccessibilityNodeInfo(@NotNull View host, @NotNull AccessibilityNodeInfoCompat info) {
                Intrinsics.checkNotNullParameter((Object)host, (String)"host");
                Intrinsics.checkNotNullParameter((Object)info, (String)"info");
                super.onInitializeAccessibilityNodeInfo(host, info);
                ReactAccessibilityDelegate.AccessibilityRole accessibilityRole = ReactAccessibilityDelegate.AccessibilityRole.fromViewTag(host);
                if (accessibilityRole != null) {
                    info.setClassName((CharSequence)ReactAccessibilityDelegate.AccessibilityRole.getValue(accessibilityRole));
                }
            }

            public void onInitializeAccessibilityEvent(@NotNull View host, @NotNull AccessibilityEvent event) {
                Intrinsics.checkNotNullParameter((Object)host, (String)"host");
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                super.onInitializeAccessibilityEvent(host, event);
                Object accessibilityRole = host.getTag(R.id.accessibility_role);
                if (accessibilityRole instanceof ReactAccessibilityDelegate.AccessibilityRole) {
                    event.setClassName((CharSequence)ReactAccessibilityDelegate.AccessibilityRole.getValue((ReactAccessibilityDelegate.AccessibilityRole)((Object)accessibilityRole)));
                }
            }
        });
    }

    public boolean onInterceptTouchEvent(@NotNull MotionEvent ev) {
        Intrinsics.checkNotNullParameter((Object)ev, (String)"ev");
        try {
            if (super.onInterceptTouchEvent(ev)) {
                NativeGestureUtil.notifyNativeGestureStarted((View)this, ev);
                this.dragging = true;
                return true;
            }
        }
        catch (IllegalArgumentException e) {
            FLog.w((String)"ReactNative", (String)"Error intercepting touch event.", (Throwable)e);
        }
        return false;
    }

    public boolean onTouchEvent(@NotNull MotionEvent ev) {
        Intrinsics.checkNotNullParameter((Object)ev, (String)"ev");
        int action = ev.getActionMasked();
        if (action == 1 && this.dragging) {
            NativeGestureUtil.notifyNativeGestureEnded((View)this, ev);
            this.dragging = false;
        }
        return super.onTouchEvent(ev);
    }

    @SuppressLint(value={"WrongConstant"})
    public final void openDrawer$ReactAndroid_debug() {
        this.openDrawer(this.drawerPosition);
    }

    @SuppressLint(value={"WrongConstant"})
    public final void closeDrawer$ReactAndroid_debug() {
        this.closeDrawer(this.drawerPosition);
    }

    public final void setDrawerPosition$ReactAndroid_debug(int newDrawerPosition) {
        this.drawerPosition = newDrawerPosition;
        this.setDrawerProperties$ReactAndroid_debug();
    }

    public final void setDrawerWidth$ReactAndroid_debug(int drawerWidthInPx) {
        this.drawerWidth = drawerWidthInPx;
        this.setDrawerProperties$ReactAndroid_debug();
    }

    public final void setDrawerProperties$ReactAndroid_debug() {
        if (this.getChildCount() == 2) {
            View drawerView = this.getChildAt(1);
            ViewGroup.LayoutParams layoutParams = drawerView.getLayoutParams();
            Intrinsics.checkNotNull((Object)layoutParams, (String)"null cannot be cast to non-null type androidx.drawerlayout.widget.DrawerLayout.LayoutParams");
            DrawerLayout.LayoutParams layoutParams2 = (DrawerLayout.LayoutParams)layoutParams;
            layoutParams2.gravity = this.drawerPosition;
            layoutParams2.width = this.drawerWidth;
            drawerView.setLayoutParams((ViewGroup.LayoutParams)layoutParams2);
            drawerView.setClickable(true);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/facebook/react/views/drawer/ReactDrawerLayout$Companion;", "", "()V", "DEFAULT_DRAWER_WIDTH", "", "ReactAndroid_debug"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

