/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.imagehelper;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import androidx.core.content.res.ResourcesCompat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.concurrent.ThreadSafe;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0002J\u0006\u0010\u000b\u001a\u00020\fJ\u001a\u0010\r\u001a\u0004\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0005H\u0002J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\b\u001a\u00020\t2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0005J\u0018\u0010\u0011\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0005J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\t2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0005J\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0005R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/facebook/react/views/imagehelper/ResourceDrawableIdHelper;", "", "()V", "resourceDrawableIdMap", "", "", "", "addDrawableId", "context", "Landroid/content/Context;", "normalizedName", "clear", "", "getOpeningXmlTag", "name", "getResourceDrawable", "Landroid/graphics/drawable/Drawable;", "getResourceDrawableId", "getResourceDrawableUri", "Landroid/net/Uri;", "isVectorDrawable", "", "Companion", "ReactAndroid_debug"})
@ThreadSafe
@SourceDebugExtension(value={"SMAP\nResourceDrawableIdHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResourceDrawableIdHelper.kt\ncom/facebook/react/views/imagehelper/ResourceDrawableIdHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,117:1\n1#2:118\n*E\n"})
public final class ResourceDrawableIdHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, Integer> resourceDrawableIdMap = new HashMap();
    @NotNull
    private static final String LOCAL_RESOURCE_SCHEME = "res";
    @NotNull
    private static final ResourceDrawableIdHelper resourceDrawableIdHelper = new ResourceDrawableIdHelper();

    private ResourceDrawableIdHelper() {
    }

    public final synchronized void clear() {
        this.resourceDrawableIdMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getResourceDrawableId(@NotNull Context context, @Nullable String name) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        CharSequence charSequence = name;
        if (charSequence == null || charSequence.length() == 0) {
            return 0;
        }
        String string2 = name.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        String normalizedName = StringsKt.replace$default((String)string2, (String)"-", (String)"_", (boolean)false, (int)4, null);
        try {
            return Integer.parseInt(normalizedName);
        }
        catch (NumberFormatException numberFormatException) {
            ResourceDrawableIdHelper resourceDrawableIdHelper = this;
            synchronized (resourceDrawableIdHelper) {
                boolean bl = false;
                Integer n = this.resourceDrawableIdMap.get(normalizedName);
                int n2 = n != null ? n.intValue() : this.addDrawableId(context, normalizedName);
                return n2;
            }
        }
    }

    private final int addDrawableId(Context context, String normalizedName) {
        int newId = context.getResources().getIdentifier(normalizedName, "drawable", context.getPackageName());
        Integer n = newId;
        this.resourceDrawableIdMap.put(normalizedName, n);
        return newId;
    }

    @Nullable
    public final Drawable getResourceDrawable(@NotNull Context context, @Nullable String name) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        int resId = this.getResourceDrawableId(context, name);
        return resId > 0 ? ResourcesCompat.getDrawable((Resources)context.getResources(), (int)resId, null) : null;
    }

    @NotNull
    public final Uri getResourceDrawableUri(@NotNull Context context, @Nullable String name) {
        Uri uri;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        int resId = this.getResourceDrawableId(context, name);
        if (resId > 0) {
            Uri uri2 = new Uri.Builder().scheme(LOCAL_RESOURCE_SCHEME).path(String.valueOf(resId)).build();
            Intrinsics.checkNotNull((Object)uri2);
            uri = uri2;
        } else {
            Uri uri3 = Uri.EMPTY;
            Intrinsics.checkNotNull((Object)uri3);
            uri = uri3;
        }
        return uri;
    }

    public final boolean isVectorDrawable(@NotNull Context context, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return Intrinsics.areEqual((Object)this.getOpeningXmlTag(context, name), (Object)"vector");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String getOpeningXmlTag(Context context, String name) {
        String string2;
        Object object = this.getResourceDrawableId(context, name);
        int it = ((Number)object).intValue();
        boolean bl = false;
        Object object2 = it > 0 ? object : null;
        if (object2 == null) {
            return null;
        }
        int resId = (Integer)object2;
        try {
            String string3;
            XmlResourceParser xmlResourceParser = context.getResources().getXml(resId);
            Intrinsics.checkNotNullExpressionValue((Object)xmlResourceParser, (String)"getXml(...)");
            XmlResourceParser xmlParser = xmlResourceParser;
            object = (AutoCloseable)xmlParser;
            Throwable throwable = null;
            try {
                XmlResourceParser it2 = (XmlResourceParser)object;
                boolean bl2 = false;
                String parentTag = null;
                int eventType = xmlParser.getEventType();
                while (eventType != 1) {
                    if (eventType == 2) {
                        parentTag = xmlParser.getName();
                        break;
                    }
                    eventType = xmlParser.next();
                }
                string3 = parentTag;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable);
            }
            string2 = string3;
        }
        catch (Resources.NotFoundException e) {
            string2 = null;
        }
        return string2;
    }

    @NotNull
    public static final ResourceDrawableIdHelper getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\r\u0010\b\u001a\u00020\u0006H\u0007\u00a2\u0006\u0002\b\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u00068FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0007\u0010\u0002\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/facebook/react/views/imagehelper/ResourceDrawableIdHelper$Companion;", "", "()V", "LOCAL_RESOURCE_SCHEME", "", "instance", "Lcom/facebook/react/views/imagehelper/ResourceDrawableIdHelper;", "getInstance$annotations", "getInstance", "()Lcom/facebook/react/views/imagehelper/ResourceDrawableIdHelper;", "resourceDrawableIdHelper", "DEPRECATED$getInstance", "ReactAndroid_debug"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ResourceDrawableIdHelper getInstance() {
            return resourceDrawableIdHelper;
        }

        @JvmStatic
        public static /* synthetic */ void getInstance$annotations() {
        }

        @Deprecated(message="Use .instance instead, this API is for backward compat", replaceWith=@ReplaceWith(expression="instance", imports={}))
        @JvmName(name="DEPRECATED$getInstance")
        @NotNull
        public final ResourceDrawableIdHelper DEPRECATED$getInstance() {
            return this.getInstance();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

