/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.defaults;

import android.app.Application;
import android.content.Context;
import com.facebook.react.JSEngineResolutionAlgorithm;
import com.facebook.react.ReactHost;
import com.facebook.react.ReactNativeHost;
import com.facebook.react.ReactPackage;
import com.facebook.react.ReactPackageTurboModuleManagerDelegate;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.UIManager;
import com.facebook.react.bridge.UIManagerProvider;
import com.facebook.react.common.annotations.UnstableReactNativeAPI;
import com.facebook.react.defaults.DefaultComponentsRegistry;
import com.facebook.react.defaults.DefaultReactHost;
import com.facebook.react.defaults.DefaultTurboModuleManagerDelegate;
import com.facebook.react.fabric.ComponentFactory;
import com.facebook.react.fabric.FabricUIManagerProviderImpl;
import com.facebook.react.fabric.ReactNativeConfig;
import com.facebook.react.uimanager.ViewManager;
import com.facebook.react.uimanager.ViewManagerRegistry;
import com.facebook.react.uimanager.ViewManagerResolver;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u000f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\n\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0014J\n\u0010\f\u001a\u0004\u0018\u00010\rH\u0014J\n\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0014J\u0015\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0001\u00a2\u0006\u0002\b\u0014R\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u00068TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00068TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0015"}, d2={"Lcom/facebook/react/defaults/DefaultReactNativeHost;", "Lcom/facebook/react/ReactNativeHost;", "application", "Landroid/app/Application;", "(Landroid/app/Application;)V", "isHermesEnabled", "", "()Ljava/lang/Boolean;", "isNewArchEnabled", "()Z", "getJSEngineResolutionAlgorithm", "Lcom/facebook/react/JSEngineResolutionAlgorithm;", "getReactPackageTurboModuleManagerDelegateBuilder", "Lcom/facebook/react/ReactPackageTurboModuleManagerDelegate$Builder;", "getUIManagerProvider", "Lcom/facebook/react/bridge/UIManagerProvider;", "toReactHost", "Lcom/facebook/react/ReactHost;", "context", "Landroid/content/Context;", "toReactHost$ReactAndroid_release", "ReactAndroid_release"})
public abstract class DefaultReactNativeHost
extends ReactNativeHost {
    protected DefaultReactNativeHost(@NotNull Application application) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        super(application);
    }

    @Override
    @Nullable
    protected ReactPackageTurboModuleManagerDelegate.Builder getReactPackageTurboModuleManagerDelegateBuilder() {
        return this.isNewArchEnabled() ? (ReactPackageTurboModuleManagerDelegate.Builder)new DefaultTurboModuleManagerDelegate.Builder() : null;
    }

    @Override
    @Nullable
    protected UIManagerProvider getUIManagerProvider() {
        return this.isNewArchEnabled() ? arg_0 -> DefaultReactNativeHost.getUIManagerProvider$lambda$0(this, arg_0) : null;
    }

    @Override
    @Nullable
    protected JSEngineResolutionAlgorithm getJSEngineResolutionAlgorithm() {
        JSEngineResolutionAlgorithm jSEngineResolutionAlgorithm;
        Boolean bl = this.isHermesEnabled();
        if (Intrinsics.areEqual((Object)bl, (Object)true)) {
            jSEngineResolutionAlgorithm = JSEngineResolutionAlgorithm.HERMES;
        } else if (Intrinsics.areEqual((Object)bl, (Object)false)) {
            jSEngineResolutionAlgorithm = JSEngineResolutionAlgorithm.JSC;
        } else if (bl == null) {
            jSEngineResolutionAlgorithm = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return jSEngineResolutionAlgorithm;
    }

    protected boolean isNewArchEnabled() {
        return false;
    }

    @Nullable
    protected Boolean isHermesEnabled() {
        return null;
    }

    @UnstableReactNativeAPI
    @NotNull
    public final ReactHost toReactHost$ReactAndroid_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        List<ReactPackage> list = this.getPackages();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getPackages(...)");
        String string = this.getJSMainModuleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getJSMainModuleName(...)");
        String string2 = this.getBundleAssetName();
        if (string2 == null) {
            string2 = "index";
        }
        Boolean bl = this.isHermesEnabled();
        return DefaultReactHost.getDefaultReactHost$default(context, list, string, string2, this.getJSBundleFile(), bl != null ? bl : true, this.getUseDeveloperSupport(), null, 128, null);
    }

    private static final UIManager getUIManagerProvider$lambda$0(DefaultReactNativeHost this$0, ReactApplicationContext reactApplicationContext) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)((Object)reactApplicationContext), (String)"reactApplicationContext");
        ComponentFactory componentFactory = new ComponentFactory();
        DefaultComponentsRegistry.register(componentFactory);
        ViewManagerRegistry viewManagerRegistry2 = this$0.getLazyViewManagersEnabled() ? new ViewManagerRegistry(new ViewManagerResolver(this$0){
            final /* synthetic */ DefaultReactNativeHost this$0;
            {
                this.this$0 = $receiver;
            }

            @Nullable
            public ViewManager getViewManager(@NotNull String viewManagerName) {
                Intrinsics.checkNotNullParameter((Object)viewManagerName, (String)"viewManagerName");
                return this.this$0.getReactInstanceManager().createViewManager(viewManagerName);
            }

            public Collection<String> getViewManagerNames() {
                return this.this$0.getReactInstanceManager().getViewManagerNames();
            }
        }) : new ViewManagerRegistry(this$0.getReactInstanceManager().getOrCreateViewManagers(reactApplicationContext));
        return new FabricUIManagerProviderImpl(componentFactory, ReactNativeConfig.DEFAULT_CONFIG, viewManagerRegistry2).createUIManager(reactApplicationContext);
    }
}

