/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react;

import com.facebook.react.BaseReactPackage;
import com.facebook.react.LazyReactPackage;
import com.facebook.react.ReactInstanceManager;
import com.facebook.react.ReactPackage;
import com.facebook.react.ReactPackageHelper;
import com.facebook.react.bridge.ModuleHolder;
import com.facebook.react.bridge.NativeModuleRegistry;
import com.facebook.react.bridge.ReactApplicationContext;
import java.util.HashMap;
import java.util.Map;

public class NativeModuleRegistryBuilder {
    private final ReactApplicationContext mReactApplicationContext;
    private final Map<String, ModuleHolder> mModules = new HashMap<String, ModuleHolder>();

    public NativeModuleRegistryBuilder(ReactApplicationContext reactApplicationContext, ReactInstanceManager reactInstanceManager) {
        this.mReactApplicationContext = reactApplicationContext;
    }

    public void processPackage(ReactPackage reactPackage) {
        Iterable<ModuleHolder> moduleHolders = reactPackage instanceof LazyReactPackage ? ((LazyReactPackage)reactPackage).getNativeModuleIterator(this.mReactApplicationContext) : (reactPackage instanceof BaseReactPackage ? ((BaseReactPackage)reactPackage).getNativeModuleIterator(this.mReactApplicationContext) : ReactPackageHelper.getNativeModuleIterator(reactPackage, this.mReactApplicationContext));
        for (ModuleHolder moduleHolder : moduleHolders) {
            String name = moduleHolder.getName();
            if (this.mModules.containsKey(name)) {
                ModuleHolder existingNativeModule = this.mModules.get(name);
                if (!moduleHolder.getCanOverrideExistingModule()) {
                    throw new IllegalStateException("Native module " + name + " tried to override " + existingNativeModule.getClassName() + ". Check the getPackages() method in MainApplication.java, it might be that module is being created twice. If this was your intention, set canOverrideExistingModule=true. This error may also be present if the package is present only once in getPackages() but is also automatically added later during build time by autolinking. Try removing the existing entry and rebuild.");
                }
                this.mModules.remove(existingNativeModule);
            }
            this.mModules.put(name, moduleHolder);
        }
    }

    public NativeModuleRegistry build() {
        return new NativeModuleRegistry(this.mReactApplicationContext, this.mModules);
    }
}

