/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.i18nmanager;

import android.content.Context;
import com.facebook.fbreact.specs.NativeI18nManagerSpec;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.modules.i18nmanager.I18nUtil;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ReactModule(name="I18nManager")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0014\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bH\u0016J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/facebook/react/modules/i18nmanager/I18nManagerModule;", "Lcom/facebook/fbreact/specs/NativeI18nManagerSpec;", "context", "Lcom/facebook/react/bridge/ReactApplicationContext;", "(Lcom/facebook/react/bridge/ReactApplicationContext;)V", "allowRTL", "", "value", "", "forceRTL", "getTypedExportedConstants", "", "", "", "swapLeftAndRightInRTL", "ReactAndroid_debug"})
public final class I18nManagerModule
extends NativeI18nManagerSpec {
    public I18nManagerModule(@Nullable ReactApplicationContext context) {
        super(context);
    }

    @Override
    @NotNull
    public Map<String, Object> getTypedExportedConstants() {
        ReactApplicationContext context = this.getReactApplicationContext();
        Locale locale = context.getResources().getConfiguration().getLocales().get(0);
        Pair[] pairArray = new Pair[3];
        I18nUtil i18nUtil = I18nUtil.Companion.getInstance();
        Intrinsics.checkNotNull((Object)((Object)context));
        pairArray[0] = TuplesKt.to((Object)"isRTL", (Object)i18nUtil.isRTL((Context)context));
        pairArray[1] = TuplesKt.to((Object)"doLeftAndRightSwapInRTL", (Object)I18nUtil.Companion.getInstance().doLeftAndRightSwapInRTL((Context)context));
        pairArray[2] = TuplesKt.to((Object)"localeIdentifier", (Object)locale.toString());
        return MapsKt.mapOf((Pair[])pairArray);
    }

    @Override
    public void allowRTL(boolean value) {
        I18nUtil i18nUtil = I18nUtil.Companion.getInstance();
        ReactApplicationContext reactApplicationContext = this.getReactApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)reactApplicationContext), (String)"getReactApplicationContext(...)");
        i18nUtil.allowRTL((Context)reactApplicationContext, value);
    }

    @Override
    public void forceRTL(boolean value) {
        I18nUtil i18nUtil = I18nUtil.Companion.getInstance();
        ReactApplicationContext reactApplicationContext = this.getReactApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)reactApplicationContext), (String)"getReactApplicationContext(...)");
        i18nUtil.forceRTL((Context)reactApplicationContext, value);
    }

    @Override
    public void swapLeftAndRightInRTL(boolean value) {
        I18nUtil i18nUtil = I18nUtil.Companion.getInstance();
        ReactApplicationContext reactApplicationContext = this.getReactApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)reactApplicationContext), (String)"getReactApplicationContext(...)");
        i18nUtil.swapLeftAndRightInRTL((Context)reactApplicationContext, value);
    }
}

