/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.runtime.internal.bolts;

import android.annotation.SuppressLint;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import androidx.annotation.NonNull;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

final class AndroidExecutors {
    private static final AndroidExecutors INSTANCE = new AndroidExecutors();
    @NonNull
    private final Executor uiThread = new UIThreadExecutor();
    private static final int CPU_COUNT = Runtime.getRuntime().availableProcessors();
    static final int CORE_POOL_SIZE = CPU_COUNT + 1;
    static final int MAX_POOL_SIZE = CPU_COUNT * 2 + 1;
    static final long KEEP_ALIVE_TIME = 1L;

    private AndroidExecutors() {
    }

    @NonNull
    public static ExecutorService newCachedThreadPool() {
        ThreadPoolExecutor executor = new ThreadPoolExecutor(CORE_POOL_SIZE, MAX_POOL_SIZE, 1L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        AndroidExecutors.allowCoreThreadTimeout(executor, true);
        return executor;
    }

    @NonNull
    public static ExecutorService newCachedThreadPool(@NonNull ThreadFactory threadFactory) {
        ThreadPoolExecutor executor = new ThreadPoolExecutor(CORE_POOL_SIZE, MAX_POOL_SIZE, 1L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory);
        AndroidExecutors.allowCoreThreadTimeout(executor, true);
        return executor;
    }

    @SuppressLint(value={"NewApi"})
    public static void allowCoreThreadTimeout(@NonNull ThreadPoolExecutor executor, boolean value) {
        if (Build.VERSION.SDK_INT >= 9) {
            executor.allowCoreThreadTimeOut(value);
        }
    }

    @NonNull
    public static Executor uiThread() {
        return AndroidExecutors.INSTANCE.uiThread;
    }

    private static class UIThreadExecutor
    implements Executor {
        private UIThreadExecutor() {
        }

        @Override
        public void execute(@NonNull Runnable command) {
            new Handler(Looper.getMainLooper()).post(command);
        }
    }
}

