/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.runtime;

import android.content.Context;
import android.graphics.Point;
import android.graphics.Rect;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import androidx.annotation.Nullable;
import com.facebook.common.logging.FLog;
import com.facebook.infer.annotation.Nullsafe;
import com.facebook.react.ReactRootView;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.config.ReactFeatureFlags;
import com.facebook.react.runtime.ReactHostImpl;
import com.facebook.react.runtime.ReactSurfaceImpl;
import com.facebook.react.uimanager.IllegalViewOperationException;
import com.facebook.react.uimanager.JSPointerDispatcher;
import com.facebook.react.uimanager.JSTouchDispatcher;
import com.facebook.react.uimanager.events.EventDispatcher;
import com.facebook.systrace.Systrace;
import java.util.Objects;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
public class ReactSurfaceView
extends ReactRootView {
    private static final String TAG = "ReactSurfaceView";
    private final ReactSurfaceImpl mSurface;
    private final JSTouchDispatcher mJSTouchDispatcher;
    @Nullable
    private JSPointerDispatcher mJSPointerDispatcher;
    private boolean mWasMeasured = false;
    private int mWidthMeasureSpec = 0;
    private int mHeightMeasureSpec = 0;

    public ReactSurfaceView(Context context, ReactSurfaceImpl surface) {
        super(context);
        this.mSurface = surface;
        this.mJSTouchDispatcher = new JSTouchDispatcher((ViewGroup)this);
        if (ReactFeatureFlags.dispatchPointerEvents) {
            this.mJSPointerDispatcher = new JSPointerDispatcher((ViewGroup)this);
        }
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int heightMode;
        Systrace.beginSection(0L, "ReactSurfaceView.onMeasure");
        int width = 0;
        int height = 0;
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        if (widthMode == Integer.MIN_VALUE || widthMode == 0) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                View child = this.getChildAt(i);
                int childSize = child.getLeft() + child.getMeasuredWidth() + child.getPaddingLeft() + child.getPaddingRight();
                width = Math.max(width, childSize);
            }
        } else {
            width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        }
        if ((heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec)) == Integer.MIN_VALUE || heightMode == 0) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                View child = this.getChildAt(i);
                int childSize = child.getTop() + child.getMeasuredHeight() + child.getPaddingTop() + child.getPaddingBottom();
                height = Math.max(height, childSize);
            }
        } else {
            height = View.MeasureSpec.getSize((int)heightMeasureSpec);
        }
        this.setMeasuredDimension(width, height);
        this.mWasMeasured = true;
        this.mWidthMeasureSpec = widthMeasureSpec;
        this.mHeightMeasureSpec = heightMeasureSpec;
        Point viewportOffset = this.getViewportOffset();
        this.mSurface.updateLayoutSpecs(this.mWidthMeasureSpec, this.mHeightMeasureSpec, viewportOffset.x, viewportOffset.y);
        Systrace.endSection(0L);
    }

    @Override
    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        if (this.mWasMeasured && changed) {
            Point viewportOffset = this.getViewportOffset();
            this.mSurface.updateLayoutSpecs(this.mWidthMeasureSpec, this.mHeightMeasureSpec, viewportOffset.x, viewportOffset.y);
        }
    }

    private Point getViewportOffset() {
        int[] locationOnScreen = new int[2];
        this.getLocationOnScreen(locationOnScreen);
        Rect visibleWindowFrame = new Rect();
        this.getWindowVisibleDisplayFrame(visibleWindowFrame);
        locationOnScreen[0] = locationOnScreen[0] - visibleWindowFrame.left;
        locationOnScreen[1] = locationOnScreen[1] - visibleWindowFrame.top;
        return new Point(locationOnScreen[0], locationOnScreen[1]);
    }

    @Override
    public void requestDisallowInterceptTouchEvent(boolean disallowIntercept) {
        ViewParent parent = this.getParent();
        if (parent != null) {
            parent.requestDisallowInterceptTouchEvent(disallowIntercept);
        }
    }

    @Override
    public void onChildStartedNativeGesture(View childView, MotionEvent ev) {
        EventDispatcher eventDispatcher = this.mSurface.getEventDispatcher();
        if (eventDispatcher == null) {
            return;
        }
        if (this.mJSTouchDispatcher != null) {
            this.mJSTouchDispatcher.onChildStartedNativeGesture(ev, eventDispatcher);
        }
        if (childView != null && this.mJSPointerDispatcher != null) {
            this.mJSPointerDispatcher.onChildStartedNativeGesture(childView, ev, eventDispatcher);
        }
    }

    @Override
    public void onChildEndedNativeGesture(View childView, MotionEvent ev) {
        EventDispatcher eventDispatcher = this.mSurface.getEventDispatcher();
        if (eventDispatcher == null) {
            return;
        }
        if (this.mJSTouchDispatcher != null && this.mSurface.getEventDispatcher() != null) {
            this.mJSTouchDispatcher.onChildEndedNativeGesture(ev, this.mSurface.getEventDispatcher());
        }
        if (this.mJSPointerDispatcher != null) {
            this.mJSPointerDispatcher.onChildStartedNativeGesture(childView, ev, eventDispatcher);
        }
    }

    @Override
    public void handleException(Throwable t) {
        ReactHostImpl reactHost = this.mSurface.getReactHost();
        if (reactHost != null) {
            String errorMessage = Objects.toString(t.getMessage(), "");
            IllegalViewOperationException e = new IllegalViewOperationException(errorMessage, (View)this, t);
            reactHost.handleHostException(e);
        }
    }

    @Override
    public void setIsFabric(boolean isFabric) {
        super.setIsFabric(true);
    }

    @Override
    public int getUIManagerType() {
        return 2;
    }

    @Override
    public String getJSModuleName() {
        return this.mSurface.getModuleName();
    }

    @Override
    protected void dispatchJSTouchEvent(MotionEvent event) {
        if (this.mJSTouchDispatcher == null) {
            FLog.w((String)TAG, (String)"Unable to dispatch touch events to JS before the dispatcher is available");
            return;
        }
        EventDispatcher eventDispatcher = this.mSurface.getEventDispatcher();
        if (eventDispatcher != null) {
            this.mJSTouchDispatcher.handleTouchEvent(event, eventDispatcher);
        } else {
            FLog.w((String)TAG, (String)"Unable to dispatch touch events to JS as the React instance has not been attached");
        }
    }

    @Override
    protected void dispatchJSPointerEvent(MotionEvent event, boolean isCapture) {
        if (this.mJSPointerDispatcher == null) {
            if (!ReactFeatureFlags.dispatchPointerEvents) {
                return;
            }
            FLog.w((String)TAG, (String)"Unable to dispatch pointer events to JS before the dispatcher is available");
            return;
        }
        EventDispatcher eventDispatcher = this.mSurface.getEventDispatcher();
        if (eventDispatcher != null) {
            this.mJSPointerDispatcher.handleMotionEvent(event, eventDispatcher, isCapture);
        } else {
            FLog.w((String)TAG, (String)"Unable to dispatch pointer events to JS as the React instance has not been attached");
        }
    }

    @Override
    public boolean hasActiveReactContext() {
        return this.mSurface.isAttached() && this.mSurface.getReactHost().getCurrentReactContext() != null;
    }

    @Override
    public boolean hasActiveReactInstance() {
        return this.mSurface.isAttached() && this.mSurface.getReactHost().isInstanceInitialized();
    }

    @Override
    @Nullable
    public ReactContext getCurrentReactContext() {
        if (this.mSurface.isAttached()) {
            return this.mSurface.getReactHost().getCurrentReactContext();
        }
        return null;
    }

    @Override
    public boolean isViewAttachedToReactInstance() {
        return this.mSurface.isAttached();
    }
}

