/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.common;

import android.content.Context;
import android.content.ContextWrapper;
import androidx.annotation.Nullable;
import com.facebook.infer.annotation.Nullsafe;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
public class ContextUtils {
    @Nullable
    public static <T> T findContextOfType(@Nullable Context context, Class<? extends T> clazz) {
        while (!clazz.isInstance(context)) {
            if (context instanceof ContextWrapper) {
                Context baseContext = ((ContextWrapper)context).getBaseContext();
                if (context == baseContext) {
                    return null;
                }
                context = baseContext;
                continue;
            }
            return null;
        }
        return (T)context;
    }
}

