/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.facebook.react.ReactPackage;
import com.facebook.react.bridge.ModuleHolder;
import com.facebook.react.bridge.ModuleSpec;
import com.facebook.react.bridge.NativeModule;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.config.ReactFeatureFlags;
import com.facebook.react.module.model.ReactModuleInfo;
import com.facebook.react.module.model.ReactModuleInfoProvider;
import com.facebook.react.uimanager.ViewManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.inject.Provider;

public abstract class BaseReactPackage
implements ReactPackage {
    @Override
    public List<NativeModule> createNativeModules(@NonNull ReactApplicationContext reactContext) {
        throw new UnsupportedOperationException("createNativeModules method is not supported. Use getModule() method instead.");
    }

    @Override
    @Nullable
    public abstract NativeModule getModule(@NonNull String var1, @NonNull ReactApplicationContext var2);

    Iterable<ModuleHolder> getNativeModuleIterator(final ReactApplicationContext reactContext) {
        Set<Map.Entry<String, ReactModuleInfo>> entrySet = this.getReactModuleInfoProvider().getReactModuleInfos().entrySet();
        final Iterator<Map.Entry<String, ReactModuleInfo>> entrySetIterator = entrySet.iterator();
        return () -> new Iterator<ModuleHolder>(){
            @Nullable
            Map.Entry<String, ReactModuleInfo> nextEntry = null;

            private void findNext() {
                while (entrySetIterator.hasNext()) {
                    Map.Entry entry = (Map.Entry)entrySetIterator.next();
                    ReactModuleInfo reactModuleInfo = (ReactModuleInfo)entry.getValue();
                    if (ReactFeatureFlags.useTurboModules && reactModuleInfo.isTurboModule()) continue;
                    this.nextEntry = entry;
                    return;
                }
                this.nextEntry = null;
            }

            @Override
            public boolean hasNext() {
                if (this.nextEntry == null) {
                    this.findNext();
                }
                return this.nextEntry != null;
            }

            @Override
            public ModuleHolder next() {
                if (this.nextEntry == null) {
                    this.findNext();
                }
                if (this.nextEntry == null) {
                    throw new NoSuchElementException("ModuleHolder not found");
                }
                Map.Entry<String, ReactModuleInfo> entry = this.nextEntry;
                this.findNext();
                String name = entry.getKey();
                ReactModuleInfo reactModuleInfo = entry.getValue();
                return new ModuleHolder(reactModuleInfo, new ModuleHolderProvider(name, reactContext));
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot remove native modules from the list");
            }
        };
    }

    protected List<ModuleSpec> getViewManagers(ReactApplicationContext reactContext) {
        return Collections.emptyList();
    }

    @Override
    public List<ViewManager> createViewManagers(@NonNull ReactApplicationContext reactContext) {
        List<ModuleSpec> viewManagerModuleSpecs = this.getViewManagers(reactContext);
        if (viewManagerModuleSpecs == null || viewManagerModuleSpecs.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ViewManager> viewManagers = new ArrayList<ViewManager>();
        for (ModuleSpec moduleSpec : viewManagerModuleSpecs) {
            viewManagers.add((ViewManager)moduleSpec.getProvider().get());
        }
        return viewManagers;
    }

    public abstract ReactModuleInfoProvider getReactModuleInfoProvider();

    private class ModuleHolderProvider
    implements Provider<NativeModule> {
        private final String mName;
        private final ReactApplicationContext mReactContext;

        public ModuleHolderProvider(String name, ReactApplicationContext reactContext) {
            this.mName = name;
            this.mReactContext = reactContext;
        }

        @Nullable
        public NativeModule get() {
            return BaseReactPackage.this.getModule(this.mName, this.mReactContext);
        }
    }
}

