/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.systeminfo;

import android.annotation.SuppressLint;
import android.app.UiModeManager;
import android.content.ContentResolver;
import android.os.Build;
import android.provider.Settings;
import androidx.annotation.Nullable;
import com.facebook.fbreact.specs.NativePlatformConstantsAndroidSpec;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.modules.systeminfo.ReactNativeVersion;
import com.facebook.react.turbomodule.core.interfaces.TurboModule;
import java.util.HashMap;
import java.util.Map;

@ReactModule(name="PlatformConstants")
@SuppressLint(value={"HardwareIds"})
public class AndroidInfoModule
extends NativePlatformConstantsAndroidSpec
implements TurboModule {
    private static final String IS_TESTING = "IS_TESTING";
    private static final String IS_DISABLE_ANIMATIONS = "IS_DISABLE_ANIMATIONS";

    public AndroidInfoModule(ReactApplicationContext reactContext) {
        super(reactContext);
    }

    private String uiMode() {
        UiModeManager uiModeManager = (UiModeManager)this.getReactApplicationContext().getSystemService("uimode");
        switch (uiModeManager.getCurrentModeType()) {
            case 4: {
                return "tv";
            }
            case 3: {
                return "car";
            }
            case 2: {
                return "desk";
            }
            case 6: {
                return "watch";
            }
            case 7: {
                return "vrheadset";
            }
            case 1: {
                return "normal";
            }
        }
        return "unknown";
    }

    @Override
    @Nullable
    public Map<String, Object> getTypedExportedConstants() {
        HashMap<String, Object> constants = new HashMap<String, Object>();
        constants.put("Version", Build.VERSION.SDK_INT);
        constants.put("Release", Build.VERSION.RELEASE);
        constants.put("Serial", Build.SERIAL);
        constants.put("Fingerprint", Build.FINGERPRINT);
        constants.put("Model", Build.MODEL);
        constants.put("Manufacturer", Build.MANUFACTURER);
        constants.put("Brand", Build.BRAND);
        constants.put("isTesting", "true".equals(System.getProperty(IS_TESTING)) || this.isRunningScreenshotTest() != false);
        String isDisableAnimations = System.getProperty(IS_DISABLE_ANIMATIONS);
        if (isDisableAnimations != null) {
            constants.put("isDisableAnimations", "true".equals(isDisableAnimations));
        }
        constants.put("reactNativeVersion", ReactNativeVersion.VERSION);
        constants.put("uiMode", this.uiMode());
        return constants;
    }

    @Override
    public String getAndroidID() {
        return Settings.Secure.getString((ContentResolver)this.getReactApplicationContext().getContentResolver(), (String)"android_id");
    }

    @Override
    public void invalidate() {
    }

    private Boolean isRunningScreenshotTest() {
        try {
            Class.forName("com.facebook.testing.react.screenshots.ReactAppScreenshotTestActivity");
            return true;
        }
        catch (ClassNotFoundException ignored) {
            return false;
        }
    }
}

