/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.scroll;

import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import androidx.core.view.AccessibilityDelegateCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import com.facebook.react.R;
import com.facebook.react.bridge.AssertionException;
import com.facebook.react.bridge.ReactSoftExceptionLogger;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.uimanager.ReactAccessibilityDelegate;
import com.facebook.react.views.scroll.ReactHorizontalScrollView;
import com.facebook.react.views.scroll.ReactScrollView;

public class ReactScrollViewAccessibilityDelegate
extends AccessibilityDelegateCompat {
    private final String TAG = ReactScrollViewAccessibilityDelegate.class.getSimpleName();

    public void onInitializeAccessibilityEvent(View host, AccessibilityEvent event) {
        super.onInitializeAccessibilityEvent(host, event);
        if (host instanceof ReactScrollView || host instanceof ReactHorizontalScrollView) {
            this.onInitializeAccessibilityEventInternal(host, event);
        } else {
            ReactSoftExceptionLogger.logSoftException(this.TAG, new AssertionException("ReactScrollViewAccessibilityDelegate should only be used with ReactScrollView or ReactHorizontalScrollView, not with class: " + host.getClass().getSimpleName()));
        }
    }

    public void onInitializeAccessibilityNodeInfo(View host, AccessibilityNodeInfoCompat info) {
        super.onInitializeAccessibilityNodeInfo(host, info);
        if (host instanceof ReactScrollView || host instanceof ReactHorizontalScrollView) {
            this.onInitializeAccessibilityNodeInfoInternal(host, info);
        } else {
            ReactSoftExceptionLogger.logSoftException(this.TAG, new AssertionException("ReactScrollViewAccessibilityDelegate should only be used with ReactScrollView or ReactHorizontalScrollView, not with class: " + host.getClass().getSimpleName()));
        }
    }

    private void onInitializeAccessibilityEventInternal(View view, AccessibilityEvent event) {
        ReadableMap accessibilityCollection = (ReadableMap)view.getTag(R.id.accessibility_collection);
        if (accessibilityCollection != null) {
            event.setItemCount(accessibilityCollection.getInt("itemCount"));
            if (!(view instanceof ViewGroup)) {
                return;
            }
            ViewGroup viewGroup = (ViewGroup)view;
            View contentView = viewGroup.getChildAt(0);
            Integer firstVisibleIndex = null;
            Integer lastVisibleIndex = null;
            if (!(contentView instanceof ViewGroup)) {
                return;
            }
            for (int index = 0; index < ((ViewGroup)contentView).getChildCount(); ++index) {
                ReadableMap nestedChildAccessibility;
                View nestedNextChild;
                boolean isVisible;
                View nextChild = ((ViewGroup)contentView).getChildAt(index);
                if (view instanceof ReactScrollView) {
                    scrollView = (ReactScrollView)view;
                    isVisible = ((ReactScrollView)scrollView).isPartiallyScrolledInView(nextChild);
                } else if (view instanceof ReactHorizontalScrollView) {
                    scrollView = (ReactHorizontalScrollView)view;
                    isVisible = ((ReactHorizontalScrollView)scrollView).isPartiallyScrolledInView(nextChild);
                } else {
                    return;
                }
                ReadableMap accessibilityCollectionItem = (ReadableMap)nextChild.getTag(R.id.accessibility_collection_item);
                if (!(nextChild instanceof ViewGroup)) {
                    return;
                }
                int childCount = ((ViewGroup)nextChild).getChildCount();
                if (childCount > 0 && accessibilityCollectionItem == null && (nestedNextChild = ((ViewGroup)nextChild).getChildAt(0)) != null && (nestedChildAccessibility = (ReadableMap)nestedNextChild.getTag(R.id.accessibility_collection_item)) != null) {
                    accessibilityCollectionItem = nestedChildAccessibility;
                }
                if (isVisible && accessibilityCollectionItem != null) {
                    if (firstVisibleIndex == null) {
                        firstVisibleIndex = accessibilityCollectionItem.getInt("itemIndex");
                    }
                    lastVisibleIndex = accessibilityCollectionItem.getInt("itemIndex");
                }
                if (firstVisibleIndex == null || lastVisibleIndex == null) continue;
                event.setFromIndex(firstVisibleIndex.intValue());
                event.setToIndex(lastVisibleIndex.intValue());
            }
        }
    }

    private void onInitializeAccessibilityNodeInfoInternal(View view, AccessibilityNodeInfoCompat info) {
        ReadableMap accessibilityCollection;
        ReactAccessibilityDelegate.AccessibilityRole accessibilityRole = ReactAccessibilityDelegate.AccessibilityRole.fromViewTag(view);
        if (accessibilityRole != null) {
            ReactAccessibilityDelegate.setRole(info, accessibilityRole, view.getContext());
        }
        if ((accessibilityCollection = (ReadableMap)view.getTag(R.id.accessibility_collection)) != null) {
            int rowCount = accessibilityCollection.getInt("rowCount");
            int columnCount = accessibilityCollection.getInt("columnCount");
            boolean hierarchical = accessibilityCollection.getBoolean("hierarchical");
            AccessibilityNodeInfoCompat.CollectionInfoCompat collectionInfoCompat = AccessibilityNodeInfoCompat.CollectionInfoCompat.obtain((int)rowCount, (int)columnCount, (boolean)hierarchical);
            info.setCollectionInfo((Object)collectionInfoCompat);
        }
        if (view instanceof ReactScrollView) {
            ReactScrollView scrollView = (ReactScrollView)view;
            info.setScrollable(scrollView.getScrollEnabled());
        } else if (view instanceof ReactHorizontalScrollView) {
            ReactHorizontalScrollView scrollView = (ReactHorizontalScrollView)view;
            info.setScrollable(scrollView.getScrollEnabled());
        }
    }
}

