/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import android.graphics.Point;
import android.graphics.Rect;
import android.view.View;
import android.view.ViewParent;
import androidx.annotation.UiThread;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.uimanager.RootView;

public class RootViewUtil {
    public static RootView getRootView(View reactView) {
        View current = reactView;
        while (!(current instanceof RootView)) {
            ViewParent next = current.getParent();
            if (next == null) {
                return null;
            }
            Assertions.assertCondition((boolean)(next instanceof View));
            current = (View)next;
        }
        return (RootView)current;
    }

    @UiThread
    public static Point getViewportOffset(View v) {
        int[] locationInWindow = new int[2];
        v.getLocationInWindow(locationInWindow);
        Rect visibleWindowFrame = new Rect();
        v.getWindowVisibleDisplayFrame(visibleWindowFrame);
        locationInWindow[0] = locationInWindow[0] - visibleWindowFrame.left;
        locationInWindow[1] = locationInWindow[1] - visibleWindowFrame.top;
        return new Point(locationInWindow[0], locationInWindow[1]);
    }
}

