/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.turbomodule.core;

import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.facebook.common.logging.FLog;
import com.facebook.infer.annotation.Assertions;
import com.facebook.jni.HybridData;
import com.facebook.proguard.annotations.DoNotStrip;
import com.facebook.react.bridge.CxxModuleWrapper;
import com.facebook.react.bridge.JSIModule;
import com.facebook.react.bridge.NativeModule;
import com.facebook.react.bridge.ReactNoCrashSoftException;
import com.facebook.react.bridge.ReactSoftExceptionLogger;
import com.facebook.react.bridge.RuntimeExecutor;
import com.facebook.react.turbomodule.core.CallInvokerHolderImpl;
import com.facebook.react.turbomodule.core.NativeMethodCallInvokerHolderImpl;
import com.facebook.react.turbomodule.core.NativeModuleSoLoader;
import com.facebook.react.turbomodule.core.TurboModuleInteropUtils;
import com.facebook.react.turbomodule.core.TurboModuleManagerDelegate;
import com.facebook.react.turbomodule.core.TurboModulePerfLogger;
import com.facebook.react.turbomodule.core.interfaces.CallInvokerHolder;
import com.facebook.react.turbomodule.core.interfaces.NativeMethodCallInvokerHolder;
import com.facebook.react.turbomodule.core.interfaces.TurboModule;
import com.facebook.react.turbomodule.core.interfaces.TurboModuleRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TurboModuleManager
implements JSIModule,
TurboModuleRegistry {
    private final List<String> mEagerInitModuleNames;
    private final ModuleProvider mTurboModuleProvider;
    private final ModuleProvider mLegacyModuleProvider;
    private final TurboModuleManagerDelegate mDelegate;
    private final Object mModuleCleanupLock = new Object();
    @GuardedBy(value="mModuleCleanupLock")
    private boolean mModuleCleanupStarted = false;
    @GuardedBy(value="mModuleCleanupLock")
    private final Map<String, ModuleHolder> mModuleHolders = new HashMap<String, ModuleHolder>();
    @DoNotStrip
    private final HybridData mHybridData;

    public TurboModuleManager(RuntimeExecutor runtimeExecutor, @Nullable TurboModuleManagerDelegate delegate, CallInvokerHolder jsCallInvokerHolder, NativeMethodCallInvokerHolder nativeMethodCallInvokerHolder) {
        this.mDelegate = delegate;
        this.mHybridData = this.initHybrid(runtimeExecutor, (CallInvokerHolderImpl)jsCallInvokerHolder, (NativeMethodCallInvokerHolderImpl)nativeMethodCallInvokerHolder, delegate);
        this.installJSIBindings(this.shouldEnableLegacyModuleInterop());
        this.mEagerInitModuleNames = delegate == null ? new ArrayList() : delegate.getEagerInitModuleNames();
        ModuleProvider nullProvider = moduleName -> null;
        this.mTurboModuleProvider = delegate == null ? nullProvider : moduleName -> (NativeModule)((Object)delegate.getModule(moduleName));
        this.mLegacyModuleProvider = delegate == null || !this.shouldEnableLegacyModuleInterop() ? nullProvider : moduleName -> {
            NativeModule nativeModule = delegate.getLegacyModule(moduleName);
            if (nativeModule != null) {
                Assertions.assertCondition((!(nativeModule instanceof TurboModule) ? 1 : 0) != 0, (String)("NativeModule \"" + moduleName + "\" is a TurboModule"));
                return nativeModule;
            }
            return null;
        };
    }

    private boolean isTurboModule(String moduleName) {
        return this.mDelegate != null && this.mDelegate.unstable_isModuleRegistered(moduleName);
    }

    private boolean isLegacyModule(String moduleName) {
        return this.mDelegate != null && this.mDelegate.unstable_isLegacyModuleRegistered(moduleName);
    }

    private boolean shouldEnableLegacyModuleInterop() {
        return this.mDelegate != null && this.mDelegate.unstable_shouldEnableLegacyModuleInterop();
    }

    private boolean shouldRouteTurboModulesThroughLegacyModuleInterop() {
        return this.mDelegate != null && this.mDelegate.unstable_shouldRouteTurboModulesThroughLegacyModuleInterop();
    }

    @Override
    @NonNull
    public List<String> getEagerInitModuleNames() {
        return this.mEagerInitModuleNames;
    }

    @DoNotStrip
    private static List<TurboModuleInteropUtils.MethodDescriptor> getMethodDescriptorsFromModule(NativeModule module) {
        return TurboModuleInteropUtils.getMethodDescriptorsFromModule(module);
    }

    @DoNotStrip
    @Nullable
    private NativeModule getLegacyJavaModule(String moduleName) {
        if (this.shouldRouteTurboModulesThroughLegacyModuleInterop()) {
            NativeModule module = this.getModule(moduleName);
            return !(module instanceof CxxModuleWrapper) ? module : null;
        }
        if (!this.isLegacyModule(moduleName)) {
            return null;
        }
        NativeModule module = this.getModule(moduleName);
        return !(module instanceof CxxModuleWrapper) && !(module instanceof TurboModule) ? module : null;
    }

    @DoNotStrip
    @Nullable
    private CxxModuleWrapper getLegacyCxxModule(String moduleName) {
        if (this.shouldRouteTurboModulesThroughLegacyModuleInterop()) {
            NativeModule module = this.getModule(moduleName);
            return module instanceof CxxModuleWrapper ? (CxxModuleWrapper)module : null;
        }
        if (!this.isLegacyModule(moduleName)) {
            return null;
        }
        NativeModule module = this.getModule(moduleName);
        return module instanceof CxxModuleWrapper && !(module instanceof TurboModule) ? (CxxModuleWrapper)module : null;
    }

    @DoNotStrip
    @Nullable
    private CxxModuleWrapper getTurboLegacyCxxModule(String moduleName) {
        if (this.shouldRouteTurboModulesThroughLegacyModuleInterop()) {
            return null;
        }
        if (!this.isTurboModule(moduleName)) {
            return null;
        }
        NativeModule module = this.getModule(moduleName);
        return module instanceof CxxModuleWrapper && module instanceof TurboModule ? (CxxModuleWrapper)module : null;
    }

    @DoNotStrip
    @Nullable
    private TurboModule getTurboJavaModule(String moduleName) {
        if (this.shouldRouteTurboModulesThroughLegacyModuleInterop()) {
            return null;
        }
        if (!this.isTurboModule(moduleName)) {
            return null;
        }
        NativeModule module = this.getModule(moduleName);
        return !(module instanceof CxxModuleWrapper) && module instanceof TurboModule ? (TurboModule)((Object)module) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public NativeModule getModule(String moduleName) {
        ModuleHolder moduleHolder;
        Object object = this.mModuleCleanupLock;
        synchronized (object) {
            if (this.mModuleCleanupStarted) {
                this.logError("getModule(): Tried to get module \"" + moduleName + "\", but TurboModuleManager was tearing down. Returning null. Was legacy: " + this.isLegacyModule(moduleName) + ". Was turbo: " + this.isTurboModule(moduleName) + ".");
                return null;
            }
            if (!this.mModuleHolders.containsKey(moduleName)) {
                this.mModuleHolders.put(moduleName, new ModuleHolder());
            }
            moduleHolder = this.mModuleHolders.get(moduleName);
        }
        TurboModulePerfLogger.moduleCreateStart(moduleName, moduleHolder.getModuleId());
        NativeModule module = this.getOrCreateModule(moduleName, moduleHolder, true);
        if (module != null) {
            TurboModulePerfLogger.moduleCreateEnd(moduleName, moduleHolder.getModuleId());
        } else {
            TurboModulePerfLogger.moduleCreateFail(moduleName, moduleHolder.getModuleId());
        }
        return module;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private NativeModule getOrCreateModule(String moduleName, @NonNull ModuleHolder moduleHolder, boolean shouldPerfLog) {
        boolean shouldCreateModule = false;
        ModuleHolder moduleHolder2 = moduleHolder;
        synchronized (moduleHolder2) {
            if (moduleHolder.isDoneCreatingModule()) {
                if (shouldPerfLog) {
                    TurboModulePerfLogger.moduleCreateCacheHit(moduleName, moduleHolder.getModuleId());
                }
                return moduleHolder.getModule();
            }
            if (!moduleHolder.isCreatingModule()) {
                shouldCreateModule = true;
                moduleHolder.startCreatingModule();
            }
        }
        if (shouldCreateModule) {
            ModuleHolder moduleHolder3;
            TurboModulePerfLogger.moduleCreateConstructStart(moduleName, moduleHolder.getModuleId());
            NativeModule nativeModule = this.mTurboModuleProvider.getModule(moduleName);
            if (nativeModule == null) {
                nativeModule = this.mLegacyModuleProvider.getModule(moduleName);
            }
            TurboModulePerfLogger.moduleCreateConstructEnd(moduleName, moduleHolder.getModuleId());
            TurboModulePerfLogger.moduleCreateSetUpStart(moduleName, moduleHolder.getModuleId());
            if (nativeModule != null) {
                moduleHolder3 = moduleHolder;
                synchronized (moduleHolder3) {
                    moduleHolder.setModule(nativeModule);
                }
                nativeModule.initialize();
            } else {
                this.logError("getOrCreateModule(): Unable to create module \"" + moduleName + "\". Was legacy: " + this.isLegacyModule(moduleName) + ". Was turbo: " + this.isTurboModule(moduleName) + ".");
            }
            TurboModulePerfLogger.moduleCreateSetUpEnd(moduleName, moduleHolder.getModuleId());
            moduleHolder3 = moduleHolder;
            synchronized (moduleHolder3) {
                moduleHolder.endCreatingModule();
                moduleHolder.notifyAll();
            }
            return nativeModule;
        }
        moduleHolder2 = moduleHolder;
        synchronized (moduleHolder2) {
            boolean wasInterrupted = false;
            while (moduleHolder.isCreatingModule()) {
                try {
                    moduleHolder.wait();
                }
                catch (InterruptedException e) {
                    wasInterrupted = true;
                }
            }
            if (wasInterrupted) {
                Thread.currentThread().interrupt();
            }
            return moduleHolder.getModule();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<NativeModule> getModules() {
        ArrayList<ModuleHolder> moduleHolders = new ArrayList<ModuleHolder>();
        Object object = this.mModuleCleanupLock;
        synchronized (object) {
            moduleHolders.addAll(this.mModuleHolders.values());
        }
        ArrayList<NativeModule> modules = new ArrayList<NativeModule>();
        Iterator iterator2 = moduleHolders.iterator();
        while (iterator2.hasNext()) {
            ModuleHolder moduleHolder;
            ModuleHolder moduleHolder2 = moduleHolder = (ModuleHolder)iterator2.next();
            synchronized (moduleHolder2) {
                if (moduleHolder.getModule() != null) {
                    modules.add(moduleHolder.getModule());
                }
            }
        }
        return modules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasModule(String moduleName) {
        ModuleHolder moduleHolder;
        Object object = this.mModuleCleanupLock;
        synchronized (object) {
            moduleHolder = this.mModuleHolders.get(moduleName);
        }
        if (moduleHolder != null) {
            object = moduleHolder;
            synchronized (object) {
                if (moduleHolder.getModule() != null) {
                    return true;
                }
            }
        }
        return false;
    }

    private void logError(String message) {
        FLog.e((String)"TurboModuleManager", (String)message);
        if (this.shouldRouteTurboModulesThroughLegacyModuleInterop()) {
            ReactSoftExceptionLogger.logSoftException("TurboModuleManager", new ReactNoCrashSoftException(message));
        }
    }

    private native HybridData initHybrid(RuntimeExecutor var1, CallInvokerHolderImpl var2, NativeMethodCallInvokerHolderImpl var3, TurboModuleManagerDelegate var4);

    private native void installJSIBindings(boolean var1);

    @Override
    public void initialize() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCatalystInstanceDestroy() {
        Iterator<Map.Entry<String, ModuleHolder>> iterator2 = this.mModuleCleanupLock;
        synchronized (iterator2) {
            this.mModuleCleanupStarted = true;
        }
        for (Map.Entry<String, ModuleHolder> moduleHolderEntry : this.mModuleHolders.entrySet()) {
            ModuleHolder moduleHolder;
            String moduleName = moduleHolderEntry.getKey();
            NativeModule nativeModule = this.getOrCreateModule(moduleName, moduleHolder = moduleHolderEntry.getValue(), false);
            if (nativeModule == null) continue;
            nativeModule.invalidate();
        }
        this.mModuleHolders.clear();
        this.mHybridData.resetNative();
    }

    static {
        NativeModuleSoLoader.maybeLoadSoLibrary();
    }

    private static interface ModuleProvider {
        @Nullable
        public NativeModule getModule(String var1);
    }

    private static class ModuleHolder {
        private volatile NativeModule mModule = null;
        private volatile boolean mIsTryingToCreate = false;
        private volatile boolean mIsDoneCreatingModule = false;
        private static volatile int sHolderCount = 0;
        private volatile int mModuleId = sHolderCount++;

        int getModuleId() {
            return this.mModuleId;
        }

        void setModule(@NonNull NativeModule module) {
            this.mModule = module;
        }

        @Nullable
        NativeModule getModule() {
            return this.mModule;
        }

        void startCreatingModule() {
            this.mIsTryingToCreate = true;
        }

        void endCreatingModule() {
            this.mIsTryingToCreate = false;
            this.mIsDoneCreatingModule = true;
        }

        boolean isDoneCreatingModule() {
            return this.mIsDoneCreatingModule;
        }

        boolean isCreatingModule() {
            return this.mIsTryingToCreate;
        }
    }
}

