/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.runtime.internal.bolts;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class AggregateException
extends Exception {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_MESSAGE = "There were multiple errors.";
    @NonNull
    private final List<Throwable> innerThrowables;

    public AggregateException(@NonNull String detailMessage, @NonNull Throwable[] innerThrowables) {
        this(detailMessage, Arrays.asList(innerThrowables));
    }

    public AggregateException(@NonNull String detailMessage, @Nullable List<? extends Throwable> innerThrowables) {
        super(detailMessage, innerThrowables != null && innerThrowables.size() > 0 ? innerThrowables.get(0) : null);
        this.innerThrowables = Collections.unmodifiableList(innerThrowables != null ? innerThrowables : new ArrayList());
    }

    public AggregateException(@Nullable List<? extends Throwable> innerThrowables) {
        this(DEFAULT_MESSAGE, innerThrowables);
    }

    @NonNull
    public List<Throwable> getInnerThrowables() {
        return this.innerThrowables;
    }

    @Override
    public void printStackTrace(@NonNull PrintStream err) {
        super.printStackTrace(err);
        int currentIndex = -1;
        for (Throwable throwable : this.innerThrowables) {
            err.append("\n");
            err.append("  Inner throwable #");
            err.append(Integer.toString(++currentIndex));
            err.append(": ");
            throwable.printStackTrace(err);
            err.append("\n");
        }
    }

    @Override
    public void printStackTrace(@NonNull PrintWriter err) {
        super.printStackTrace(err);
        int currentIndex = -1;
        for (Throwable throwable : this.innerThrowables) {
            err.append("\n");
            err.append("  Inner throwable #");
            err.append(Integer.toString(++currentIndex));
            err.append(": ");
            throwable.printStackTrace(err);
            err.append("\n");
        }
    }

    @Deprecated
    @NonNull
    public List<Exception> getErrors() {
        ArrayList<Exception> errors = new ArrayList<Exception>();
        if (this.innerThrowables == null) {
            return errors;
        }
        for (Throwable cause : this.innerThrowables) {
            if (cause instanceof Exception) {
                errors.add((Exception)cause);
                continue;
            }
            errors.add(new Exception(cause));
        }
        return errors;
    }

    @Deprecated
    @NonNull
    public Throwable[] getCauses() {
        return this.innerThrowables.toArray(new Throwable[this.innerThrowables.size()]);
    }
}

