/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.runtime;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.facebook.common.logging.FLog;
import com.facebook.infer.annotation.Assertions;
import com.facebook.infer.annotation.Nullsafe;
import com.facebook.infer.annotation.ThreadConfined;
import com.facebook.infer.annotation.ThreadSafe;
import com.facebook.react.JSEngineResolutionAlgorithm;
import com.facebook.react.MemoryPressureRouter;
import com.facebook.react.ReactHost;
import com.facebook.react.ReactInstanceEventListener;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.JSBundleLoader;
import com.facebook.react.bridge.MemoryPressureListener;
import com.facebook.react.bridge.NativeArray;
import com.facebook.react.bridge.NativeModule;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReactMarker;
import com.facebook.react.bridge.ReactMarkerConstants;
import com.facebook.react.bridge.ReactNoCrashBridgeNotAllowedSoftException;
import com.facebook.react.bridge.ReactNoCrashSoftException;
import com.facebook.react.bridge.ReactSoftExceptionLogger;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.bridge.queue.QueueThreadExceptionHandler;
import com.facebook.react.bridge.queue.ReactQueueConfiguration;
import com.facebook.react.common.LifecycleState;
import com.facebook.react.common.build.ReactBuildConfig;
import com.facebook.react.config.ReactFeatureFlags;
import com.facebook.react.devsupport.DevSupportManagerBase;
import com.facebook.react.devsupport.DisabledDevSupportManager;
import com.facebook.react.devsupport.interfaces.DevSupportManager;
import com.facebook.react.fabric.ComponentFactory;
import com.facebook.react.fabric.FabricUIManager;
import com.facebook.react.interfaces.TaskInterface;
import com.facebook.react.interfaces.exceptionmanager.ReactJsExceptionHandler;
import com.facebook.react.interfaces.fabric.ReactSurface;
import com.facebook.react.modules.core.DefaultHardwareBackBtnHandler;
import com.facebook.react.modules.core.DeviceEventManagerModule;
import com.facebook.react.runtime.BridgelessAtomicRef;
import com.facebook.react.runtime.BridgelessDevSupportManager;
import com.facebook.react.runtime.BridgelessReactContext;
import com.facebook.react.runtime.BridgelessReactStateTracker;
import com.facebook.react.runtime.ReactHostDelegate;
import com.facebook.react.runtime.ReactInstance;
import com.facebook.react.runtime.ReactLifecycleStateManager;
import com.facebook.react.runtime.ReactSurfaceImpl;
import com.facebook.react.runtime.ReactSurfaceView;
import com.facebook.react.runtime.internal.bolts.Task;
import com.facebook.react.runtime.internal.bolts.TaskCompletionSource;
import com.facebook.react.uimanager.UIManagerModule;
import com.facebook.react.uimanager.events.BlackHoleEventDispatcher;
import com.facebook.react.uimanager.events.EventDispatcher;
import com.facebook.react.views.imagehelper.ResourceDrawableIdHelper;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;

@ThreadSafe
@Nullsafe(value=Nullsafe.Mode.LOCAL)
public class ReactHostImpl
implements ReactHost {
    private static final boolean DEV = ReactBuildConfig.DEBUG;
    private static final String TAG = "ReactHost";
    private static final int BRIDGELESS_MARKER_INSTANCE_KEY = 1;
    private static final AtomicInteger mCounter = new AtomicInteger(0);
    private final Context mContext;
    private final ReactHostDelegate mReactHostDelegate;
    private final ComponentFactory mComponentFactory;
    private final ReactJsExceptionHandler mReactJsExceptionHandler;
    private final DevSupportManager mDevSupportManager;
    private final Executor mBGExecutor;
    private final Executor mUIExecutor;
    private final QueueThreadExceptionHandler mQueueThreadExceptionHandler;
    private final Set<ReactSurfaceImpl> mAttachedSurfaces = Collections.synchronizedSet(new HashSet());
    private final MemoryPressureRouter mMemoryPressureRouter;
    private final boolean mAllowPackagerServerAccess;
    private final boolean mUseDevSupport;
    private final Collection<ReactInstanceEventListener> mReactInstanceEventListeners = Collections.synchronizedList(new ArrayList());
    private final BridgelessAtomicRef<Task<ReactInstance>> mReactInstanceTaskRef = new BridgelessAtomicRef<Task<ReactInstance>>(Task.forResult((ReactInstance)Assertions.nullsafeFIXME(null, (String)"forResult parameter supports null, but is not annotated as @Nullable")));
    private final BridgelessAtomicRef<BridgelessReactContext> mBridgelessReactContextRef = new BridgelessAtomicRef();
    private final AtomicReference<Activity> mActivity = new AtomicReference();
    private final AtomicReference<WeakReference<Activity>> mLastUsedActivity = new AtomicReference<WeakReference<Object>>(new WeakReference<Object>(null));
    private final BridgelessReactStateTracker mBridgelessReactStateTracker = new BridgelessReactStateTracker(DEV);
    private final ReactLifecycleStateManager mReactLifecycleStateManager = new ReactLifecycleStateManager(this.mBridgelessReactStateTracker);
    private final int mId = mCounter.getAndIncrement();
    @Nullable
    private JSEngineResolutionAlgorithm mJSEngineResolutionAlgorithm = null;
    private MemoryPressureListener mMemoryPressureListener;
    @Nullable
    private DefaultHardwareBackBtnHandler mDefaultHardwareBackBtnHandler;
    private final Set<Function0<Unit>> mBeforeDestroyListeners = Collections.synchronizedSet(new HashSet());
    @ThreadConfined(value="ReactHost")
    @Nullable
    private Task<Void> mStartTask = null;
    @ThreadConfined(value="ReactHost")
    @Nullable
    private Task<ReactInstance> mReloadTask = null;
    @ThreadConfined(value="ReactHost")
    @Nullable
    private Task<Void> mDestroyTask = null;

    public ReactHostImpl(Context context, ReactHostDelegate delegate, ComponentFactory componentFactory, boolean allowPackagerServerAccess, ReactJsExceptionHandler reactJsExceptionHandler, boolean useDevSupport) {
        this(context, delegate, componentFactory, Executors.newSingleThreadExecutor(), Task.UI_THREAD_EXECUTOR, reactJsExceptionHandler, allowPackagerServerAccess, useDevSupport);
    }

    public ReactHostImpl(Context context, ReactHostDelegate delegate, ComponentFactory componentFactory, Executor bgExecutor, Executor uiExecutor, ReactJsExceptionHandler reactJsExceptionHandler, boolean allowPackagerServerAccess, boolean useDevSupport) {
        this.mContext = context;
        this.mReactHostDelegate = delegate;
        this.mComponentFactory = componentFactory;
        this.mBGExecutor = bgExecutor;
        this.mUIExecutor = uiExecutor;
        this.mReactJsExceptionHandler = reactJsExceptionHandler;
        this.mQueueThreadExceptionHandler = this::handleHostException;
        this.mMemoryPressureRouter = new MemoryPressureRouter(context);
        this.mMemoryPressureListener = level -> this.callWithExistingReactInstance("handleMemoryPressure(" + level + ")", reactInstance -> reactInstance.handleMemoryPressure(level));
        this.mAllowPackagerServerAccess = allowPackagerServerAccess;
        this.mDevSupportManager = DEV ? new BridgelessDevSupportManager(this, this.mContext, this.mReactHostDelegate.getJsMainModulePath()) : new DisabledDevSupportManager();
        this.mUseDevSupport = useDevSupport;
    }

    @Override
    public LifecycleState getLifecycleState() {
        return this.mReactLifecycleStateManager.getLifecycleState();
    }

    @Override
    public TaskInterface<Void> start() {
        if (ReactFeatureFlags.enableBridgelessArchitectureNewCreateReloadDestroy) {
            return this.newStart();
        }
        return this.oldStart();
    }

    TaskInterface<Void> prerenderSurface(ReactSurfaceImpl surface) {
        String method = "prerenderSurface(surfaceId = " + surface.getSurfaceID() + ")";
        this.log(method, "Schedule");
        this.attachSurface(surface);
        return this.callAfterGetOrCreateReactInstance(method, reactInstance -> {
            this.log(method, "Execute");
            reactInstance.prerenderSurface(surface);
        });
    }

    TaskInterface<Void> startSurface(ReactSurfaceImpl surface) {
        String method = "startSurface(surfaceId = " + surface.getSurfaceID() + ")";
        this.log(method, "Schedule");
        this.attachSurface(surface);
        return this.callAfterGetOrCreateReactInstance(method, reactInstance -> {
            this.log(method, "Execute");
            reactInstance.startSurface(surface);
        });
    }

    TaskInterface<Void> stopSurface(ReactSurfaceImpl surface) {
        String method = "stopSurface(surfaceId = " + surface.getSurfaceID() + ")";
        this.log(method, "Schedule");
        this.detachSurface(surface);
        return this.callWithExistingReactInstance(method, reactInstance -> {
            this.log(method, "Execute");
            reactInstance.stopSurface(surface);
        }).makeVoid();
    }

    @Override
    @ThreadConfined(value="UI")
    public void onHostResume(@Nullable Activity activity, @Nullable DefaultHardwareBackBtnHandler defaultBackButtonImpl) {
        this.mDefaultHardwareBackBtnHandler = defaultBackButtonImpl;
        this.onHostResume(activity);
    }

    @Override
    @ThreadConfined(value="UI")
    public void onHostResume(@Nullable Activity activity) {
        String method = "onHostResume(activity)";
        this.log("onHostResume(activity)");
        this.setCurrentActivity(activity);
        ReactContext currentContext = this.getCurrentReactContext();
        this.mReactLifecycleStateManager.moveToOnHostResume(currentContext, this.getCurrentActivity());
    }

    @Override
    @ThreadConfined(value="UI")
    public void onHostPause(@Nullable Activity activity) {
        String method = "onHostPause(activity)";
        this.log("onHostPause(activity)");
        ReactContext currentContext = this.getCurrentReactContext();
        Activity currentActivity = this.getCurrentActivity();
        if (currentActivity != null) {
            String currentActivityClass = currentActivity.getClass().getSimpleName();
            String activityClass = activity == null ? "null" : activity.getClass().getSimpleName();
            Assertions.assertCondition((activity == currentActivity ? 1 : 0) != 0, (String)("Pausing an activity that is not the current activity, this is incorrect! Current activity: " + currentActivityClass + " Paused activity: " + activityClass));
        }
        this.mDefaultHardwareBackBtnHandler = null;
        this.mReactLifecycleStateManager.moveToOnHostPause(currentContext, currentActivity);
    }

    @Override
    @ThreadConfined(value="UI")
    public void onHostPause() {
        String method = "onHostPause()";
        this.log("onHostPause()");
        ReactContext currentContext = this.getCurrentReactContext();
        this.mDefaultHardwareBackBtnHandler = null;
        this.mReactLifecycleStateManager.moveToOnHostPause(currentContext, this.getCurrentActivity());
    }

    @Override
    @ThreadConfined(value="UI")
    public void onHostDestroy() {
        String method = "onHostDestroy()";
        this.log("onHostDestroy()");
        this.moveToHostDestroy(this.getCurrentReactContext());
    }

    @Override
    @ThreadConfined(value="UI")
    public void onHostDestroy(@Nullable Activity activity) {
        String method = "onHostDestroy(activity)";
        this.log("onHostDestroy(activity)");
        Activity currentActivity = this.getCurrentActivity();
        if (currentActivity == activity) {
            this.moveToHostDestroy(this.getCurrentReactContext());
        }
    }

    @Override
    @Nullable
    public ReactContext getCurrentReactContext() {
        return this.mBridgelessReactContextRef.getNullable();
    }

    @Override
    public DevSupportManager getDevSupportManager() {
        return (DevSupportManager)Assertions.assertNotNull((Object)this.mDevSupportManager);
    }

    @Override
    public ReactSurface createSurface(Context context, String moduleName, @Nullable Bundle initialProps) {
        ReactSurfaceImpl surface = new ReactSurfaceImpl(context, moduleName, initialProps);
        surface.attachView(new ReactSurfaceView(context, surface));
        surface.attach(this);
        return surface;
    }

    public MemoryPressureRouter getMemoryPressureRouter() {
        return this.mMemoryPressureRouter;
    }

    boolean isInstanceInitialized() {
        ReactInstance reactInstance = this.mReactInstanceTaskRef.get().getResult();
        return reactInstance != null;
    }

    @Override
    @ThreadConfined(value="UI")
    public boolean onBackPressed() {
        UiThreadUtil.assertOnUiThread();
        ReactInstance reactInstance = this.mReactInstanceTaskRef.get().getResult();
        if (reactInstance == null) {
            return false;
        }
        DeviceEventManagerModule deviceEventManagerModule = reactInstance.getNativeModule(DeviceEventManagerModule.class);
        if (deviceEventManagerModule == null) {
            return false;
        }
        deviceEventManagerModule.emitHardwareBackPressed();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public ReactQueueConfiguration getReactQueueConfiguration() {
        BridgelessAtomicRef<Task<ReactInstance>> bridgelessAtomicRef = this.mReactInstanceTaskRef;
        synchronized (bridgelessAtomicRef) {
            Task<ReactInstance> task = this.mReactInstanceTaskRef.get();
            if (!task.isFaulted() && !task.isCancelled() && task.getResult() != null) {
                return task.getResult().getReactQueueConfiguration();
            }
        }
        return null;
    }

    public void addReactInstanceEventListener(ReactInstanceEventListener listener) {
        this.mReactInstanceEventListeners.add(listener);
    }

    public void removeReactInstanceEventListener(ReactInstanceEventListener listener) {
        this.mReactInstanceEventListeners.remove(listener);
    }

    @Override
    public TaskInterface<Void> reload(String reason) {
        String method = "reload()";
        if (ReactFeatureFlags.enableBridgelessArchitectureNewCreateReloadDestroy) {
            return Task.call(() -> {
                Task<Void> reloadTask = null;
                if (this.mDestroyTask != null) {
                    this.log("reload()", "Waiting for destroy to finish, before reloading React Native.");
                    reloadTask = this.mDestroyTask.continueWithTask(task -> this.newGetOrCreateReloadTask(reason), this.mBGExecutor).makeVoid();
                } else {
                    reloadTask = this.newGetOrCreateReloadTask(reason).makeVoid();
                }
                return reloadTask.continueWithTask(task -> {
                    if (task.isFaulted()) {
                        this.mReactHostDelegate.handleInstanceException(task.getError());
                        return this.newGetOrCreateDestroyTask("Reload failed", task.getError());
                    }
                    return task;
                }, this.mBGExecutor);
            }, this.mBGExecutor).continueWithTask(Task::getResult);
        }
        return this.oldReload(reason);
    }

    @Override
    public TaskInterface<Void> destroy(String reason, @Nullable Exception ex) {
        String method = "destroy()";
        if (ReactFeatureFlags.enableBridgelessArchitectureNewCreateReloadDestroy) {
            return Task.call(() -> {
                if (this.mReloadTask != null) {
                    this.log("destroy()", "Reloading React Native. Waiting for reload to finish before destroying React Native.");
                    return this.mReloadTask.continueWithTask(task -> this.newGetOrCreateDestroyTask(reason, ex), this.mBGExecutor);
                }
                return this.newGetOrCreateDestroyTask(reason, ex);
            }, this.mBGExecutor).continueWithTask(Task::getResult);
        }
        this.oldDestroy(reason, ex);
        return Task.forResult((Void)Assertions.nullsafeFIXME(null, (String)"Empty Destroy Task"));
    }

    private MemoryPressureListener createMemoryPressureListener(ReactInstance reactInstance) {
        WeakReference<ReactInstance> weakReactInstance = new WeakReference<ReactInstance>(reactInstance);
        return level -> this.mBGExecutor.execute(() -> {
            ReactInstance strongReactInstance = (ReactInstance)weakReactInstance.get();
            if (strongReactInstance != null) {
                strongReactInstance.handleMemoryPressure(level);
            }
        });
    }

    @Nullable
    Activity getCurrentActivity() {
        return this.mActivity.get();
    }

    @Nullable
    Activity getLastUsedActivity() {
        WeakReference<Activity> lastUsedActivityWeakRef = this.mLastUsedActivity.get();
        if (lastUsedActivityWeakRef != null) {
            return (Activity)lastUsedActivityWeakRef.get();
        }
        return null;
    }

    private void setCurrentActivity(@Nullable Activity activity) {
        this.mActivity.set(activity);
        if (activity != null) {
            this.mLastUsedActivity.set(new WeakReference<Activity>(activity));
        }
    }

    EventDispatcher getEventDispatcher() {
        ReactInstance reactInstance = this.mReactInstanceTaskRef.get().getResult();
        if (reactInstance == null) {
            return BlackHoleEventDispatcher.get();
        }
        return reactInstance.getEventDispatcher();
    }

    @Nullable
    FabricUIManager getUIManager() {
        ReactInstance reactInstance = this.mReactInstanceTaskRef.get().getResult();
        if (reactInstance == null) {
            return null;
        }
        return reactInstance.getUIManager();
    }

    <T extends NativeModule> boolean hasNativeModule(Class<T> nativeModuleInterface) {
        ReactInstance reactInstance = this.mReactInstanceTaskRef.get().getResult();
        if (reactInstance != null) {
            return reactInstance.hasNativeModule(nativeModuleInterface);
        }
        return false;
    }

    Collection<NativeModule> getNativeModules() {
        ReactInstance reactInstance = this.mReactInstanceTaskRef.get().getResult();
        if (reactInstance != null) {
            return reactInstance.getNativeModules();
        }
        return new ArrayList<NativeModule>();
    }

    @Nullable
    <T extends NativeModule> T getNativeModule(Class<T> nativeModuleInterface) {
        ReactInstance reactInstance;
        if (nativeModuleInterface == UIManagerModule.class) {
            ReactSoftExceptionLogger.logSoftExceptionVerbose(TAG, new ReactNoCrashBridgeNotAllowedSoftException("getNativeModule(UIManagerModule.class) cannot be called when the bridge is disabled"));
        }
        if ((reactInstance = this.mReactInstanceTaskRef.get().getResult()) != null) {
            return reactInstance.getNativeModule(nativeModuleInterface);
        }
        return null;
    }

    DefaultHardwareBackBtnHandler getDefaultBackButtonHandler() {
        return () -> {
            UiThreadUtil.assertOnUiThread();
            if (this.mDefaultHardwareBackBtnHandler != null) {
                this.mDefaultHardwareBackBtnHandler.invokeDefaultOnBackPressed();
            }
        };
    }

    Task<Boolean> loadBundle(JSBundleLoader bundleLoader) {
        String method = "loadBundle()";
        this.log("loadBundle()", "Schedule");
        return this.callWithExistingReactInstance("loadBundle()", reactInstance -> {
            this.log("loadBundle()", "Execute");
            reactInstance.loadJSBundle(bundleLoader);
        });
    }

    Task<Boolean> registerSegment(int segmentId, String path, Callback callback) {
        String method = "registerSegment(segmentId = \"" + segmentId + "\", path = \"" + path + "\")";
        this.log(method, "Schedule");
        return this.callWithExistingReactInstance(method, reactInstance -> {
            this.log(method, "Execute");
            reactInstance.registerSegment(segmentId, path);
            ((Callback)Assertions.assertNotNull((Object)callback)).invoke(new Object[0]);
        });
    }

    void handleHostException(Exception e) {
        String method = "handleHostException(message = \"" + e.getMessage() + "\")";
        this.log(method);
        if (DEV) {
            this.mDevSupportManager.handleException(e);
        }
        this.destroy(method, e);
        this.mReactHostDelegate.handleInstanceException(e);
    }

    Task<Boolean> callFunctionOnModule(String moduleName, String methodName, NativeArray args) {
        String method = "callFunctionOnModule(\"" + moduleName + "\", \"" + methodName + "\")";
        return this.callWithExistingReactInstance(method, reactInstance -> reactInstance.callFunctionOnModule(moduleName, methodName, args));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void attachSurface(ReactSurfaceImpl surface) {
        String method = "attachSurface(surfaceId = " + surface.getSurfaceID() + ")";
        this.log(method);
        Set<ReactSurfaceImpl> set = this.mAttachedSurfaces;
        synchronized (set) {
            this.mAttachedSurfaces.add(surface);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void detachSurface(ReactSurfaceImpl surface) {
        String method = "detachSurface(surfaceId = " + surface.getSurfaceID() + ")";
        this.log(method);
        Set<ReactSurfaceImpl> set = this.mAttachedSurfaces;
        synchronized (set) {
            this.mAttachedSurfaces.remove(surface);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isSurfaceAttached(ReactSurfaceImpl surface) {
        Set<ReactSurfaceImpl> set = this.mAttachedSurfaces;
        synchronized (set) {
            return this.mAttachedSurfaces.contains(surface);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isSurfaceWithModuleNameAttached(String moduleName) {
        Set<ReactSurfaceImpl> set = this.mAttachedSurfaces;
        synchronized (set) {
            for (ReactSurfaceImpl surface : this.mAttachedSurfaces) {
                if (!surface.getModuleName().equals(moduleName)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBeforeDestroyListener(@NonNull Function0<Unit> onBeforeDestroy) {
        Set<Function0<Unit>> set = this.mBeforeDestroyListeners;
        synchronized (set) {
            this.mBeforeDestroyListeners.add(onBeforeDestroy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeBeforeDestroyListener(@NonNull Function0<Unit> onBeforeDestroy) {
        Set<Function0<Unit>> set = this.mBeforeDestroyListeners;
        synchronized (set) {
            this.mBeforeDestroyListeners.remove(onBeforeDestroy);
        }
    }

    private Task<Void> oldStart() {
        String method = "oldStart()";
        return Task.call(() -> {
            if (this.mStartTask == null) {
                this.log("oldStart()", "Schedule");
                this.mStartTask = this.getOrCreateReactInstanceTask().continueWithTask(task -> {
                    if (task.isFaulted()) {
                        this.destroy("oldStart() failure: " + task.getError().getMessage(), task.getError());
                        this.mReactHostDelegate.handleInstanceException(task.getError());
                    }
                    return task;
                }, this.mBGExecutor).makeVoid();
            }
            return this.mStartTask;
        }, this.mBGExecutor).continueWithTask(Task::getResult);
    }

    private Task<Void> newStart() {
        String method = "newStart()";
        return Task.call(() -> {
            if (this.mStartTask == null) {
                this.log("newStart()", "Schedule");
                this.mStartTask = this.waitThenCallNewGetOrCreateReactInstanceTask().continueWithTask(task -> {
                    if (task.isFaulted()) {
                        this.mReactHostDelegate.handleInstanceException(task.getError());
                        return this.newGetOrCreateDestroyTask("newStart() failure: " + task.getError().getMessage(), task.getError()).continueWithTask(destroyTask -> Task.forError(task.getError())).makeVoid();
                    }
                    return task.makeVoid();
                }, this.mBGExecutor);
            }
            return this.mStartTask;
        }, this.mBGExecutor).continueWithTask(Task::getResult);
    }

    @ThreadConfined(value="UI")
    private void moveToHostDestroy(@Nullable ReactContext currentContext) {
        this.mReactLifecycleStateManager.moveToOnHostDestroy(currentContext);
        this.setCurrentActivity(null);
    }

    private void raiseSoftException(String method, String message) {
        this.raiseSoftException(method, message, null);
    }

    private void raiseSoftException(String method, String message, @Nullable Throwable throwable) {
        this.log(method, message);
        if (ReactFeatureFlags.enableBridgelessArchitectureSoftExceptions) {
            if (throwable != null) {
                ReactSoftExceptionLogger.logSoftException(TAG, new ReactNoCrashSoftException(method + ": " + message, throwable));
                return;
            }
            ReactSoftExceptionLogger.logSoftException(TAG, new ReactNoCrashSoftException(method + ": " + message));
        }
    }

    private Task<Boolean> callWithExistingReactInstance(String callingMethod, VeniceThenable<ReactInstance> continuation) {
        String method = "callWithExistingReactInstance(" + callingMethod + ")";
        return this.mReactInstanceTaskRef.get().onSuccess(task -> {
            ReactInstance reactInstance = (ReactInstance)task.getResult();
            if (reactInstance == null) {
                this.raiseSoftException(method, "Execute: ReactInstance null. Dropping work.");
                return Boolean.FALSE;
            }
            continuation.then(reactInstance);
            return Boolean.TRUE;
        }, this.mBGExecutor);
    }

    private Task<Void> callAfterGetOrCreateReactInstance(String callingMethod, VeniceThenable<ReactInstance> runnable) {
        String method = "callAfterGetOrCreateReactInstance(" + callingMethod + ")";
        return this.getOrCreateReactInstanceTask().onSuccess(task -> {
            ReactInstance reactInstance = (ReactInstance)task.getResult();
            if (reactInstance == null) {
                this.raiseSoftException(method, "Execute: ReactInstance is null");
                return null;
            }
            runnable.then(reactInstance);
            return null;
        }, this.mBGExecutor).continueWith(task -> {
            if (task.isFaulted()) {
                this.handleHostException(task.getError());
            }
            return null;
        }, this.mBGExecutor);
    }

    private BridgelessReactContext getOrCreateReactContext() {
        String method = "getOrCreateReactContext()";
        return this.mBridgelessReactContextRef.getOrCreate(() -> {
            this.log("getOrCreateReactContext()", "Creating BridgelessReactContext");
            return new BridgelessReactContext(this.mContext, this);
        });
    }

    private Task<ReactInstance> getOrCreateReactInstanceTask() {
        if (ReactFeatureFlags.enableBridgelessArchitectureNewCreateReloadDestroy) {
            return Task.call(this::waitThenCallNewGetOrCreateReactInstanceTask, this.mBGExecutor).continueWithTask(Task::getResult);
        }
        return this.oldGetOrCreateReactInstanceTask();
    }

    @ThreadConfined(value="ReactHost")
    private Task<ReactInstance> waitThenCallNewGetOrCreateReactInstanceTask() {
        return this.waitThenCallNewGetOrCreateReactInstanceTaskWithRetries(0, 4);
    }

    @ThreadConfined(value="ReactHost")
    private Task<ReactInstance> waitThenCallNewGetOrCreateReactInstanceTaskWithRetries(int tryNum, int maxTries) {
        String method = "waitThenCallNewGetOrCreateReactInstanceTaskWithRetries";
        if (this.mReloadTask != null) {
            this.log("waitThenCallNewGetOrCreateReactInstanceTaskWithRetries", "React Native is reloading. Return reload task.");
            return this.mReloadTask;
        }
        if (this.mDestroyTask != null) {
            boolean shouldTryAgain;
            boolean bl = shouldTryAgain = tryNum < maxTries;
            if (shouldTryAgain) {
                this.log("waitThenCallNewGetOrCreateReactInstanceTaskWithRetries", "React Native is tearing down.Wait for teardown to finish, before trying again (try count = " + tryNum + ").");
                return this.mDestroyTask.onSuccessTask(task -> this.waitThenCallNewGetOrCreateReactInstanceTaskWithRetries(tryNum + 1, maxTries), this.mBGExecutor);
            }
            this.raiseSoftException("waitThenCallNewGetOrCreateReactInstanceTaskWithRetries", "React Native is tearing down. Not wait for teardown to finish: reached max retries.");
        }
        return this.newGetOrCreateReactInstanceTask();
    }

    @ThreadConfined(value="ReactHost")
    private Task<ReactInstance> newGetOrCreateReactInstanceTask() {
        String method = "newGetOrCreateReactInstanceTask()";
        this.log("newGetOrCreateReactInstanceTask()");
        return this.mReactInstanceTaskRef.getOrCreate(() -> {
            class Result {
                final ReactInstance mInstance;
                final ReactContext mContext;
                final boolean mIsReloading;

                Result() {
                    this.mInstance = instance;
                    this.mContext = reactContext;
                    this.mIsReloading = ReactHostImpl.this.mReloadTask != null;
                }
            }
            this.log("newGetOrCreateReactInstanceTask()", "Start");
            ReactMarker.logMarker(ReactMarkerConstants.REACT_BRIDGELESS_LOADING_START, 1);
            return this.getJsBundleLoader().onSuccess(task -> {
                JSBundleLoader bundleLoader = (JSBundleLoader)task.getResult();
                final BridgelessReactContext reactContext = this.getOrCreateReactContext();
                DevSupportManager devSupportManager = this.getDevSupportManager();
                reactContext.setJSExceptionHandler(devSupportManager);
                this.log("newGetOrCreateReactInstanceTask()", "Creating ReactInstance");
                final ReactInstance instance = new ReactInstance(reactContext, this.mReactHostDelegate, this.mComponentFactory, devSupportManager, this.mQueueThreadExceptionHandler, this.mReactJsExceptionHandler, this.mUseDevSupport);
                if (ReactFeatureFlags.unstable_bridgelessArchitectureMemoryPressureHackyBoltsFix) {
                    this.mMemoryPressureListener = this.createMemoryPressureListener(instance);
                }
                this.mMemoryPressureRouter.addMemoryPressureListener(this.mMemoryPressureListener);
                this.log("newGetOrCreateReactInstanceTask()", "Loading JS Bundle");
                instance.loadJSBundle(bundleLoader);
                this.log("newGetOrCreateReactInstanceTask()", "Calling DevSupportManagerBase.onNewReactContextCreated(reactContext)");
                devSupportManager.onNewReactContextCreated(reactContext);
                reactContext.runOnJSQueueThread(() -> ReactMarker.logMarker(ReactMarkerConstants.REACT_BRIDGELESS_LOADING_END, 1));
                return new Result();
            }, this.mBGExecutor).onSuccess(task -> {
                boolean isManagerResumed;
                ReactInstance reactInstance = ((Result)task.getResult()).mInstance;
                ReactContext reactContext = ((Result)task.getResult()).mContext;
                boolean isReloading = ((Result)task.getResult()).mIsReloading;
                boolean bl = isManagerResumed = this.mReactLifecycleStateManager.getLifecycleState() == LifecycleState.RESUMED;
                if (isReloading && !isManagerResumed) {
                    this.mReactLifecycleStateManager.moveToOnHostResume(reactContext, this.getCurrentActivity());
                } else {
                    this.mReactLifecycleStateManager.resumeReactContextIfHostResumed(reactContext, this.getCurrentActivity());
                }
                ReactInstanceEventListener[] listeners = new ReactInstanceEventListener[this.mReactInstanceEventListeners.size()];
                ReactInstanceEventListener[] finalListeners = this.mReactInstanceEventListeners.toArray(listeners);
                this.log("newGetOrCreateReactInstanceTask()", "Executing ReactInstanceEventListeners");
                for (ReactInstanceEventListener listener : finalListeners) {
                    if (listener == null) continue;
                    listener.onReactContextInitialized(reactContext);
                }
                return reactInstance;
            }, this.mUIExecutor);
        });
    }

    private Task<ReactInstance> oldGetOrCreateReactInstanceTask() {
        String method = "oldGetOrCreateReactInstanceTask()";
        this.log("oldGetOrCreateReactInstanceTask()");
        return this.mReactInstanceTaskRef.getOrCreate(() -> {
            this.log("oldGetOrCreateReactInstanceTask()", "Start");
            ReactMarker.logMarker(ReactMarkerConstants.REACT_BRIDGELESS_LOADING_START, 1);
            BridgelessReactContext reactContext = this.getOrCreateReactContext();
            DevSupportManager devSupportManager = this.getDevSupportManager();
            reactContext.setJSExceptionHandler(devSupportManager);
            return this.getJsBundleLoader().onSuccess(task -> {
                JSBundleLoader bundleLoader = (JSBundleLoader)task.getResult();
                this.log("oldGetOrCreateReactInstanceTask()", "Creating ReactInstance");
                ReactInstance instance = new ReactInstance(reactContext, this.mReactHostDelegate, this.mComponentFactory, devSupportManager, this.mQueueThreadExceptionHandler, this.mReactJsExceptionHandler, this.mUseDevSupport);
                if (ReactFeatureFlags.unstable_bridgelessArchitectureMemoryPressureHackyBoltsFix) {
                    this.mMemoryPressureListener = this.createMemoryPressureListener(instance);
                }
                this.mMemoryPressureRouter.addMemoryPressureListener(this.mMemoryPressureListener);
                this.log("oldGetOrCreateReactInstanceTask()", "Loading JS Bundle");
                instance.loadJSBundle(bundleLoader);
                this.log("oldGetOrCreateReactInstanceTask()", "Calling DevSupportManagerBase.onNewReactContextCreated(reactContext)");
                devSupportManager.onNewReactContextCreated(reactContext);
                reactContext.runOnJSQueueThread(() -> ReactMarker.logMarker(ReactMarkerConstants.REACT_BRIDGELESS_LOADING_END, 1));
                return instance;
            }, this.mBGExecutor).onSuccess(task -> {
                this.mReactLifecycleStateManager.resumeReactContextIfHostResumed(reactContext, this.getCurrentActivity());
                ReactInstanceEventListener[] listeners = new ReactInstanceEventListener[this.mReactInstanceEventListeners.size()];
                ReactInstanceEventListener[] finalListeners = this.mReactInstanceEventListeners.toArray(listeners);
                this.log("oldGetOrCreateReactInstanceTask()", "Executing ReactInstanceEventListeners");
                for (ReactInstanceEventListener listener : finalListeners) {
                    if (listener == null) continue;
                    listener.onReactContextInitialized(reactContext);
                }
                return (ReactInstance)task.getResult();
            }, this.mUIExecutor);
        });
    }

    private Task<JSBundleLoader> getJsBundleLoader() {
        String method = "getJSBundleLoader()";
        this.log("getJSBundleLoader()");
        if (DEV && this.mAllowPackagerServerAccess) {
            return this.isMetroRunning().onSuccessTask(task -> {
                boolean isMetroRunning = (Boolean)task.getResult();
                if (isMetroRunning) {
                    return this.loadJSBundleFromMetro();
                }
                return Task.forResult(this.mReactHostDelegate.getJsBundleLoader());
            }, this.mBGExecutor);
        }
        if (DEV) {
            FLog.d((String)TAG, (String)"Packager server access is disabled in this environment");
        }
        return Task.call(() -> this.mReactHostDelegate.getJsBundleLoader());
    }

    private Task<Boolean> isMetroRunning() {
        String method = "isMetroRunning()";
        this.log("isMetroRunning()");
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        DevSupportManager asyncDevSupportManager = this.getDevSupportManager();
        asyncDevSupportManager.isPackagerRunning(packagerIsRunning -> {
            this.log("isMetroRunning()", "Async result = " + packagerIsRunning);
            taskCompletionSource.setResult(packagerIsRunning);
        });
        return taskCompletionSource.getTask();
    }

    private Task<JSBundleLoader> loadJSBundleFromMetro() {
        String method = "loadJSBundleFromMetro()";
        this.log("loadJSBundleFromMetro()");
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        DevSupportManagerBase asyncDevSupportManager = (DevSupportManagerBase)this.getDevSupportManager();
        String bundleURL = asyncDevSupportManager.getDevServerHelper().getDevServerBundleURL((String)Assertions.assertNotNull((Object)asyncDevSupportManager.getJSAppBundleName()));
        asyncDevSupportManager.reloadJSFromServer(bundleURL, () -> {
            this.log("loadJSBundleFromMetro()", "Creating BundleLoader");
            JSBundleLoader bundleLoader = JSBundleLoader.createCachedBundleFromNetworkLoader(bundleURL, asyncDevSupportManager.getDownloadedJSBundleFile());
            taskCompletionSource.setResult(bundleLoader);
        });
        return taskCompletionSource.getTask();
    }

    private void log(String method, String message) {
        this.mBridgelessReactStateTracker.enterState("ReactHost{" + this.mId + "}." + method + ": " + message);
    }

    private void log(String method) {
        this.mBridgelessReactStateTracker.enterState("ReactHost{" + this.mId + "}." + method);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopAttachedSurfaces(String method, ReactInstance reactInstance) {
        this.log(method, "Stopping all React Native surfaces");
        Set<ReactSurfaceImpl> set = this.mAttachedSurfaces;
        synchronized (set) {
            for (ReactSurfaceImpl surface : this.mAttachedSurfaces) {
                reactInstance.stopSurface(surface);
                surface.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startAttachedSurfaces(String method, ReactInstance reactInstance) {
        this.log(method, "Restarting previously running React Native Surfaces");
        Set<ReactSurfaceImpl> set = this.mAttachedSurfaces;
        synchronized (set) {
            for (ReactSurfaceImpl surface : this.mAttachedSurfaces) {
                reactInstance.startSurface(surface);
            }
        }
    }

    private ReactInstanceTaskUnwrapper createReactInstanceUnwraper(String tag, String method, String reason) {
        return (task, stage) -> {
            ReactInstance reactInstance = (ReactInstance)task.getResult();
            ReactInstance currentReactInstance = this.mReactInstanceTaskRef.get().getResult();
            String stageLabel = "Stage: " + stage;
            String reasonLabel = tag + " reason: " + reason;
            if (task.isFaulted()) {
                Exception ex = task.getError();
                String faultLabel = "Fault reason: " + ex.getMessage();
                this.raiseSoftException(method, tag + ": ReactInstance task faulted. " + stageLabel + ". " + faultLabel + ". " + reasonLabel);
                return currentReactInstance;
            }
            if (task.isCancelled()) {
                this.raiseSoftException(method, tag + ": ReactInstance task cancelled. " + stageLabel + ". " + reasonLabel);
                return currentReactInstance;
            }
            if (reactInstance == null) {
                this.raiseSoftException(method, tag + ": ReactInstance task returned null. " + stageLabel + ". " + reasonLabel);
                return currentReactInstance;
            }
            if (currentReactInstance != null && reactInstance != currentReactInstance) {
                this.raiseSoftException(method, tag + ": Detected two different ReactInstances. Returning old. " + stageLabel + ". " + reasonLabel);
            }
            return reactInstance;
        };
    }

    @ThreadConfined(value="ReactHost")
    private Task<ReactInstance> newGetOrCreateReloadTask(String reason) {
        String method = "newGetOrCreateReloadTask()";
        this.log("newGetOrCreateReloadTask()");
        this.raiseSoftException("newGetOrCreateReloadTask()", reason);
        ReactInstanceTaskUnwrapper reactInstanceTaskUnwrapper = this.createReactInstanceUnwraper("Reload", "newGetOrCreateReloadTask()", reason);
        if (this.mReloadTask == null) {
            this.mReloadTask = this.mReactInstanceTaskRef.get().continueWithTask(task -> {
                this.log("newGetOrCreateReloadTask()", "Starting React Native reload");
                ReactInstance reactInstance = reactInstanceTaskUnwrapper.unwrap(task, "1: Starting reload");
                ReactContext reactContext = this.mBridgelessReactContextRef.getNullable();
                if (reactContext == null) {
                    this.raiseSoftException("newGetOrCreateReloadTask()", "ReactContext is null. Reload reason: " + reason);
                }
                if (reactContext != null && this.mReactLifecycleStateManager.getLifecycleState() == LifecycleState.RESUMED) {
                    this.log("newGetOrCreateReloadTask()", "Calling ReactContext.onHostPause()");
                    reactContext.onHostPause();
                }
                return Task.forResult(reactInstance);
            }, this.mUIExecutor).continueWithTask(task -> {
                ReactInstance reactInstance = reactInstanceTaskUnwrapper.unwrap(task, "2: Surface shutdown");
                if (reactInstance == null) {
                    this.raiseSoftException("newGetOrCreateReloadTask()", "Skipping surface shutdown: ReactInstance null");
                    return task;
                }
                this.stopAttachedSurfaces("newGetOrCreateReloadTask()", reactInstance);
                return task;
            }, this.mBGExecutor).continueWithTask(task -> {
                HashSet<Function0<Unit>> beforeDestroyListeners;
                reactInstanceTaskUnwrapper.unwrap(task, "3: Executing Before Destroy Listeners");
                Set<Function0<Unit>> set = this.mBeforeDestroyListeners;
                synchronized (set) {
                    beforeDestroyListeners = new HashSet<Function0<Unit>>(this.mBeforeDestroyListeners);
                }
                for (Function0 function0 : beforeDestroyListeners) {
                    function0.invoke();
                }
                return task;
            }, this.mUIExecutor).continueWithTask(task -> {
                reactInstanceTaskUnwrapper.unwrap(task, "4: Destroying ReactContext");
                this.log("newGetOrCreateReloadTask()", "Removing memory pressure listener");
                this.mMemoryPressureRouter.removeMemoryPressureListener(this.mMemoryPressureListener);
                ReactContext reactContext = this.mBridgelessReactContextRef.getNullable();
                if (reactContext != null) {
                    this.log("newGetOrCreateReloadTask()", "Destroying ReactContext");
                    reactContext.destroy();
                }
                if (this.mUseDevSupport && reactContext != null) {
                    this.log("newGetOrCreateReloadTask()", "Calling DevSupportManager.onReactInstanceDestroyed(reactContext)");
                    this.mDevSupportManager.onReactInstanceDestroyed(reactContext);
                }
                return task;
            }, this.mUIExecutor).continueWithTask(task -> {
                ReactInstance reactInstance = reactInstanceTaskUnwrapper.unwrap(task, "5: Destroying ReactInstance");
                if (reactInstance == null) {
                    this.raiseSoftException("newGetOrCreateReloadTask()", "Skipping ReactInstance.destroy(): ReactInstance null");
                } else {
                    this.log("newGetOrCreateReloadTask()", "Destroying ReactInstance");
                    reactInstance.destroy();
                }
                this.log("newGetOrCreateReloadTask()", "Resetting ReactContext ref");
                this.mBridgelessReactContextRef.reset();
                this.log("newGetOrCreateReloadTask()", "Resetting ReactInstance task ref");
                this.mReactInstanceTaskRef.reset();
                this.log("newGetOrCreateReloadTask()", "Resetting preload task ref");
                this.mStartTask = null;
                return this.newGetOrCreateReactInstanceTask();
            }, this.mBGExecutor).continueWithTask(task -> {
                ReactInstance reactInstance = reactInstanceTaskUnwrapper.unwrap(task, "7: Restarting surfaces");
                if (reactInstance == null) {
                    this.raiseSoftException("newGetOrCreateReloadTask()", "Skipping surface restart: ReactInstance null");
                    return task;
                }
                this.startAttachedSurfaces("newGetOrCreateReloadTask()", reactInstance);
                return task;
            }, this.mBGExecutor).continueWithTask(task -> {
                if (task.isFaulted()) {
                    Exception fault = task.getError();
                    this.raiseSoftException("newGetOrCreateReloadTask()", "Error during reload. ReactInstance task faulted. Fault reason: " + fault.getMessage() + ". Reload reason: " + reason, task.getError());
                }
                if (task.isCancelled()) {
                    this.raiseSoftException("newGetOrCreateReloadTask()", "Error during reload. ReactInstance task cancelled. Reload reason: " + reason);
                }
                this.log("newGetOrCreateReloadTask()", "Resetting reload task ref");
                this.mReloadTask = null;
                return task;
            }, this.mBGExecutor);
        }
        return this.mReloadTask;
    }

    @ThreadConfined(value="ReactHost")
    private Task<Void> newGetOrCreateDestroyTask(String reason, @Nullable Exception ex) {
        String method = "newGetOrCreateDestroyTask()";
        this.log("newGetOrCreateDestroyTask()");
        this.raiseSoftException("newGetOrCreateDestroyTask()", reason, ex);
        ReactInstanceTaskUnwrapper reactInstanceTaskUnwrapper = this.createReactInstanceUnwraper("Destroy", "newGetOrCreateDestroyTask()", reason);
        if (this.mDestroyTask == null) {
            this.mDestroyTask = this.mReactInstanceTaskRef.get().continueWithTask(task -> {
                ReactContext reactContext;
                this.log("newGetOrCreateDestroyTask()", "Starting React Native destruction");
                ReactInstance reactInstance = reactInstanceTaskUnwrapper.unwrap(task, "1: Starting destroy");
                if (this.mUseDevSupport) {
                    this.log("newGetOrCreateDestroyTask()", "DevSupportManager cleanup");
                    this.mDevSupportManager.stopInspector();
                }
                if ((reactContext = (ReactContext)this.mBridgelessReactContextRef.getNullable()) == null) {
                    this.raiseSoftException("newGetOrCreateDestroyTask()", "ReactContext is null. Destroy reason: " + reason);
                }
                this.log("newGetOrCreateDestroyTask()", "Move ReactHost to onHostDestroy()");
                this.mReactLifecycleStateManager.moveToOnHostDestroy(reactContext);
                return Task.forResult(reactInstance);
            }, this.mUIExecutor).continueWithTask(task -> {
                ReactInstance reactInstance = reactInstanceTaskUnwrapper.unwrap(task, "2: Stopping surfaces");
                if (reactInstance == null) {
                    this.raiseSoftException("newGetOrCreateDestroyTask()", "Skipping surface shutdown: ReactInstance null");
                    return task;
                }
                this.stopAttachedSurfaces("newGetOrCreateDestroyTask()", reactInstance);
                return task;
            }, this.mBGExecutor).continueWithTask(task -> {
                HashSet<Function0<Unit>> beforeDestroyListeners;
                reactInstanceTaskUnwrapper.unwrap(task, "3: Executing Before Destroy Listeners");
                Set<Function0<Unit>> set = this.mBeforeDestroyListeners;
                synchronized (set) {
                    beforeDestroyListeners = new HashSet<Function0<Unit>>(this.mBeforeDestroyListeners);
                }
                for (Function0 function0 : beforeDestroyListeners) {
                    function0.invoke();
                }
                return task;
            }, this.mUIExecutor).continueWithTask(task -> {
                reactInstanceTaskUnwrapper.unwrap(task, "4: Destroying ReactContext");
                ReactContext reactContext = this.mBridgelessReactContextRef.getNullable();
                if (reactContext == null) {
                    this.raiseSoftException("newGetOrCreateDestroyTask()", "ReactContext is null. Destroy reason: " + reason);
                }
                this.log("newGetOrCreateDestroyTask()", "Destroying MemoryPressureRouter");
                this.mMemoryPressureRouter.destroy(this.mContext);
                if (reactContext != null) {
                    this.log("newGetOrCreateDestroyTask()", "Destroying ReactContext");
                    reactContext.destroy();
                }
                this.setCurrentActivity(null);
                ResourceDrawableIdHelper.getInstance().clear();
                return task;
            }, this.mUIExecutor).continueWithTask(task -> {
                ReactInstance reactInstance = reactInstanceTaskUnwrapper.unwrap(task, "5: Destroying ReactInstance");
                if (reactInstance == null) {
                    this.raiseSoftException("newGetOrCreateDestroyTask()", "Skipping ReactInstance.destroy(): ReactInstance null");
                } else {
                    this.log("newGetOrCreateDestroyTask()", "Destroying ReactInstance");
                    reactInstance.destroy();
                }
                this.log("newGetOrCreateDestroyTask()", "Resetting ReactContext ref ");
                this.mBridgelessReactContextRef.reset();
                this.log("newGetOrCreateDestroyTask()", "Resetting ReactInstance task ref");
                this.mReactInstanceTaskRef.reset();
                this.log("newGetOrCreateDestroyTask()", "Resetting Preload task ref");
                this.mStartTask = null;
                this.log("newGetOrCreateDestroyTask()", "Resetting destroy task ref");
                this.mDestroyTask = null;
                return task;
            }, this.mBGExecutor).continueWith(task -> {
                if (task.isFaulted()) {
                    Exception fault = task.getError();
                    this.raiseSoftException("newGetOrCreateDestroyTask()", "React destruction failed. ReactInstance task faulted. Fault reason: " + fault.getMessage() + ". Destroy reason: " + reason, task.getError());
                }
                if (task.isCancelled()) {
                    this.raiseSoftException("newGetOrCreateDestroyTask()", "React destruction failed. ReactInstance task cancelled. Destroy reason: " + reason);
                }
                return null;
            });
        }
        return this.mDestroyTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Task<Void> oldReload(String reason) {
        String method = "oldReload()";
        this.log("oldReload()");
        this.raiseSoftException("oldReload()", reason);
        BridgelessAtomicRef<Task<ReactInstance>> bridgelessAtomicRef = this.mReactInstanceTaskRef;
        synchronized (bridgelessAtomicRef) {
            this.mMemoryPressureRouter.removeMemoryPressureListener(this.mMemoryPressureListener);
            this.oldDestroyReactInstanceAndContext("oldReload()", reason);
            return this.callAfterGetOrCreateReactInstance("oldReload()", reactInstance -> {
                this.log("oldReload()", "Restarting Surfaces");
                Set<ReactSurfaceImpl> set = this.mAttachedSurfaces;
                synchronized (set) {
                    for (ReactSurfaceImpl surface : this.mAttachedSurfaces) {
                        reactInstance.startSurface(surface);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void oldDestroy(String reason, @Nullable Exception ex) {
        String method = "oldDestroy()";
        this.log("oldDestroy()");
        this.raiseSoftException("oldDestroy()", reason, ex);
        BridgelessAtomicRef<Task<ReactInstance>> bridgelessAtomicRef = this.mReactInstanceTaskRef;
        synchronized (bridgelessAtomicRef) {
            ReactInstance reactInstance = this.mReactInstanceTaskRef.get().getResult();
            if (reactInstance == null) {
                return;
            }
            ReactContext reactContext = this.getCurrentReactContext();
            if (reactContext != null) {
                this.mMemoryPressureRouter.destroy((Context)reactContext);
            }
            this.oldDestroyReactInstanceAndContext("oldDestroy()", reason);
            this.log("oldDestroy()", "Clearing attached surfaces");
            Set<ReactSurfaceImpl> set = this.mAttachedSurfaces;
            synchronized (set) {
                this.mAttachedSurfaces.clear();
            }
            Task.call(() -> {
                this.moveToHostDestroy(reactContext);
                return null;
            }, this.mUIExecutor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void oldDestroyReactInstanceAndContext(String callingMethod, String reason) {
        String method = "oldDestroyReactInstanceAndContext(" + callingMethod + ")";
        this.log(method);
        BridgelessAtomicRef<Task<ReactInstance>> bridgelessAtomicRef = this.mReactInstanceTaskRef;
        synchronized (bridgelessAtomicRef) {
            Task<ReactInstance> task = this.mReactInstanceTaskRef.getAndReset();
            if (!task.isFaulted() && !task.isCancelled()) {
                ReactInstance instance = task.getResult();
                if (instance == null) {
                    this.log(method, "ReactInstance is null");
                    return;
                }
                this.log(method, "Stopping surfaces");
                Set<ReactSurfaceImpl> set = this.mAttachedSurfaces;
                synchronized (set) {
                    for (ReactSurfaceImpl surface : this.mAttachedSurfaces) {
                        instance.stopSurface(surface);
                        surface.clear();
                    }
                }
                ReactContext reactContext = this.getCurrentReactContext();
                if (reactContext != null) {
                    this.log(method, "DevSupportManager.onReactInstanceDestroyed()");
                    this.getDevSupportManager().onReactInstanceDestroyed(reactContext);
                    this.log(method, "Destroy ReactContext");
                    this.mBridgelessReactContextRef.reset();
                }
                this.mBGExecutor.execute(() -> {
                    this.log(method, "Destroy ReactInstance");
                    instance.destroy();
                    this.log(method, "Resetting Preload task ref");
                    this.mStartTask = null;
                });
            } else {
                this.raiseSoftException(method, "Not cleaning up ReactInstance: task.isFaulted() = " + task.isFaulted() + ", task.isCancelled() = " + task.isCancelled() + ". Reason: " + reason);
                this.mBGExecutor.execute(() -> {
                    this.log(method, "Resetting Preload task ref");
                    this.mStartTask = null;
                });
            }
        }
    }

    public void setJSEngineResolutionAlgorithm(@Nullable JSEngineResolutionAlgorithm jsEngineResolutionAlgorithm) {
        this.mJSEngineResolutionAlgorithm = jsEngineResolutionAlgorithm;
    }

    @Nullable
    public JSEngineResolutionAlgorithm getJSEngineResolutionAlgorithm() {
        return this.mJSEngineResolutionAlgorithm;
    }

    static interface VeniceThenable<T> {
        public void then(T var1);
    }

    private static interface ReactInstanceTaskUnwrapper {
        @Nullable
        public ReactInstance unwrap(Task<ReactInstance> var1, String var2);
    }
}

