/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.runtime;

import com.facebook.react.runtime.internal.bolts.CancellationTokenSource;
import com.facebook.react.runtime.internal.bolts.Task;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

class BoltsFutureTask<T>
implements Future<T> {
    private final Task<T> mTask;
    private boolean isTaskCancelled = false;
    private final CancellationTokenSource mCancellationTokenSource;

    private BoltsFutureTask(Task<T> task) {
        this(task, new CancellationTokenSource());
    }

    private BoltsFutureTask(Task<T> task, CancellationTokenSource cancellationTokenSource) {
        this.mTask = task;
        this.mCancellationTokenSource = cancellationTokenSource;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        try {
            if (!this.isDone()) {
                this.mCancellationTokenSource.cancel();
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.isTaskCancelled = true;
        }
    }

    @Override
    public boolean isCancelled() {
        return this.isTaskCancelled || this.mTask.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.isTaskCancelled || this.mTask.isCancelled() || this.mTask.isFaulted() || this.mTask.isCompleted();
    }

    @Override
    public T get() throws ExecutionException, InterruptedException {
        this.mTask.waitForCompletion();
        return this.getResult(this.mTask);
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws ExecutionException, InterruptedException, TimeoutException {
        if (this.mTask.waitForCompletion(timeout, unit)) {
            return this.getResult(this.mTask);
        }
        throw new TimeoutException();
    }

    private T getResult(Task<T> task) throws ExecutionException {
        if (task.isFaulted()) {
            throw new ExecutionException("", new Throwable());
        }
        if (task.isCancelled()) {
            throw new CancellationException("");
        }
        return task.getResult();
    }
}

