/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.fabric.interop;

import android.content.Context;
import androidx.annotation.Nullable;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.WritableArray;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.common.annotations.VisibleForTesting;
import com.facebook.react.fabric.interop.InteropEvent;
import com.facebook.react.uimanager.UIManagerHelper;
import com.facebook.react.uimanager.events.EventDispatcher;
import com.facebook.react.uimanager.events.RCTEventEmitter;

public class InteropEventEmitter
implements RCTEventEmitter {
    private final ReactContext mReactContext;
    @Nullable
    private EventDispatcher mEventDispatcherOverride;

    public InteropEventEmitter(ReactContext reactContext) {
        this.mReactContext = reactContext;
    }

    @Override
    public void receiveEvent(int targetReactTag, String eventName, @Nullable WritableMap eventData) {
        EventDispatcher dispatcher = this.mEventDispatcherOverride != null ? this.mEventDispatcherOverride : UIManagerHelper.getEventDispatcherForReactTag(this.mReactContext, targetReactTag);
        int surfaceId = UIManagerHelper.getSurfaceId((Context)this.mReactContext);
        if (dispatcher != null) {
            dispatcher.dispatchEvent(new InteropEvent(eventName, eventData, surfaceId, targetReactTag));
        }
    }

    @Override
    public void receiveTouches(String eventName, WritableArray touches, WritableArray changedIndices) {
        throw new UnsupportedOperationException("EventEmitter#receiveTouches is not supported by the Fabric Interop Layer");
    }

    @VisibleForTesting
    void overrideEventDispatcher(EventDispatcher eventDispatcherOverride) {
        this.mEventDispatcherOverride = eventDispatcherOverride;
    }
}

