/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.common.mapbuffer;

import android.util.SparseArray;
import com.facebook.proguard.annotations.DoNotStrip;
import com.facebook.react.common.mapbuffer.MapBuffer;
import com.facebook.react.common.mapbuffer.MapBufferSoLoader;
import java.util.Iterator;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010(\n\u0002\b\n\b\u0007\u0018\u0000 *2\u00020\u0001:\u0002*+B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004H\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0004H\u0016J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\u0004H\u0016J\u0010\u0010\u0013\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004H\u0016J\u0010\u0010\u0014\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0003J\u0010\u0010\u0017\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u0004H\u0016J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00010\u00192\u0006\u0010\f\u001a\u00020\u0004H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\f\u001a\u00020\u0004H\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\f\u001a\u00020\u0004H\u0016J\u0013\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\t0\u001fH\u0003\u00a2\u0006\u0002\u0010 J\u000f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000e0\"H\u0096\u0002J\u0016\u0010#\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010$\u001a\u00020\u0001J\u0016\u0010#\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010$\u001a\u00020\u000bJ\u0016\u0010#\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010$\u001a\u00020\u0012J\u0016\u0010#\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010$\u001a\u00020\u0004J\u0016\u0010#\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010$\u001a\u00020\u001bJ\u0018\u0010%\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010$\u001a\u00020\tH\u0002J(\u0010&\u001a\u0002H'\"\u0006\b\u0000\u0010'\u0018\u00012\u0006\u0010\f\u001a\u00020\u00042\b\u0010$\u001a\u0004\u0018\u00010\tH\u0082\b\u00a2\u0006\u0002\u0010(J\u0014\u0010)\u001a\u00020\u001d*\u00020\t2\u0006\u0010\f\u001a\u00020\u0004H\u0002R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/facebook/react/common/mapbuffer/WritableMapBuffer;", "Lcom/facebook/react/common/mapbuffer/MapBuffer;", "()V", "count", "", "getCount", "()I", "values", "Landroid/util/SparseArray;", "", "contains", "", "key", "entryAt", "Lcom/facebook/react/common/mapbuffer/MapBuffer$Entry;", "offset", "getBoolean", "getDouble", "", "getInt", "getKeyOffset", "getKeys", "", "getMapBuffer", "getMapBufferList", "", "getString", "", "getType", "Lcom/facebook/react/common/mapbuffer/MapBuffer$DataType;", "getValues", "", "()[Ljava/lang/Object;", "iterator", "", "put", "value", "putInternal", "verifyValue", "T", "(ILjava/lang/Object;)Ljava/lang/Object;", "dataType", "Companion", "MapBufferEntry", "ReactAndroid_debug"})
@NotThreadSafe
@DoNotStrip
@SourceDebugExtension(value={"SMAP\nWritableMapBuffer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WritableMapBuffer.kt\ncom/facebook/react/common/mapbuffer/WritableMapBuffer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,184:1\n118#1:186\n119#1,4:188\n118#1:192\n119#1,4:194\n118#1:198\n119#1,4:200\n118#1:204\n119#1,4:206\n118#1:210\n119#1,4:212\n118#1:216\n119#1,4:218\n1#2:185\n1#2:187\n1#2:193\n1#2:199\n1#2:205\n1#2:211\n1#2:217\n*S KotlinDebug\n*F\n+ 1 WritableMapBuffer.kt\ncom/facebook/react/common/mapbuffer/WritableMapBuffer\n*L\n104#1:186\n104#1:188,4\n106#1:192\n106#1:194,4\n108#1:198\n108#1:200,4\n110#1:204\n110#1:206,4\n112#1:210\n112#1:212,4\n114#1:216\n114#1:218,4\n104#1:187\n106#1:193\n108#1:199\n110#1:205\n112#1:211\n114#1:217\n*E\n"})
public final class WritableMapBuffer
implements MapBuffer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SparseArray<Object> values = new SparseArray();

    @NotNull
    public final WritableMapBuffer put(int key, boolean value) {
        return this.putInternal(key, value);
    }

    @NotNull
    public final WritableMapBuffer put(int key, int value) {
        return this.putInternal(key, value);
    }

    @NotNull
    public final WritableMapBuffer put(int key, double value) {
        return this.putInternal(key, value);
    }

    @NotNull
    public final WritableMapBuffer put(int key, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.putInternal(key, value);
    }

    @NotNull
    public final WritableMapBuffer put(int key, @NotNull MapBuffer value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.putInternal(key, value);
    }

    private final WritableMapBuffer putInternal(int key, Object value) {
        IntRange intRange = MapBuffer.Companion.getKEY_RANGE$ReactAndroid_debug();
        int n = intRange.getFirst();
        if (!(key <= intRange.getLast() ? n <= key : false)) {
            boolean bl = false;
            String string = "Only integers in [0;65535] range are allowed for keys.";
            throw new IllegalArgumentException(string.toString());
        }
        this.values.put(key, value);
        return this;
    }

    @Override
    public int getCount() {
        return this.values.size();
    }

    @Override
    public boolean contains(int key) {
        return this.values.get(key) != null;
    }

    @Override
    public int getKeyOffset(int key) {
        return this.values.indexOfKey(key);
    }

    @Override
    @NotNull
    public MapBuffer.Entry entryAt(int offset) {
        return new MapBufferEntry(offset);
    }

    @Override
    @NotNull
    public MapBuffer.DataType getType(int key) {
        Object value = this.values.get(key);
        if (!(value != null)) {
            boolean bl = false;
            String string = "Key not found: " + key;
            throw new IllegalArgumentException(string.toString());
        }
        Intrinsics.checkNotNullExpressionValue((Object)value, (String)"value");
        return this.dataType(value, key);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean getBoolean(int key) {
        void var3_3;
        WritableMapBuffer writableMapBuffer = this;
        Object value$iv = this.values.get(key);
        boolean $i$f$verifyValue = false;
        if (!(value$iv != null)) {
            boolean $i$a$-require-WritableMapBuffer$verifyValue$1$iv22 = false;
            String $i$a$-require-WritableMapBuffer$verifyValue$1$iv22 = "Key not found: " + key;
            throw new IllegalArgumentException($i$a$-require-WritableMapBuffer$verifyValue$1$iv22.toString());
        }
        if (!(value$iv instanceof Boolean)) {
            boolean bl = false;
            String string = "Expected " + Boolean.class + " for key: " + key + ", found " + value$iv.getClass() + " instead.";
            throw new IllegalStateException(string.toString());
        }
        return (Boolean)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getInt(int key) {
        void var3_3;
        WritableMapBuffer writableMapBuffer = this;
        Object value$iv = this.values.get(key);
        boolean $i$f$verifyValue = false;
        if (!(value$iv != null)) {
            boolean $i$a$-require-WritableMapBuffer$verifyValue$1$iv22 = false;
            String $i$a$-require-WritableMapBuffer$verifyValue$1$iv22 = "Key not found: " + key;
            throw new IllegalArgumentException($i$a$-require-WritableMapBuffer$verifyValue$1$iv22.toString());
        }
        if (!(value$iv instanceof Integer)) {
            boolean bl = false;
            String string = "Expected " + Integer.class + " for key: " + key + ", found " + value$iv.getClass() + " instead.";
            throw new IllegalStateException(string.toString());
        }
        return ((Number)var3_3).intValue();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public double getDouble(int key) {
        void var3_3;
        WritableMapBuffer writableMapBuffer = this;
        Object value$iv = this.values.get(key);
        boolean $i$f$verifyValue = false;
        if (!(value$iv != null)) {
            boolean $i$a$-require-WritableMapBuffer$verifyValue$1$iv22 = false;
            String $i$a$-require-WritableMapBuffer$verifyValue$1$iv22 = "Key not found: " + key;
            throw new IllegalArgumentException($i$a$-require-WritableMapBuffer$verifyValue$1$iv22.toString());
        }
        if (!(value$iv instanceof Double)) {
            boolean bl = false;
            String string = "Expected " + Double.class + " for key: " + key + ", found " + value$iv.getClass() + " instead.";
            throw new IllegalStateException(string.toString());
        }
        return ((Number)var3_3).doubleValue();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String getString(int key) {
        void var3_3;
        WritableMapBuffer writableMapBuffer = this;
        Object value$iv = this.values.get(key);
        boolean $i$f$verifyValue = false;
        if (!(value$iv != null)) {
            boolean $i$a$-require-WritableMapBuffer$verifyValue$1$iv22 = false;
            String $i$a$-require-WritableMapBuffer$verifyValue$1$iv22 = "Key not found: " + key;
            throw new IllegalArgumentException($i$a$-require-WritableMapBuffer$verifyValue$1$iv22.toString());
        }
        if (!(value$iv instanceof String)) {
            boolean bl = false;
            String string = "Expected " + String.class + " for key: " + key + ", found " + value$iv.getClass() + " instead.";
            throw new IllegalStateException(string.toString());
        }
        return (String)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public MapBuffer getMapBuffer(int key) {
        void var3_3;
        WritableMapBuffer writableMapBuffer = this;
        Object value$iv = this.values.get(key);
        boolean $i$f$verifyValue = false;
        if (!(value$iv != null)) {
            boolean $i$a$-require-WritableMapBuffer$verifyValue$1$iv22 = false;
            String $i$a$-require-WritableMapBuffer$verifyValue$1$iv22 = "Key not found: " + key;
            throw new IllegalArgumentException($i$a$-require-WritableMapBuffer$verifyValue$1$iv22.toString());
        }
        if (!(value$iv instanceof MapBuffer)) {
            boolean bl = false;
            String string = "Expected " + MapBuffer.class + " for key: " + key + ", found " + value$iv.getClass() + " instead.";
            throw new IllegalStateException(string.toString());
        }
        return (MapBuffer)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<MapBuffer> getMapBufferList(int key) {
        void var3_3;
        WritableMapBuffer writableMapBuffer = this;
        Object value$iv = this.values.get(key);
        boolean $i$f$verifyValue = false;
        if (!(value$iv != null)) {
            boolean $i$a$-require-WritableMapBuffer$verifyValue$1$iv22 = false;
            String $i$a$-require-WritableMapBuffer$verifyValue$1$iv22 = "Key not found: " + key;
            throw new IllegalArgumentException($i$a$-require-WritableMapBuffer$verifyValue$1$iv22.toString());
        }
        if (!(value$iv instanceof List)) {
            boolean bl = false;
            String string = "Expected " + List.class + " for key: " + key + ", found " + value$iv.getClass() + " instead.";
            throw new IllegalStateException(string.toString());
        }
        return (List)var3_3;
    }

    private final /* synthetic */ <T> T verifyValue(int key, Object value) {
        boolean $i$f$verifyValue = false;
        if (!(value != null)) {
            boolean $i$a$-require-WritableMapBuffer$verifyValue$22 = false;
            String $i$a$-require-WritableMapBuffer$verifyValue$22 = "Key not found: " + key;
            throw new IllegalArgumentException($i$a$-require-WritableMapBuffer$verifyValue$22.toString());
        }
        Intrinsics.reifiedOperationMarker((int)3, (String)"T");
        if (!(value instanceof Object)) {
            boolean bl = false;
            Intrinsics.reifiedOperationMarker((int)4, (String)"T");
            String string = "Expected " + Object.class + " for key: " + key + ", found " + value.getClass() + " instead.";
            throw new IllegalStateException(string.toString());
        }
        return (T)value;
    }

    private final MapBuffer.DataType dataType(Object $this$dataType, int key) {
        MapBuffer.DataType dataType;
        Object value = $this$dataType;
        if (value instanceof Boolean) {
            dataType = MapBuffer.DataType.BOOL;
        } else if (value instanceof Integer) {
            dataType = MapBuffer.DataType.INT;
        } else if (value instanceof Double) {
            dataType = MapBuffer.DataType.DOUBLE;
        } else if (value instanceof String) {
            dataType = MapBuffer.DataType.STRING;
        } else if (value instanceof MapBuffer) {
            dataType = MapBuffer.DataType.MAP;
        } else {
            throw new IllegalStateException("Key " + key + " has value of unknown type: " + value.getClass());
        }
        return dataType;
    }

    @Override
    @NotNull
    public Iterator<MapBuffer.Entry> iterator() {
        return new Iterator<MapBuffer.Entry>(this){
            private int count;
            final /* synthetic */ WritableMapBuffer this$0;
            {
                this.this$0 = $receiver;
            }

            public final int getCount() {
                return this.count;
            }

            public final void setCount(int n) {
                this.count = n;
            }

            public boolean hasNext() {
                return this.count < WritableMapBuffer.access$getValues$p(this.this$0).size();
            }

            @NotNull
            public MapBuffer.Entry next() {
                int n = this.count;
                this.count = n + 1;
                return this.this$0.new MapBufferEntry(n);
            }

            public void remove() {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }
        };
    }

    @DoNotStrip
    private final int[] getKeys() {
        int n = 0;
        int n2 = this.values.size();
        int[] nArray = new int[n2];
        while (n < n2) {
            int n3 = n++;
            nArray[n3] = this.values.keyAt(n3);
        }
        return nArray;
    }

    @DoNotStrip
    private final Object[] getValues() {
        int n = 0;
        int n2 = this.values.size();
        Object[] objectArray = new Object[n2];
        while (n < n2) {
            int n3 = n++;
            Intrinsics.checkNotNullExpressionValue((Object)this.values.valueAt(n3), (String)"values.valueAt(it)");
        }
        return objectArray;
    }

    static {
        MapBufferSoLoader.staticInit();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u001bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006\u001e"}, d2={"Lcom/facebook/react/common/mapbuffer/WritableMapBuffer$MapBufferEntry;", "Lcom/facebook/react/common/mapbuffer/MapBuffer$Entry;", "index", "", "(Lcom/facebook/react/common/mapbuffer/WritableMapBuffer;I)V", "booleanValue", "", "getBooleanValue", "()Z", "doubleValue", "", "getDoubleValue", "()D", "intValue", "getIntValue", "()I", "key", "getKey", "mapBufferValue", "Lcom/facebook/react/common/mapbuffer/MapBuffer;", "getMapBufferValue", "()Lcom/facebook/react/common/mapbuffer/MapBuffer;", "stringValue", "", "getStringValue", "()Ljava/lang/String;", "type", "Lcom/facebook/react/common/mapbuffer/MapBuffer$DataType;", "getType", "()Lcom/facebook/react/common/mapbuffer/MapBuffer$DataType;", "ReactAndroid_debug"})
    @SourceDebugExtension(value={"SMAP\nWritableMapBuffer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WritableMapBuffer.kt\ncom/facebook/react/common/mapbuffer/WritableMapBuffer$MapBufferEntry\n+ 2 WritableMapBuffer.kt\ncom/facebook/react/common/mapbuffer/WritableMapBuffer\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,184:1\n118#2:185\n119#2,4:187\n118#2:191\n119#2,4:193\n118#2:197\n119#2,4:199\n118#2:203\n119#2,4:205\n118#2:209\n119#2,4:211\n1#3:186\n1#3:192\n1#3:198\n1#3:204\n1#3:210\n*S KotlinDebug\n*F\n+ 1 WritableMapBuffer.kt\ncom/facebook/react/common/mapbuffer/WritableMapBuffer$MapBufferEntry\n*L\n149#1:185\n149#1:187,4\n152#1:191\n152#1:193,4\n155#1:197\n155#1:199,4\n158#1:203\n158#1:205,4\n161#1:209\n161#1:211,4\n149#1:186\n152#1:192\n155#1:198\n158#1:204\n161#1:210\n*E\n"})
    private final class MapBufferEntry
    implements MapBuffer.Entry {
        private final int index;
        private final int key;
        @NotNull
        private final MapBuffer.DataType type;

        public MapBufferEntry(int index) {
            this.index = index;
            this.key = WritableMapBuffer.this.values.keyAt(this.index);
            Object object = WritableMapBuffer.this.values.valueAt(this.index);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"values.valueAt(index)");
            this.type = WritableMapBuffer.this.dataType(object, this.getKey());
        }

        @Override
        public int getKey() {
            return this.key;
        }

        @Override
        @NotNull
        public MapBuffer.DataType getType() {
            return this.type;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean getBooleanValue() {
            void var3_3;
            void key$iv;
            WritableMapBuffer writableMapBuffer = WritableMapBuffer.this;
            int n = this.getKey();
            Object value$iv = WritableMapBuffer.this.values.valueAt(this.index);
            boolean $i$f$verifyValue = false;
            if (!(value$iv != null)) {
                boolean $i$a$-require-WritableMapBuffer$verifyValue$1$iv22 = false;
                String $i$a$-require-WritableMapBuffer$verifyValue$1$iv22 = "Key not found: " + (int)key$iv;
                throw new IllegalArgumentException($i$a$-require-WritableMapBuffer$verifyValue$1$iv22.toString());
            }
            if (!(value$iv instanceof Boolean)) {
                boolean bl = false;
                String string = "Expected " + Boolean.class + " for key: " + (int)key$iv + ", found " + value$iv.getClass() + " instead.";
                throw new IllegalStateException(string.toString());
            }
            return (Boolean)var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int getIntValue() {
            void var3_3;
            void key$iv;
            WritableMapBuffer writableMapBuffer = WritableMapBuffer.this;
            int n = this.getKey();
            Object value$iv = WritableMapBuffer.this.values.valueAt(this.index);
            boolean $i$f$verifyValue = false;
            if (!(value$iv != null)) {
                boolean $i$a$-require-WritableMapBuffer$verifyValue$1$iv22 = false;
                String $i$a$-require-WritableMapBuffer$verifyValue$1$iv22 = "Key not found: " + (int)key$iv;
                throw new IllegalArgumentException($i$a$-require-WritableMapBuffer$verifyValue$1$iv22.toString());
            }
            if (!(value$iv instanceof Integer)) {
                boolean bl = false;
                String string = "Expected " + Integer.class + " for key: " + (int)key$iv + ", found " + value$iv.getClass() + " instead.";
                throw new IllegalStateException(string.toString());
            }
            return ((Number)var3_3).intValue();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public double getDoubleValue() {
            void var3_3;
            void key$iv;
            WritableMapBuffer writableMapBuffer = WritableMapBuffer.this;
            int n = this.getKey();
            Object value$iv = WritableMapBuffer.this.values.valueAt(this.index);
            boolean $i$f$verifyValue = false;
            if (!(value$iv != null)) {
                boolean $i$a$-require-WritableMapBuffer$verifyValue$1$iv22 = false;
                String $i$a$-require-WritableMapBuffer$verifyValue$1$iv22 = "Key not found: " + (int)key$iv;
                throw new IllegalArgumentException($i$a$-require-WritableMapBuffer$verifyValue$1$iv22.toString());
            }
            if (!(value$iv instanceof Double)) {
                boolean bl = false;
                String string = "Expected " + Double.class + " for key: " + (int)key$iv + ", found " + value$iv.getClass() + " instead.";
                throw new IllegalStateException(string.toString());
            }
            return ((Number)var3_3).doubleValue();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public String getStringValue() {
            void var3_3;
            void key$iv;
            WritableMapBuffer writableMapBuffer = WritableMapBuffer.this;
            int n = this.getKey();
            Object value$iv = WritableMapBuffer.this.values.valueAt(this.index);
            boolean $i$f$verifyValue = false;
            if (!(value$iv != null)) {
                boolean $i$a$-require-WritableMapBuffer$verifyValue$1$iv22 = false;
                String $i$a$-require-WritableMapBuffer$verifyValue$1$iv22 = "Key not found: " + (int)key$iv;
                throw new IllegalArgumentException($i$a$-require-WritableMapBuffer$verifyValue$1$iv22.toString());
            }
            if (!(value$iv instanceof String)) {
                boolean bl = false;
                String string = "Expected " + String.class + " for key: " + (int)key$iv + ", found " + value$iv.getClass() + " instead.";
                throw new IllegalStateException(string.toString());
            }
            return (String)var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public MapBuffer getMapBufferValue() {
            void var3_3;
            void key$iv;
            WritableMapBuffer writableMapBuffer = WritableMapBuffer.this;
            int n = this.getKey();
            Object value$iv = WritableMapBuffer.this.values.valueAt(this.index);
            boolean $i$f$verifyValue = false;
            if (!(value$iv != null)) {
                boolean $i$a$-require-WritableMapBuffer$verifyValue$1$iv22 = false;
                String $i$a$-require-WritableMapBuffer$verifyValue$1$iv22 = "Key not found: " + (int)key$iv;
                throw new IllegalArgumentException($i$a$-require-WritableMapBuffer$verifyValue$1$iv22.toString());
            }
            if (!(value$iv instanceof MapBuffer)) {
                boolean bl = false;
                String string = "Expected " + MapBuffer.class + " for key: " + (int)key$iv + ", found " + value$iv.getClass() + " instead.";
                throw new IllegalStateException(string.toString());
            }
            return (MapBuffer)var3_3;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/facebook/react/common/mapbuffer/WritableMapBuffer$Companion;", "", "()V", "ReactAndroid_debug"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

