/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge;

import android.app.Activity;
import androidx.annotation.Nullable;
import com.facebook.common.logging.FLog;
import com.facebook.infer.annotation.Assertions;
import com.facebook.infer.annotation.ThreadConfined;
import com.facebook.react.bridge.BaseJavaModule;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactSoftExceptionLogger;
import com.facebook.react.common.build.ReactBuildConfig;

public abstract class ReactContextBaseJavaModule
extends BaseJavaModule {
    @Nullable
    private final ReactApplicationContext mReactApplicationContext;

    public ReactContextBaseJavaModule() {
        this.mReactApplicationContext = null;
    }

    public ReactContextBaseJavaModule(@Nullable ReactApplicationContext reactContext) {
        this.mReactApplicationContext = reactContext;
    }

    protected final ReactApplicationContext getReactApplicationContext() {
        return (ReactApplicationContext)((Object)Assertions.assertNotNull((Object)((Object)this.mReactApplicationContext), (String)"Tried to get ReactApplicationContext even though NativeModule wasn't instantiated with one"));
    }

    @ThreadConfined(value="ANY")
    @Nullable
    protected final ReactApplicationContext getReactApplicationContextIfActiveOrWarn() {
        if (this.mReactApplicationContext.hasActiveReactInstance()) {
            return this.mReactApplicationContext;
        }
        String msg = "Catalyst Instance has already disappeared: requested by " + this.getName();
        if (ReactBuildConfig.DEBUG) {
            FLog.w((String)"ReactNative", (String)msg);
        } else {
            ReactSoftExceptionLogger.logSoftException("ReactNative", new RuntimeException(msg));
        }
        return null;
    }

    @Nullable
    protected final Activity getCurrentActivity() {
        return this.mReactApplicationContext.getCurrentActivity();
    }
}

