/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.drawer;

import android.content.Context;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import androidx.core.view.AccessibilityDelegateCompat;
import androidx.core.view.ViewCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import androidx.drawerlayout.widget.DrawerLayout;
import com.facebook.common.logging.FLog;
import com.facebook.react.R;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.uimanager.ReactAccessibilityDelegate;
import com.facebook.react.uimanager.events.NativeGestureUtil;

class ReactDrawerLayout
extends DrawerLayout {
    public static final int DEFAULT_DRAWER_WIDTH = -1;
    private int mDrawerPosition = 0x800003;
    private int mDrawerWidth = -1;
    private boolean mDragging = false;

    public ReactDrawerLayout(ReactContext reactContext) {
        super((Context)reactContext);
        ViewCompat.setAccessibilityDelegate((View)this, (AccessibilityDelegateCompat)new AccessibilityDelegateCompat(){

            public void onInitializeAccessibilityNodeInfo(View host, AccessibilityNodeInfoCompat info) {
                super.onInitializeAccessibilityNodeInfo(host, info);
                ReactAccessibilityDelegate.AccessibilityRole accessibilityRole = (ReactAccessibilityDelegate.AccessibilityRole)((Object)host.getTag(R.id.accessibility_role));
                if (accessibilityRole != null) {
                    info.setClassName((CharSequence)ReactAccessibilityDelegate.AccessibilityRole.getValue(accessibilityRole));
                }
            }

            public void onInitializeAccessibilityEvent(View host, AccessibilityEvent event) {
                super.onInitializeAccessibilityEvent(host, event);
                ReactAccessibilityDelegate.AccessibilityRole accessibilityRole = (ReactAccessibilityDelegate.AccessibilityRole)((Object)host.getTag(R.id.accessibility_role));
                if (accessibilityRole != null) {
                    event.setClassName((CharSequence)ReactAccessibilityDelegate.AccessibilityRole.getValue(accessibilityRole));
                }
            }
        });
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        try {
            if (super.onInterceptTouchEvent(ev)) {
                NativeGestureUtil.notifyNativeGestureStarted((View)this, ev);
                this.mDragging = true;
                return true;
            }
        }
        catch (IllegalArgumentException e) {
            FLog.w((String)"ReactNative", (String)"Error intercepting touch event.", (Throwable)e);
        }
        return false;
    }

    public boolean onTouchEvent(MotionEvent ev) {
        int action = ev.getActionMasked();
        if (action == 1 && this.mDragging) {
            NativeGestureUtil.notifyNativeGestureEnded((View)this, ev);
            this.mDragging = false;
        }
        return super.onTouchEvent(ev);
    }

    void openDrawer() {
        this.openDrawer(this.mDrawerPosition);
    }

    void closeDrawer() {
        this.closeDrawer(this.mDrawerPosition);
    }

    void setDrawerPosition(int drawerPosition) {
        this.mDrawerPosition = drawerPosition;
        this.setDrawerProperties();
    }

    void setDrawerWidth(int drawerWidthInPx) {
        this.mDrawerWidth = drawerWidthInPx;
        this.setDrawerProperties();
    }

    void setDrawerProperties() {
        if (this.getChildCount() == 2) {
            View drawerView = this.getChildAt(1);
            DrawerLayout.LayoutParams layoutParams = (DrawerLayout.LayoutParams)drawerView.getLayoutParams();
            layoutParams.gravity = this.mDrawerPosition;
            layoutParams.width = this.mDrawerWidth;
            drawerView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            drawerView.setClickable(true);
        }
    }
}

