/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import android.content.Context;
import android.view.View;
import androidx.annotation.Nullable;
import com.facebook.common.logging.FLog;
import com.facebook.react.bridge.ColorPropConverter;
import com.facebook.react.bridge.Dynamic;
import com.facebook.react.bridge.DynamicFromObject;
import com.facebook.react.bridge.JSApplicationIllegalArgumentException;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.uimanager.ReactShadowNode;
import com.facebook.react.uimanager.ViewManager;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.facebook.react.uimanager.annotations.ReactPropGroup;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

class ViewManagersPropertyCache {
    private static final Map<Class, Map<String, PropSetter>> CLASS_PROPS_CACHE = new HashMap<Class, Map<String, PropSetter>>();
    private static final Map<String, PropSetter> EMPTY_PROPS_MAP = new HashMap<String, PropSetter>();

    ViewManagersPropertyCache() {
    }

    public static void clear() {
        CLASS_PROPS_CACHE.clear();
        EMPTY_PROPS_MAP.clear();
    }

    static Map<String, String> getNativePropsForView(Class<? extends ViewManager> viewManagerTopClass, Class<? extends ReactShadowNode> shadowNodeTopClass) {
        HashMap<String, String> nativeProps = new HashMap<String, String>();
        Map<String, PropSetter> viewManagerProps = ViewManagersPropertyCache.getNativePropSettersForViewManagerClass(viewManagerTopClass);
        for (PropSetter setter : viewManagerProps.values()) {
            nativeProps.put(setter.getPropName(), setter.getPropType());
        }
        Map<String, PropSetter> shadowNodeProps = ViewManagersPropertyCache.getNativePropSettersForShadowNodeClass(shadowNodeTopClass);
        for (PropSetter setter : shadowNodeProps.values()) {
            nativeProps.put(setter.getPropName(), setter.getPropType());
        }
        return nativeProps;
    }

    static Map<String, PropSetter> getNativePropSettersForViewManagerClass(Class<? extends ViewManager> cls) {
        if (cls == ViewManager.class) {
            return EMPTY_PROPS_MAP;
        }
        Map<String, PropSetter> props = CLASS_PROPS_CACHE.get(cls);
        if (props != null) {
            return props;
        }
        props = new HashMap<String, PropSetter>(ViewManagersPropertyCache.getNativePropSettersForViewManagerClass(cls.getSuperclass()));
        ViewManagersPropertyCache.extractPropSettersFromViewManagerClassDefinition(cls, props);
        CLASS_PROPS_CACHE.put(cls, props);
        return props;
    }

    static Map<String, PropSetter> getNativePropSettersForShadowNodeClass(Class<? extends ReactShadowNode> cls) {
        for (Class<?> iface : cls.getInterfaces()) {
            if (iface != ReactShadowNode.class) continue;
            return EMPTY_PROPS_MAP;
        }
        Map<String, PropSetter> props = CLASS_PROPS_CACHE.get(cls);
        if (props != null) {
            return props;
        }
        props = new HashMap<String, PropSetter>(ViewManagersPropertyCache.getNativePropSettersForShadowNodeClass(cls.getSuperclass()));
        ViewManagersPropertyCache.extractPropSettersFromShadowNodeClassDefinition(cls, props);
        CLASS_PROPS_CACHE.put(cls, props);
        return props;
    }

    private static PropSetter createPropSetter(ReactProp annotation, Method method, Class<?> propTypeClass) {
        if (propTypeClass == Dynamic.class) {
            return new DynamicPropSetter(annotation, method);
        }
        if (propTypeClass == Boolean.TYPE) {
            return new BooleanPropSetter(annotation, method, annotation.defaultBoolean());
        }
        if (propTypeClass == Integer.TYPE) {
            if ("Color".equals(annotation.customType())) {
                return new ColorPropSetter(annotation, method, annotation.defaultInt());
            }
            return new IntPropSetter(annotation, method, annotation.defaultInt());
        }
        if (propTypeClass == Float.TYPE) {
            return new FloatPropSetter(annotation, method, annotation.defaultFloat());
        }
        if (propTypeClass == Double.TYPE) {
            return new DoublePropSetter(annotation, method, annotation.defaultDouble());
        }
        if (propTypeClass == String.class) {
            return new StringPropSetter(annotation, method);
        }
        if (propTypeClass == Boolean.class) {
            return new BoxedBooleanPropSetter(annotation, method);
        }
        if (propTypeClass == Integer.class) {
            if ("Color".equals(annotation.customType())) {
                return new BoxedColorPropSetter(annotation, method);
            }
            return new BoxedIntPropSetter(annotation, method);
        }
        if (propTypeClass == ReadableArray.class) {
            return new ArrayPropSetter(annotation, method);
        }
        if (propTypeClass == ReadableMap.class) {
            return new MapPropSetter(annotation, method);
        }
        throw new RuntimeException("Unrecognized type: " + propTypeClass + " for method: " + method.getDeclaringClass().getName() + "#" + method.getName());
    }

    private static void createPropSetters(ReactPropGroup annotation, Method method, Class<?> propTypeClass, Map<String, PropSetter> props) {
        String[] names = annotation.names();
        if (propTypeClass == Dynamic.class) {
            for (int i = 0; i < names.length; ++i) {
                props.put(names[i], new DynamicPropSetter(annotation, method, i));
            }
        } else if (propTypeClass == Integer.TYPE) {
            for (int i = 0; i < names.length; ++i) {
                props.put(names[i], new IntPropSetter(annotation, method, i, annotation.defaultInt()));
            }
        } else if (propTypeClass == Float.TYPE) {
            for (int i = 0; i < names.length; ++i) {
                props.put(names[i], new FloatPropSetter(annotation, method, i, annotation.defaultFloat()));
            }
        } else if (propTypeClass == Double.TYPE) {
            for (int i = 0; i < names.length; ++i) {
                props.put(names[i], new DoublePropSetter(annotation, method, i, annotation.defaultDouble()));
            }
        } else if (propTypeClass == Integer.class) {
            for (int i = 0; i < names.length; ++i) {
                props.put(names[i], new BoxedIntPropSetter(annotation, method, i));
            }
        } else {
            throw new RuntimeException("Unrecognized type: " + propTypeClass + " for method: " + method.getDeclaringClass().getName() + "#" + method.getName());
        }
    }

    private static void extractPropSettersFromViewManagerClassDefinition(Class<? extends ViewManager> cls, Map<String, PropSetter> props) {
        Method[] declaredMethods = cls.getDeclaredMethods();
        for (int i = 0; i < declaredMethods.length; ++i) {
            ReactPropGroup groupAnnotation;
            Method method = declaredMethods[i];
            ReactProp annotation = method.getAnnotation(ReactProp.class);
            if (annotation != null) {
                Class<?>[] paramTypes = method.getParameterTypes();
                if (paramTypes.length != 2) {
                    throw new RuntimeException("Wrong number of args for prop setter: " + cls.getName() + "#" + method.getName());
                }
                if (!View.class.isAssignableFrom(paramTypes[0])) {
                    throw new RuntimeException("First param should be a view subclass to be updated: " + cls.getName() + "#" + method.getName());
                }
                props.put(annotation.name(), ViewManagersPropertyCache.createPropSetter(annotation, method, paramTypes[1]));
            }
            if ((groupAnnotation = method.getAnnotation(ReactPropGroup.class)) == null) continue;
            Class<?>[] paramTypes = method.getParameterTypes();
            if (paramTypes.length != 3) {
                throw new RuntimeException("Wrong number of args for group prop setter: " + cls.getName() + "#" + method.getName());
            }
            if (!View.class.isAssignableFrom(paramTypes[0])) {
                throw new RuntimeException("First param should be a view subclass to be updated: " + cls.getName() + "#" + method.getName());
            }
            if (paramTypes[1] != Integer.TYPE) {
                throw new RuntimeException("Second argument should be property index: " + cls.getName() + "#" + method.getName());
            }
            ViewManagersPropertyCache.createPropSetters(groupAnnotation, method, paramTypes[2], props);
        }
    }

    private static void extractPropSettersFromShadowNodeClassDefinition(Class<? extends ReactShadowNode> cls, Map<String, PropSetter> props) {
        for (Method method : cls.getDeclaredMethods()) {
            ReactPropGroup groupAnnotation;
            ReactProp annotation = method.getAnnotation(ReactProp.class);
            if (annotation != null) {
                Class<?>[] paramTypes = method.getParameterTypes();
                if (paramTypes.length != 1) {
                    throw new RuntimeException("Wrong number of args for prop setter: " + cls.getName() + "#" + method.getName());
                }
                props.put(annotation.name(), ViewManagersPropertyCache.createPropSetter(annotation, method, paramTypes[0]));
            }
            if ((groupAnnotation = method.getAnnotation(ReactPropGroup.class)) == null) continue;
            Class<?>[] paramTypes = method.getParameterTypes();
            if (paramTypes.length != 2) {
                throw new RuntimeException("Wrong number of args for group prop setter: " + cls.getName() + "#" + method.getName());
            }
            if (paramTypes[0] != Integer.TYPE) {
                throw new RuntimeException("Second argument should be property index: " + cls.getName() + "#" + method.getName());
            }
            ViewManagersPropertyCache.createPropSetters(groupAnnotation, method, paramTypes[1], props);
        }
    }

    private static ThreadLocal<Object[]> createThreadLocalArray(final int size) {
        if (size <= 0) {
            return null;
        }
        return new ThreadLocal<Object[]>(){

            @Override
            @Nullable
            protected Object[] initialValue() {
                return new Object[size];
            }
        };
    }

    private static class BoxedColorPropSetter
    extends PropSetter {
        public BoxedColorPropSetter(ReactProp prop, Method setter) {
            super(prop, "mixed", setter);
        }

        @Override
        @Nullable
        protected Object getValueOrDefault(Object value, Context context) {
            if (value != null) {
                return ColorPropConverter.getColor(value, context);
            }
            return null;
        }
    }

    private static class BoxedIntPropSetter
    extends PropSetter {
        public BoxedIntPropSetter(ReactProp prop, Method setter) {
            super(prop, "number", setter);
        }

        public BoxedIntPropSetter(ReactPropGroup prop, Method setter, int index) {
            super(prop, "number", setter, index);
        }

        @Override
        @Nullable
        protected Object getValueOrDefault(Object value, Context context) {
            if (value != null) {
                if (value instanceof Double) {
                    return ((Double)value).intValue();
                }
                return (Integer)value;
            }
            return null;
        }
    }

    private static class BoxedBooleanPropSetter
    extends PropSetter {
        public BoxedBooleanPropSetter(ReactProp prop, Method setter) {
            super(prop, "boolean", setter);
        }

        @Override
        @Nullable
        protected Object getValueOrDefault(Object value, Context context) {
            if (value != null) {
                return (Boolean)value != false ? Boolean.TRUE : Boolean.FALSE;
            }
            return null;
        }
    }

    private static class StringPropSetter
    extends PropSetter {
        public StringPropSetter(ReactProp prop, Method setter) {
            super(prop, "String", setter);
        }

        @Override
        @Nullable
        protected Object getValueOrDefault(Object value, Context context) {
            return (String)value;
        }
    }

    private static class MapPropSetter
    extends PropSetter {
        public MapPropSetter(ReactProp prop, Method setter) {
            super(prop, "Map", setter);
        }

        @Override
        @Nullable
        protected Object getValueOrDefault(Object value, Context context) {
            return (ReadableMap)value;
        }
    }

    private static class ArrayPropSetter
    extends PropSetter {
        public ArrayPropSetter(ReactProp prop, Method setter) {
            super(prop, "Array", setter);
        }

        @Override
        @Nullable
        protected Object getValueOrDefault(Object value, Context context) {
            return (ReadableArray)value;
        }
    }

    private static class FloatPropSetter
    extends PropSetter {
        private final float mDefaultValue;

        public FloatPropSetter(ReactProp prop, Method setter, float defaultValue) {
            super(prop, "number", setter);
            this.mDefaultValue = defaultValue;
        }

        public FloatPropSetter(ReactPropGroup prop, Method setter, int index, float defaultValue) {
            super(prop, "number", setter, index);
            this.mDefaultValue = defaultValue;
        }

        @Override
        protected Object getValueOrDefault(Object value, Context context) {
            return Float.valueOf(value == null ? this.mDefaultValue : Float.valueOf(((Double)value).floatValue()).floatValue());
        }
    }

    private static class BooleanPropSetter
    extends PropSetter {
        private final boolean mDefaultValue;

        public BooleanPropSetter(ReactProp prop, Method setter, boolean defaultValue) {
            super(prop, "boolean", setter);
            this.mDefaultValue = defaultValue;
        }

        @Override
        protected Object getValueOrDefault(Object value, Context context) {
            boolean val = value == null ? this.mDefaultValue : (Boolean)value;
            return val ? Boolean.TRUE : Boolean.FALSE;
        }
    }

    private static class ColorPropSetter
    extends PropSetter {
        private final int mDefaultValue;

        public ColorPropSetter(ReactProp prop, Method setter) {
            this(prop, setter, 0);
        }

        public ColorPropSetter(ReactProp prop, Method setter, int defaultValue) {
            super(prop, "mixed", setter);
            this.mDefaultValue = defaultValue;
        }

        @Override
        protected Object getValueOrDefault(Object value, Context context) {
            if (value == null) {
                return this.mDefaultValue;
            }
            return ColorPropConverter.getColor(value, context);
        }
    }

    private static class DoublePropSetter
    extends PropSetter {
        private final double mDefaultValue;

        public DoublePropSetter(ReactProp prop, Method setter, double defaultValue) {
            super(prop, "number", setter);
            this.mDefaultValue = defaultValue;
        }

        public DoublePropSetter(ReactPropGroup prop, Method setter, int index, double defaultValue) {
            super(prop, "number", setter, index);
            this.mDefaultValue = defaultValue;
        }

        @Override
        protected Object getValueOrDefault(Object value, Context context) {
            return value == null ? this.mDefaultValue : (Double)value;
        }
    }

    private static class IntPropSetter
    extends PropSetter {
        private final int mDefaultValue;

        public IntPropSetter(ReactProp prop, Method setter, int defaultValue) {
            super(prop, "number", setter);
            this.mDefaultValue = defaultValue;
        }

        public IntPropSetter(ReactPropGroup prop, Method setter, int index, int defaultValue) {
            super(prop, "number", setter, index);
            this.mDefaultValue = defaultValue;
        }

        @Override
        protected Object getValueOrDefault(Object value, Context context) {
            return value == null ? this.mDefaultValue : Integer.valueOf(((Double)value).intValue());
        }
    }

    private static class DynamicPropSetter
    extends PropSetter {
        public DynamicPropSetter(ReactProp prop, Method setter) {
            super(prop, "mixed", setter);
        }

        public DynamicPropSetter(ReactPropGroup prop, Method setter, int index) {
            super(prop, "mixed", setter, index);
        }

        @Override
        protected Object getValueOrDefault(Object value, Context context) {
            if (value instanceof Dynamic) {
                return value;
            }
            return new DynamicFromObject(value);
        }
    }

    static abstract class PropSetter {
        protected final String mPropName;
        protected final String mPropType;
        protected final Method mSetter;
        @Nullable
        protected final Integer mIndex;
        private static final ThreadLocal<Object[]> VIEW_MGR_ARGS = ViewManagersPropertyCache.createThreadLocalArray(2);
        private static final ThreadLocal<Object[]> VIEW_MGR_GROUP_ARGS = ViewManagersPropertyCache.createThreadLocalArray(3);
        private static final ThreadLocal<Object[]> SHADOW_ARGS = ViewManagersPropertyCache.createThreadLocalArray(1);
        private static final ThreadLocal<Object[]> SHADOW_GROUP_ARGS = ViewManagersPropertyCache.createThreadLocalArray(2);

        private PropSetter(ReactProp prop, String defaultType, Method setter) {
            this.mPropName = prop.name();
            this.mPropType = "__default_type__".equals(prop.customType()) ? defaultType : prop.customType();
            this.mSetter = setter;
            this.mIndex = null;
        }

        private PropSetter(ReactPropGroup prop, String defaultType, Method setter, int index) {
            this.mPropName = prop.names()[index];
            this.mPropType = "__default_type__".equals(prop.customType()) ? defaultType : prop.customType();
            this.mSetter = setter;
            this.mIndex = index;
        }

        public String getPropName() {
            return this.mPropName;
        }

        public String getPropType() {
            return this.mPropType;
        }

        public void updateViewProp(ViewManager viewManager, View viewToUpdate, Object value) {
            try {
                Object[] args;
                if (this.mIndex == null) {
                    args = VIEW_MGR_ARGS.get();
                    args[0] = viewToUpdate;
                    args[1] = this.getValueOrDefault(value, viewToUpdate.getContext());
                } else {
                    args = VIEW_MGR_GROUP_ARGS.get();
                    args[0] = viewToUpdate;
                    args[1] = this.mIndex;
                    args[2] = this.getValueOrDefault(value, viewToUpdate.getContext());
                }
                this.mSetter.invoke((Object)viewManager, args);
                Arrays.fill(args, null);
            }
            catch (Throwable t) {
                FLog.e(ViewManager.class, (String)("Error while updating prop " + this.mPropName), (Throwable)t);
                throw new JSApplicationIllegalArgumentException("Error while updating property '" + this.mPropName + "' of a view managed by: " + viewManager.getName(), t);
            }
        }

        public void updateShadowNodeProp(ReactShadowNode nodeToUpdate, Object value) {
            try {
                Object[] args;
                if (this.mIndex == null) {
                    args = SHADOW_ARGS.get();
                    args[0] = this.getValueOrDefault(value, (Context)nodeToUpdate.getThemedContext());
                } else {
                    args = SHADOW_GROUP_ARGS.get();
                    args[0] = this.mIndex;
                    args[1] = this.getValueOrDefault(value, (Context)nodeToUpdate.getThemedContext());
                }
                this.mSetter.invoke((Object)nodeToUpdate, args);
                Arrays.fill(args, null);
            }
            catch (Throwable t) {
                FLog.e(ViewManager.class, (String)("Error while updating prop " + this.mPropName), (Throwable)t);
                throw new JSApplicationIllegalArgumentException("Error while updating property '" + this.mPropName + "' in shadow node of type: " + nodeToUpdate.getViewClass(), t);
            }
        }

        @Nullable
        protected abstract Object getValueOrDefault(Object var1, Context var2);
    }
}

