/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.animated;

import android.util.SparseArray;
import androidx.annotation.Nullable;
import androidx.annotation.UiThread;
import com.facebook.common.logging.FLog;
import com.facebook.react.animated.AdditionAnimatedNode;
import com.facebook.react.animated.AnimatedNode;
import com.facebook.react.animated.AnimatedNodeValueListener;
import com.facebook.react.animated.AnimatedNodeWithUpdateableConfig;
import com.facebook.react.animated.AnimationDriver;
import com.facebook.react.animated.ColorAnimatedNode;
import com.facebook.react.animated.DecayAnimation;
import com.facebook.react.animated.DiffClampAnimatedNode;
import com.facebook.react.animated.DivisionAnimatedNode;
import com.facebook.react.animated.EventAnimationDriver;
import com.facebook.react.animated.FrameBasedAnimationDriver;
import com.facebook.react.animated.InterpolationAnimatedNode;
import com.facebook.react.animated.ModulusAnimatedNode;
import com.facebook.react.animated.MultiplicationAnimatedNode;
import com.facebook.react.animated.PropsAnimatedNode;
import com.facebook.react.animated.SpringAnimation;
import com.facebook.react.animated.StyleAnimatedNode;
import com.facebook.react.animated.SubtractionAnimatedNode;
import com.facebook.react.animated.TrackingAnimatedNode;
import com.facebook.react.animated.TransformAnimatedNode;
import com.facebook.react.animated.ValueAnimatedNode;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.JSApplicationCausedNativeException;
import com.facebook.react.bridge.JSApplicationIllegalArgumentException;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactNoCrashSoftException;
import com.facebook.react.bridge.ReactSoftExceptionLogger;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.UIManager;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.uimanager.UIManagerHelper;
import com.facebook.react.uimanager.events.Event;
import com.facebook.react.uimanager.events.EventDispatcher;
import com.facebook.react.uimanager.events.EventDispatcherListener;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class NativeAnimatedNodesManager
implements EventDispatcherListener {
    private static final String TAG = "NativeAnimatedNodesManager";
    private final SparseArray<AnimatedNode> mAnimatedNodes = new SparseArray();
    private final SparseArray<AnimationDriver> mActiveAnimations = new SparseArray();
    private final SparseArray<AnimatedNode> mUpdatedNodes = new SparseArray();
    private final List<EventAnimationDriver> mEventDrivers = new ArrayList<EventAnimationDriver>();
    private final ReactApplicationContext mReactApplicationContext;
    private int mAnimatedGraphBFSColor = 0;
    private final List<AnimatedNode> mRunUpdateNodeList = new LinkedList<AnimatedNode>();
    private boolean mEventListenerInitializedForFabric = false;
    private boolean mEventListenerInitializedForNonFabric = false;
    private boolean mWarnedAboutGraphTraversal = false;

    public NativeAnimatedNodesManager(ReactApplicationContext reactApplicationContext) {
        this.mReactApplicationContext = reactApplicationContext;
    }

    public void initializeEventListenerForUIManagerType(int uiManagerType) {
        if (uiManagerType == 2 ? this.mEventListenerInitializedForFabric : this.mEventListenerInitializedForNonFabric) {
            return;
        }
        UIManager uiManager = UIManagerHelper.getUIManager(this.mReactApplicationContext, uiManagerType);
        if (uiManager != null) {
            ((EventDispatcher)uiManager.getEventDispatcher()).addListener(this);
            if (uiManagerType == 2) {
                this.mEventListenerInitializedForFabric = true;
            } else {
                this.mEventListenerInitializedForNonFabric = true;
            }
        }
    }

    @Nullable
    public AnimatedNode getNodeById(int id2) {
        return (AnimatedNode)this.mAnimatedNodes.get(id2);
    }

    public boolean hasActiveAnimations() {
        return this.mActiveAnimations.size() > 0 || this.mUpdatedNodes.size() > 0;
    }

    @UiThread
    public void createAnimatedNode(int tag, ReadableMap config) {
        AnimatedNode node;
        if (this.mAnimatedNodes.get(tag) != null) {
            throw new JSApplicationIllegalArgumentException("createAnimatedNode: Animated node [" + tag + "] already exists");
        }
        String type = config.getString("type");
        if ("style".equals(type)) {
            node = new StyleAnimatedNode(config, this);
        } else if ("value".equals(type)) {
            node = new ValueAnimatedNode(config);
        } else if ("color".equals(type)) {
            node = new ColorAnimatedNode(config, this, this.mReactApplicationContext);
        } else if ("props".equals(type)) {
            node = new PropsAnimatedNode(config, this);
        } else if ("interpolation".equals(type)) {
            node = new InterpolationAnimatedNode(config);
        } else if ("addition".equals(type)) {
            node = new AdditionAnimatedNode(config, this);
        } else if ("subtraction".equals(type)) {
            node = new SubtractionAnimatedNode(config, this);
        } else if ("division".equals(type)) {
            node = new DivisionAnimatedNode(config, this);
        } else if ("multiplication".equals(type)) {
            node = new MultiplicationAnimatedNode(config, this);
        } else if ("modulus".equals(type)) {
            node = new ModulusAnimatedNode(config, this);
        } else if ("diffclamp".equals(type)) {
            node = new DiffClampAnimatedNode(config, this);
        } else if ("transform".equals(type)) {
            node = new TransformAnimatedNode(config, this);
        } else if ("tracking".equals(type)) {
            node = new TrackingAnimatedNode(config, this);
        } else {
            throw new JSApplicationIllegalArgumentException("Unsupported node type: " + type);
        }
        node.mTag = tag;
        this.mAnimatedNodes.put(tag, (Object)node);
        this.mUpdatedNodes.put(tag, (Object)node);
    }

    @UiThread
    public void updateAnimatedNodeConfig(int tag, ReadableMap config) {
        AnimatedNode node = (AnimatedNode)this.mAnimatedNodes.get(tag);
        if (node == null) {
            throw new JSApplicationIllegalArgumentException("updateAnimatedNode: Animated node [" + tag + "] does not exist");
        }
        if (node instanceof AnimatedNodeWithUpdateableConfig) {
            this.stopAnimationsForNode(node);
            ((AnimatedNodeWithUpdateableConfig)((Object)node)).onUpdateConfig(config);
            this.mUpdatedNodes.put(tag, (Object)node);
        }
    }

    @UiThread
    public void dropAnimatedNode(int tag) {
        this.mAnimatedNodes.remove(tag);
        this.mUpdatedNodes.remove(tag);
    }

    @UiThread
    public void startListeningToAnimatedNodeValue(int tag, AnimatedNodeValueListener listener) {
        AnimatedNode node = (AnimatedNode)this.mAnimatedNodes.get(tag);
        if (node == null || !(node instanceof ValueAnimatedNode)) {
            throw new JSApplicationIllegalArgumentException("startListeningToAnimatedNodeValue: Animated node [" + tag + "] does not exist, or is not a 'value' node");
        }
        ((ValueAnimatedNode)node).setValueListener(listener);
    }

    @UiThread
    public void stopListeningToAnimatedNodeValue(int tag) {
        AnimatedNode node = (AnimatedNode)this.mAnimatedNodes.get(tag);
        if (node == null || !(node instanceof ValueAnimatedNode)) {
            throw new JSApplicationIllegalArgumentException("startListeningToAnimatedNodeValue: Animated node [" + tag + "] does not exist, or is not a 'value' node");
        }
        ((ValueAnimatedNode)node).setValueListener(null);
    }

    @UiThread
    public void setAnimatedNodeValue(int tag, double value) {
        AnimatedNode node = (AnimatedNode)this.mAnimatedNodes.get(tag);
        if (node == null || !(node instanceof ValueAnimatedNode)) {
            throw new JSApplicationIllegalArgumentException("setAnimatedNodeValue: Animated node [" + tag + "] does not exist, or is not a 'value' node");
        }
        this.stopAnimationsForNode(node);
        ((ValueAnimatedNode)node).mValue = value;
        this.mUpdatedNodes.put(tag, (Object)node);
    }

    @UiThread
    public void setAnimatedNodeOffset(int tag, double offset) {
        AnimatedNode node = (AnimatedNode)this.mAnimatedNodes.get(tag);
        if (node == null || !(node instanceof ValueAnimatedNode)) {
            throw new JSApplicationIllegalArgumentException("setAnimatedNodeOffset: Animated node [" + tag + "] does not exist, or is not a 'value' node");
        }
        ((ValueAnimatedNode)node).mOffset = offset;
        this.mUpdatedNodes.put(tag, (Object)node);
    }

    @UiThread
    public void flattenAnimatedNodeOffset(int tag) {
        AnimatedNode node = (AnimatedNode)this.mAnimatedNodes.get(tag);
        if (node == null || !(node instanceof ValueAnimatedNode)) {
            throw new JSApplicationIllegalArgumentException("flattenAnimatedNodeOffset: Animated node [" + tag + "] does not exist, or is not a 'value' node");
        }
        ((ValueAnimatedNode)node).flattenOffset();
    }

    @UiThread
    public void extractAnimatedNodeOffset(int tag) {
        AnimatedNode node = (AnimatedNode)this.mAnimatedNodes.get(tag);
        if (node == null || !(node instanceof ValueAnimatedNode)) {
            throw new JSApplicationIllegalArgumentException("extractAnimatedNodeOffset: Animated node [" + tag + "] does not exist, or is not a 'value' node");
        }
        ((ValueAnimatedNode)node).extractOffset();
    }

    @UiThread
    public void startAnimatingNode(int animationId, int animatedNodeTag, ReadableMap animationConfig, Callback endCallback) {
        AnimationDriver animation;
        AnimatedNode node = (AnimatedNode)this.mAnimatedNodes.get(animatedNodeTag);
        if (node == null) {
            throw new JSApplicationIllegalArgumentException("startAnimatingNode: Animated node [" + animatedNodeTag + "] does not exist");
        }
        if (!(node instanceof ValueAnimatedNode)) {
            throw new JSApplicationIllegalArgumentException("startAnimatingNode: Animated node [" + animatedNodeTag + "] should be of type " + ValueAnimatedNode.class.getName());
        }
        AnimationDriver existingDriver = (AnimationDriver)this.mActiveAnimations.get(animationId);
        if (existingDriver != null) {
            existingDriver.resetConfig(animationConfig);
            return;
        }
        String type = animationConfig.getString("type");
        if ("frames".equals(type)) {
            animation = new FrameBasedAnimationDriver(animationConfig);
        } else if ("spring".equals(type)) {
            animation = new SpringAnimation(animationConfig);
        } else if ("decay".equals(type)) {
            animation = new DecayAnimation(animationConfig);
        } else {
            throw new JSApplicationIllegalArgumentException("startAnimatingNode: Unsupported animation type [" + animatedNodeTag + "]: " + type);
        }
        animation.mId = animationId;
        animation.mEndCallback = endCallback;
        animation.mAnimatedValue = (ValueAnimatedNode)node;
        this.mActiveAnimations.put(animationId, (Object)animation);
    }

    @UiThread
    private void stopAnimationsForNode(AnimatedNode animatedNode) {
        for (int i = 0; i < this.mActiveAnimations.size(); ++i) {
            AnimationDriver animation = (AnimationDriver)this.mActiveAnimations.valueAt(i);
            if (!animatedNode.equals(animation.mAnimatedValue)) continue;
            if (animation.mEndCallback != null) {
                WritableMap endCallbackResponse = Arguments.createMap();
                endCallbackResponse.putBoolean("finished", false);
                animation.mEndCallback.invoke(endCallbackResponse);
            } else if (this.mReactApplicationContext != null) {
                WritableMap params = Arguments.createMap();
                params.putInt("animationId", animation.mId);
                params.putBoolean("finished", false);
                this.mReactApplicationContext.emitDeviceEvent("onNativeAnimatedModuleAnimationFinished", params);
            }
            this.mActiveAnimations.removeAt(i);
            --i;
        }
    }

    @UiThread
    public void stopAnimation(int animationId) {
        for (int i = 0; i < this.mActiveAnimations.size(); ++i) {
            AnimationDriver animation = (AnimationDriver)this.mActiveAnimations.valueAt(i);
            if (animation.mId != animationId) continue;
            if (animation.mEndCallback != null) {
                WritableMap endCallbackResponse = Arguments.createMap();
                endCallbackResponse.putBoolean("finished", false);
                animation.mEndCallback.invoke(endCallbackResponse);
            } else if (this.mReactApplicationContext != null) {
                WritableMap params = Arguments.createMap();
                params.putInt("animationId", animation.mId);
                params.putBoolean("finished", false);
                this.mReactApplicationContext.emitDeviceEvent("onNativeAnimatedModuleAnimationFinished", params);
            }
            this.mActiveAnimations.removeAt(i);
            return;
        }
    }

    @UiThread
    public void connectAnimatedNodes(int parentNodeTag, int childNodeTag) {
        AnimatedNode parentNode = (AnimatedNode)this.mAnimatedNodes.get(parentNodeTag);
        if (parentNode == null) {
            throw new JSApplicationIllegalArgumentException("connectAnimatedNodes: Animated node with tag (parent) [" + parentNodeTag + "] does not exist");
        }
        AnimatedNode childNode = (AnimatedNode)this.mAnimatedNodes.get(childNodeTag);
        if (childNode == null) {
            throw new JSApplicationIllegalArgumentException("connectAnimatedNodes: Animated node with tag (child) [" + childNodeTag + "] does not exist");
        }
        parentNode.addChild(childNode);
        this.mUpdatedNodes.put(childNodeTag, (Object)childNode);
    }

    public void disconnectAnimatedNodes(int parentNodeTag, int childNodeTag) {
        AnimatedNode parentNode = (AnimatedNode)this.mAnimatedNodes.get(parentNodeTag);
        if (parentNode == null) {
            throw new JSApplicationIllegalArgumentException("disconnectAnimatedNodes: Animated node with tag (parent) [" + parentNodeTag + "] does not exist");
        }
        AnimatedNode childNode = (AnimatedNode)this.mAnimatedNodes.get(childNodeTag);
        if (childNode == null) {
            throw new JSApplicationIllegalArgumentException("disconnectAnimatedNodes: Animated node with tag (child) [" + childNodeTag + "] does not exist");
        }
        parentNode.removeChild(childNode);
        this.mUpdatedNodes.put(childNodeTag, (Object)childNode);
    }

    @UiThread
    public void connectAnimatedNodeToView(int animatedNodeTag, int viewTag) {
        AnimatedNode node = (AnimatedNode)this.mAnimatedNodes.get(animatedNodeTag);
        if (node == null) {
            throw new JSApplicationIllegalArgumentException("connectAnimatedNodeToView: Animated node with tag [" + animatedNodeTag + "] does not exist");
        }
        if (!(node instanceof PropsAnimatedNode)) {
            throw new JSApplicationIllegalArgumentException("connectAnimatedNodeToView: Animated node connected to view [" + viewTag + "] should be of type " + PropsAnimatedNode.class.getName());
        }
        if (this.mReactApplicationContext == null) {
            throw new IllegalStateException("connectAnimatedNodeToView: Animated node could not be connected, no ReactApplicationContext: " + viewTag);
        }
        UIManager uiManager = UIManagerHelper.getUIManagerForReactTag(this.mReactApplicationContext, viewTag);
        if (uiManager == null) {
            ReactSoftExceptionLogger.logSoftException(TAG, new ReactNoCrashSoftException("connectAnimatedNodeToView: Animated node could not be connected to UIManager - uiManager disappeared for tag: " + viewTag));
            return;
        }
        PropsAnimatedNode propsAnimatedNode = (PropsAnimatedNode)node;
        propsAnimatedNode.connectToView(viewTag, uiManager);
        this.mUpdatedNodes.put(animatedNodeTag, (Object)node);
    }

    @UiThread
    public void disconnectAnimatedNodeFromView(int animatedNodeTag, int viewTag) {
        AnimatedNode node = (AnimatedNode)this.mAnimatedNodes.get(animatedNodeTag);
        if (node == null) {
            throw new JSApplicationIllegalArgumentException("disconnectAnimatedNodeFromView: Animated node with tag [" + animatedNodeTag + "] does not exist");
        }
        if (!(node instanceof PropsAnimatedNode)) {
            throw new JSApplicationIllegalArgumentException("disconnectAnimatedNodeFromView: Animated node connected to view [" + viewTag + "] should be of type " + PropsAnimatedNode.class.getName());
        }
        PropsAnimatedNode propsAnimatedNode = (PropsAnimatedNode)node;
        propsAnimatedNode.disconnectFromView(viewTag);
    }

    @UiThread
    public void getValue(int tag, Callback callback) {
        AnimatedNode node = (AnimatedNode)this.mAnimatedNodes.get(tag);
        if (node == null || !(node instanceof ValueAnimatedNode)) {
            throw new JSApplicationIllegalArgumentException("getValue: Animated node with tag [" + tag + "] does not exist or is not a 'value' node");
        }
        double value = ((ValueAnimatedNode)node).getValue();
        if (callback != null) {
            callback.invoke(value);
            return;
        }
        if (this.mReactApplicationContext == null) {
            return;
        }
        WritableMap params = Arguments.createMap();
        params.putInt("tag", tag);
        params.putDouble("value", value);
        this.mReactApplicationContext.emitDeviceEvent("onNativeAnimatedModuleGetValue", params);
    }

    @UiThread
    public void restoreDefaultValues(int animatedNodeTag) {
        AnimatedNode node = (AnimatedNode)this.mAnimatedNodes.get(animatedNodeTag);
        if (node == null) {
            return;
        }
        if (!(node instanceof PropsAnimatedNode)) {
            throw new JSApplicationIllegalArgumentException("Animated node connected to view [?] should be of type " + PropsAnimatedNode.class.getName());
        }
        PropsAnimatedNode propsAnimatedNode = (PropsAnimatedNode)node;
        propsAnimatedNode.restoreDefaultValues();
    }

    @UiThread
    public void addAnimatedEventToView(int viewTag, String eventHandlerName, ReadableMap eventMapping) {
        int nodeTag = eventMapping.getInt("animatedValueTag");
        AnimatedNode node = (AnimatedNode)this.mAnimatedNodes.get(nodeTag);
        if (node == null) {
            throw new JSApplicationIllegalArgumentException("addAnimatedEventToView: Animated node with tag [" + nodeTag + "] does not exist");
        }
        if (!(node instanceof ValueAnimatedNode)) {
            throw new JSApplicationIllegalArgumentException("addAnimatedEventToView: Animated node on view [" + viewTag + "] connected to event handler (" + eventHandlerName + ") should be of type " + ValueAnimatedNode.class.getName());
        }
        ReadableArray path = eventMapping.getArray("nativeEventPath");
        ArrayList<String> pathList = new ArrayList<String>(path.size());
        for (int i = 0; i < path.size(); ++i) {
            pathList.add(path.getString(i));
        }
        String eventName = this.normalizeEventName(eventHandlerName);
        EventAnimationDriver eventDriver = new EventAnimationDriver(eventName, viewTag, pathList, (ValueAnimatedNode)node);
        this.mEventDrivers.add(eventDriver);
    }

    @UiThread
    public void removeAnimatedEventFromView(int viewTag, String eventHandlerName, int animatedValueTag) {
        String eventName = this.normalizeEventName(eventHandlerName);
        ListIterator<EventAnimationDriver> it = this.mEventDrivers.listIterator();
        while (it.hasNext()) {
            EventAnimationDriver driver = it.next();
            if (!eventName.equals(driver.mEventName) || viewTag != driver.mViewTag || animatedValueTag != driver.mValueNode.mTag) continue;
            it.remove();
            break;
        }
    }

    @Override
    public void onEventDispatch(final Event event) {
        if (UiThreadUtil.isOnUiThread()) {
            this.handleEvent(event);
        } else {
            UiThreadUtil.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    NativeAnimatedNodesManager.this.handleEvent(event);
                }
            });
        }
    }

    @UiThread
    private void handleEvent(Event event) {
        if (!this.mEventDrivers.isEmpty()) {
            if (this.mReactApplicationContext == null) {
                return;
            }
            UIManager uiManager = UIManagerHelper.getUIManager(this.mReactApplicationContext, event.getUIManagerType());
            if (uiManager == null) {
                return;
            }
            boolean foundAtLeastOneDriver = false;
            Event.EventAnimationDriverMatchSpec matchSpec = event.getEventAnimationDriverMatchSpec();
            for (EventAnimationDriver driver : this.mEventDrivers) {
                if (!matchSpec.match(driver.mViewTag, driver.mEventName)) continue;
                foundAtLeastOneDriver = true;
                this.stopAnimationsForNode(driver.mValueNode);
                event.dispatch(driver);
                this.mRunUpdateNodeList.add(driver.mValueNode);
            }
            if (foundAtLeastOneDriver) {
                this.updateNodes(this.mRunUpdateNodeList);
                this.mRunUpdateNodeList.clear();
            }
        }
    }

    @UiThread
    public void runUpdates(long frameTimeNanos) {
        AnimationDriver animation;
        int i;
        UiThreadUtil.assertOnUiThread();
        boolean hasFinishedAnimations = false;
        for (i = 0; i < this.mUpdatedNodes.size(); ++i) {
            AnimatedNode node = (AnimatedNode)this.mUpdatedNodes.valueAt(i);
            this.mRunUpdateNodeList.add(node);
        }
        this.mUpdatedNodes.clear();
        for (i = 0; i < this.mActiveAnimations.size(); ++i) {
            animation = (AnimationDriver)this.mActiveAnimations.valueAt(i);
            animation.runAnimationStep(frameTimeNanos);
            ValueAnimatedNode valueNode = animation.mAnimatedValue;
            this.mRunUpdateNodeList.add(valueNode);
            if (!animation.mHasFinished) continue;
            hasFinishedAnimations = true;
        }
        this.updateNodes(this.mRunUpdateNodeList);
        this.mRunUpdateNodeList.clear();
        if (hasFinishedAnimations) {
            for (i = this.mActiveAnimations.size() - 1; i >= 0; --i) {
                animation = (AnimationDriver)this.mActiveAnimations.valueAt(i);
                if (!animation.mHasFinished) continue;
                if (animation.mEndCallback != null) {
                    WritableMap endCallbackResponse = Arguments.createMap();
                    endCallbackResponse.putBoolean("finished", true);
                    animation.mEndCallback.invoke(endCallbackResponse);
                } else if (this.mReactApplicationContext != null) {
                    WritableMap params = Arguments.createMap();
                    params.putInt("animationId", animation.mId);
                    params.putBoolean("finished", true);
                    this.mReactApplicationContext.emitDeviceEvent("onNativeAnimatedModuleAnimationFinished", params);
                }
                this.mActiveAnimations.removeAt(i);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @UiThread
    private void updateNodes(List<AnimatedNode> nodes) {
        int activeNodesCount = 0;
        int updatedNodesCount = 0;
        ++this.mAnimatedGraphBFSColor;
        if (this.mAnimatedGraphBFSColor == 0) {
            ++this.mAnimatedGraphBFSColor;
        }
        ArrayDeque<AnimatedNode> nodesQueue = new ArrayDeque<AnimatedNode>();
        for (AnimatedNode node : nodes) {
            if (node.mBFSColor == this.mAnimatedGraphBFSColor) continue;
            node.mBFSColor = this.mAnimatedGraphBFSColor;
            ++activeNodesCount;
            nodesQueue.add(node);
        }
        while (!nodesQueue.isEmpty()) {
            AnimatedNode nextNode = (AnimatedNode)nodesQueue.poll();
            if (nextNode.mChildren == null) continue;
            for (int i = 0; i < nextNode.mChildren.size(); ++i) {
                AnimatedNode child = nextNode.mChildren.get(i);
                ++child.mActiveIncomingNodes;
                if (child.mBFSColor == this.mAnimatedGraphBFSColor) continue;
                child.mBFSColor = this.mAnimatedGraphBFSColor;
                ++activeNodesCount;
                nodesQueue.add(child);
            }
        }
        ++this.mAnimatedGraphBFSColor;
        if (this.mAnimatedGraphBFSColor == 0) {
            ++this.mAnimatedGraphBFSColor;
        }
        for (AnimatedNode node : nodes) {
            if (node.mActiveIncomingNodes != 0 || node.mBFSColor == this.mAnimatedGraphBFSColor) continue;
            node.mBFSColor = this.mAnimatedGraphBFSColor;
            ++updatedNodesCount;
            nodesQueue.add(node);
        }
        int cyclesDetected = 0;
        while (!nodesQueue.isEmpty()) {
            AnimatedNode nextNode = (AnimatedNode)nodesQueue.poll();
            try {
                nextNode.update();
                if (nextNode instanceof PropsAnimatedNode) {
                    ((PropsAnimatedNode)nextNode).updateView();
                }
            }
            catch (JSApplicationCausedNativeException e) {
                FLog.e((String)TAG, (String)"Native animation workaround, frame lost as result of race condition", (Throwable)e);
            }
            if (nextNode instanceof ValueAnimatedNode) {
                ((ValueAnimatedNode)nextNode).onValueUpdate();
            }
            if (nextNode.mChildren == null) continue;
            for (int i = 0; i < nextNode.mChildren.size(); ++i) {
                AnimatedNode child = nextNode.mChildren.get(i);
                --child.mActiveIncomingNodes;
                if (child.mBFSColor != this.mAnimatedGraphBFSColor && child.mActiveIncomingNodes == 0) {
                    child.mBFSColor = this.mAnimatedGraphBFSColor;
                    ++updatedNodesCount;
                    nodesQueue.add(child);
                    continue;
                }
                if (child.mBFSColor != this.mAnimatedGraphBFSColor) continue;
                ++cyclesDetected;
            }
        }
        if (activeNodesCount != updatedNodesCount) {
            if (this.mWarnedAboutGraphTraversal) {
                return;
            }
            this.mWarnedAboutGraphTraversal = true;
            FLog.e((String)TAG, (String)"Detected animation cycle or disconnected graph. ");
            for (AnimatedNode node : nodes) {
                FLog.e((String)TAG, (String)node.prettyPrintWithChildren());
            }
            String reason = cyclesDetected > 0 ? "cycles (" + cyclesDetected + ")" : "disconnected regions";
            IllegalStateException ex = new IllegalStateException("Looks like animated nodes graph has " + reason + ", there are " + activeNodesCount + " but toposort visited only " + updatedNodesCount);
            if (this.mEventListenerInitializedForFabric && cyclesDetected == 0) {
                ReactSoftExceptionLogger.logSoftException(TAG, new ReactNoCrashSoftException(ex));
                return;
            } else {
                if (!this.mEventListenerInitializedForFabric) throw ex;
                ReactSoftExceptionLogger.logSoftException(TAG, new ReactNoCrashSoftException(ex));
            }
            return;
        } else {
            this.mWarnedAboutGraphTraversal = false;
        }
    }

    private String normalizeEventName(String eventHandlerName) {
        String eventName = eventHandlerName;
        if (eventHandlerName.startsWith("on")) {
            eventName = "top" + eventHandlerName.substring(2);
        }
        return eventName;
    }
}

