/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.fabric;

import android.annotation.SuppressLint;
import android.content.ComponentCallbacks;
import android.content.Context;
import android.graphics.Point;
import android.os.SystemClock;
import android.view.View;
import androidx.annotation.AnyThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.UiThread;
import com.facebook.common.logging.FLog;
import com.facebook.debug.holder.PrinterHolder;
import com.facebook.debug.tags.ReactDebugOverlayTags;
import com.facebook.infer.annotation.ThreadConfined;
import com.facebook.proguard.annotations.DoNotStripAny;
import com.facebook.react.bridge.ColorPropConverter;
import com.facebook.react.bridge.LifecycleEventListener;
import com.facebook.react.bridge.NativeArray;
import com.facebook.react.bridge.NativeMap;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReactMarker;
import com.facebook.react.bridge.ReactMarkerConstants;
import com.facebook.react.bridge.ReactSoftExceptionLogger;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.UIManager;
import com.facebook.react.bridge.UIManagerListener;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.common.mapbuffer.ReadableMapBuffer;
import com.facebook.react.config.ReactFeatureFlags;
import com.facebook.react.fabric.Binding;
import com.facebook.react.fabric.DevToolsReactPerfLogger;
import com.facebook.react.fabric.FabricComponents;
import com.facebook.react.fabric.FabricSoLoader;
import com.facebook.react.fabric.GuardedFrameCallback;
import com.facebook.react.fabric.SurfaceHandler;
import com.facebook.react.fabric.SurfaceHandlerBinding;
import com.facebook.react.fabric.events.EventEmitterWrapper;
import com.facebook.react.fabric.events.FabricEventEmitter;
import com.facebook.react.fabric.interop.InteropEventEmitter;
import com.facebook.react.fabric.mounting.LayoutMetricsConversions;
import com.facebook.react.fabric.mounting.MountItemDispatcher;
import com.facebook.react.fabric.mounting.MountingManager;
import com.facebook.react.fabric.mounting.SurfaceMountingManager;
import com.facebook.react.fabric.mounting.mountitems.DispatchCommandMountItem;
import com.facebook.react.fabric.mounting.mountitems.DispatchIntCommandMountItem;
import com.facebook.react.fabric.mounting.mountitems.DispatchStringCommandMountItem;
import com.facebook.react.fabric.mounting.mountitems.IntBufferBatchMountItem;
import com.facebook.react.fabric.mounting.mountitems.MountItem;
import com.facebook.react.fabric.mounting.mountitems.PreAllocateViewMountItem;
import com.facebook.react.fabric.mounting.mountitems.SendAccessibilityEvent;
import com.facebook.react.modules.core.ReactChoreographer;
import com.facebook.react.modules.i18nmanager.I18nUtil;
import com.facebook.react.uimanager.IllegalViewOperationException;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.ReactRoot;
import com.facebook.react.uimanager.ReactRootViewTagGenerator;
import com.facebook.react.uimanager.RootViewUtil;
import com.facebook.react.uimanager.StateWrapper;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.UIManagerHelper;
import com.facebook.react.uimanager.ViewManagerPropertyUpdater;
import com.facebook.react.uimanager.ViewManagerRegistry;
import com.facebook.react.uimanager.events.BatchEventDispatchedListener;
import com.facebook.react.uimanager.events.EventDispatcher;
import com.facebook.react.uimanager.events.EventDispatcherImpl;
import com.facebook.react.uimanager.events.RCTEventEmitter;
import com.facebook.react.views.text.TextLayoutManager;
import com.facebook.react.views.text.TextLayoutManagerMapBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.CopyOnWriteArrayList;

@SuppressLint(value={"MissingNativeLoadLibrary"})
@DoNotStripAny
public class FabricUIManager
implements UIManager,
LifecycleEventListener {
    public static final String TAG = FabricUIManager.class.getSimpleName();
    public static final boolean IS_DEVELOPMENT_ENVIRONMENT = false;
    public static final boolean ENABLE_FABRIC_LOGS;
    public static final boolean ENABLE_FABRIC_PERF_LOGS;
    public DevToolsReactPerfLogger mDevToolsReactPerfLogger;
    private static final DevToolsReactPerfLogger.DevToolsReactPerfLoggerListener FABRIC_PERF_LOGGER;
    @Nullable
    private Binding mBinding;
    @NonNull
    private final ReactApplicationContext mReactApplicationContext;
    @NonNull
    private final MountingManager mMountingManager;
    @NonNull
    private final EventDispatcher mEventDispatcher;
    @NonNull
    private final MountItemDispatcher mMountItemDispatcher;
    @NonNull
    private final ViewManagerRegistry mViewManagerRegistry;
    @NonNull
    private final BatchEventDispatchedListener mBatchEventDispatchedListener;
    @NonNull
    private final CopyOnWriteArrayList<UIManagerListener> mListeners = new CopyOnWriteArrayList();
    @ThreadConfined(value="UI")
    @NonNull
    private final DispatchUIFrameCallback mDispatchUIFrameCallback;
    private volatile boolean mDestroyed = false;
    private boolean mDriveCxxAnimations = false;
    private long mDispatchViewUpdatesTime = 0L;
    private long mCommitStartTime = 0L;
    private long mLayoutTime = 0L;
    private long mFinishTransactionTime = 0L;
    private long mFinishTransactionCPPTime = 0L;
    private int mCurrentSynchronousCommitNumber = 10000;
    private MountingManager.MountItemExecutor mMountItemExecutor = new MountingManager.MountItemExecutor(){

        @Override
        public void executeItems(Queue<MountItem> items) {
            FabricUIManager.this.mMountItemDispatcher.dispatchMountItems(items);
        }
    };

    public FabricUIManager(@NonNull ReactApplicationContext reactContext, @NonNull ViewManagerRegistry viewManagerRegistry, @NonNull BatchEventDispatchedListener batchEventDispatchedListener) {
        this.mDispatchUIFrameCallback = new DispatchUIFrameCallback(reactContext);
        this.mReactApplicationContext = reactContext;
        this.mMountingManager = new MountingManager(viewManagerRegistry, this.mMountItemExecutor);
        this.mMountItemDispatcher = new MountItemDispatcher(this.mMountingManager, new MountItemDispatchListener());
        this.mEventDispatcher = new EventDispatcherImpl(reactContext);
        this.mBatchEventDispatchedListener = batchEventDispatchedListener;
        this.mReactApplicationContext.addLifecycleEventListener(this);
        this.mViewManagerRegistry = viewManagerRegistry;
        this.mReactApplicationContext.registerComponentCallbacks((ComponentCallbacks)viewManagerRegistry);
    }

    @Override
    @Deprecated
    @UiThread
    @ThreadConfined(value="UI")
    public <T extends View> int addRootView(T rootView, WritableMap initialProps, @Nullable String initialUITemplate) {
        ReactSoftExceptionLogger.logSoftException(TAG, new IllegalViewOperationException("Do not call addRootView in Fabric; it is unsupported. Call startSurface instead."));
        ReactRoot reactRootView = (ReactRoot)rootView;
        int rootTag = reactRootView.getRootViewTag();
        ThemedReactContext reactContext = new ThemedReactContext(this.mReactApplicationContext, rootView.getContext(), reactRootView.getSurfaceID(), rootTag);
        this.mMountingManager.startSurface(rootTag, reactContext, rootView);
        String moduleName = reactRootView.getJSModuleName();
        if (ENABLE_FABRIC_LOGS) {
            FLog.d((String)TAG, (String)"Starting surface for module: %s and reactTag: %d", (Object)moduleName, (Object)rootTag);
        }
        this.mBinding.startSurface(rootTag, moduleName, (NativeMap)((Object)initialProps));
        if (initialUITemplate != null) {
            this.mBinding.renderTemplateToSurface(rootTag, initialUITemplate);
        }
        return rootTag;
    }

    @UiThread
    @ThreadConfined(value="UI")
    public ReadableMap getInspectorDataForInstance(int surfaceId, View view) {
        UiThreadUtil.assertOnUiThread();
        int reactTag = view.getId();
        EventEmitterWrapper eventEmitter = this.mMountingManager.getEventEmitter(surfaceId, reactTag);
        return this.mBinding.getInspectorDataForInstance(eventEmitter);
    }

    @Override
    @AnyThread
    @ThreadConfined(value="ANY")
    public <T extends View> int startSurface(T rootView, String moduleName, WritableMap initialProps, int widthMeasureSpec, int heightMeasureSpec) {
        int rootTag = ((ReactRoot)rootView).getRootViewTag();
        Context context = rootView.getContext();
        ThemedReactContext reactContext = new ThemedReactContext(this.mReactApplicationContext, context, moduleName, rootTag);
        if (ENABLE_FABRIC_LOGS) {
            FLog.d((String)TAG, (String)"Starting surface for module: %s and reactTag: %d", (Object)moduleName, (Object)rootTag);
        }
        this.mMountingManager.startSurface(rootTag, reactContext, rootView);
        Point viewportOffset = UiThreadUtil.isOnUiThread() ? RootViewUtil.getViewportOffset(rootView) : new Point(0, 0);
        this.mBinding.startSurfaceWithConstraints(rootTag, moduleName, (NativeMap)((Object)initialProps), LayoutMetricsConversions.getMinSize(widthMeasureSpec), LayoutMetricsConversions.getMaxSize(widthMeasureSpec), LayoutMetricsConversions.getMinSize(heightMeasureSpec), LayoutMetricsConversions.getMaxSize(heightMeasureSpec), viewportOffset.x, viewportOffset.y, I18nUtil.getInstance().isRTL(context), I18nUtil.getInstance().doLeftAndRightSwapInRTL(context));
        return rootTag;
    }

    public void startSurface(SurfaceHandler surfaceHandler, Context context, @Nullable View rootView) {
        int rootTag = ReactRootViewTagGenerator.getNextRootViewTag();
        ThemedReactContext reactContext = new ThemedReactContext(this.mReactApplicationContext, context, surfaceHandler.getModuleName(), rootTag);
        this.mMountingManager.startSurface(rootTag, reactContext, rootView);
        surfaceHandler.setSurfaceId(rootTag);
        if (surfaceHandler instanceof SurfaceHandlerBinding) {
            this.mBinding.registerSurface((SurfaceHandlerBinding)surfaceHandler);
        }
        surfaceHandler.setMountable(rootView != null);
        surfaceHandler.start();
    }

    public void attachRootView(SurfaceHandler surfaceHandler, View rootView) {
        ThemedReactContext reactContext = new ThemedReactContext(this.mReactApplicationContext, rootView.getContext(), surfaceHandler.getModuleName(), surfaceHandler.getSurfaceId());
        this.mMountingManager.attachRootView(surfaceHandler.getSurfaceId(), rootView, reactContext);
        surfaceHandler.setMountable(true);
    }

    public void stopSurface(SurfaceHandler surfaceHandler) {
        if (!surfaceHandler.isRunning()) {
            ReactSoftExceptionLogger.logSoftException(TAG, new IllegalStateException("Trying to stop surface that hasn't started yet"));
            return;
        }
        this.mMountingManager.stopSurface(surfaceHandler.getSurfaceId());
        surfaceHandler.stop();
        if (surfaceHandler instanceof SurfaceHandlerBinding) {
            this.mBinding.unregisterSurface((SurfaceHandlerBinding)surfaceHandler);
        }
    }

    public void onRequestEventBeat() {
        this.mEventDispatcher.dispatchAllEvents();
    }

    @Override
    @AnyThread
    @ThreadConfined(value="ANY")
    public void stopSurface(int surfaceID) {
        this.mMountingManager.stopSurface(surfaceID);
        this.mBinding.stopSurface(surfaceID);
    }

    @Override
    public void initialize() {
        this.mEventDispatcher.registerEventEmitter(2, new FabricEventEmitter(this));
        this.mEventDispatcher.addBatchEventDispatchedListener(this.mBatchEventDispatchedListener);
        if (ENABLE_FABRIC_PERF_LOGS) {
            this.mDevToolsReactPerfLogger = new DevToolsReactPerfLogger();
            this.mDevToolsReactPerfLogger.addDevToolsReactPerfLoggerListener(FABRIC_PERF_LOGGER);
            ReactMarker.addFabricListener(this.mDevToolsReactPerfLogger);
        }
        if (ReactFeatureFlags.unstable_useFabricInterop) {
            InteropEventEmitter interopEventEmitter = new InteropEventEmitter(this.mReactApplicationContext);
            this.mReactApplicationContext.internal_registerInteropModule(RCTEventEmitter.class, interopEventEmitter);
        }
    }

    @Override
    @AnyThread
    @ThreadConfined(value="ANY")
    public void onCatalystInstanceDestroy() {
        FLog.i((String)TAG, (String)"FabricUIManager.onCatalystInstanceDestroy");
        if (this.mDevToolsReactPerfLogger != null) {
            this.mDevToolsReactPerfLogger.removeDevToolsReactPerfLoggerListener(FABRIC_PERF_LOGGER);
            ReactMarker.removeFabricListener(this.mDevToolsReactPerfLogger);
        }
        if (this.mDestroyed) {
            ReactSoftExceptionLogger.logSoftException(TAG, new IllegalStateException("Cannot double-destroy FabricUIManager"));
            return;
        }
        this.mDestroyed = true;
        this.mDispatchUIFrameCallback.stop();
        this.mEventDispatcher.removeBatchEventDispatchedListener(this.mBatchEventDispatchedListener);
        this.mEventDispatcher.unregisterEventEmitter(2);
        this.mReactApplicationContext.unregisterComponentCallbacks((ComponentCallbacks)this.mViewManagerRegistry);
        this.mViewManagerRegistry.invalidate();
        this.mReactApplicationContext.removeLifecycleEventListener(this);
        this.onHostPause();
        this.mBinding.unregister();
        this.mBinding = null;
        ViewManagerPropertyUpdater.clear();
        if (!ReactFeatureFlags.enableBridgelessArchitecture) {
            this.mEventDispatcher.onCatalystInstanceDestroyed();
        }
    }

    private NativeArray measureLines(ReadableMap attributedString, ReadableMap paragraphAttributes, float width, float height) {
        return (NativeArray)((Object)TextLayoutManager.measureLines((Context)this.mReactApplicationContext, attributedString, paragraphAttributes, PixelUtil.toPixelFromDIP(width)));
    }

    private NativeArray measureLinesMapBuffer(ReadableMapBuffer attributedString, ReadableMapBuffer paragraphAttributes, float width, float height) {
        return (NativeArray)((Object)TextLayoutManagerMapBuffer.measureLines((Context)this.mReactApplicationContext, attributedString, paragraphAttributes, PixelUtil.toPixelFromDIP(width)));
    }

    private long measure(int rootTag, String componentName, ReadableMap localData, ReadableMap props, ReadableMap state, float minWidth, float maxWidth, float minHeight, float maxHeight) {
        return this.measure(rootTag, componentName, localData, props, state, minWidth, maxWidth, minHeight, maxHeight, null);
    }

    public int getColor(int surfaceId, String[] resourcePaths) {
        ThemedReactContext context = this.mMountingManager.getSurfaceManagerEnforced(surfaceId, "getColor").getContext();
        for (String resourcePath : resourcePaths) {
            Integer color = ColorPropConverter.resolveResourcePath((Context)context, resourcePath);
            if (color == null) continue;
            return color;
        }
        return 0;
    }

    private long measure(int surfaceId, String componentName, ReadableMap localData, ReadableMap props, ReadableMap state, float minWidth, float maxWidth, float minHeight, float maxHeight, @Nullable float[] attachmentsPositions) {
        ReactContext context;
        if (surfaceId > 0) {
            SurfaceMountingManager surfaceMountingManager = this.mMountingManager.getSurfaceManagerEnforced(surfaceId, "measure");
            if (surfaceMountingManager.isStopped()) {
                return 0L;
            }
            context = surfaceMountingManager.getContext();
        } else {
            context = this.mReactApplicationContext;
        }
        return this.mMountingManager.measure(context, componentName, localData, props, state, LayoutMetricsConversions.getYogaSize(minWidth, maxWidth), LayoutMetricsConversions.getYogaMeasureMode(minWidth, maxWidth), LayoutMetricsConversions.getYogaSize(minHeight, maxHeight), LayoutMetricsConversions.getYogaMeasureMode(minHeight, maxHeight), attachmentsPositions);
    }

    private long measureMapBuffer(int surfaceId, String componentName, ReadableMapBuffer localData, ReadableMapBuffer props, @Nullable ReadableMapBuffer state, float minWidth, float maxWidth, float minHeight, float maxHeight, @Nullable float[] attachmentsPositions) {
        ReactContext context;
        if (surfaceId > 0) {
            SurfaceMountingManager surfaceMountingManager = this.mMountingManager.getSurfaceManagerEnforced(surfaceId, "measure");
            if (surfaceMountingManager.isStopped()) {
                return 0L;
            }
            context = surfaceMountingManager.getContext();
        } else {
            context = this.mReactApplicationContext;
        }
        return this.mMountingManager.measureMapBuffer(context, componentName, localData, props, state, LayoutMetricsConversions.getYogaSize(minWidth, maxWidth), LayoutMetricsConversions.getYogaMeasureMode(minWidth, maxWidth), LayoutMetricsConversions.getYogaSize(minHeight, maxHeight), LayoutMetricsConversions.getYogaMeasureMode(minHeight, maxHeight), attachmentsPositions);
    }

    public boolean getThemeData(int surfaceId, float[] defaultTextInputPadding) {
        SurfaceMountingManager surfaceMountingManager = this.mMountingManager.getSurfaceManagerEnforced(surfaceId, "getThemeData");
        ThemedReactContext themedReactContext = surfaceMountingManager.getContext();
        if (themedReactContext == null) {
            FLog.w((String)TAG, (String)"\"themedReactContext\" is null when call \"getThemeData\"");
            return false;
        }
        float[] defaultTextInputPaddingForTheme = UIManagerHelper.getDefaultTextInputPadding(themedReactContext);
        defaultTextInputPadding[0] = defaultTextInputPaddingForTheme[0];
        defaultTextInputPadding[1] = defaultTextInputPaddingForTheme[1];
        defaultTextInputPadding[2] = defaultTextInputPaddingForTheme[2];
        defaultTextInputPadding[3] = defaultTextInputPaddingForTheme[3];
        return true;
    }

    @Override
    public void addUIManagerEventListener(UIManagerListener listener) {
        this.mListeners.add(listener);
    }

    @Override
    public void removeUIManagerEventListener(UIManagerListener listener) {
        this.mListeners.remove(listener);
    }

    @Override
    @UiThread
    @ThreadConfined(value="UI")
    public void synchronouslyUpdateViewOnUIThread(final int reactTag, final @NonNull ReadableMap props) {
        UiThreadUtil.assertOnUiThread();
        int commitNumber = this.mCurrentSynchronousCommitNumber++;
        MountItem synchronousMountItem = new MountItem(){

            @Override
            public void execute(@NonNull MountingManager mountingManager) {
                try {
                    mountingManager.updateProps(reactTag, props);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            @Override
            public int getSurfaceId() {
                return -1;
            }

            public String toString() {
                String propsString = "<hidden>";
                return String.format("SYNC UPDATE PROPS [%d]: %s", reactTag, propsString);
            }
        };
        if (!this.mMountingManager.getViewExists(reactTag)) {
            this.mMountItemDispatcher.addMountItem(synchronousMountItem);
            return;
        }
        ReactMarker.logFabricMarker(ReactMarkerConstants.FABRIC_UPDATE_UI_MAIN_THREAD_START, null, commitNumber);
        if (ENABLE_FABRIC_LOGS) {
            FLog.d((String)TAG, (String)"SynchronouslyUpdateViewOnUIThread for tag %d: %s", (Object)reactTag, (Object)"<hidden>");
        }
        synchronousMountItem.execute(this.mMountingManager);
        ReactMarker.logFabricMarker(ReactMarkerConstants.FABRIC_UPDATE_UI_MAIN_THREAD_END, null, commitNumber);
    }

    @AnyThread
    @ThreadConfined(value="ANY")
    private void preallocateView(int rootTag, int reactTag, String componentName, @Nullable Object props, @Nullable Object stateWrapper, @Nullable Object eventEmitterWrapper, boolean isLayoutable) {
        this.mMountItemDispatcher.addPreAllocateMountItem(new PreAllocateViewMountItem(rootTag, reactTag, FabricComponents.getFabricComponentName(componentName), props, (StateWrapper)stateWrapper, (EventEmitterWrapper)eventEmitterWrapper, isLayoutable));
    }

    @AnyThread
    @ThreadConfined(value="ANY")
    private MountItem createIntBufferBatchMountItem(int rootTag, int[] intBuffer, Object[] objBuffer, int commitNumber) {
        return new IntBufferBatchMountItem(rootTag, intBuffer, objBuffer, commitNumber);
    }

    @AnyThread
    @ThreadConfined(value="ANY")
    private void scheduleMountItem(@Nullable MountItem mountItem, int commitNumber, long commitStartTime, long diffStartTime, long diffEndTime, long layoutStartTime, long layoutEndTime, long finishTransactionStartTime, long finishTransactionEndTime) {
        long scheduleMountItemStartTime = SystemClock.uptimeMillis();
        boolean isBatchMountItem = mountItem instanceof IntBufferBatchMountItem;
        boolean shouldSchedule = isBatchMountItem && ((IntBufferBatchMountItem)mountItem).shouldSchedule() || !isBatchMountItem && mountItem != null;
        for (UIManagerListener listener : this.mListeners) {
            listener.didScheduleMountItems(this);
        }
        if (isBatchMountItem) {
            this.mCommitStartTime = commitStartTime;
            this.mLayoutTime = layoutEndTime - layoutStartTime;
            this.mFinishTransactionCPPTime = finishTransactionEndTime - finishTransactionStartTime;
            this.mFinishTransactionTime = scheduleMountItemStartTime - finishTransactionStartTime;
            this.mDispatchViewUpdatesTime = SystemClock.uptimeMillis();
        }
        if (shouldSchedule) {
            this.mMountItemDispatcher.addMountItem(mountItem);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    FabricUIManager.this.mMountItemDispatcher.tryDispatchMountItems();
                }
            };
            if (UiThreadUtil.isOnUiThread()) {
                runnable.run();
            } else if (ReactFeatureFlags.enableEarlyScheduledMountItemExecution) {
                UiThreadUtil.runOnUiThread(runnable);
            }
        }
        if (isBatchMountItem) {
            ReactMarker.logFabricMarker(ReactMarkerConstants.FABRIC_COMMIT_START, null, commitNumber, commitStartTime);
            ReactMarker.logFabricMarker(ReactMarkerConstants.FABRIC_FINISH_TRANSACTION_START, null, commitNumber, finishTransactionStartTime);
            ReactMarker.logFabricMarker(ReactMarkerConstants.FABRIC_FINISH_TRANSACTION_END, null, commitNumber, finishTransactionEndTime);
            ReactMarker.logFabricMarker(ReactMarkerConstants.FABRIC_DIFF_START, null, commitNumber, diffStartTime);
            ReactMarker.logFabricMarker(ReactMarkerConstants.FABRIC_DIFF_END, null, commitNumber, diffEndTime);
            ReactMarker.logFabricMarker(ReactMarkerConstants.FABRIC_LAYOUT_START, null, commitNumber, layoutStartTime);
            ReactMarker.logFabricMarker(ReactMarkerConstants.FABRIC_LAYOUT_END, null, commitNumber, layoutEndTime);
            ReactMarker.logFabricMarker(ReactMarkerConstants.FABRIC_COMMIT_END, null, commitNumber);
        }
    }

    public void setBinding(Binding binding) {
        this.mBinding = binding;
    }

    @Override
    @UiThread
    @ThreadConfined(value="UI")
    public void updateRootLayoutSpecs(int surfaceId, int widthMeasureSpec, int heightMeasureSpec, int offsetX, int offsetY) {
        SurfaceMountingManager surfaceMountingManager;
        if (ENABLE_FABRIC_LOGS) {
            FLog.d((String)TAG, (String)"Updating Root Layout Specs for [%d]", (Object)surfaceId);
        }
        if ((surfaceMountingManager = this.mMountingManager.getSurfaceManager(surfaceId)) == null) {
            ReactSoftExceptionLogger.logSoftException(TAG, new IllegalViewOperationException("Cannot updateRootLayoutSpecs on surfaceId that does not exist: " + surfaceId));
            return;
        }
        ThemedReactContext reactContext = surfaceMountingManager.getContext();
        boolean isRTL = false;
        boolean doLeftAndRightSwapInRTL = false;
        if (reactContext != null) {
            isRTL = I18nUtil.getInstance().isRTL((Context)reactContext);
            doLeftAndRightSwapInRTL = I18nUtil.getInstance().doLeftAndRightSwapInRTL((Context)reactContext);
        }
        this.mBinding.setConstraints(surfaceId, LayoutMetricsConversions.getMinSize(widthMeasureSpec), LayoutMetricsConversions.getMaxSize(widthMeasureSpec), LayoutMetricsConversions.getMinSize(heightMeasureSpec), LayoutMetricsConversions.getMaxSize(heightMeasureSpec), offsetX, offsetY, isRTL, doLeftAndRightSwapInRTL);
    }

    @Override
    public View resolveView(int reactTag) {
        UiThreadUtil.assertOnUiThread();
        SurfaceMountingManager surfaceManager = this.mMountingManager.getSurfaceManagerForView(reactTag);
        return surfaceManager == null ? null : surfaceManager.getView(reactTag);
    }

    @Override
    public void receiveEvent(int reactTag, String eventName, @Nullable WritableMap params) {
        this.receiveEvent(-1, reactTag, eventName, params);
    }

    @Override
    public void receiveEvent(int surfaceId, int reactTag, String eventName, @Nullable WritableMap params) {
        this.receiveEvent(surfaceId, reactTag, eventName, false, 0, params);
    }

    public void receiveEvent(int surfaceId, int reactTag, String eventName, boolean canCoalesceEvent, int customCoalesceKey, @Nullable WritableMap params) {
        this.receiveEvent(surfaceId, reactTag, eventName, canCoalesceEvent, customCoalesceKey, params, 2);
    }

    public void receiveEvent(int surfaceId, int reactTag, String eventName, boolean canCoalesceEvent, int customCoalesceKey, @Nullable WritableMap params, int eventCategory) {
        if (this.mDestroyed) {
            FLog.e((String)TAG, (String)"Attempted to receiveEvent after destruction");
            return;
        }
        EventEmitterWrapper eventEmitter = this.mMountingManager.getEventEmitter(surfaceId, reactTag);
        if (eventEmitter == null) {
            if (ReactFeatureFlags.enableFabricPendingEventQueue && this.mMountingManager.getViewExists(reactTag)) {
                this.mMountingManager.enqueuePendingEvent(reactTag, new SurfaceMountingManager.ViewEvent(eventName, params, eventCategory, canCoalesceEvent, customCoalesceKey));
            } else {
                FLog.d((String)TAG, (String)("Unable to invoke event: " + eventName + " for reactTag: " + reactTag));
            }
            return;
        }
        if (canCoalesceEvent) {
            eventEmitter.invokeUnique(eventName, params, customCoalesceKey);
        } else {
            eventEmitter.invoke(eventName, params, eventCategory);
        }
    }

    @Override
    public void onHostResume() {
        ReactChoreographer.getInstance().postFrameCallback(ReactChoreographer.CallbackType.DISPATCH_UI, this.mDispatchUIFrameCallback);
    }

    @NonNull
    public EventDispatcher getEventDispatcher() {
        return this.mEventDispatcher;
    }

    @Override
    public void onHostPause() {
        ReactChoreographer.getInstance().removeFrameCallback(ReactChoreographer.CallbackType.DISPATCH_UI, this.mDispatchUIFrameCallback);
    }

    @Override
    public void onHostDestroy() {
    }

    @Override
    @Deprecated
    @AnyThread
    @ThreadConfined(value="ANY")
    public void dispatchCommand(int reactTag, int commandId, @Nullable ReadableArray commandArgs) {
        throw new UnsupportedOperationException("dispatchCommand called without surfaceId - Fabric dispatchCommand must be called through Fabric JSI API");
    }

    @Override
    @Deprecated
    @AnyThread
    @ThreadConfined(value="ANY")
    public void dispatchCommand(int reactTag, String commandId, @Nullable ReadableArray commandArgs) {
        throw new UnsupportedOperationException("dispatchCommand called without surfaceId - Fabric dispatchCommand must be called through Fabric JSI API");
    }

    @Deprecated
    @AnyThread
    @ThreadConfined(value="ANY")
    public void dispatchCommand(int surfaceId, int reactTag, int commandId, @Nullable ReadableArray commandArgs) {
        this.mMountItemDispatcher.dispatchCommandMountItem(new DispatchIntCommandMountItem(surfaceId, reactTag, commandId, commandArgs));
    }

    @AnyThread
    @ThreadConfined(value="ANY")
    public void dispatchCommand(int surfaceId, int reactTag, String commandId, @Nullable ReadableArray commandArgs) {
        if (ReactFeatureFlags.unstable_useFabricInterop) {
            this.mMountItemDispatcher.dispatchCommandMountItem(this.createDispatchCommandMountItemForInterop(surfaceId, reactTag, commandId, commandArgs));
        } else {
            this.mMountItemDispatcher.dispatchCommandMountItem(new DispatchStringCommandMountItem(surfaceId, reactTag, commandId, commandArgs));
        }
    }

    @Override
    @AnyThread
    @ThreadConfined(value="ANY")
    public void sendAccessibilityEvent(int reactTag, int eventType) {
        this.mMountItemDispatcher.addMountItem(new SendAccessibilityEvent(-1, reactTag, eventType));
    }

    @AnyThread
    @ThreadConfined(value="ANY")
    public void sendAccessibilityEventFromJS(int surfaceId, int reactTag, String eventTypeJS) {
        int eventType;
        if ("focus".equals(eventTypeJS)) {
            eventType = 8;
        } else if ("windowStateChange".equals(eventTypeJS)) {
            eventType = 32;
        } else if ("click".equals(eventTypeJS)) {
            eventType = 1;
        } else if ("viewHoverEnter".equals(eventTypeJS)) {
            eventType = 128;
        } else {
            throw new IllegalArgumentException("sendAccessibilityEventFromJS: invalid eventType " + eventTypeJS);
        }
        this.mMountItemDispatcher.addMountItem(new SendAccessibilityEvent(surfaceId, reactTag, eventType));
    }

    public void setJSResponder(final int surfaceId, final int reactTag, final int initialReactTag, final boolean blockNativeResponder) {
        this.mMountItemDispatcher.addMountItem(new MountItem(){

            @Override
            public void execute(MountingManager mountingManager) {
                SurfaceMountingManager surfaceMountingManager = mountingManager.getSurfaceManager(surfaceId);
                if (surfaceMountingManager != null) {
                    surfaceMountingManager.setJSResponder(reactTag, initialReactTag, blockNativeResponder);
                } else {
                    FLog.e((String)TAG, (String)("setJSResponder skipped, surface no longer available [" + surfaceId + "]"));
                }
            }

            @Override
            public int getSurfaceId() {
                return surfaceId;
            }

            public String toString() {
                return String.format("SET_JS_RESPONDER [%d] [surface:%d]", reactTag, surfaceId);
            }
        });
    }

    public void clearJSResponder() {
        this.mMountItemDispatcher.addMountItem(new MountItem(){

            @Override
            public void execute(MountingManager mountingManager) {
                mountingManager.clearJSResponder();
            }

            @Override
            public int getSurfaceId() {
                return -1;
            }

            public String toString() {
                return "CLEAR_JS_RESPONDER";
            }
        });
    }

    @Override
    public void profileNextBatch() {
    }

    @Override
    @Deprecated
    @Nullable
    public String resolveCustomDirectEventName(@Nullable String eventName) {
        if (eventName == null) {
            return null;
        }
        if (eventName.startsWith("top")) {
            return "on" + eventName.substring(3);
        }
        return eventName;
    }

    @AnyThread
    public void onAnimationStarted() {
        this.mDriveCxxAnimations = true;
    }

    @AnyThread
    public void onAllAnimationsComplete() {
        this.mDriveCxxAnimations = false;
    }

    @Override
    public Map<String, Long> getPerformanceCounters() {
        HashMap<String, Long> performanceCounters = new HashMap<String, Long>();
        performanceCounters.put("CommitStartTime", this.mCommitStartTime);
        performanceCounters.put("LayoutTime", this.mLayoutTime);
        performanceCounters.put("DispatchViewUpdatesTime", this.mDispatchViewUpdatesTime);
        performanceCounters.put("RunStartTime", this.mMountItemDispatcher.getRunStartTime());
        performanceCounters.put("BatchedExecutionTime", this.mMountItemDispatcher.getBatchedExecutionTime());
        performanceCounters.put("FinishFabricTransactionTime", this.mFinishTransactionTime);
        performanceCounters.put("FinishFabricTransactionCPPTime", this.mFinishTransactionCPPTime);
        return performanceCounters;
    }

    DispatchCommandMountItem createDispatchCommandMountItemForInterop(int surfaceId, int reactTag, String commandId, @Nullable ReadableArray commandArgs) {
        try {
            int commandIdInteger = Integer.parseInt(commandId);
            return new DispatchIntCommandMountItem(surfaceId, reactTag, commandIdInteger, commandArgs);
        }
        catch (NumberFormatException e) {
            return new DispatchStringCommandMountItem(surfaceId, reactTag, commandId, commandArgs);
        }
    }

    static {
        boolean bl = ENABLE_FABRIC_LOGS = ReactFeatureFlags.enableFabricLogs || PrinterHolder.getPrinter().shouldDisplayLogMessage(ReactDebugOverlayTags.FABRIC_UI_MANAGER);
        ENABLE_FABRIC_PERF_LOGS = ENABLE_FABRIC_LOGS;
        FABRIC_PERF_LOGGER = new DevToolsReactPerfLogger.DevToolsReactPerfLoggerListener(){

            @Override
            public void onFabricCommitEnd(DevToolsReactPerfLogger.FabricCommitPoint commitPoint) {
                long commitDuration = commitPoint.getCommitDuration();
                long layoutDuration = commitPoint.getLayoutDuration();
                long diffDuration = commitPoint.getDiffDuration();
                long transactionEndDuration = commitPoint.getTransactionEndDuration();
                long batchExecutionDuration = commitPoint.getBatchExecutionDuration();
                DevToolsReactPerfLogger.mStreamingCommitStats.add(commitDuration);
                DevToolsReactPerfLogger.mStreamingLayoutStats.add(layoutDuration);
                DevToolsReactPerfLogger.mStreamingDiffStats.add(diffDuration);
                DevToolsReactPerfLogger.mStreamingTransactionEndStats.add(transactionEndDuration);
                DevToolsReactPerfLogger.mStreamingBatchExecutionStats.add(batchExecutionDuration);
                FLog.i((String)TAG, (String)"Statistics of Fabric commit #%d:\n - Total commit time: %d ms. Avg: %.2f. Median: %.2f ms. Max: %d ms.\n - Layout time: %d ms. Avg: %.2f. Median: %.2f ms. Max: %d ms.\n - Diffing time: %d ms. Avg: %.2f. Median: %.2f ms. Max: %d ms.\n - FinishTransaction (Diffing + JNI serialization): %d ms. Avg: %.2f. Median: %.2f ms. Max: %d ms.\n - Mounting: %d ms. Avg: %.2f. Median: %.2f ms. Max: %d ms.\n", (Object[])new Object[]{commitPoint.getCommitNumber(), commitDuration, DevToolsReactPerfLogger.mStreamingCommitStats.getAverage(), DevToolsReactPerfLogger.mStreamingCommitStats.getMedian(), DevToolsReactPerfLogger.mStreamingCommitStats.getMax(), layoutDuration, DevToolsReactPerfLogger.mStreamingLayoutStats.getAverage(), DevToolsReactPerfLogger.mStreamingLayoutStats.getMedian(), DevToolsReactPerfLogger.mStreamingLayoutStats.getMax(), diffDuration, DevToolsReactPerfLogger.mStreamingDiffStats.getAverage(), DevToolsReactPerfLogger.mStreamingDiffStats.getMedian(), DevToolsReactPerfLogger.mStreamingDiffStats.getMax(), transactionEndDuration, DevToolsReactPerfLogger.mStreamingTransactionEndStats.getAverage(), DevToolsReactPerfLogger.mStreamingTransactionEndStats.getMedian(), DevToolsReactPerfLogger.mStreamingTransactionEndStats.getMax(), batchExecutionDuration, DevToolsReactPerfLogger.mStreamingBatchExecutionStats.getAverage(), DevToolsReactPerfLogger.mStreamingBatchExecutionStats.getMedian(), DevToolsReactPerfLogger.mStreamingBatchExecutionStats.getMax()});
            }
        };
        FabricSoLoader.staticInit();
    }

    private class DispatchUIFrameCallback
    extends GuardedFrameCallback {
        private volatile boolean mIsMountingEnabled;

        private DispatchUIFrameCallback(ReactContext reactContext) {
            super(reactContext);
            this.mIsMountingEnabled = true;
        }

        @AnyThread
        void stop() {
            this.mIsMountingEnabled = false;
        }

        @Override
        @UiThread
        @ThreadConfined(value="UI")
        public void doFrameGuarded(long frameTimeNanos) {
            if (!this.mIsMountingEnabled || FabricUIManager.this.mDestroyed) {
                FLog.w((String)TAG, (String)"Not flushing pending UI operations because of previously thrown Exception");
                return;
            }
            if (FabricUIManager.this.mDriveCxxAnimations && FabricUIManager.this.mBinding != null) {
                FabricUIManager.this.mBinding.driveCxxAnimations();
            }
            try {
                FabricUIManager.this.mMountItemDispatcher.dispatchPreMountItems(frameTimeNanos);
                FabricUIManager.this.mMountItemDispatcher.tryDispatchMountItems();
            }
            catch (Exception ex) {
                FLog.e((String)TAG, (String)"Exception thrown when executing UIFrameGuarded", (Throwable)ex);
                this.stop();
                throw ex;
            }
            finally {
                ReactChoreographer.getInstance().postFrameCallback(ReactChoreographer.CallbackType.DISPATCH_UI, FabricUIManager.this.mDispatchUIFrameCallback);
            }
        }
    }

    private class MountItemDispatchListener
    implements MountItemDispatcher.ItemDispatchListener {
        private MountItemDispatchListener() {
        }

        @Override
        public void willMountItems() {
            for (UIManagerListener listener : FabricUIManager.this.mListeners) {
                listener.willMountItems(FabricUIManager.this);
            }
        }

        @Override
        public void didMountItems() {
            for (UIManagerListener listener : FabricUIManager.this.mListeners) {
                listener.didMountItems(FabricUIManager.this);
            }
        }

        @Override
        public void didDispatchMountItems() {
            for (UIManagerListener listener : FabricUIManager.this.mListeners) {
                listener.didDispatchMountItems(FabricUIManager.this);
            }
        }
    }
}

