/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.devsupport;

import android.content.Context;
import android.net.Uri;
import android.os.AsyncTask;
import android.text.SpannedString;
import android.text.method.LinkMovementMethod;
import android.util.Pair;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.ProgressBar;
import android.widget.TextView;
import androidx.annotation.Nullable;
import com.facebook.common.logging.FLog;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.R;
import com.facebook.react.common.MapBuilder;
import com.facebook.react.devsupport.StackTraceHelper;
import com.facebook.react.devsupport.interfaces.DevSupportManager;
import com.facebook.react.devsupport.interfaces.ErrorType;
import com.facebook.react.devsupport.interfaces.RedBoxHandler;
import com.facebook.react.devsupport.interfaces.StackFrame;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.json.JSONObject;

public class RedBoxContentView
extends LinearLayout
implements AdapterView.OnItemClickListener {
    @Nullable
    private RedBoxHandler mRedBoxHandler;
    private DevSupportManager mDevSupportManager;
    private ListView mStackView;
    private Button mReloadJsButton;
    private Button mDismissButton;
    @Nullable
    private Button mReportButton;
    @Nullable
    private TextView mReportTextView;
    @Nullable
    private ProgressBar mLoadingIndicator;
    @Nullable
    private View mLineSeparator;
    private boolean isReporting = false;
    private RedBoxHandler.ReportCompletedListener mReportCompletedListener = new RedBoxHandler.ReportCompletedListener(){

        @Override
        public void onReportSuccess(SpannedString spannedString) {
            RedBoxContentView.this.isReporting = false;
            ((Button)Assertions.assertNotNull((Object)RedBoxContentView.this.mReportButton)).setEnabled(true);
            ((ProgressBar)Assertions.assertNotNull((Object)RedBoxContentView.this.mLoadingIndicator)).setVisibility(8);
            ((TextView)Assertions.assertNotNull((Object)RedBoxContentView.this.mReportTextView)).setText((CharSequence)spannedString);
        }

        @Override
        public void onReportError(SpannedString spannedString) {
            RedBoxContentView.this.isReporting = false;
            ((Button)Assertions.assertNotNull((Object)RedBoxContentView.this.mReportButton)).setEnabled(true);
            ((ProgressBar)Assertions.assertNotNull((Object)RedBoxContentView.this.mLoadingIndicator)).setVisibility(8);
            ((TextView)Assertions.assertNotNull((Object)RedBoxContentView.this.mReportTextView)).setText((CharSequence)spannedString);
        }
    };
    private View.OnClickListener mReportButtonOnClickListener = new View.OnClickListener(){

        public void onClick(View view) {
            if (RedBoxContentView.this.mRedBoxHandler == null || !RedBoxContentView.this.mRedBoxHandler.isReportEnabled() || RedBoxContentView.this.isReporting) {
                return;
            }
            RedBoxContentView.this.isReporting = true;
            ((TextView)Assertions.assertNotNull((Object)RedBoxContentView.this.mReportTextView)).setText((CharSequence)"Reporting...");
            ((TextView)Assertions.assertNotNull((Object)RedBoxContentView.this.mReportTextView)).setVisibility(0);
            ((ProgressBar)Assertions.assertNotNull((Object)RedBoxContentView.this.mLoadingIndicator)).setVisibility(0);
            ((View)Assertions.assertNotNull((Object)RedBoxContentView.this.mLineSeparator)).setVisibility(0);
            ((Button)Assertions.assertNotNull((Object)RedBoxContentView.this.mReportButton)).setEnabled(false);
            String title = (String)Assertions.assertNotNull((Object)RedBoxContentView.this.mDevSupportManager.getLastErrorTitle());
            StackFrame[] stack = (StackFrame[])Assertions.assertNotNull((Object)RedBoxContentView.this.mDevSupportManager.getLastErrorStack());
            String sourceUrl = RedBoxContentView.this.mDevSupportManager.getSourceUrl();
            RedBoxContentView.this.mRedBoxHandler.reportRedbox(view.getContext(), title, stack, sourceUrl, (RedBoxHandler.ReportCompletedListener)Assertions.assertNotNull((Object)RedBoxContentView.this.mReportCompletedListener));
        }
    };

    public RedBoxContentView(Context context) {
        super(context);
    }

    public RedBoxContentView setDevSupportManager(DevSupportManager devSupportManager) {
        this.mDevSupportManager = devSupportManager;
        return this;
    }

    public RedBoxContentView setRedBoxHandler(@Nullable RedBoxHandler redBoxHandler) {
        this.mRedBoxHandler = redBoxHandler;
        return this;
    }

    public void init() {
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.redbox_view, (ViewGroup)this);
        this.mStackView = (ListView)this.findViewById(R.id.rn_redbox_stack);
        this.mStackView.setOnItemClickListener((AdapterView.OnItemClickListener)this);
        this.mReloadJsButton = (Button)this.findViewById(R.id.rn_redbox_reload_button);
        this.mReloadJsButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ((DevSupportManager)Assertions.assertNotNull((Object)RedBoxContentView.this.mDevSupportManager)).handleReloadJS();
            }
        });
        this.mDismissButton = (Button)this.findViewById(R.id.rn_redbox_dismiss_button);
        this.mDismissButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ((DevSupportManager)Assertions.assertNotNull((Object)RedBoxContentView.this.mDevSupportManager)).hideRedboxDialog();
            }
        });
        if (this.mRedBoxHandler != null && this.mRedBoxHandler.isReportEnabled()) {
            this.mLoadingIndicator = (ProgressBar)this.findViewById(R.id.rn_redbox_loading_indicator);
            this.mLineSeparator = this.findViewById(R.id.rn_redbox_line_separator);
            this.mReportTextView = (TextView)this.findViewById(R.id.rn_redbox_report_label);
            this.mReportTextView.setMovementMethod(LinkMovementMethod.getInstance());
            this.mReportTextView.setHighlightColor(0);
            this.mReportButton = (Button)this.findViewById(R.id.rn_redbox_report_button);
            this.mReportButton.setOnClickListener(this.mReportButtonOnClickListener);
        }
    }

    public void setExceptionDetails(String title, StackFrame[] stack) {
        this.mStackView.setAdapter((ListAdapter)new StackAdapter(title, stack));
    }

    public void resetReporting() {
        if (this.mRedBoxHandler == null || !this.mRedBoxHandler.isReportEnabled()) {
            return;
        }
        this.isReporting = false;
        ((TextView)Assertions.assertNotNull((Object)this.mReportTextView)).setVisibility(8);
        ((ProgressBar)Assertions.assertNotNull((Object)this.mLoadingIndicator)).setVisibility(8);
        ((View)Assertions.assertNotNull((Object)this.mLineSeparator)).setVisibility(8);
        ((Button)Assertions.assertNotNull((Object)this.mReportButton)).setVisibility(0);
        ((Button)Assertions.assertNotNull((Object)this.mReportButton)).setEnabled(true);
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        new OpenStackFrameTask((DevSupportManager)Assertions.assertNotNull((Object)this.mDevSupportManager)).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new StackFrame[]{(StackFrame)this.mStackView.getAdapter().getItem(position)});
    }

    public void refreshContentView() {
        String message = this.mDevSupportManager.getLastErrorTitle();
        StackFrame[] stack = this.mDevSupportManager.getLastErrorStack();
        ErrorType errorType = this.mDevSupportManager.getLastErrorType();
        Pair<String, StackFrame[]> errorInfo = this.mDevSupportManager.processErrorCustomizers((Pair<String, StackFrame[]>)Pair.create((Object)message, (Object)stack));
        this.setExceptionDetails((String)errorInfo.first, (StackFrame[])errorInfo.second);
        RedBoxHandler redBoxHandler = this.mDevSupportManager.getRedBoxHandler();
        if (redBoxHandler != null) {
            redBoxHandler.handleRedbox(message, stack, errorType);
            this.resetReporting();
        }
    }

    private static class OpenStackFrameTask
    extends AsyncTask<StackFrame, Void, Void> {
        private static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
        private final DevSupportManager mDevSupportManager;

        private OpenStackFrameTask(DevSupportManager devSupportManager) {
            this.mDevSupportManager = devSupportManager;
        }

        protected Void doInBackground(StackFrame ... stackFrames) {
            try {
                String openStackFrameUrl = Uri.parse((String)this.mDevSupportManager.getSourceUrl()).buildUpon().path("/open-stack-frame").query(null).build().toString();
                OkHttpClient client = new OkHttpClient();
                for (StackFrame frame : stackFrames) {
                    String payload = OpenStackFrameTask.stackFrameToJson(frame).toString();
                    RequestBody body = RequestBody.create((MediaType)JSON, (String)payload);
                    Request request = new Request.Builder().url(openStackFrameUrl).post(body).build();
                    client.newCall(request).execute();
                }
            }
            catch (Exception e) {
                FLog.e((String)"ReactNative", (String)"Could not open stack frame", (Throwable)e);
            }
            return null;
        }

        private static JSONObject stackFrameToJson(StackFrame frame) {
            return new JSONObject(MapBuilder.of("file", frame.getFile(), "methodName", frame.getMethod(), "lineNumber", frame.getLine(), "column", frame.getColumn()));
        }
    }

    private static class StackAdapter
    extends BaseAdapter {
        private static final int VIEW_TYPE_COUNT = 2;
        private static final int VIEW_TYPE_TITLE = 0;
        private static final int VIEW_TYPE_STACKFRAME = 1;
        private final String mTitle;
        private final StackFrame[] mStack;

        public StackAdapter(String title, StackFrame[] stack) {
            this.mTitle = title;
            this.mStack = stack;
            Assertions.assertNotNull((Object)this.mTitle);
            Assertions.assertNotNull((Object)this.mStack);
        }

        public boolean areAllItemsEnabled() {
            return false;
        }

        public boolean isEnabled(int position) {
            return position > 0;
        }

        public int getCount() {
            return this.mStack.length + 1;
        }

        public Object getItem(int position) {
            return position == 0 ? this.mTitle : this.mStack[position - 1];
        }

        public long getItemId(int position) {
            return position;
        }

        public int getViewTypeCount() {
            return 2;
        }

        public int getItemViewType(int position) {
            return position == 0 ? 0 : 1;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            if (position == 0) {
                TextView title = convertView != null ? (TextView)convertView : (TextView)LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.redbox_item_title, parent, false);
                String titleSafe = this.mTitle == null ? "<unknown title>" : this.mTitle;
                title.setText((CharSequence)titleSafe.replaceAll("\\x1b\\[[0-9;]*m", ""));
                return title;
            }
            if (convertView == null) {
                convertView = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.redbox_item_frame, parent, false);
                convertView.setTag((Object)new FrameViewHolder(convertView));
            }
            StackFrame frame = this.mStack[position - 1];
            FrameViewHolder holder = (FrameViewHolder)convertView.getTag();
            holder.mMethodView.setText((CharSequence)frame.getMethod());
            holder.mFileView.setText((CharSequence)StackTraceHelper.formatFrameSource(frame));
            holder.mMethodView.setTextColor(frame.isCollapsed() ? -5592406 : -1);
            holder.mFileView.setTextColor(frame.isCollapsed() ? -8355712 : -5000269);
            return convertView;
        }

        private static class FrameViewHolder {
            private final TextView mMethodView;
            private final TextView mFileView;

            private FrameViewHolder(View v) {
                this.mMethodView = (TextView)v.findViewById(R.id.rn_frame_method);
                this.mFileView = (TextView)v.findViewById(R.id.rn_frame_file);
            }
        }
    }
}

