/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.fabric;

import com.facebook.jni.HybridData;
import com.facebook.proguard.annotations.DoNotStrip;
import com.facebook.react.bridge.NativeMap;
import com.facebook.react.fabric.FabricSoLoader;
import com.facebook.react.fabric.SurfaceHandler;
import com.facebook.react.fabric.mounting.LayoutMetricsConversions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class SurfaceHandlerBinding
implements SurfaceHandler {
    private static final int NO_SURFACE_ID = 0;
    public static final int DISPLAY_MODE_VISIBLE = 0;
    public static final int DISPLAY_MODE_SUSPENDED = 1;
    public static final int DISPLAY_MODE_HIDDEN = 2;
    @DoNotStrip
    private final HybridData mHybridData;

    private static native HybridData initHybrid(int var0, String var1);

    public SurfaceHandlerBinding(String moduleName) {
        this.mHybridData = SurfaceHandlerBinding.initHybrid(0, moduleName);
    }

    @Override
    public int getSurfaceId() {
        return this.getSurfaceIdNative();
    }

    private native int getSurfaceIdNative();

    @Override
    public void setSurfaceId(int surfaceId) {
        this.setSurfaceIdNative(surfaceId);
    }

    private native void setSurfaceIdNative(int var1);

    @Override
    public String getModuleName() {
        return this.getModuleNameNative();
    }

    private native String getModuleNameNative();

    @Override
    public void start() {
        this.startNative();
    }

    private native void startNative();

    @Override
    public void stop() {
        this.stopNative();
    }

    private native void stopNative();

    @Override
    public boolean isRunning() {
        return this.isRunningNative();
    }

    private native boolean isRunningNative();

    @Override
    public void setLayoutConstraints(int widthMeasureSpec, int heightMeasureSpec, int offsetX, int offsetY, boolean doLeftAndRightSwapInRTL, boolean isRTL, float pixelDensity) {
        this.setLayoutConstraintsNative(LayoutMetricsConversions.getMinSize(widthMeasureSpec) / pixelDensity, LayoutMetricsConversions.getMaxSize(widthMeasureSpec) / pixelDensity, LayoutMetricsConversions.getMinSize(heightMeasureSpec) / pixelDensity, LayoutMetricsConversions.getMaxSize(heightMeasureSpec) / pixelDensity, (float)offsetX / pixelDensity, (float)offsetY / pixelDensity, doLeftAndRightSwapInRTL, isRTL, pixelDensity);
    }

    private native void setLayoutConstraintsNative(float var1, float var2, float var3, float var4, float var5, float var6, boolean var7, boolean var8, float var9);

    @Override
    public void setProps(NativeMap props) {
        this.setPropsNative(props);
    }

    private native void setPropsNative(NativeMap var1);

    @Override
    public void setMountable(boolean mountable) {
        this.setDisplayModeNative(mountable ? 0 : 1);
    }

    private native void setDisplayModeNative(int var1);

    static {
        FabricSoLoader.staticInit();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DisplayModeTypeDef {
    }
}

