/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge;

import android.content.res.AssetManager;
import android.os.AsyncTask;
import androidx.annotation.Nullable;
import com.facebook.common.logging.FLog;
import com.facebook.infer.annotation.Assertions;
import com.facebook.infer.annotation.ThreadConfined;
import com.facebook.jni.HybridData;
import com.facebook.proguard.annotations.DoNotStrip;
import com.facebook.react.bridge.CatalystInstance;
import com.facebook.react.bridge.JSBundleLoader;
import com.facebook.react.bridge.JSExceptionHandler;
import com.facebook.react.bridge.JSIModule;
import com.facebook.react.bridge.JSIModuleRegistry;
import com.facebook.react.bridge.JSIModuleSpec;
import com.facebook.react.bridge.JSIModuleType;
import com.facebook.react.bridge.JavaModuleWrapper;
import com.facebook.react.bridge.JavaScriptContextHolder;
import com.facebook.react.bridge.JavaScriptExecutor;
import com.facebook.react.bridge.JavaScriptModule;
import com.facebook.react.bridge.JavaScriptModuleRegistry;
import com.facebook.react.bridge.ModuleHolder;
import com.facebook.react.bridge.NativeArray;
import com.facebook.react.bridge.NativeArrayInterface;
import com.facebook.react.bridge.NativeModule;
import com.facebook.react.bridge.NativeModuleRegistry;
import com.facebook.react.bridge.NotThreadSafeBridgeIdleDebugListener;
import com.facebook.react.bridge.ReactBridge;
import com.facebook.react.bridge.ReactCallback;
import com.facebook.react.bridge.ReactMarker;
import com.facebook.react.bridge.ReactMarkerConstants;
import com.facebook.react.bridge.RuntimeExecutor;
import com.facebook.react.bridge.RuntimeScheduler;
import com.facebook.react.bridge.Systrace;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.bridge.WritableNativeArray;
import com.facebook.react.bridge.queue.MessageQueueThread;
import com.facebook.react.bridge.queue.QueueThreadExceptionHandler;
import com.facebook.react.bridge.queue.ReactQueueConfiguration;
import com.facebook.react.bridge.queue.ReactQueueConfigurationImpl;
import com.facebook.react.bridge.queue.ReactQueueConfigurationSpec;
import com.facebook.react.common.annotations.VisibleForTesting;
import com.facebook.react.config.ReactFeatureFlags;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.turbomodule.core.CallInvokerHolderImpl;
import com.facebook.react.turbomodule.core.interfaces.TurboModule;
import com.facebook.react.turbomodule.core.interfaces.TurboModuleRegistry;
import com.facebook.systrace.TraceListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;

@DoNotStrip
public class CatalystInstanceImpl
implements CatalystInstance {
    private static final AtomicInteger sNextInstanceIdForTrace;
    private final ReactQueueConfigurationImpl mReactQueueConfiguration;
    private final CopyOnWriteArrayList<NotThreadSafeBridgeIdleDebugListener> mBridgeIdleListeners;
    private final AtomicInteger mPendingJSCalls = new AtomicInteger(0);
    private final String mJsPendingCallsTitleForTrace = "pending_js_calls_instance" + sNextInstanceIdForTrace.getAndIncrement();
    private volatile boolean mDestroyed = false;
    private final TraceListener mTraceListener;
    private final JavaScriptModuleRegistry mJSModuleRegistry;
    private final JSBundleLoader mJSBundleLoader;
    private final ArrayList<PendingJSCall> mJSCallsPendingInit = new ArrayList();
    private final Object mJSCallsPendingInitLock = new Object();
    private final NativeModuleRegistry mNativeModuleRegistry;
    private final JSIModuleRegistry mJSIModuleRegistry = new JSIModuleRegistry();
    private final JSExceptionHandler mJSExceptionHandler;
    private final MessageQueueThread mNativeModulesQueueThread;
    private boolean mInitialized = false;
    private volatile boolean mAcceptCalls = false;
    private boolean mJSBundleHasLoaded;
    @Nullable
    private String mSourceURL;
    private JavaScriptContextHolder mJavaScriptContextHolder;
    @Nullable
    private volatile TurboModuleRegistry mTurboModuleRegistry = null;
    @Nullable
    private JSIModule mTurboModuleManagerJSIModule = null;
    private final HybridData mHybridData;

    private static native HybridData initHybrid();

    @Override
    public native CallInvokerHolderImpl getJSCallInvokerHolder();

    @Override
    public native CallInvokerHolderImpl getNativeCallInvokerHolder();

    private CatalystInstanceImpl(ReactQueueConfigurationSpec reactQueueConfigurationSpec, JavaScriptExecutor jsExecutor, NativeModuleRegistry nativeModuleRegistry, JSBundleLoader jsBundleLoader, JSExceptionHandler jSExceptionHandler) {
        FLog.d((String)"ReactNative", (String)"Initializing React Xplat Bridge.");
        com.facebook.systrace.Systrace.beginSection(0L, "createCatalystInstanceImpl");
        this.mHybridData = CatalystInstanceImpl.initHybrid();
        this.mReactQueueConfiguration = ReactQueueConfigurationImpl.create(reactQueueConfigurationSpec, new NativeExceptionHandler());
        this.mBridgeIdleListeners = new CopyOnWriteArrayList();
        this.mNativeModuleRegistry = nativeModuleRegistry;
        this.mJSModuleRegistry = new JavaScriptModuleRegistry();
        this.mJSBundleLoader = jsBundleLoader;
        this.mJSExceptionHandler = jSExceptionHandler;
        this.mNativeModulesQueueThread = this.mReactQueueConfiguration.getNativeModulesQueueThread();
        this.mTraceListener = new JSProfilerTraceListener(this);
        com.facebook.systrace.Systrace.endSection(0L);
        FLog.d((String)"ReactNative", (String)"Initializing React Xplat Bridge before initializeBridge");
        com.facebook.systrace.Systrace.beginSection(0L, "initializeCxxBridge");
        if (ReactFeatureFlags.warnOnLegacyNativeModuleSystemUse) {
            this.warnOnLegacyNativeModuleSystemUse();
        }
        this.initializeBridge(new BridgeCallback(this), jsExecutor, this.mReactQueueConfiguration.getJSQueueThread(), this.mNativeModulesQueueThread, this.mNativeModuleRegistry.getJavaModules(this), this.mNativeModuleRegistry.getCxxModules());
        FLog.d((String)"ReactNative", (String)"Initializing React Xplat Bridge after initializeBridge");
        com.facebook.systrace.Systrace.endSection(0L);
        this.mJavaScriptContextHolder = new JavaScriptContextHolder(this.getJavaScriptContext());
    }

    @Override
    public void extendNativeModules(NativeModuleRegistry modules) {
        this.mNativeModuleRegistry.registerModules(modules);
        Collection<JavaModuleWrapper> javaModules = modules.getJavaModules(this);
        Collection<ModuleHolder> cxxModules = modules.getCxxModules();
        this.jniExtendNativeModules(javaModules, cxxModules);
    }

    private native void jniExtendNativeModules(Collection<JavaModuleWrapper> var1, Collection<ModuleHolder> var2);

    private native void warnOnLegacyNativeModuleSystemUse();

    private native void initializeBridge(ReactCallback var1, JavaScriptExecutor var2, MessageQueueThread var3, MessageQueueThread var4, Collection<JavaModuleWrapper> var5, Collection<ModuleHolder> var6);

    @Override
    public void setSourceURLs(String deviceURL, String remoteURL) {
        this.mSourceURL = deviceURL;
        this.jniSetSourceURL(remoteURL);
    }

    @Override
    public void registerSegment(int segmentId, String path) {
        this.jniRegisterSegment(segmentId, path);
    }

    @Override
    public void loadScriptFromAssets(AssetManager assetManager, String assetURL, boolean loadSynchronously) {
        this.mSourceURL = assetURL;
        this.jniLoadScriptFromAssets(assetManager, assetURL, loadSynchronously);
    }

    @Override
    public void loadScriptFromFile(String fileName, String sourceURL, boolean loadSynchronously) {
        this.mSourceURL = sourceURL;
        this.jniLoadScriptFromFile(fileName, sourceURL, loadSynchronously);
    }

    @Override
    public void loadSplitBundleFromFile(String fileName, String sourceURL) {
        this.jniLoadScriptFromFile(fileName, sourceURL, false);
    }

    private native void jniSetSourceURL(String var1);

    private native void jniRegisterSegment(int var1, String var2);

    private native void jniLoadScriptFromAssets(AssetManager var1, String var2, boolean var3);

    private native void jniLoadScriptFromFile(String var1, String var2, boolean var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runJSBundle() {
        FLog.d((String)"ReactNative", (String)"CatalystInstanceImpl.runJSBundle()");
        Assertions.assertCondition((!this.mJSBundleHasLoaded ? 1 : 0) != 0, (String)"JS bundle was already loaded!");
        this.mJSBundleLoader.loadScript(this);
        Object object = this.mJSCallsPendingInitLock;
        synchronized (object) {
            this.mAcceptCalls = true;
            for (PendingJSCall function : this.mJSCallsPendingInit) {
                function.call(this);
            }
            this.mJSCallsPendingInit.clear();
            this.mJSBundleHasLoaded = true;
        }
        com.facebook.systrace.Systrace.registerListener(this.mTraceListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasRunJSBundle() {
        Object object = this.mJSCallsPendingInitLock;
        synchronized (object) {
            return this.mJSBundleHasLoaded && this.mAcceptCalls;
        }
    }

    @Override
    @Nullable
    public String getSourceURL() {
        return this.mSourceURL;
    }

    private native void jniCallJSFunction(String var1, String var2, NativeArray var3);

    @Override
    public void callFunction(String module, String method, NativeArray arguments) {
        this.callFunction(new PendingJSCall(module, method, arguments));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callFunction(PendingJSCall function) {
        if (this.mDestroyed) {
            String call = function.toString();
            FLog.w((String)"ReactNative", (String)("Calling JS function after bridge has been destroyed: " + call));
            return;
        }
        if (!this.mAcceptCalls) {
            Object object = this.mJSCallsPendingInitLock;
            synchronized (object) {
                if (!this.mAcceptCalls) {
                    this.mJSCallsPendingInit.add(function);
                    return;
                }
            }
        }
        function.call(this);
    }

    private native void jniCallJSCallback(int var1, NativeArray var2);

    @Override
    public void invokeCallback(int callbackID, NativeArrayInterface arguments) {
        if (this.mDestroyed) {
            FLog.w((String)"ReactNative", (String)"Invoking JS callback after bridge has been destroyed.");
            return;
        }
        this.jniCallJSCallback(callbackID, (NativeArray)arguments);
    }

    @Override
    @ThreadConfined(value="UI")
    public void destroy() {
        FLog.d((String)"ReactNative", (String)"CatalystInstanceImpl.destroy() start");
        UiThreadUtil.assertOnUiThread();
        if (this.mDestroyed) {
            return;
        }
        ReactMarker.logMarker(ReactMarkerConstants.DESTROY_CATALYST_INSTANCE_START);
        this.mDestroyed = true;
        this.mNativeModulesQueueThread.runOnQueue(new Runnable(){

            @Override
            public void run() {
                boolean wasIdle;
                CatalystInstanceImpl.this.mNativeModuleRegistry.notifyJSInstanceDestroy();
                CatalystInstanceImpl.this.mJSIModuleRegistry.notifyJSInstanceDestroy();
                boolean bl = wasIdle = CatalystInstanceImpl.this.mPendingJSCalls.getAndSet(0) == 0;
                if (!CatalystInstanceImpl.this.mBridgeIdleListeners.isEmpty()) {
                    for (NotThreadSafeBridgeIdleDebugListener listener : CatalystInstanceImpl.this.mBridgeIdleListeners) {
                        if (!wasIdle) {
                            listener.onTransitionToBridgeIdle();
                        }
                        listener.onBridgeDestroyed();
                    }
                }
                CatalystInstanceImpl.this.getReactQueueConfiguration().getJSQueueThread().runOnQueue(new Runnable(){

                    @Override
                    public void run() {
                        if (CatalystInstanceImpl.this.mTurboModuleManagerJSIModule != null) {
                            CatalystInstanceImpl.this.mTurboModuleManagerJSIModule.onCatalystInstanceDestroy();
                        }
                        CatalystInstanceImpl.this.getReactQueueConfiguration().getUIQueueThread().runOnQueue(new Runnable(){

                            @Override
                            public void run() {
                                AsyncTask.execute((Runnable)new Runnable(){

                                    @Override
                                    public void run() {
                                        CatalystInstanceImpl.this.mJavaScriptContextHolder.clear();
                                        CatalystInstanceImpl.this.mHybridData.resetNative();
                                        CatalystInstanceImpl.this.getReactQueueConfiguration().destroy();
                                        FLog.d((String)"ReactNative", (String)"CatalystInstanceImpl.destroy() end");
                                        ReactMarker.logMarker(ReactMarkerConstants.DESTROY_CATALYST_INSTANCE_END);
                                    }
                                });
                            }
                        });
                    }
                });
            }
        });
        com.facebook.systrace.Systrace.unregisterListener(this.mTraceListener);
    }

    @Override
    public boolean isDestroyed() {
        return this.mDestroyed;
    }

    @Override
    @VisibleForTesting
    public void initialize() {
        FLog.d((String)"ReactNative", (String)"CatalystInstanceImpl.initialize()");
        Assertions.assertCondition((!this.mInitialized ? 1 : 0) != 0, (String)"This catalyst instance has already been initialized");
        Assertions.assertCondition((boolean)this.mAcceptCalls, (String)"RunJSBundle hasn't completed.");
        this.mInitialized = true;
        this.mNativeModulesQueueThread.runOnQueue(new Runnable(){

            @Override
            public void run() {
                CatalystInstanceImpl.this.mNativeModuleRegistry.notifyJSInstanceInitialized();
            }
        });
    }

    @Override
    public ReactQueueConfiguration getReactQueueConfiguration() {
        return this.mReactQueueConfiguration;
    }

    @Override
    public <T extends JavaScriptModule> T getJSModule(Class<T> jsInterface) {
        return this.mJSModuleRegistry.getJavaScriptModule(this, jsInterface);
    }

    @Override
    public <T extends NativeModule> boolean hasNativeModule(Class<T> nativeModuleInterface) {
        String moduleName = this.getNameFromAnnotation(nativeModuleInterface);
        return this.getTurboModuleRegistry() != null && this.getTurboModuleRegistry().hasModule(moduleName) ? true : this.mNativeModuleRegistry.hasModule(moduleName);
    }

    @Override
    @Nullable
    public <T extends NativeModule> T getNativeModule(Class<T> nativeModuleInterface) {
        return (T)this.getNativeModule(this.getNameFromAnnotation(nativeModuleInterface));
    }

    private TurboModuleRegistry getTurboModuleRegistry() {
        if (ReactFeatureFlags.useTurboModules) {
            return (TurboModuleRegistry)Assertions.assertNotNull((Object)this.mTurboModuleRegistry, (String)"TurboModules are enabled, but mTurboModuleRegistry hasn't been set.");
        }
        return null;
    }

    @Override
    @Nullable
    public NativeModule getNativeModule(String moduleName) {
        TurboModule turboModule;
        if (this.getTurboModuleRegistry() != null && (turboModule = this.getTurboModuleRegistry().getModule(moduleName)) != null) {
            return (NativeModule)((Object)turboModule);
        }
        return this.mNativeModuleRegistry.hasModule(moduleName) ? this.mNativeModuleRegistry.getModule(moduleName) : null;
    }

    private <T extends NativeModule> String getNameFromAnnotation(Class<T> nativeModuleInterface) {
        ReactModule annotation = nativeModuleInterface.getAnnotation(ReactModule.class);
        if (annotation == null) {
            throw new IllegalArgumentException("Could not find @ReactModule annotation in " + nativeModuleInterface.getCanonicalName());
        }
        return annotation.name();
    }

    @Override
    public Collection<NativeModule> getNativeModules() {
        ArrayList<NativeModule> nativeModules = new ArrayList<NativeModule>();
        nativeModules.addAll(this.mNativeModuleRegistry.getAllModules());
        if (this.getTurboModuleRegistry() != null) {
            for (TurboModule turboModule : this.getTurboModuleRegistry().getModules()) {
                nativeModules.add((NativeModule)((Object)turboModule));
            }
        }
        return nativeModules;
    }

    private native void jniHandleMemoryPressure(int var1);

    @Override
    public void handleMemoryPressure(int level) {
        if (this.mDestroyed) {
            return;
        }
        this.jniHandleMemoryPressure(level);
    }

    @Override
    public void addBridgeIdleDebugListener(NotThreadSafeBridgeIdleDebugListener listener) {
        this.mBridgeIdleListeners.add(listener);
    }

    @Override
    public void removeBridgeIdleDebugListener(NotThreadSafeBridgeIdleDebugListener listener) {
        this.mBridgeIdleListeners.remove(listener);
    }

    @Override
    public native void setGlobalVariable(String var1, String var2);

    @Override
    public JavaScriptContextHolder getJavaScriptContextHolder() {
        return this.mJavaScriptContextHolder;
    }

    @Override
    public native RuntimeExecutor getRuntimeExecutor();

    @Override
    public native RuntimeScheduler getRuntimeScheduler();

    @Override
    public void addJSIModules(List<JSIModuleSpec> jsiModules) {
        this.mJSIModuleRegistry.registerModules(jsiModules);
    }

    @Override
    public JSIModule getJSIModule(JSIModuleType moduleType) {
        return this.mJSIModuleRegistry.getModule(moduleType);
    }

    private native long getJavaScriptContext();

    private void incrementPendingJSCalls() {
        int oldPendingCalls = this.mPendingJSCalls.getAndIncrement();
        boolean wasIdle = oldPendingCalls == 0;
        com.facebook.systrace.Systrace.traceCounter(0L, this.mJsPendingCallsTitleForTrace, oldPendingCalls + 1);
        if (wasIdle && !this.mBridgeIdleListeners.isEmpty()) {
            this.mNativeModulesQueueThread.runOnQueue(new Runnable(){

                @Override
                public void run() {
                    for (NotThreadSafeBridgeIdleDebugListener listener : CatalystInstanceImpl.this.mBridgeIdleListeners) {
                        listener.onTransitionToBridgeBusy();
                    }
                }
            });
        }
    }

    @Override
    public void setTurboModuleManager(JSIModule module) {
        this.mTurboModuleRegistry = (TurboModuleRegistry)((Object)module);
        this.mTurboModuleManagerJSIModule = module;
    }

    private void decrementPendingJSCalls() {
        int newPendingCalls = this.mPendingJSCalls.decrementAndGet();
        boolean isNowIdle = newPendingCalls == 0;
        com.facebook.systrace.Systrace.traceCounter(0L, this.mJsPendingCallsTitleForTrace, newPendingCalls);
        if (isNowIdle && !this.mBridgeIdleListeners.isEmpty()) {
            this.mNativeModulesQueueThread.runOnQueue(new Runnable(){

                @Override
                public void run() {
                    for (NotThreadSafeBridgeIdleDebugListener listener : CatalystInstanceImpl.this.mBridgeIdleListeners) {
                        listener.onTransitionToBridgeIdle();
                    }
                }
            });
        }
    }

    private void onNativeException(Exception e) {
        this.mJSExceptionHandler.handleException(e);
        this.mReactQueueConfiguration.getUIQueueThread().runOnQueue(new Runnable(){

            @Override
            public void run() {
                CatalystInstanceImpl.this.destroy();
            }
        });
    }

    static {
        ReactBridge.staticInit();
        sNextInstanceIdForTrace = new AtomicInteger(1);
    }

    public static class Builder {
        @Nullable
        private ReactQueueConfigurationSpec mReactQueueConfigurationSpec;
        @Nullable
        private JSBundleLoader mJSBundleLoader;
        @Nullable
        private NativeModuleRegistry mRegistry;
        @Nullable
        private JavaScriptExecutor mJSExecutor;
        @Nullable
        private JSExceptionHandler mJSExceptionHandler;

        public Builder setReactQueueConfigurationSpec(ReactQueueConfigurationSpec ReactQueueConfigurationSpec2) {
            this.mReactQueueConfigurationSpec = ReactQueueConfigurationSpec2;
            return this;
        }

        public Builder setRegistry(NativeModuleRegistry registry) {
            this.mRegistry = registry;
            return this;
        }

        public Builder setJSBundleLoader(JSBundleLoader jsBundleLoader) {
            this.mJSBundleLoader = jsBundleLoader;
            return this;
        }

        public Builder setJSExecutor(JavaScriptExecutor jsExecutor) {
            this.mJSExecutor = jsExecutor;
            return this;
        }

        public Builder setJSExceptionHandler(JSExceptionHandler handler) {
            this.mJSExceptionHandler = handler;
            return this;
        }

        public CatalystInstanceImpl build() {
            return new CatalystInstanceImpl((ReactQueueConfigurationSpec)Assertions.assertNotNull((Object)this.mReactQueueConfigurationSpec), (JavaScriptExecutor)Assertions.assertNotNull((Object)this.mJSExecutor), (NativeModuleRegistry)Assertions.assertNotNull((Object)this.mRegistry), (JSBundleLoader)Assertions.assertNotNull((Object)this.mJSBundleLoader), (JSExceptionHandler)Assertions.assertNotNull((Object)this.mJSExceptionHandler));
        }
    }

    private static class JSProfilerTraceListener
    implements TraceListener {
        private final WeakReference<CatalystInstanceImpl> mOuter;

        public JSProfilerTraceListener(CatalystInstanceImpl outer) {
            this.mOuter = new WeakReference<CatalystInstanceImpl>(outer);
        }

        @Override
        public void onTraceStarted() {
            CatalystInstanceImpl impl = (CatalystInstanceImpl)this.mOuter.get();
            if (impl != null) {
                impl.getJSModule(Systrace.class).setEnabled(true);
            }
        }

        @Override
        public void onTraceStopped() {
            CatalystInstanceImpl impl = (CatalystInstanceImpl)this.mOuter.get();
            if (impl != null) {
                impl.getJSModule(Systrace.class).setEnabled(false);
            }
        }
    }

    private class NativeExceptionHandler
    implements QueueThreadExceptionHandler {
        private NativeExceptionHandler() {
        }

        @Override
        public void handleException(Exception e) {
            CatalystInstanceImpl.this.onNativeException(e);
        }
    }

    private static class BridgeCallback
    implements ReactCallback {
        private final WeakReference<CatalystInstanceImpl> mOuter;

        BridgeCallback(CatalystInstanceImpl outer) {
            this.mOuter = new WeakReference<CatalystInstanceImpl>(outer);
        }

        @Override
        public void onBatchComplete() {
            CatalystInstanceImpl impl = (CatalystInstanceImpl)this.mOuter.get();
            if (impl != null) {
                impl.mNativeModuleRegistry.onBatchComplete();
            }
        }

        @Override
        public void incrementPendingJSCalls() {
            CatalystInstanceImpl impl = (CatalystInstanceImpl)this.mOuter.get();
            if (impl != null) {
                impl.incrementPendingJSCalls();
            }
        }

        @Override
        public void decrementPendingJSCalls() {
            CatalystInstanceImpl impl = (CatalystInstanceImpl)this.mOuter.get();
            if (impl != null) {
                impl.decrementPendingJSCalls();
            }
        }
    }

    public static class PendingJSCall {
        public String mModule;
        public String mMethod;
        @Nullable
        public NativeArray mArguments;

        public PendingJSCall(String module, String method, @Nullable NativeArray arguments) {
            this.mModule = module;
            this.mMethod = method;
            this.mArguments = arguments;
        }

        void call(CatalystInstanceImpl catalystInstance) {
            NativeArray arguments = this.mArguments != null ? this.mArguments : new WritableNativeArray();
            catalystInstance.jniCallJSFunction(this.mModule, this.mMethod, arguments);
        }

        public String toString() {
            return this.mModule + "." + this.mMethod + "(" + (this.mArguments == null ? "" : this.mArguments.toString()) + ")";
        }
    }
}

