/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager.events;

import androidx.annotation.Nullable;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.common.SystemClock;
import com.facebook.react.uimanager.IllegalViewOperationException;
import com.facebook.react.uimanager.common.ViewUtil;
import com.facebook.react.uimanager.events.EventCategoryDef;
import com.facebook.react.uimanager.events.RCTEventEmitter;
import com.facebook.react.uimanager.events.RCTModernEventEmitter;

public abstract class Event<T extends Event> {
    private static int sUniqueID = 0;
    private boolean mInitialized;
    private int mUIManagerType;
    private int mSurfaceId;
    private int mViewTag;
    private long mTimestampMs;
    private int mUniqueID = sUniqueID++;
    @Nullable
    private EventAnimationDriverMatchSpec mEventAnimationDriverMatchSpec;

    protected Event() {
    }

    @Deprecated
    protected Event(int viewTag) {
        this.init(viewTag);
    }

    protected Event(int surfaceId, int viewTag) {
        this.init(surfaceId, viewTag);
    }

    @Deprecated
    protected void init(int viewTag) {
        this.init(-1, viewTag);
    }

    protected void init(int surfaceId, int viewTag) {
        this.init(surfaceId, viewTag, SystemClock.uptimeMillis());
    }

    protected void init(int surfaceId, int viewTag, long timestampMs) {
        int uiManagerType;
        this.mSurfaceId = surfaceId;
        this.mViewTag = viewTag;
        int n = uiManagerType = surfaceId == -1 ? 1 : 2;
        if (uiManagerType == 1 && !ViewUtil.isRootTag(viewTag)) {
            uiManagerType = ViewUtil.getUIManagerType(viewTag);
        }
        this.mUIManagerType = uiManagerType;
        this.mTimestampMs = timestampMs;
        this.mInitialized = true;
    }

    public final int getViewTag() {
        return this.mViewTag;
    }

    public final int getSurfaceId() {
        return this.mSurfaceId;
    }

    public final long getTimestampMs() {
        return this.mTimestampMs;
    }

    public boolean canCoalesce() {
        return true;
    }

    public T coalesce(T otherEvent) {
        return (T)(this.getTimestampMs() >= ((Event)otherEvent).getTimestampMs() ? this : otherEvent);
    }

    public short getCoalescingKey() {
        return 0;
    }

    public int getUniqueID() {
        return this.mUniqueID;
    }

    public void onDispose() {
    }

    boolean isInitialized() {
        return this.mInitialized;
    }

    final void dispose() {
        this.mInitialized = false;
        this.onDispose();
    }

    public final int getUIManagerType() {
        return this.mUIManagerType;
    }

    public abstract String getEventName();

    public EventAnimationDriverMatchSpec getEventAnimationDriverMatchSpec() {
        if (this.mEventAnimationDriverMatchSpec == null) {
            this.mEventAnimationDriverMatchSpec = new EventAnimationDriverMatchSpec(){

                @Override
                public boolean match(int viewTag, String eventName) {
                    return viewTag == Event.this.getViewTag() && eventName.equals(Event.this.getEventName());
                }
            };
        }
        return this.mEventAnimationDriverMatchSpec;
    }

    @Deprecated
    public void dispatch(RCTEventEmitter rctEventEmitter) {
        WritableMap eventData = this.getEventData();
        if (eventData == null) {
            throw new IllegalViewOperationException("Event: you must return a valid, non-null value from `getEventData`, or override `dispatch` and `dispatchModern`. Event: " + this.getEventName());
        }
        rctEventEmitter.receiveEvent(this.getViewTag(), this.getEventName(), eventData);
    }

    @Nullable
    protected WritableMap getEventData() {
        return null;
    }

    @EventCategoryDef
    protected int getEventCategory() {
        return 2;
    }

    @Deprecated
    public void dispatchModern(RCTModernEventEmitter rctEventEmitter) {
        WritableMap eventData;
        if (this.getSurfaceId() != -1 && (eventData = this.getEventData()) != null) {
            rctEventEmitter.receiveEvent(this.getSurfaceId(), this.getViewTag(), this.getEventName(), this.canCoalesce(), this.getCoalescingKey(), eventData, this.getEventCategory());
            return;
        }
        this.dispatch(rctEventEmitter);
    }

    public static interface EventAnimationDriverMatchSpec {
        public boolean match(int var1, String var2);
    }
}

