/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hermes.unicode;

import com.facebook.proguard.annotations.DoNotStrip;
import java.text.Collator;
import java.text.DateFormat;
import java.text.Normalizer;
import java.util.Locale;

@DoNotStrip
public class AndroidUnicodeUtils {
    @DoNotStrip
    public static int localeCompare(String left, String right) {
        Collator collator = Collator.getInstance();
        return collator.compare(left, right);
    }

    @DoNotStrip
    public static String dateFormat(double unixtimeMs, boolean formatDate, boolean formatTime) {
        DateFormat format;
        if (formatDate && formatTime) {
            format = DateFormat.getDateTimeInstance(2, 2);
        } else if (formatDate) {
            format = DateFormat.getDateInstance(2);
        } else if (formatTime) {
            format = DateFormat.getTimeInstance(2);
        } else {
            throw new RuntimeException("Bad dateFormat configuration");
        }
        return format.format((long)unixtimeMs).toString();
    }

    @DoNotStrip
    public static String convertToCase(String input, int targetCase, boolean useCurrentLocale) {
        boolean targetUppercase = false;
        boolean targetLowercase = true;
        Locale locale = useCurrentLocale ? Locale.getDefault() : Locale.ENGLISH;
        switch (targetCase) {
            case 1: {
                return input.toLowerCase(locale);
            }
            case 0: {
                return input.toUpperCase(locale);
            }
        }
        throw new RuntimeException("Invalid target case");
    }

    @DoNotStrip
    public static String normalize(String input, int form) {
        boolean formC = false;
        boolean formD = true;
        int formKC = 2;
        int formKD = 3;
        switch (form) {
            case 0: {
                return Normalizer.normalize(input, Normalizer.Form.NFC);
            }
            case 1: {
                return Normalizer.normalize(input, Normalizer.Form.NFD);
            }
            case 2: {
                return Normalizer.normalize(input, Normalizer.Form.NFKC);
            }
            case 3: {
                return Normalizer.normalize(input, Normalizer.Form.NFKD);
            }
        }
        throw new RuntimeException("Invalid form");
    }
}

